/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.tea;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.UUID;
import kubatech.savedata.PlayerData;
import kubatech.savedata.PlayerDataManager;
import kubatech.tileentity.TeaStorageTile;
import net.minecraft.nbt.NBTTagCompound;

public class TeaNetwork {
    public BigInteger teaAmount = BigInteger.ZERO;
    public BigInteger teaLimit = BigInteger.valueOf(Long.MAX_VALUE);
    PlayerData owner;
    private final HashSet<TeaStorageTile> teaStorageExtenders = new HashSet();

    public static TeaNetwork getNetwork(UUID player) {
        PlayerData p = PlayerDataManager.getPlayer(player);
        if (p == null) {
            return null;
        }
        TeaNetwork n = p.teaNetwork;
        if (n == null) {
            p.teaNetwork = new TeaNetwork();
            p.teaNetwork.owner = p;
            return p.teaNetwork;
        }
        n.owner = p;
        return n;
    }

    public boolean canAfford(long price, boolean take) {
        return this.canAfford(BigInteger.valueOf(price), take);
    }

    public boolean canAfford(BigInteger price, boolean take) {
        if (this.teaAmount.compareTo(price) >= 0) {
            if (take) {
                this.teaAmount = this.teaAmount.subtract(price);
                this.markDirty();
            }
            return true;
        }
        return false;
    }

    public boolean addTea(long toAdd) {
        return this.addTea(BigInteger.valueOf(toAdd));
    }

    public boolean addTea(BigInteger toAdd) {
        BigInteger newValue = this.teaAmount.add(toAdd);
        if (newValue.compareTo(this.teaLimit) > 0) {
            return false;
        }
        this.teaAmount = this.teaAmount.add(toAdd);
        this.markDirty();
        return true;
    }

    public boolean canAdd(long toAdd) {
        return this.canAdd(BigInteger.valueOf(toAdd));
    }

    public boolean canAdd(BigInteger toAdd) {
        return this.teaAmount.add(toAdd).compareTo(this.teaLimit) <= 0;
    }

    public void registerTeaStorageExtender(TeaStorageTile storageTile) {
        if (this.teaStorageExtenders.add(storageTile)) {
            this.teaLimit = this.teaLimit.add(storageTile.teaExtendAmount());
        }
    }

    public void unregisterTeaStorageExtender(TeaStorageTile storageTile) {
        if (this.teaStorageExtenders.remove((Object)storageTile)) {
            this.teaLimit = this.teaLimit.subtract(storageTile.teaExtendAmount());
        }
    }

    public void markDirty() {
        this.owner.markDirty();
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74773_a("teaAmount", this.teaAmount.toByteArray());
        return nbt;
    }

    public static TeaNetwork fromNBT(NBTTagCompound nbt) {
        TeaNetwork teaNetwork = new TeaNetwork();
        teaNetwork.teaAmount = new BigInteger(nbt.func_74770_j("teaAmount"));
        return teaNetwork;
    }
}

