/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.beamline;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.common.GTClient;
import gregtech.common.render.GTTextureBuilder;
import gtnhlanth.common.beamline.IConnectsToBeamline;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEBeamlinePipe
extends MetaPipeEntity
implements IConnectsToBeamline {
    private static Textures.BlockIcons.CustomIcon pipe;
    private byte connectionCount = 0;
    private boolean active;

    public MTEBeamlinePipe(int id, String name, String nameRegional) {
        super(id, name, nameRegional, 0);
    }

    public MTEBeamlinePipe(String name) {
        super(name, 0);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if ((aTick & 0x1FL) == 31L) {
                this.mConnections = 0;
                this.connectionCount = 0;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    IMetaTileEntity meta;
                    ForgeDirection d1 = dir.getOpposite();
                    TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(dir);
                    if (tTileEntity instanceof IConnectsToBeamline) {
                        if (!((IConnectsToBeamline)tTileEntity).canConnect(d1)) continue;
                        this.mConnections = (byte)(this.mConnections | 1 << dir.ordinal());
                        this.connectionCount = (byte)(this.connectionCount + 1);
                        continue;
                    }
                    if (!(tTileEntity instanceof IGregTechTileEntity) || !((meta = ((IGregTechTileEntity)tTileEntity).getMetaTileEntity()) instanceof IConnectsToBeamline) || !((IConnectsToBeamline)meta).canConnect(d1)) continue;
                    this.mConnections = (byte)(this.mConnections | 1 << dir.ordinal());
                    this.connectionCount = (byte)(this.connectionCount + 1);
                }
            }
        } else if (aBaseMetaTileEntity.isClientSide() && GTClient.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public byte getTileEntityBaseType() {
        return 7;
    }

    @Override
    public void loadNBTData(NBTTagCompound arg0) {
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new MTEBeamlinePipe(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound arg0) {
    }

    @Override
    public float getThickNess() {
        if (GTMod.instance.isClientSide() && GTClient.hideValue == 1) {
            return 0.0625f;
        }
        return 0.5f;
    }

    @Override
    public boolean renderInside(ForgeDirection arg0) {
        return false;
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public IConnectsToBeamline getNext(IConnectsToBeamline source) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        pipe = new Textures.BlockIcons.CustomIcon("iconsets/pipe");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection aSide, int aConnections, int aColorIndex, boolean aConnected, boolean aRedstone) {
        return new ITexture[]{new GTTextureBuilder().addIcon(pipe).build(), new GTTextureBuilder().addIcon(pipe).setRGBA(Dyes.getModulation((byte)aColorIndex, Dyes.MACHINE_METAL.getRGBA())).build()};
    }

    public void markUsed() {
        this.active = true;
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        byte tConn;
        float tSpace;
        float tSide0 = tSpace = 0.3125f;
        float tSide1 = 1.0f - tSpace;
        float tSide2 = tSpace;
        float tSide3 = 1.0f - tSpace;
        float tSide4 = tSpace;
        float tSide5 = 1.0f - tSpace;
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.DOWN) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.UP) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.NORTH) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.SOUTH) != 0) {
            tSide4 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.WEST) != 0) {
            tSide4 = 0.0f;
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.EAST) != 0) {
            tSide2 = 0.0f;
            tSide0 = 0.0f;
            tSide5 = 1.0f;
            tSide3 = 1.0f;
            tSide1 = 1.0f;
        }
        if (((tConn = ((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections) & 1 << ForgeDirection.DOWN.ordinal()) != 0) {
            tSide0 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.UP.ordinal()) != 0) {
            tSide1 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.NORTH.ordinal()) != 0) {
            tSide2 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.SOUTH.ordinal()) != 0) {
            tSide3 = 1.0f;
        }
        if ((tConn & 1 << ForgeDirection.WEST.ordinal()) != 0) {
            tSide4 = 0.0f;
        }
        if ((tConn & 1 << ForgeDirection.EAST.ordinal()) != 0) {
            tSide5 = 1.0f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)aX + tSide4), (double)((float)aY + tSide0), (double)((float)aZ + tSide2), (double)((float)aX + tSide5), (double)((float)aY + tSide1), (double)((float)aZ + tSide3));
    }

    @Override
    public String[] getDescription() {
        return new String[]{StatCollector.func_74838_a((String)"beamline.pipe.desc.0"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"beamline.pipe.desc.1"), "Added by " + EnumChatFormatting.GREEN + "GTNH: Lanthanides"};
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }
}

