/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.blocks.textures;

import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gtPlusPlus.xmod.gregtech.common.blocks.GregtechMetaCasingBlocks;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.CasingTextureHandler;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.MTEIndustrialCentrifuge;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TexturesCentrifugeMultiblock {
    public IIcon handleCasingsGT(IBlockAccess aWorld, int xCoord, int yCoord, int zCoord, ForgeDirection side, GregtechMetaCasingBlocks thisBlock) {
        return this.handleCasingsGT58(aWorld, xCoord, yCoord, zCoord, side, thisBlock);
    }

    private static int isCentrifugeControllerWithSide(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection side) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (!(tTileEntity instanceof IGregTechTileEntity)) {
            return 0;
        }
        IGregTechTileEntity tTile = (IGregTechTileEntity)tTileEntity;
        if (tTile.getMetaTileEntity() instanceof MTEIndustrialCentrifuge && tTile.getFrontFacing() == side) {
            return tTile.isActive() ? 1 : 2;
        }
        return 0;
    }

    public IIcon handleCasingsGT58(IBlockAccess aWorld, int xCoord, int yCoord, int zCoord, ForgeDirection side, GregtechMetaCasingBlocks thisBlock) {
        int tMeta = aWorld.func_72805_g(xCoord, yCoord, zCoord);
        int ordinalSide = side.ordinal();
        if (tMeta != 0) {
            return CasingTextureHandler.getIcon(ordinalSide, tMeta);
        }
        int tInvertLeftRightMod = ordinalSide % 2 * 2 - 1;
        switch (ordinalSide / 2) {
            case 0: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        if (i == 0 && j == 0 || TexturesCentrifugeMultiblock.isCentrifugeControllerWithSide(aWorld, xCoord + j, yCoord, zCoord + i, side) == 0) continue;
                        IMetaTileEntity tMetaTileEntity = ((IGregTechTileEntity)aWorld.func_147438_o(xCoord + j, yCoord, zCoord + i)).getMetaTileEntity();
                        return this.getIconByIndex(tMetaTileEntity, 4 - i * 3 - j);
                    }
                }
                break;
            }
            case 1: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        if (i == 0 && j == 0 || TexturesCentrifugeMultiblock.isCentrifugeControllerWithSide(aWorld, xCoord + j, yCoord + i, zCoord, side) == 0) continue;
                        IMetaTileEntity tMetaTileEntity = ((IGregTechTileEntity)aWorld.func_147438_o(xCoord + j, yCoord + i, zCoord)).getMetaTileEntity();
                        return this.getIconByIndex(tMetaTileEntity, 4 + i * 3 - j * tInvertLeftRightMod);
                    }
                }
                break;
            }
            case 2: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        if (i == 0 && j == 0 || TexturesCentrifugeMultiblock.isCentrifugeControllerWithSide(aWorld, xCoord, yCoord + i, zCoord + j, side) == 0) continue;
                        IMetaTileEntity tMetaTileEntity = ((IGregTechTileEntity)aWorld.func_147438_o(xCoord, yCoord + i, zCoord + j)).getMetaTileEntity();
                        return this.getIconByIndex(tMetaTileEntity, 4 + i * 3 + j * tInvertLeftRightMod);
                    }
                }
                break;
            }
        }
        return TexturesGtBlock.Casing_Material_Centrifuge.getIcon();
    }

    public boolean isCentrifugeRunning(IMetaTileEntity aTile) {
        if (aTile == null) {
            return false;
        }
        return aTile.getBaseMetaTileEntity().isActive();
    }

    public boolean isUsingAnimatedTexture(IMetaTileEntity aMetaTileEntity) {
        if (aMetaTileEntity != null && aMetaTileEntity instanceof MTEIndustrialCentrifuge) {
            return ((MTEIndustrialCentrifuge)aMetaTileEntity).usingAnimations();
        }
        return false;
    }

    public IIcon getIconByIndex(IMetaTileEntity aMetaTileEntity, int aIndex) {
        if (this.isUsingAnimatedTexture(aMetaTileEntity) && this.isCentrifugeRunning(aMetaTileEntity)) {
            return TexturesGtBlock.CENTRIFUGEACTIVE[aIndex].getIcon();
        }
        return TexturesGtBlock.CENTRIFUGE[aIndex].getIcon();
    }
}

