/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.data;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TypeCounter<V>
implements Set<V> {
    private final Map<String, InternalTypeCounterObject<V>> mInternalMap = new LinkedHashMap<String, InternalTypeCounterObject<V>>();
    private String mHighestValueKey;
    private int mHighestValue = 0;
    private final Class mClass;

    public TypeCounter(Class o) {
        Logger.WARNING("Created new TypeCounter for " + o.getName());
        this.mClass = o;
    }

    @Override
    public boolean add(V arg0) {
        return this.add(arg0, null);
    }

    public boolean add(V arg0, String aKeyName) {
        String aKey = aKeyName != null ? aKeyName : arg0.toString();
        InternalTypeCounterObject<V> aValue = this.mInternalMap.get(aKey);
        if (aValue == null) {
            aValue = new InternalTypeCounterObject<V>(arg0);
            Logger.WARNING("Adding new key to map: " + aKey);
        }
        aValue.add();
        int a = aValue.count();
        if (a > this.mHighestValue) {
            this.mHighestValue = a;
            this.mHighestValueKey = aKey;
            Logger.WARNING("New Highest Count - " + aKey + ":" + a);
        }
        this.mInternalMap.put(aKey, aValue);
        Logger.WARNING(aKey + ":" + a);
        return true;
    }

    @Override
    public boolean addAll(Collection arg0) {
        boolean aReturn = true;
        for (Object o : arg0) {
            Object j;
            boolean b;
            if (!this.mClass.isInstance(o) || (b = this.add((V)(j = o)))) continue;
            aReturn = false;
        }
        return aReturn;
    }

    @Override
    public void clear() {
        this.mInternalMap.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.mInternalMap.containsKey(arg0.toString());
    }

    @Override
    public boolean containsAll(Collection arg0) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.mInternalMap.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return null;
    }

    @Override
    public boolean remove(Object arg0) {
        InternalTypeCounterObject<V> aValue = this.mInternalMap.remove(arg0.toString());
        return aValue != null;
    }

    @Override
    public boolean removeAll(Collection arg0) {
        boolean aReturn = true;
        for (Object o : arg0) {
            boolean a = this.remove(o);
            if (a) continue;
            aReturn = false;
        }
        return aReturn;
    }

    @Override
    public boolean retainAll(Collection arg0) {
        return false;
    }

    @Override
    public int size() {
        return this.mInternalMap.size();
    }

    @Override
    public Object[] toArray() {
        Object[] aArray = new Object[this.mInternalMap.size()];
        int aPos = 0;
        for (String k : this.mInternalMap.keySet()) {
            if (k == null) continue;
            InternalTypeCounterObject<V> aVal = this.mInternalMap.get(k);
            aArray[aPos++] = new Pair<String, InternalTypeCounterObject<V>>(k, aVal);
        }
        return aArray;
    }

    @Override
    public V[] toArray(Object[] a) {
        Object[] aArray = new Object[a.length];
        int aPos = 0;
        for (Object k : a) {
            if (k == null) continue;
            aArray[aPos++] = k;
        }
        return aArray;
    }

    public V getResults() {
        InternalTypeCounterObject<V> x = this.mInternalMap.get(this.mHighestValueKey);
        return x.get();
    }

    public static class InternalTypeCounterObject<Z> {
        private final Z mObject;
        private int mCounter = 0;

        public InternalTypeCounterObject(Z o) {
            this.mObject = o;
        }

        public String hash() {
            return String.valueOf(this.mObject.hashCode());
        }

        public Z get() {
            return this.mObject;
        }

        public void add() {
            ++this.mCounter;
        }

        public int count() {
            return this.mCounter;
        }
    }
}

