/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pollution;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.ICleanroom;
import gregtech.api.interfaces.ICleanroomReceiver;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GTPacketPollution;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTChunkAssociatedData;
import gregtech.api.util.GTUtility;
import gregtech.common.GTProxy;
import gregtech.common.pollution.BlockMatcher;
import gregtech.common.pollution.PollutionConfig;
import gregtech.common.pollution.PollutionRenderer;
import gregtech.common.pollution.PollutionTooltip;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class Pollution {
    private static final Storage STORAGE = new Storage();
    private List<ChunkCoordIntPair> pollutionList = new ArrayList<ChunkCoordIntPair>();
    private final Set<ChunkCoordIntPair> pollutedChunks = new HashSet<ChunkCoordIntPair>();
    private int operationsPerTick = 0;
    private static final short cycleLen = 1200;
    private final World world;
    private boolean blank = true;
    public static int mPlayerPollution;
    private static final int POLLUTIONPACKET_MINVALUE = 1000;
    private static GT_PollutionEventHandler EVENT_HANDLER;
    public static BlockMatcher standardBlocks;
    public static BlockMatcher liquidBlocks;
    public static BlockMatcher doublePlants;
    public static BlockMatcher crossedSquares;
    public static BlockMatcher blockVine;

    public Pollution(World world) {
        this.world = world;
        if (EVENT_HANDLER == null) {
            EVENT_HANDLER = new GT_PollutionEventHandler();
            MinecraftForge.EVENT_BUS.register((Object)EVENT_HANDLER);
        }
    }

    public static void onWorldTick(TickEvent.WorldTickEvent aEvent) {
        if (!GTMod.gregtechproxy.mPollution) {
            return;
        }
        if (aEvent.phase == TickEvent.Phase.START) {
            return;
        }
        Pollution pollutionInstance = GTProxy.dimensionWisePollution.get(aEvent.world.field_73011_w.field_76574_g);
        if (pollutionInstance == null) {
            return;
        }
        pollutionInstance.tickPollutionInWorld((int)(aEvent.world.func_82737_E() % 1200L));
    }

    public static void onPostInitClient() {
        if (PollutionConfig.pollution) {
            standardBlocks = new BlockMatcher();
            liquidBlocks = new BlockMatcher();
            doublePlants = new BlockMatcher();
            crossedSquares = new BlockMatcher();
            blockVine = new BlockMatcher();
            standardBlocks.updateClassList(PollutionConfig.renderStandardBlock);
            liquidBlocks.updateClassList(PollutionConfig.renderBlockLiquid);
            doublePlants.updateClassList(PollutionConfig.renderBlockDoublePlant);
            crossedSquares.updateClassList(PollutionConfig.renderCrossedSquares);
            blockVine.updateClassList(PollutionConfig.renderblockVine);
            MinecraftForge.EVENT_BUS.register((Object)standardBlocks);
            MinecraftForge.EVENT_BUS.register((Object)liquidBlocks);
            MinecraftForge.EVENT_BUS.register((Object)doublePlants);
            MinecraftForge.EVENT_BUS.register((Object)crossedSquares);
            MinecraftForge.EVENT_BUS.register((Object)blockVine);
            MinecraftForge.EVENT_BUS.register((Object)new PollutionTooltip());
        }
    }

    private void tickPollutionInWorld(int aTickID) {
        if (aTickID == 0 || this.blank) {
            this.pollutionList = new ArrayList<ChunkCoordIntPair>(this.pollutedChunks);
            this.operationsPerTick = !this.pollutionList.isEmpty() ? Math.max(1, this.pollutionList.size() / 1200) : 0;
            this.blank = false;
        }
        for (int chunksProcessed = 0; chunksProcessed < this.operationsPerTick && !this.pollutionList.isEmpty(); ++chunksProcessed) {
            ChunkCoordIntPair actualPos = this.pollutionList.remove(this.pollutionList.size() - 1);
            ChunkData currentData = (ChunkData)STORAGE.get(this.world, actualPos);
            int tPollution = currentData.getAmount();
            if ((tPollution = (int)(0.9945f * (float)tPollution)) > 400000) {
                ChunkCoordIntPair[] tNeighbors = new ChunkCoordIntPair[]{new ChunkCoordIntPair(actualPos.field_77276_a + 1, actualPos.field_77275_b), new ChunkCoordIntPair(actualPos.field_77276_a - 1, actualPos.field_77275_b), new ChunkCoordIntPair(actualPos.field_77276_a, actualPos.field_77275_b + 1), new ChunkCoordIntPair(actualPos.field_77276_a, actualPos.field_77275_b - 1)};
                for (ChunkCoordIntPair neighborPosition : tNeighbors) {
                    ChunkData neighbor = (ChunkData)STORAGE.get(this.world, neighborPosition);
                    int neighborPollution = neighbor.getAmount();
                    if (neighborPollution * 6 >= tPollution * 5) continue;
                    int tDiff = tPollution - neighborPollution;
                    neighborPollution = GTUtility.safeInt((long)neighborPollution + (long)(tDiff /= 20));
                    tPollution -= tDiff;
                    this.setChunkPollution(neighborPosition, neighborPollution);
                }
                if (tPollution > GTMod.gregtechproxy.mPollutionSmogLimit) {
                    AxisAlignedBB chunk = AxisAlignedBB.func_72330_a((double)(actualPos.field_77276_a << 4), (double)0.0, (double)(actualPos.field_77275_b << 4), (double)((actualPos.field_77276_a << 4) + 16), (double)256.0, (double)((actualPos.field_77275_b << 4) + 16));
                    List tEntitys = this.world.func_72872_a(EntityLivingBase.class, chunk);
                    for (EntityLivingBase tEnt : tEntitys) {
                        if (tEnt instanceof EntityPlayerMP && ((EntityPlayerMP)tEnt).field_71075_bZ.field_75098_d || GTUtility.isWearingFullGasHazmat(tEnt)) continue;
                        switch (XSTR.XSTR_INSTANCE.nextInt(3)) {
                            default: {
                                tEnt.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, Math.min(tPollution / 1000, 1000), tPollution / 400000));
                            }
                            case 1: {
                                tEnt.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, Math.min(tPollution / 1000, 1000), tPollution / 400000));
                            }
                            case 2: 
                        }
                        tEnt.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, Math.min(tPollution / 1000, 1000), tPollution / 400000));
                    }
                    if (tPollution > GTMod.gregtechproxy.mPollutionPoisonLimit) {
                        for (EntityLivingBase tEnt : tEntitys) {
                            if (tEnt instanceof EntityPlayerMP && ((EntityPlayerMP)tEnt).field_71075_bZ.field_75098_d || GTUtility.isWearingFullGasHazmat(tEnt)) continue;
                            switch (XSTR.XSTR_INSTANCE.nextInt(4)) {
                                default: {
                                    tEnt.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, tPollution / 500000));
                                }
                                case 1: {
                                    tEnt.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, Math.min(tPollution / 2000, 1000), 1));
                                }
                                case 2: {
                                    tEnt.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, Math.min(tPollution / 4000, 1000), tPollution / 500000));
                                }
                                case 3: 
                            }
                            tEnt.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, Math.min(tPollution / 2000, 1000), 1));
                        }
                        if (tPollution > GTMod.gregtechproxy.mPollutionVegetationLimit) {
                            for (int f = 20; f < tPollution / 25000; ++f) {
                                int x = (actualPos.field_77276_a << 4) + XSTR.XSTR_INSTANCE.nextInt(16);
                                int y = 60 + (-f + XSTR.XSTR_INSTANCE.nextInt(f * 2 + 1));
                                int z = (actualPos.field_77275_b << 4) + XSTR.XSTR_INSTANCE.nextInt(16);
                                Pollution.damageBlock(this.world, x, y, z, tPollution > GTMod.gregtechproxy.mPollutionSourRainLimit);
                            }
                        }
                    }
                }
            }
            this.setChunkPollution(actualPos, tPollution);
            if (tPollution <= 1000) continue;
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.world.field_73011_w.field_76574_g, (double)(actualPos.field_77276_a << 4), 64.0, (double)(actualPos.field_77275_b << 4), 256.0);
            GTValues.NW.sendToAllAround(new GTPacketPollution(actualPos, tPollution), point);
        }
    }

    private void setChunkPollution(ChunkCoordIntPair coord, int pollution) {
        Pollution.mutatePollution(this.world, coord.field_77276_a, coord.field_77275_b, c -> c.setAmount(pollution), this.pollutedChunks);
    }

    private static void damageBlock(World world, int x, int y, int z, boolean sourRain) {
        if (world.field_72995_K) {
            return;
        }
        Block tBlock = world.func_147439_a(x, y, z);
        int tMeta = world.func_72805_g(x, y, z);
        if (tBlock == Blocks.field_150350_a || tBlock == Blocks.field_150348_b || tBlock == Blocks.field_150354_m || tBlock == Blocks.field_150330_I) {
            return;
        }
        if (tBlock == Blocks.field_150362_t || tBlock == Blocks.field_150361_u || tBlock.func_149688_o() == Material.field_151584_j) {
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150436_aH) {
            tBlock.func_149697_b(world, x, y, z, tMeta, 0);
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150329_H) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150330_I);
        }
        if (tBlock == Blocks.field_150395_bd) {
            tBlock.func_149697_b(world, x, y, z, tMeta, 0);
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150392_bi || tBlock == Blocks.field_150464_aj || tBlock == Blocks.field_150434_aF || tBlock.func_149688_o() == Material.field_151570_A || tBlock == Blocks.field_150440_ba || tBlock == Blocks.field_150394_bc) {
            tBlock.func_149697_b(world, x, y, z, tMeta, 0);
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150328_O || tBlock == Blocks.field_150327_N || tBlock == Blocks.field_150459_bM || tBlock == Blocks.field_150469_bN || tBlock == Blocks.field_150423_aK || tBlock == Blocks.field_150393_bb) {
            tBlock.func_149697_b(world, x, y, z, tMeta, 0);
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150345_g || tBlock.func_149688_o() == Material.field_151585_k) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150330_I);
        }
        if (tBlock == Blocks.field_150375_by) {
            tBlock.func_149697_b(world, x, y, z, tMeta, 0);
            world.func_147468_f(x, y, z);
        }
        if (tBlock == Blocks.field_150341_Y) {
            world.func_147449_b(x, y, z, Blocks.field_150347_e);
        }
        if (tBlock == Blocks.field_150349_c || tBlock.func_149688_o() == Material.field_151577_b) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
        }
        if (tBlock == Blocks.field_150458_ak || tBlock == Blocks.field_150346_d) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150354_m);
        }
        if (sourRain && world.func_72896_J() && (tBlock == Blocks.field_150351_n || tBlock == Blocks.field_150347_e) && world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a && world.func_72937_j(x, y, z)) {
            if (tBlock == Blocks.field_150347_e) {
                world.func_147449_b(x, y, z, Blocks.field_150351_n);
            } else {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150354_m);
            }
        }
    }

    private static Pollution getPollutionManager(World world) {
        return GTProxy.dimensionWisePollution.computeIfAbsent(world.field_73011_w.field_76574_g, i -> new Pollution(world));
    }

    public static void addPollution(IGregTechTileEntity te, int aPollution) {
        Pollution.addPollution((TileEntity)te, aPollution);
    }

    public static void addPollution(TileEntity te, int aPollution) {
        ICleanroomReceiver receiver;
        ICleanroom cleanroom;
        if (!GTMod.gregtechproxy.mPollution || aPollution == 0 || te.func_145831_w().field_72995_K) {
            return;
        }
        if (aPollution > 0 && te instanceof ICleanroomReceiver && (cleanroom = (receiver = (ICleanroomReceiver)te).getCleanroom()) != null && cleanroom.isValidCleanroom()) {
            cleanroom.pollute();
        }
        Pollution.addPollution(te.func_145831_w(), te.field_145851_c >> 4, te.field_145849_e >> 4, aPollution);
    }

    public static void addPollution(Chunk ch, int aPollution) {
        Pollution.addPollution(ch.field_76637_e, ch.field_76635_g, ch.field_76647_h, aPollution);
    }

    public static void addPollution(World w, int chunkX, int chunkZ, int aPollution) {
        if (!GTMod.gregtechproxy.mPollution || aPollution == 0 || w.field_72995_K) {
            return;
        }
        Pollution.mutatePollution(w, chunkX, chunkZ, d -> d.changeAmount(aPollution), null);
    }

    private static void mutatePollution(World world, int x, int z, Consumer<ChunkData> mutator, @Nullable Set<ChunkCoordIntPair> chunks) {
        boolean hasPollution;
        ChunkData data = (ChunkData)STORAGE.get(world, x, z);
        boolean hadPollution = data.getAmount() > 0;
        mutator.accept(data);
        boolean bl = hasPollution = data.getAmount() > 0;
        if (hasPollution != hadPollution) {
            if (chunks == null) {
                chunks = Pollution.getPollutionManager((World)world).pollutedChunks;
            }
            if (hasPollution) {
                chunks.add(new ChunkCoordIntPair(x, z));
            } else {
                chunks.remove(new ChunkCoordIntPair(x, z));
            }
        }
    }

    public static int getPollution(IGregTechTileEntity te) {
        return Pollution.getPollution(te.getWorld(), te.getXCoord() >> 4, te.getZCoord() >> 4);
    }

    public static int getPollution(Chunk ch) {
        return Pollution.getPollution(ch.field_76637_e, ch.field_76635_g, ch.field_76647_h);
    }

    public static int getPollution(World w, int chunkX, int chunkZ) {
        if (!GTMod.gregtechproxy.mPollution) {
            return 0;
        }
        if (w.field_72995_K) {
            return PollutionRenderer.getKnownPollution(chunkX << 4, chunkZ << 4);
        }
        return ((ChunkData)STORAGE.get(w, chunkX, chunkZ)).getAmount();
    }

    @Deprecated
    public static int getPollution(ChunkCoordIntPair aCh, int aDim) {
        return Pollution.getPollution((World)DimensionManager.getWorld((int)aDim), aCh.field_77276_a, aCh.field_77275_b);
    }

    public static boolean hasPollution(Chunk ch) {
        if (!GTMod.gregtechproxy.mPollution) {
            return false;
        }
        return STORAGE.isCreated(ch.field_76637_e, ch.func_76632_l()) && ((ChunkData)STORAGE.get(ch)).getAmount() > 0;
    }

    @Deprecated
    public static void addPollution(World aWorld, ChunkPosition aPos, int aPollution) {
        Pollution.addPollution(aWorld.func_72938_d(aPos.field_151329_a, aPos.field_151328_c), aPollution);
    }

    public static void migrate(ChunkDataEvent.Load e) {
        Pollution.addPollution(e.getChunk(), e.getData().func_74762_e("GTPOLLUTION"));
    }

    @ParametersAreNonnullByDefault
    private static final class Storage
    extends GTChunkAssociatedData<ChunkData> {
        private Storage() {
            super("Pollution", ChunkData.class, 64, (byte)0, false);
        }

        @Override
        protected void writeElement(DataOutput output, ChunkData element, World world, int chunkX, int chunkZ) throws IOException {
            output.writeInt(element.getAmount());
        }

        @Override
        protected ChunkData readElement(DataInput input, int version, World world, int chunkX, int chunkZ) throws IOException {
            if (version != 0) {
                throw new IOException("Region file corrupted");
            }
            ChunkData data = new ChunkData(input.readInt());
            if (data.getAmount() > 0) {
                Pollution.getPollutionManager(world).pollutedChunks.add(new ChunkCoordIntPair(chunkX, chunkZ));
            }
            return data;
        }

        @Override
        protected ChunkData createElement(World world, int chunkX, int chunkZ) {
            return new ChunkData();
        }

        @Override
        public void loadAll(World w) {
            super.loadAll(w);
        }

        public boolean isCreated(World world, ChunkCoordIntPair coord) {
            return this.isCreated(world.field_73011_w.field_76574_g, coord.field_77276_a, coord.field_77275_b);
        }
    }

    public static class GT_PollutionEventHandler {
        @SubscribeEvent
        public void chunkWatch(ChunkWatchEvent.Watch event) {
            int pollution;
            if (!GTMod.gregtechproxy.mPollution) {
                return;
            }
            World world = event.player.field_70170_p;
            if (STORAGE.isCreated(world, event.chunk) && (pollution = ((ChunkData)STORAGE.get(world, event.chunk)).getAmount()) > 1000) {
                GTValues.NW.sendToPlayer(new GTPacketPollution(event.chunk, pollution), event.player);
            }
        }

        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load e) {
            if (!e.world.field_72995_K) {
                STORAGE.loadAll(e.world);
            }
        }
    }

    private static final class ChunkData
    implements GTChunkAssociatedData.IData {
        public int amount;

        private ChunkData() {
            this(0);
        }

        private ChunkData(int amount) {
            this.amount = Math.max(0, amount);
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = Math.max(amount, 0);
        }

        public void changeAmount(int delta) {
            this.amount = Math.max(GTUtility.safeInt((long)this.amount + (long)delta, 0), 0);
        }

        @Override
        public boolean isSameAsDefault() {
            return this.amount == 0;
        }
    }
}

