/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import com.gtnewhorizons.modularui.api.fluids.IFluidTankLong;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.tileentity.IVoidable;
import gregtech.api.logic.FluidInventoryLogic;
import gregtech.api.logic.ItemInventoryLogic;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class VoidProtectionHelper {
    private IVoidable machine;
    private boolean protectExcessItem;
    private boolean protectExcessFluid;
    private int maxParallel = 1;
    private boolean isItemFull;
    private boolean isFluidFull;
    private ItemStack[] itemOutputs;
    private FluidStack[] fluidOutputs;
    private ItemInventoryLogic itemOutputInventory;
    private FluidInventoryLogic fluidOutputInventory;
    private boolean built;
    private boolean muteMode;
    private int outputMultiplier = 1;
    private double chanceMultiplier = 1.0;
    private Function<Integer, Integer> chanceGetter = i -> 10000;

    public VoidProtectionHelper setMachine(IVoidable machine) {
        return this.setMachine(machine, machine.protectsExcessItem(), machine.protectsExcessFluid());
    }

    public VoidProtectionHelper setMachine(IVoidable machine, boolean protectExcessItem, boolean protectExcessFluid) {
        this.protectExcessItem = protectExcessItem;
        this.protectExcessFluid = protectExcessFluid;
        this.machine = machine;
        return this;
    }

    public VoidProtectionHelper setItemOutputs(ItemStack[] itemOutputs) {
        this.itemOutputs = itemOutputs;
        return this;
    }

    public VoidProtectionHelper setFluidOutputs(FluidStack[] fluidOutputs) {
        this.fluidOutputs = fluidOutputs;
        return this;
    }

    public VoidProtectionHelper setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
        return this;
    }

    public VoidProtectionHelper setItemOutputInventory(ItemInventoryLogic itemOutputInventory) {
        this.itemOutputInventory = itemOutputInventory;
        return this;
    }

    public VoidProtectionHelper setFluidOutputInventory(FluidInventoryLogic fluidOutputInventory) {
        this.fluidOutputInventory = fluidOutputInventory;
        return this;
    }

    public VoidProtectionHelper setMuTEMode(boolean muteMode) {
        this.muteMode = muteMode;
        return this;
    }

    public VoidProtectionHelper setOutputMultiplier(int outputMultiplier) {
        this.outputMultiplier = outputMultiplier;
        return this;
    }

    public VoidProtectionHelper setChanceMultiplier(double chanceMultiplier) {
        this.chanceMultiplier = chanceMultiplier;
        return this;
    }

    public VoidProtectionHelper setChangeGetter(Function<Integer, Integer> getter) {
        this.chanceGetter = getter;
        return this;
    }

    public VoidProtectionHelper build() {
        if (this.built) {
            throw new IllegalStateException("Tried to build twice");
        }
        if (this.machine == null) {
            throw new IllegalStateException("Machine is not set");
        }
        this.built = true;
        this.determineParallel();
        return this;
    }

    public int getMaxParallel() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get parallels before building");
        }
        return this.maxParallel;
    }

    public boolean isItemFull() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get isItemFull before building");
        }
        return this.isItemFull;
    }

    public boolean isFluidFull() {
        if (!this.built) {
            throw new IllegalStateException("Tried to get isFluidFull before building");
        }
        return this.isFluidFull;
    }

    private void determineParallel() {
        if (this.itemOutputs == null) {
            this.itemOutputs = new ItemStack[0];
        }
        if (this.fluidOutputs == null) {
            this.fluidOutputs = new FluidStack[0];
        }
        if (this.protectExcessItem && this.itemOutputs.length > 0 && !this.machine.canDumpItemToME()) {
            this.maxParallel = Math.min(this.calculateMaxItemParallels(), this.maxParallel);
            if (this.maxParallel <= 0) {
                this.isItemFull = true;
                return;
            }
        }
        if (this.protectExcessFluid && this.fluidOutputs.length > 0) {
            this.maxParallel = Math.min(this.calculateMaxFluidParallels(), this.maxParallel);
            if (this.maxParallel <= 0) {
                this.isFluidFull = true;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private int calculateMaxFluidParallels() {
        void var6_10;
        List<? extends IFluidStore> hatches = this.machine.getFluidOutputSlots(this.fluidOutputs);
        if (hatches.size() < this.fluidOutputs.length) {
            return 0;
        }
        HashMap<FluidStack, Integer> tFluidOutputMap = new HashMap<FluidStack, Integer>();
        HashMap<FluidStack, ParallelData> tParallels = new HashMap<FluidStack, ParallelData>();
        FluidStack[] fluidStackArray = this.fluidOutputs;
        int n = fluidStackArray.length;
        boolean bl = false;
        while (var6_10 < n) {
            FluidStack aY = fluidStackArray[var6_10];
            if (aY != null && aY.amount > 0) {
                tFluidOutputMap.merge(aY, aY.amount, Integer::sum);
                tParallels.put(aY, new ParallelData(0, 0L));
            }
            ++var6_10;
        }
        if (tFluidOutputMap.isEmpty()) {
            return this.maxParallel;
        }
        for (IFluidStore iFluidStore : hatches) {
            int n2 = iFluidStore.getAvailableSpace();
            if (n2 <= 0 || iFluidStore.isEmptyAndAcceptsAnyFluid()) continue;
            for (Map.Entry entry : tParallels.entrySet()) {
                FluidStack tFluidOutput = (FluidStack)entry.getKey();
                if (!iFluidStore.canStoreFluid(tFluidOutput)) continue;
                ParallelData tParallel = (ParallelData)entry.getValue();
                Integer tCraftSize = (Integer)tFluidOutputMap.get(tFluidOutput);
                tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + (long)n2) / (long)tCraftSize.intValue());
                tParallel.partial = (tParallel.partial + (long)n2) % (long)tCraftSize.intValue();
            }
        }
        PriorityQueue<ParallelStackInfo> aParallelQueue = new PriorityQueue<ParallelStackInfo>(Comparator.comparing(i -> ((ParallelStackInfo)i).batch));
        for (Map.Entry entry : tParallels.entrySet()) {
            aParallelQueue.add(new ParallelStackInfo(((ParallelData)entry.getValue()).batch, ((ParallelData)entry.getValue()).partial, (FluidStack)entry.getKey()));
        }
        for (IFluidStore iFluidStore : hatches) {
            if (!iFluidStore.isEmptyAndAcceptsAnyFluid()) continue;
            ParallelStackInfo tParallel = aParallelQueue.poll();
            assert (tParallel != null);
            Integer n3 = (Integer)tFluidOutputMap.get(tParallel.stack);
            int tSpaceLeft = iFluidStore.getAvailableSpace();
            tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + (long)tSpaceLeft) / (long)n3.intValue());
            tParallel.partial = (tParallel.partial + (long)tSpaceLeft) % (long)n3.intValue();
            aParallelQueue.add(tParallel);
        }
        return ((ParallelStackInfo)aParallelQueue.element()).batch;
    }

    private int calculateMaxFluidParallelsMuTE() {
        if (this.fluidOutputs.length > this.fluidOutputInventory.getInventory().getTanks()) {
            return 0;
        }
        HashMap<FluidStack, Integer> tFluidOutputMap = new HashMap<FluidStack, Integer>();
        HashMap<FluidStack, ParallelData> tParallels = new HashMap<FluidStack, ParallelData>();
        for (FluidStack aY : this.fluidOutputs) {
            int fluidAmount;
            if (aY == null || (fluidAmount = aY.amount * this.outputMultiplier) <= 0) continue;
            tFluidOutputMap.merge(aY, fluidAmount, Integer::sum);
            tParallels.put(aY, new ParallelData(0, 0L));
        }
        if (tFluidOutputMap.isEmpty()) {
            return this.maxParallel;
        }
        for (int i2 = 0; i2 < this.fluidOutputInventory.getInventory().getTanks(); ++i2) {
            IFluidTankLong tank = this.fluidOutputInventory.getInventory().getFluidTank(i2);
            long tSpaceLeft = tank.getCapacityLong() - tank.getFluidAmountLong();
            if (tSpaceLeft <= 0L || tank.getStoredFluid() == null) continue;
            for (Map.Entry entry : tParallels.entrySet()) {
                FluidStack tFluidOutput = (FluidStack)entry.getKey();
                if (tank.fill(tFluidOutput.getFluid(), (long)tFluidOutput.amount, false) == (long)tFluidOutput.amount) continue;
                ParallelData tParallel = (ParallelData)entry.getValue();
                Integer tCraftSize = (Integer)tFluidOutputMap.get(tFluidOutput);
                tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + tSpaceLeft) / (long)tCraftSize.intValue());
                tParallel.partial = (tParallel.partial + tSpaceLeft) % (long)tCraftSize.intValue();
            }
        }
        PriorityQueue<ParallelStackInfo> aParallelQueue = new PriorityQueue<ParallelStackInfo>(Comparator.comparing(i -> ((ParallelStackInfo)i).batch));
        for (Map.Entry entry : tParallels.entrySet()) {
            aParallelQueue.add(new ParallelStackInfo(((ParallelData)entry.getValue()).batch, ((ParallelData)entry.getValue()).partial, (FluidStack)entry.getKey()));
        }
        for (int i3 = 0; i3 < this.fluidOutputInventory.getInventory().getTanks(); ++i3) {
            IFluidTankLong tank = this.fluidOutputInventory.getInventory().getFluidTank(i3);
            if (tank.getStoredFluid() != null) continue;
            ParallelStackInfo tParallel = aParallelQueue.poll();
            assert (tParallel != null);
            Integer tCraftSize = (Integer)tFluidOutputMap.get(tParallel.stack);
            long tSpaceLeft = tank.getCapacityLong();
            tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + tSpaceLeft) / (long)tCraftSize.intValue());
            tParallel.partial = (tParallel.partial + tSpaceLeft) % (long)tCraftSize.intValue();
            aParallelQueue.add(tParallel);
        }
        return ((ParallelStackInfo)aParallelQueue.element()).batch;
    }

    private int calculateMaxItemParallels() {
        List<ItemStack> busStacks = this.muteMode ? this.itemOutputInventory.getInventory().getStacks() : this.machine.getItemOutputSlots(this.itemOutputs);
        ItemStackMap tItemOutputMap = new ItemStackMap();
        ItemStackMap tParallels = new ItemStackMap();
        int tSlotsFree = 0;
        int index = 0;
        for (ItemStack tItem : this.itemOutputs) {
            int itemStackSize;
            if (tItem == null || (itemStackSize = (int)((double)(tItem.field_77994_a * this.outputMultiplier) * Math.ceil(this.chanceMultiplier * (double)this.chanceGetter.apply(index++).intValue() / 10000.0))) <= 0) continue;
            tItemOutputMap.merge(tItem, itemStackSize, Integer::sum);
            tParallels.put(tItem, new ParallelData(0, 0L));
        }
        if (tItemOutputMap.isEmpty()) {
            return this.maxParallel;
        }
        if (this.itemOutputs.length > 0) {
            for (ItemStack tBusStack : busStacks) {
                if (tBusStack == null) {
                    ++tSlotsFree;
                    continue;
                }
                int tMaxBusStackSize = tBusStack.func_77976_d();
                if (tBusStack.field_77994_a >= tMaxBusStackSize) continue;
                int tSpaceLeft = tMaxBusStackSize - tBusStack.field_77994_a;
                Integer tCraftSize = (Integer)tItemOutputMap.get(tBusStack);
                if (tCraftSize == null) continue;
                ParallelData tParallel = (ParallelData)tParallels.get(tBusStack);
                tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + (long)tSpaceLeft) / (long)tCraftSize.intValue());
                tParallel.partial = (tParallel.partial + (long)tSpaceLeft) % (long)tCraftSize.intValue();
            }
            PriorityQueue<ParallelStackInfo> aParallelQueue = new PriorityQueue<ParallelStackInfo>(Comparator.comparing(i -> ((ParallelStackInfo)i).batch));
            for (Map.Entry entry : tParallels.entrySet()) {
                aParallelQueue.add(new ParallelStackInfo(((ParallelData)entry.getValue()).batch, ((ParallelData)entry.getValue()).partial, (ItemStack)entry.getKey()));
            }
            while (tSlotsFree > 0) {
                ParallelStackInfo tParallel = aParallelQueue.poll();
                assert (tParallel != null);
                Integer tCraftSize = (Integer)tItemOutputMap.get(tParallel.stack);
                int tStackSize = ((ItemStack)tParallel.stack).func_77976_d();
                tParallel.batch = (int)((long)tParallel.batch + (tParallel.partial + (long)tStackSize) / (long)tCraftSize.intValue());
                tParallel.partial = (tParallel.partial + (long)tStackSize) % (long)tCraftSize.intValue();
                aParallelQueue.add(tParallel);
                --tSlotsFree;
            }
            return ((ParallelStackInfo)aParallelQueue.element()).batch;
        }
        return 0;
    }

    private static class ParallelData {
        private int batch;
        private long partial;

        private ParallelData(int batch, long partial) {
            this.batch = batch;
            this.partial = partial;
        }
    }

    private static class ParallelStackInfo<T> {
        private int batch;
        private long partial;
        private final T stack;

        private ParallelStackInfo(int batch, long partial, T stack) {
            this.batch = batch;
            this.partial = partial;
            this.stack = stack;
        }
    }
}

