/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.API.modularUI.BWUITextures;
import bartworks.MainMod;
import bartworks.common.configs.Configuration;
import bartworks.common.loaders.ItemRegistry;
import bartworks.util.BWTooltipReference;
import bartworks.util.ConnectedBlocksChecker;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTELESU
extends MTEMultiBlockBase {
    private static final byte TEXID_SIDE = 0;
    private static final byte TEXID_CHARGING = 1;
    private static final byte TEXID_IDLE = 2;
    private static final byte TEXID_EMPTY = 3;
    private static final IIcon[] iIcons = new IIcon[4];
    private static final IIconContainer[] iIconContainers = new IIconContainer[4];
    private static final ITexture[][] iTextures = new ITexture[4][1];
    public ConnectedBlocksChecker connectedcells;
    public final ItemStack[] circuits = new ItemStack[5];
    private final ItemStackHandler circuitsInventoryHandler = new ItemStackHandler(this.circuits){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private long mStorage;
    protected static final NumberFormatMUI numberFormat = new NumberFormatMUI();
    private long clientEU;
    private long clientMaxEU;
    private long clientMaxIn;
    private long clientMaxOut;
    private long clientAmps;

    public MTELESU(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.mStorage = Configuration.multiblocks.energyPerCell;
    }

    public MTELESU(String aName) {
        super(aName);
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public long maxEUStore() {
        return this.mStorage >= 0x7FFFFFFFFFFFFFFEL || this.mStorage < 0L ? 0x7FFFFFFFFFFFFFFEL : this.mStorage;
    }

    @Override
    public long maxAmperesIn() {
        int ret = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.circuits[i] == null || !this.circuits[i].func_77973_b().equals(GTUtility.getIntegratedCircuit(0).func_77973_b())) continue;
            ret += this.circuits[i].func_77960_j();
        }
        return ret > 0 ? (long)ret : 1L;
    }

    @Override
    public long maxAmperesOut() {
        return this.maxAmperesIn();
    }

    @Override
    public long maxEUInput() {
        for (int i = 1; i < GTValues.V.length; ++i) {
            if (this.maxEUOutput() > GTValues.V[i] || this.maxEUOutput() <= GTValues.V[i - 1]) continue;
            return Math.min(GTValues.V[i], 32768L);
        }
        return 8L;
    }

    @Override
    public long maxEUOutput() {
        return Math.min(Math.max(this.mStorage / (long)Configuration.multiblocks.energyPerCell, 1L), 32768L);
    }

    @Override
    public int rechargerSlotStartIndex() {
        return 0;
    }

    @Override
    public int rechargerSlotCount() {
        return 1;
    }

    @Override
    public int dechargerSlotStartIndex() {
        return 1;
    }

    @Override
    public int dechargerSlotCount() {
        return 1;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return true;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTELESU(this.mName);
    }

    @Override
    public String[] getDescription() {
        ArrayList<String> e = new ArrayList<String>();
        String[] dsc = StatCollector.func_74838_a((String)"tooltip.tile.lesu.0.name").split(";");
        Collections.addAll(e, dsc);
        e.add(StatCollector.func_74838_a((String)"tooltip.tile.lesu.1.name") + " " + GTUtility.formatNumbers(Configuration.multiblocks.energyPerCell) + "EU");
        dsc = StatCollector.func_74838_a((String)"tooltip.tile.lesu.2.name").split(";");
        Collections.addAll(e, dsc);
        e.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"tooltip.tile.lesu.3.name"));
        e.add(BWTooltipReference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get());
        return e.toArray(new String[0]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        for (int i = 0; i < iTextures.length; ++i) {
            MTELESU.iIcons[i] = aBlockIconRegister.func_94245_a("bartworks:LESU_CASING_" + i);
            final int finalI = i;
            MTELESU.iIconContainers[i] = new IIconContainer(){

                @Override
                public IIcon getIcon() {
                    return iIcons[finalI];
                }

                @Override
                public IIcon getOverlayIcon() {
                    return iIcons[finalI];
                }

                @Override
                public ResourceLocation getTextureFile() {
                    return new ResourceLocation("bartworks:LESU_CASING_" + finalI);
                }
            };
        }
    }

    public boolean isClientSide() {
        if (this.getWorld() != null) {
            return this.getWorld().field_72995_K ? FMLCommonHandler.instance().getSide() == Side.CLIENT : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] ret = new ITexture[]{};
        if (this.isClientSide()) {
            for (int i = 0; i < iTextures.length; ++i) {
                MTELESU.iTextures[i][0] = TextureFactory.of(iIconContainers[i], Dyes.getModulation(0, Dyes.MACHINE_METAL.mRGBa));
            }
            ret = side == facing && this.getBaseMetaTileEntity().getUniversalEnergyStored() <= 0L ? iTextures[3] : (side == facing && !aActive ? iTextures[2] : (side == facing && aActive ? iTextures[1] : iTextures[0]));
        }
        return ret;
    }

    @Override
    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return true;
    }

    @Override
    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return true;
    }

    @Override
    public int func_70302_i_() {
        return 6;
    }

    @Override
    public ItemStack func_70301_a(int slotIn) {
        if (slotIn > 1) {
            return this.circuits[slotIn - 2];
        }
        return this.mInventory[slotIn];
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (index < 2) {
            this.mInventory[index] = stack;
        } else {
            this.circuits[index - 2] = stack;
        }
    }

    @Override
    public String func_145825_b() {
        return "L.E.S.U.";
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        boolean bl;
        switch (index) {
            case 0: 
            case 1: {
                bl = true;
                break;
            }
            default: {
                bl = stack != null && stack.func_77973_b().equals(GTUtility.getIntegratedCircuit(0).func_77973_b());
            }
        }
        return bl;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean checkRecipe(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.checkMachine(aBaseMetaTileEntity, null);
        super.onFirstTick(aBaseMetaTileEntity);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mMaxProgresstime = 1;
            if (aTick % 20L == 0L) {
                this.checkMachine(aBaseMetaTileEntity, null);
            }
        }
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        this.mMaxProgresstime = 1;
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74783_a("customCircuitInv", GTUtility.stacksToIntArray(this.circuits));
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        int[] stacks = aNBT.func_74759_k("customCircuitInv");
        for (int i = 0; i < stacks.length; ++i) {
            this.circuits[i] = GTUtility.intToStack(stacks[i]);
        }
        super.loadNBTData(aNBT);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        long startingTime = System.nanoTime();
        this.connectedcells = new ConnectedBlocksChecker();
        this.connectedcells.get_connected(aBaseMetaTileEntity.getWorld(), aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord(), ItemRegistry.BW_BLOCKS[1]);
        if (this.connectedcells.get_meta_of_sideblocks(aBaseMetaTileEntity.getWorld(), this.getBaseMetaTileEntity().getMetaTileID(), new int[]{aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord()}, true)) {
            this.getBaseMetaTileEntity().disableWorking();
            this.getBaseMetaTileEntity().setActive(false);
            this.mStorage = 0L;
            this.mMaxProgresstime = 0;
            this.mProgresstime = 0;
            return false;
        }
        this.mEfficiency = this.getMaxEfficiency(null);
        this.mStorage = (long)(Configuration.multiblocks.energyPerCell * this.connectedcells.hashset.size()) >= 0x7FFFFFFFFFFFFFFEL || Configuration.multiblocks.energyPerCell * this.connectedcells.hashset.size() < 0 ? 0x7FFFFFFFFFFFFFFEL : (long)(Configuration.multiblocks.energyPerCell * this.connectedcells.hashset.size());
        this.mMaxProgresstime = 1;
        this.mProgresstime = 0;
        this.getBaseMetaTileEntity().enableWorking();
        this.getBaseMetaTileEntity().setActive(true);
        long finishedTime = System.nanoTime();
        if (finishedTime - startingTime > 5000000L) {
            MainMod.LOGGER.warn("LESU LookUp took longer than 5ms!(" + (finishedTime - startingTime) + "ns / " + (finishedTime - startingTime) / 1000000L + "ms) Owner:" + this.getBaseMetaTileEntity().getOwnerName() + " Check at x:" + this.getBaseMetaTileEntity().getXCoord() + " y:" + this.getBaseMetaTileEntity().getYCoord() + " z:" + this.getBaseMetaTileEntity().getZCoord() + " DIM-ID: " + this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
        }
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    public World getWorld() {
        return this.getBaseMetaTileEntity().getWorld();
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT_GRAY).setSize(17, 17).setPos(105, 51));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(7, 4).setSize(118, 67))).widget(new SlotWidget(new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, 1){

            public int func_75219_a() {
                return 1;
            }
        }).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_IN}).setPos(127, 13))).widget(new SlotWidget(new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, 0){

            public int func_75219_a() {
                return 1;
            }
        }).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_CHARGER}).setPos(127, 49));
        for (int i = 0; i < 4; ++i) {
            builder.widget(new SlotWidget((IItemHandlerModifiable)this.circuitsInventoryHandler, i).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_INT_CIRCUIT}).setPos(151, 4 + i * 18));
        }
        DynamicPositionedColumn screenElements = new DynamicPositionedColumn();
        this.drawTexts(screenElements);
        builder.widget((Widget)screenElements);
        ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)BWUITextures.PICTURE_STORED_EU_FRAME).setPos(7, 72).setSize(118, 7))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.getBaseMetaTileEntity().getStoredEU() / (float)this.getBaseMetaTileEntity().getEUCapacity())).setDirection(ProgressBar.Direction.RIGHT).setTexture(BWUITextures.PROGRESSBAR_STORED_EU_116, 116).setPos(8, 73).setSize(116, 5));
    }

    private void drawTexts(DynamicPositionedColumn screenElements) {
        screenElements.setSpace(0).setPos(11, 8);
        ((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)((Column)screenElements.widget((Widget)new TextWidget().setStringSupplier(() -> "EU: " + numberFormat.format(this.clientEU)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.getBaseMetaTileEntity().getStoredEU(), val -> {
            this.clientEU = val;
        }))).widget((Widget)new TextWidget().setStringSupplier(() -> "MAX: " + numberFormat.format(this.clientMaxEU)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.getBaseMetaTileEntity().isActive() ? this.getBaseMetaTileEntity().getOutputVoltage() * (long)Configuration.multiblocks.energyPerCell : 0L, val -> {
            this.clientMaxEU = val;
        }))).widget((Widget)new TextWidget().setStringSupplier(() -> "MAX EU/t IN: " + numberFormat.format(this.clientMaxIn)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.getBaseMetaTileEntity().getInputVoltage(), val -> {
            this.clientMaxIn = val;
        }))).widget((Widget)new TextWidget().setStringSupplier(() -> "EU/t OUT: " + numberFormat.format(this.clientMaxOut)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.getBaseMetaTileEntity().getOutputVoltage(), val -> {
            this.clientMaxOut = val;
        }))).widget((Widget)new TextWidget().setStringSupplier(() -> "AMP/t IN/OUT: " + numberFormat.format(this.clientAmps)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.getBaseMetaTileEntity().getInputAmperage(), val -> {
            this.clientAmps = val;
        }))).widget(new TextWidget(Text.localised((String)"tooltip.LESU.0.name", (Object[])new Object[0])).setDefaultColor(Color.YELLOW.getRGB()).setEnabled(widget -> this.maxEUStore() >= 0x7FFFFFFFFFFFFFFEL))).widget(new TextWidget(Text.localised((String)"tooltip.LESU.1.name", (Object[])new Object[0])).setDefaultColor(Color.RED.getRGB()).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()));
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

