/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi.godforge;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.fluids.FluidTanksHandler;
import com.gtnewhorizons.modularui.api.fluids.IFluidTanksHandler;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStreamUtil;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tectech.TecTech;
import tectech.loader.recipe.Godforge;
import tectech.recipe.TecTechRecipeMaps;
import tectech.thing.CustomItemList;
import tectech.thing.gui.TecTechUITextures;
import tectech.thing.metaTileEntity.multi.godforge.MTEBaseModule;
import tectech.thing.metaTileEntity.multi.godforge.util.ForgeOfGodsUI;
import tectech.thing.metaTileEntity.multi.godforge.util.GodforgeMath;

public class MTEExoticModule
extends MTEBaseModule {
    private int numberOfFluids = 0;
    private int numberOfItems = 0;
    private long ticker = 0L;
    private long EUt = 0L;
    private long actualParallel = 0L;
    private boolean recipeInProgress = false;
    private boolean recipeRegenerated = false;
    private boolean magmatterMode = false;
    private FluidStack[] randomizedFluidInput = new FluidStack[0];
    private ItemStack[] randomizedItemInput = new ItemStack[0];
    private GTRecipe plasmaRecipe = null;
    private BigInteger powerForRecipe = BigInteger.ZERO;
    private static final int NUMBER_OF_INPUTS = 7;
    private static final int INPUT_LIST_WINDOW_ID = 11;
    private static final int POSSIBLE_INPUTS_WINDOW_ID = 12;

    public MTEExoticModule(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEExoticModule(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEExoticModule(this.mName);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected Stream<GTRecipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                if (!MTEExoticModule.this.recipeInProgress) {
                    if (MTEExoticModule.this.magmatterMode) {
                        MTEExoticModule.this.plasmaRecipe = MTEExoticModule.this.generateMagmatterRecipe();
                    } else {
                        MTEExoticModule.this.plasmaRecipe = MTEExoticModule.this.generateQuarkGluonRecipe();
                    }
                }
                return GTStreamUtil.ofNullable(MTEExoticModule.this.plasmaRecipe);
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (!MTEExoticModule.this.recipeInProgress || MTEExoticModule.this.recipeRegenerated) {
                    MTEExoticModule.this.powerForRecipe = BigInteger.valueOf(MTEExoticModule.this.getSafeProcessingVoltage()).multiply(BigInteger.valueOf((long)recipe.mDuration * MTEExoticModule.this.actualParallel));
                    if (WirelessNetworkManager.getUserEU(MTEExoticModule.this.userUUID).compareTo(MTEExoticModule.this.powerForRecipe) < 0) {
                        MTEExoticModule.this.plasmaRecipe = null;
                        return CheckRecipeResultRegistry.insufficientStartupPower(MTEExoticModule.this.powerForRecipe);
                    }
                    if (MTEExoticModule.this.numberOfFluids != 0) {
                        for (FluidStack fluidStack : MTEExoticModule.this.randomizedFluidInput) {
                            MTEExoticModule.dumpFluid(MTEExoticModule.this.mOutputHatches, new FluidStack(fluidStack.getFluid(), fluidStack.amount / 1000), false);
                        }
                    }
                    if (MTEExoticModule.this.numberOfItems != 0) {
                        for (FluidStack fluidStack : MTEExoticModule.this.randomizedItemInput) {
                            MTEExoticModule.this.addOutput((ItemStack)fluidStack);
                        }
                    }
                    MTEExoticModule.this.recipeInProgress = true;
                    MTEExoticModule.this.recipeRegenerated = false;
                }
                for (FluidStack fluidStack : recipe.mFluidInputs) {
                    if (ArrayUtils.contains((Object[])this.inputFluids, (Object)fluidStack) && this.inputFluids[ArrayUtils.indexOf((Object[])this.inputFluids, (Object)fluidStack)].amount == fluidStack.amount) continue;
                    return SimpleCheckRecipeResult.ofFailure("waiting_for_inputs");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@NotNull GTRecipe recipe) {
                MTEExoticModule.this.EUt = this.calculatedEut;
                MTEExoticModule.this.powerForRecipe = BigInteger.valueOf(MTEExoticModule.this.EUt).multiply(BigInteger.valueOf((long)this.duration * MTEExoticModule.this.actualParallel));
                if (!WirelessNetworkManager.addEUToGlobalEnergyMap(MTEExoticModule.this.userUUID, MTEExoticModule.this.powerForRecipe.negate())) {
                    return CheckRecipeResultRegistry.insufficientStartupPower(MTEExoticModule.this.powerForRecipe);
                }
                MTEExoticModule.this.addToPowerTally(MTEExoticModule.this.powerForRecipe);
                MTEExoticModule.this.addToRecipeTally(this.calculatedParallels);
                this.setCalculatedEut(0L);
                MTEExoticModule.this.plasmaRecipe = null;
                MTEExoticModule.this.recipeInProgress = false;
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setEUt(MTEExoticModule.this.getSafeProcessingVoltage()).setDurationDecreasePerOC(MTEExoticModule.this.getOverclockTimeFactor());
            }
        };
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(Integer.MAX_VALUE);
        logic.setAmperageOC(false);
        logic.setSpeedBonus(this.getSpeedBonus());
        logic.setEuModifier(this.getEnergyDiscount());
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return TecTechRecipeMaps.godforgeExoticMatterRecipes;
    }

    private GTRecipe generateQuarkGluonRecipe() {
        this.actualParallel = this.getMaxParallel();
        this.numberOfFluids = GodforgeMath.getRandomIntInRange(0, 7);
        this.numberOfItems = 7 - this.numberOfFluids;
        this.randomizedFluidInput = this.getRandomFluidInputs(Godforge.exoticModulePlasmaFluidMap, this.numberOfFluids);
        this.randomizedItemInput = this.getRandomItemInputs(Godforge.exoticModulePlasmaItemMap, this.numberOfItems);
        if (this.numberOfFluids != 0) {
            for (FluidStack fluidStack : this.randomizedFluidInput) {
                fluidStack.amount = 1000 * GodforgeMath.getRandomIntInRange(1, 64);
            }
        }
        if (this.numberOfItems != 0) {
            for (FluidStack fluidStack : this.randomizedItemInput) {
                fluidStack.field_77994_a = GodforgeMath.getRandomIntInRange(1, 7);
            }
        }
        return new GTRecipe(false, null, null, null, null, (FluidStack[])ArrayUtils.addAll((Object[])this.convertItemToPlasma(this.randomizedItemInput, 9L), (Object[])this.convertFluidToPlasma(this.randomizedFluidInput, 1L)), new FluidStack[]{MaterialsUEVplus.QuarkGluonPlasma.getFluid(1000L * this.actualParallel)}, 200, (int)TierEU.RECIPE_MAX, 0);
    }

    private GTRecipe generateMagmatterRecipe() {
        this.actualParallel = this.getMaxParallel();
        this.randomizedItemInput = this.getRandomItemInputs(Godforge.exoticModuleMagmatterItemMap, 1);
        this.numberOfItems = 1;
        this.numberOfFluids = 2;
        int timeAmount = GodforgeMath.getRandomIntInRange(1, 50);
        int spaceAmount = GodforgeMath.getRandomIntInRange(51, 100);
        this.randomizedFluidInput = new FluidStack[]{MaterialsUEVplus.Time.getMolten((long)timeAmount * 1000L), MaterialsUEVplus.Space.getMolten((long)spaceAmount * 1000L)};
        return new GTRecipe(false, null, null, null, null, (FluidStack[])ArrayUtils.addAll((Object[])this.convertItemToPlasma(this.randomizedItemInput, spaceAmount - timeAmount), (Object[])new FluidStack[]{MaterialsUEVplus.Time.getMolten(timeAmount), MaterialsUEVplus.Space.getMolten(spaceAmount)}), new FluidStack[]{MaterialsUEVplus.MagMatter.getMolten(576L * this.actualParallel)}, 200, (int)TierEU.RECIPE_MAX, 0);
    }

    /*
     * WARNING - void declaration
     */
    private FluidStack[] getRandomFluidInputs(HashMap<FluidStack, Integer> fluidMap, int numberOfFluids) {
        void var7_9;
        int cumulativeWeight = 0;
        ArrayList<Map.Entry<FluidStack, Integer>> fluidEntryList = new ArrayList<Map.Entry<FluidStack, Integer>>(fluidMap.entrySet());
        ArrayList<Integer> cumulativeWeights = new ArrayList<Integer>();
        for (Map.Entry entry : fluidEntryList) {
            cumulativeWeights.add(cumulativeWeight += ((Integer)entry.getValue()).intValue());
        }
        ArrayList<FluidStack> pickedFluids = new ArrayList<FluidStack>();
        boolean bl = false;
        while (var7_9 < numberOfFluids) {
            int randomWeight = GodforgeMath.getRandomIntInRange(1, cumulativeWeight);
            for (int j = 0; j < cumulativeWeights.size(); ++j) {
                if (randomWeight > (Integer)cumulativeWeights.get(j)) continue;
                FluidStack pickedFluid = (FluidStack)((Map.Entry)fluidEntryList.get(j)).getKey();
                if (pickedFluids.contains(pickedFluid)) {
                    --var7_9;
                    break;
                }
                pickedFluids.add(pickedFluid);
                break;
            }
            ++var7_9;
        }
        return pickedFluids.toArray(new FluidStack[0]);
    }

    /*
     * WARNING - void declaration
     */
    private ItemStack[] getRandomItemInputs(HashMap<ItemStack, Integer> itemMap, int numberOfItems) {
        void var7_9;
        int cumulativeWeight = 0;
        ArrayList<Map.Entry<ItemStack, Integer>> itemEntryList = new ArrayList<Map.Entry<ItemStack, Integer>>(itemMap.entrySet());
        ArrayList<Integer> cumulativeWeights = new ArrayList<Integer>();
        for (Map.Entry entry : itemEntryList) {
            cumulativeWeights.add(cumulativeWeight += ((Integer)entry.getValue()).intValue());
        }
        ArrayList<ItemStack> pickedItems = new ArrayList<ItemStack>();
        boolean bl = false;
        while (var7_9 < numberOfItems) {
            int randomWeight = GodforgeMath.getRandomIntInRange(1, cumulativeWeight);
            for (int j = 0; j < cumulativeWeights.size(); ++j) {
                if (randomWeight > (Integer)cumulativeWeights.get(j)) continue;
                ItemStack pickedItem = (ItemStack)((Map.Entry)itemEntryList.get(j)).getKey();
                if (pickedItems.contains(pickedItem)) {
                    --var7_9;
                    break;
                }
                pickedItems.add(pickedItem);
                break;
            }
            ++var7_9;
        }
        return pickedItems.toArray(new ItemStack[0]);
    }

    private FluidStack[] convertItemToPlasma(ItemStack[] items, long multiplier) {
        ArrayList<FluidStack> plasmas = new ArrayList<FluidStack>();
        for (ItemStack itemStack : items) {
            String dict = OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)itemStack)[0]);
            String strippedOreDict = dict.substring(4);
            plasmas.add(FluidRegistry.getFluidStack((String)("plasma." + strippedOreDict.toLowerCase()), (int)((int)(144L * multiplier * (long)itemStack.field_77994_a))));
        }
        return plasmas.toArray(new FluidStack[0]);
    }

    private FluidStack[] convertFluidToPlasma(FluidStack[] fluids, long multiplier) {
        ArrayList<FluidStack> plasmas = new ArrayList<FluidStack>();
        for (FluidStack fluidStack : fluids) {
            String[] fluidName = fluidStack.getUnlocalizedName().split("\\.");
            plasmas.add(FluidRegistry.getFluidStack((String)("plasma." + fluidName[fluidName.length - 1]), (int)((int)(multiplier * (long)fluidStack.amount))));
        }
        return plasmas.toArray(new FluidStack[0]);
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound NBT2) {
        NBT2.func_74757_a("recipeInProgress", this.recipeInProgress);
        NBT2.func_74757_a("magmatterMode", this.magmatterMode);
        NBT2.func_74772_a("maxParallel", this.actualParallel);
        NBTTagCompound fluidStackListNBTTag = new NBTTagCompound();
        if (this.plasmaRecipe != null) {
            fluidStackListNBTTag.func_74772_a("numberOfPlasmas", (long)this.plasmaRecipe.mFluidInputs.length);
            int index = 0;
            for (FluidStack stack : this.plasmaRecipe.mFluidInputs) {
                fluidStackListNBTTag.func_74772_a(index + "fluidAmount", (long)stack.amount);
                NBT2.func_74782_a(index + "fluidStack", (NBTBase)stack.writeToNBT(new NBTTagCompound()));
                ++index;
            }
        } else {
            fluidStackListNBTTag.func_74772_a("numberOfPlasmas", 0L);
        }
        NBT2.func_74782_a("inputPlasmas", (NBTBase)fluidStackListNBTTag);
        super.saveNBTData(NBT2);
    }

    @Override
    public void loadNBTData(NBTTagCompound NBT2) {
        this.recipeInProgress = NBT2.func_74767_n("recipeInProgress");
        this.magmatterMode = NBT2.func_74767_n("magmatterMode");
        this.actualParallel = NBT2.func_74763_f("maxParallel");
        NBTTagCompound tempFluidTag = NBT2.func_74775_l("inputPlasmas");
        long numberOfPlasmas = tempFluidTag.func_74763_f("numberOfPlasmas");
        if (numberOfPlasmas > 0L) {
            FluidStack[] stacks = new FluidStack[(int)numberOfPlasmas];
            int i = 0;
            while ((long)i < numberOfPlasmas) {
                int amount = tempFluidTag.func_74762_e(i + "fluidAmount");
                FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)NBT2.func_74775_l(i + "fluidStack"));
                stacks[i] = new FluidStack(stack, amount);
                ++i;
            }
            FluidStack outputFluid = this.magmatterMode ? MaterialsUEVplus.MagMatter.getMolten(576L * this.actualParallel) : MaterialsUEVplus.QuarkGluonPlasma.getFluid(1000L * this.actualParallel);
            this.plasmaRecipe = new GTRecipe(false, null, null, null, null, stacks, new FluidStack[]{outputFluid}, 200, (int)TierEU.RECIPE_MAX, 0);
        }
        super.loadNBTData(NBT2);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        ++this.ticker;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new DrawableWidget().setPos(8, 69).setSize(16, 16).addTooltip(StatCollector.func_74838_a((String)"fog.button.exoticinputs.tooltip")).setTooltipShowUpDelay(5));
        super.addUIWidgets(builder, buildContext);
        buildContext.addSyncedWindow(11, this::createInputListWindow);
        buildContext.addSyncedWindow(12, this::createPossibleInputsWindow);
        builder.widget((Widget)this.createMagmatterSwitch((IWidgetBuilder<?>)builder));
        builder.widget(this.createExpectedInputsButton());
        builder.widget(new DrawableWidget().setDrawable((IDrawable)ModularUITextures.ICON_INFO).setPos(8, 69).setSize(16, 16));
    }

    protected ModularWindow createInputListWindow(EntityPlayer player) {
        int WIDTH = 100;
        int HEIGHT = 60;
        int PARENT_WIDTH = this.getGUIWidth();
        int PARENT_HEIGHT = this.getGUIHeight();
        Pos2d[] slotPositions = new Pos2d[]{new Pos2d(23, 35), new Pos2d(41, 35), new Pos2d(59, 35), new Pos2d(14, 17), new Pos2d(32, 17), new Pos2d(50, 17), new Pos2d(68, 17)};
        ModularWindow.Builder builder = ModularWindow.builder((int)100, (int)60);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.setPos((size, window) -> Alignment.Center.getAlignedPos(size, new Size(PARENT_WIDTH, PARENT_HEIGHT)).add(Alignment.TopLeft.getAlignedPos(new Size(PARENT_WIDTH, PARENT_HEIGHT), new Size(100, 60))).subtract(100, -47));
        FluidTanksHandler tanksHandler = new FluidTanksHandler(7, 128000L);
        for (int i = 0; i < 7; ++i) {
            if (this.plasmaRecipe != null && i < this.plasmaRecipe.mFluidInputs.length) {
                FluidStack plasma = this.plasmaRecipe.mFluidInputs[i];
                tanksHandler.setFluidInTank(i, plasma.getFluid(), (long)plasma.amount);
            }
            ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)ModularUITextures.FLUID_SLOT).setSize(18, 18).setPos(slotPositions[i]))).widget(new FluidSlotWidget((IFluidTanksHandler)tanksHandler, i).setInteraction(false, false).setSize(18, 18).setPos(slotPositions[i]).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.recipeInProgress, val -> {
                this.recipeInProgress = val;
            }), (IWidgetBuilder)builder, (widget, val) -> widget.checkNeedsRebuild()));
        }
        builder.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.expectedinputs")).setDefaultColor(EnumChatFormatting.BLACK).setTextAlignment(Alignment.Center).setSize(100, 9).setPos(0, 6));
        builder.widget(new ButtonWidget().setOnClick((arg_0, arg_1) -> this.lambda$createInputListWindow$4((IFluidTanksHandler)tanksHandler, arg_0, arg_1)).setPlayClickSound(true).setBackground(new IDrawable[]{TecTechUITextures.OVERLAY_CYCLIC_BLUE}).dynamicTooltip(this::refreshTooltip).setTooltipShowUpDelay(5).setSize(16, 16).setPos(5, 37).attachSyncer((FakeSyncWidget)new FakeSyncWidget.LongSyncer(() -> this.ticker, val -> {
            this.ticker = val;
        }), (IWidgetBuilder)builder, (widget, val) -> widget.notifyTooltipChange()));
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            builder.widget(this.createPossibleInputsButton());
        }
        return builder.build();
    }

    private Widget createExpectedInputsButton() {
        return new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(11);
            }
        }).setPlayClickSound(true).setSize(16, 16).setPos(8, 69);
    }

    protected ModularWindow createPossibleInputsWindow(EntityPlayer player) {
        int WIDTH = 300;
        int HEIGHT = 143;
        ModularWindow.Builder builder = ModularWindow.builder((int)300, (int)143);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.setDraggable(true);
        builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(284, 4));
        int QGPItemMapSize = Godforge.exoticModulePlasmaItemMap.size();
        int QGPFluidMapSize = Godforge.exoticModulePlasmaFluidMap.size();
        ItemStackHandler QGPItemHandler = new ItemStackHandler(QGPItemMapSize);
        FluidTanksHandler QGPFluidHandler = new FluidTanksHandler(QGPFluidMapSize, 128000L);
        ArrayList<Map.Entry<ItemStack, Integer>> itemEntryList = new ArrayList<Map.Entry<ItemStack, Integer>>(Godforge.exoticModulePlasmaItemMap.entrySet());
        ArrayList<Map.Entry<FluidStack, Integer>> fluidEntryList = new ArrayList<Map.Entry<FluidStack, Integer>>(Godforge.exoticModulePlasmaFluidMap.entrySet());
        int slotYQGP = 0;
        for (int i = 0; i < QGPItemMapSize + QGPFluidMapSize; ++i) {
            int slotXQGP = 6 + i % 16 * 18;
            slotYQGP = 17 + i / 16 * 18;
            if (i < QGPItemMapSize) {
                QGPItemHandler.setStackInSlot(i, GTUtility.copyAmount(1, (ItemStack)((Map.Entry)itemEntryList.get(i)).getKey()));
                builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.BUTTON_STANDARD_PRESSED).setPos(slotXQGP, slotYQGP).setSize(18, 18));
                builder.widget(new SlotWidget((IItemHandlerModifiable)QGPItemHandler, i).setAccess(false, false).setRenderStackSize(false).disableInteraction().setPos(slotXQGP, slotYQGP).setSize(18, 18));
                continue;
            }
            QGPFluidHandler.setFluidInTank(i - QGPItemMapSize, ((FluidStack)((Map.Entry)fluidEntryList.get(i - QGPItemMapSize)).getKey()).getFluid(), 1L);
            ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)ModularUITextures.FLUID_SLOT).setSize(18, 18).setPos(slotXQGP, slotYQGP))).widget(new FluidSlotWidget((IFluidTanksHandler)QGPFluidHandler, i - QGPItemMapSize).setInteraction(false, false).setSize(18, 18).setPos(slotXQGP, slotYQGP));
        }
        int magMatterItemMapSize = Godforge.exoticModuleMagmatterItemMap.size();
        ItemStackHandler magMatterItemHandler = new ItemStackHandler(magMatterItemMapSize);
        FluidTanksHandler magMatterFluidHandler = new FluidTanksHandler(2, 128000L);
        magMatterFluidHandler.setFluidInTank(0, MaterialsUEVplus.Space.getMolten(1L).getFluid(), 1L);
        magMatterFluidHandler.setFluidInTank(1, MaterialsUEVplus.Time.getMolten(1L).getFluid(), 1L);
        ArrayList<Map.Entry<ItemStack, Integer>> magMatteritemEntryList = new ArrayList<Map.Entry<ItemStack, Integer>>(Godforge.exoticModuleMagmatterItemMap.entrySet());
        for (int i = 0; i < magMatterItemMapSize + 2; ++i) {
            int slotXMagmatter = 6 + i % 16 * 18;
            int slotYMagmatter = slotYQGP + 30 + i / 16 * 18;
            if (i < magMatterItemMapSize) {
                magMatterItemHandler.setStackInSlot(i, GTUtility.copyAmount(1, (ItemStack)((Map.Entry)magMatteritemEntryList.get(i)).getKey()));
                builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.BUTTON_STANDARD_PRESSED).setPos(slotXMagmatter, slotYMagmatter).setSize(18, 18));
                builder.widget(new SlotWidget((IItemHandlerModifiable)magMatterItemHandler, i).setAccess(false, false).setRenderStackSize(false).disableInteraction().setPos(slotXMagmatter, slotYMagmatter).setSize(18, 18));
                continue;
            }
            ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)ModularUITextures.FLUID_SLOT).setSize(18, 18).setPos(slotXMagmatter, slotYMagmatter))).widget(new FluidSlotWidget((IFluidTanksHandler)magMatterFluidHandler, i - magMatterItemMapSize).setInteraction(false, false).setSize(18, 18).setPos(slotXMagmatter, slotYMagmatter));
        }
        builder.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.possibleinputsqgp")).setDefaultColor(EnumChatFormatting.BLACK).setTextAlignment(Alignment.Center).setSize(300, 9).setPos(0, 6));
        builder.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.possibleinputsmagmatter")).setDefaultColor(EnumChatFormatting.BLACK).setTextAlignment(Alignment.Center).setSize(300, 9).setPos(0, slotYQGP + 21));
        return builder.build();
    }

    private Widget createPossibleInputsButton() {
        return new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(12);
            }
        }).setPlayClickSound(true).setBackground(new IDrawable[]{ModularUITextures.ICON_INFO}).addTooltip(StatCollector.func_74838_a((String)"fog.button.possibleexoticinputs.tooltip")).setTooltipShowUpDelay(5).setSize(16, 16).setPos(79, 37);
    }

    protected ButtonWidget createMagmatterSwitch(IWidgetBuilder<?> builder) {
        Widget button = new ButtonWidget().setOnClick((clickData, widget) -> {
            if (this.isMagmatterCapable) {
                TecTech.proxy.playSound(this.getBaseMetaTileEntity(), "fx_click");
                this.magmatterMode = !this.magmatterMode;
                widget.notifyTooltipChange();
            }
        }).setPlayClickSound(false).setBackground(() -> new IDrawable[]{TecTechUITextures.BUTTON_CELESTIAL_32x32, new ItemDrawable(this.isMagmatterCapable && this.isMagmatterModeOn() ? GTOreDictUnificator.get(OrePrefixes.dust, MaterialsUEVplus.MagMatter, 1L) : CustomItemList.Godforge_FakeItemQGP.get(1L, new Object[0]))}).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(this::isMagmatterModeOn, this::setMagmatterMode), builder).dynamicTooltip(() -> {
            ArrayList<String> ret = new ArrayList<String>();
            if (!this.isMagmatterModeOn()) {
                ret.add(StatCollector.func_74838_a((String)"fog.button.magmattermode.tooltip.01"));
            }
            if (this.isMagmatterCapable && this.isMagmatterModeOn()) {
                ret.add(StatCollector.func_74838_a((String)"fog.button.magmattermode.tooltip.02"));
            }
            if (!this.isMagmatterCapable) {
                ret.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"fog.button.magmattermode.tooltip.03"));
            }
            return ret;
        }).setTooltipShowUpDelay(5).setSize(16, 16).setPos(174, 91).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.isMagmatterCapable, this::setMagmatterCapable), builder);
        return (ButtonWidget)button;
    }

    private List<String> refreshTooltip() {
        if (this.ticker > 1200L) {
            return ImmutableList.of((Object)StatCollector.func_74838_a((String)"fog.button.reciperefresh.tooltip"));
        }
        return ImmutableList.of((Object)(StatCollector.func_74838_a((String)"fog.button.refreshtimer.tooltip") + " " + (int)Math.ceil((double)(1200L - this.ticker) / 20.0) + " " + StatCollector.func_74838_a((String)"fog.button.seconds")));
    }

    public boolean isMagmatterModeOn() {
        return this.magmatterMode;
    }

    private void setMagmatterMode(boolean enabled) {
        this.magmatterMode = enabled;
    }

    @Override
    public void setMagmatterCapable(boolean isCapable) {
        if (!isCapable && this.isMagmatterCapable) {
            this.setMagmatterMode(false);
        }
        super.setMagmatterCapable(isCapable);
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Exotic Matter Producer").addInfo("This is a module of the Godforge.").addInfo("Must be part of a Godforge to function.").addInfo("Used for ultra high temperature matter degeneration.").addSeparator(EnumChatFormatting.AQUA, 75).addInfo("The fourth and final module of the Godforge, this module breaks apart the very").addInfo("building blocks of matter, producing exotic mixtures in the process. Quark-Gluon Plasma").addInfo("can be manufactured right away, but production of Magnetic Monopole Matter (Magmatter)").addInfo("requires a fully upgraded Godforge.").addInfo("This module is specialized towards acquisition of unique materials.").beginStructureBlock(7, 7, 13, false).addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Singularity Reinforced Stellar Shielding Casing").addStructureInfo(EnumChatFormatting.GOLD + "20" + EnumChatFormatting.GRAY + " Boundless Gravitationally Severed Structure Casing").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Harmonic Phonon Transmission Conduit").addStructureInfo(EnumChatFormatting.GOLD + "5" + EnumChatFormatting.GRAY + " Celestial Matter Guidance Casing").addStructureInfo(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " Stellar Energy Siphon Casing").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " Output Hatch").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + " Output Bus").toolTipFinisher(EnumChatFormatting.AQUA, 75, new String[0]);
        return tt;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> str = new ArrayList<String>();
        str.add("Progress: " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s");
        str.add("Currently using: " + EnumChatFormatting.RED + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.EUt * this.actualParallel) : "0") + EnumChatFormatting.RESET + " EU/t");
        str.add(EnumChatFormatting.YELLOW + "Max Parallel: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getMaxParallel()));
        str.add(EnumChatFormatting.YELLOW + "Current Parallel: " + EnumChatFormatting.RESET + (this.getBaseMetaTileEntity().isActive() ? GTUtility.formatNumbers(this.getMaxParallel()) : "0"));
        str.add(EnumChatFormatting.YELLOW + "Recipe time multiplier: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getSpeedBonus()));
        str.add(EnumChatFormatting.YELLOW + "Energy multiplier: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getEnergyDiscount()));
        str.add(EnumChatFormatting.YELLOW + "Recipe time divisor per non-perfect OC: " + EnumChatFormatting.RESET + GTUtility.formatNumbers(this.getOverclockTimeFactor()));
        return str.toArray(new String[0]);
    }

    private /* synthetic */ void lambda$createInputListWindow$4(IFluidTanksHandler tanksHandler, Widget.ClickData clickData, Widget widget) {
        if (!widget.isClient() && this.ticker > 1200L) {
            this.plasmaRecipe = this.magmatterMode ? this.generateMagmatterRecipe() : this.generateQuarkGluonRecipe();
            this.recipeRegenerated = true;
            for (int i = 0; i < 7; ++i) {
                if (i >= this.plasmaRecipe.mFluidInputs.length) continue;
                FluidStack plasma = this.plasmaRecipe.mFluidInputs[i];
                tanksHandler.setFluidInTank(i, plasma.getFluid(), (long)plasma.amount);
            }
            this.ticker = 0L;
            ForgeOfGodsUI.reopenWindow(widget, 11);
        }
    }
}

