/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.recipe;

import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.core.material.MaterialsElements;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.bop.blocks.BOPBlockRegistrator;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.common.helpers.VolumetricFlaskHelper;
import gtPlusPlus.xmod.gregtech.registration.gregtech.GregtechConduits;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class RecipesGeneral {
    static final ItemStack NULL = null;
    static ItemStack RECIPE_Paper;
    static ItemStack RECIPE_Dirt;
    static ItemStack RECIPE_Snow;
    static ItemStack RECIPE_Obsidian;
    static String RECIPE_LapisDust;
    static ItemStack OUTPUT_Blueprint;
    static ItemStack RECIPE_CraftingTable;
    static ItemStack RECIPE_BasicCasingIC2;

    public static void loadRecipes() {
        RECIPE_Paper = ItemUtils.getSimpleStack(Items.field_151121_aF);
        RECIPE_Dirt = ItemUtils.getSimpleStack(Blocks.field_150346_d);
        RECIPE_Snow = ItemUtils.getSimpleStack(Blocks.field_150433_aE);
        RECIPE_Obsidian = ItemUtils.getSimpleStack(Blocks.field_150343_Z);
        RECIPE_CraftingTable = ItemUtils.getSimpleStack(Blocks.field_150462_ai);
        RECIPE_BasicCasingIC2 = ItemUtils.getItemStackFromFQRN("IC2:blockMachine", 1);
        OUTPUT_Blueprint = ItemUtils.getSimpleStack(ModItems.itemBlueprintBase, 2);
        RecipesGeneral.run();
        RecipesGeneral.addCompressedObsidian();
        RecipesGeneral.addFuelBlocks();
        RecipesGeneral.migratedRecipes();
    }

    private static void run() {
        ItemStack ironBars;
        RecipeUtils.addShapedRecipe(RECIPE_Paper, RECIPE_LapisDust, NULL, RECIPE_Paper, RECIPE_LapisDust, NULL, RECIPE_LapisDust, RECIPE_LapisDust, NULL, OUTPUT_Blueprint);
        if (RecipeUtils.addShapedRecipe("stickWood", "stickWood", "stickWood", "stickWood", "treeSapling", "stickWood", "stickWood", "dustBone", "stickWood", ItemUtils.getSimpleStack(BOPBlockRegistrator.sapling_Rainforest))) {
            Logger.INFO("Added a recipe for Rainforest oak Saplings.");
        }
        if (RecipeUtils.addShapedRecipe(ironBars = ItemUtils.getItemStackFromFQRN("dreamcraft:item.SteelBars", 1), ironBars, ironBars, ironBars, "frameGtWroughtIron", ironBars, ironBars, ironBars, ironBars, ItemUtils.getSimpleStack(ModBlocks.blockFishTrap))) {
            Logger.INFO("Added a recipe for the Fish Trap.");
        }
        if (RecipeUtils.addShapelessGregtechRecipe(new Object[]{"dustLead", "dustBronze", "dustTin", "dustLead", "dustBronze"}, MaterialsAlloy.POTIN.getDust(5))) {
            Logger.INFO("Added shapeless recipe for Potin Dust.");
        }
        if (RecipeUtils.addShapelessGregtechRecipe(new Object[]{"dustGold", "dustGold", "dustCopper"}, ItemUtils.getSimpleStack(ModItems.dustTumbagaMix))) {
            Logger.INFO("Added shapeless recipe for Tumbaga Mix.");
        }
        if (RecipeUtils.addShapelessGregtechRecipe(new Object[]{ItemUtils.getSimpleStack(ModItems.dustTumbagaMix), ItemUtils.getSimpleStack(ModItems.dustTumbagaMix), ItemUtils.getSimpleStack(ModItems.dustTumbagaMix), "dustGold"}, MaterialsAlloy.TUMBAGA.getDust(10))) {
            Logger.INFO("Added shapeless recipe for Tumbaga Dust.");
        }
        RecipeUtils.addShapedRecipe(CI.craftingToolFile, "plateIron", "stickIron", "plateIron", "ringIron", "plateIron", "stickIron", "plateIron", CI.craftingToolHammer_Hard, ItemUtils.simpleMetaStack(ModItems.itemBasicTurbine, 0, 1));
        RecipeUtils.addShapedRecipe(CI.craftingToolFile, "plateBronze", "stickBronze", "plateBronze", "ringBronze", "plateBronze", "stickBronze", "plateBronze", CI.craftingToolHammer_Hard, ItemUtils.simpleMetaStack(ModItems.itemBasicTurbine, 1, 1));
        RecipeUtils.addShapedRecipe(CI.craftingToolFile, "plateSteel", "stickSteel", "plateSteel", "ringSteel", "plateSteel", "stickSteel", "plateSteel", CI.craftingToolHammer_Hard, ItemUtils.simpleMetaStack(ModItems.itemBasicTurbine, 2, 1));
        GTValues.RA.stdBuilder().itemInputs(ItemList.Large_Fluid_Cell_Aluminium.get(1L, new Object[0])).itemOutputs(VolumetricFlaskHelper.getLargeVolumetricFlask(2)).fluidInputs(FluidUtils.getFluidStack("molten.borosilicateglass", 4000)).duration(300).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.fluidSolidifierRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Large_Fluid_Cell_TungstenSteel.get(1L, new Object[0])).itemOutputs(VolumetricFlaskHelper.getGiganticVolumetricFlask(2)).fluidInputs(FluidUtils.getFluidStack("molten.borosilicateglass", 16000)).duration(300).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.fluidSolidifierRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Tesseract.get(1L, new Object[0])).itemOutputs(VolumetricFlaskHelper.getKleinBottle(1)).fluidInputs(MaterialsElements.STANDALONE.CHRONOMATIC_GLASS.getFluidStack(2304)).duration(300).eut(TierEU.RECIPE_UHV).addTo(RecipeMaps.fluidSolidifierRecipes);
        Logger.RECIPE("[Inspection] Explosives");
        if (RecipeUtils.addShapedRecipe(CI.explosiveITNT, CI.explosiveTNT, CI.explosiveITNT, CI.explosiveTNT, "frameGtIron", CI.explosiveTNT, "dustSulfur", CI.explosiveTNT, "dustSulfur", ItemUtils.getSimpleStack(ModBlocks.blockMiningExplosive, 3))) {
            Logger.INFO("Added a recipe for Mining Explosives.");
        }
        if (RecipeUtils.addShapedRecipe("gemExquisiteRuby", "gemFlawlessDiamond", "gemExquisiteDiamond", "gemFlawlessRuby", ItemList.Credit_Greg_Osmium.get(1L, new Object[0]), "gemFlawlessSapphire", "gemExquisiteEmerald", "gemFlawlessEmerald", "gemExquisiteSapphire", ItemUtils.getSimpleStack(ModItems.itemAlkalusDisk))) {
            Logger.INFO("Added a recipe for The Alkalus Disk.");
        }
        Logger.RECIPE("[Inspection] Wither Cage");
        if (RecipeUtils.addShapedRecipe("stickBlackSteel", "plateTungstenSteel", "stickBlackSteel", "plateTungstenSteel", ItemUtils.getSimpleStack(Items.field_151156_bN), "plateTungstenSteel", "stickBlackSteel", "plateTungstenSteel", "stickBlackSteel", ItemUtils.getSimpleStack(ModBlocks.blockWitherGuard, 32))) {
            Logger.INFO("Added a recipe for Wither Cages.");
        }
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(Items.field_151008_G, 64), ItemUtils.getSimpleStack(Blocks.field_150475_bE, 32), ItemUtils.getSimpleStack(Blocks.field_150484_ah, 32), Materials.Ruby.getBlocks(32), Materials.Sapphire.getBlocks(32), ItemUtils.getSimpleStack(Blocks.field_150340_R, 32)).itemOutputs(ItemUtils.getSimpleStack(ModItems.itemMagicFeather, 1)).fluidInputs(Materials.Silver.getMolten(4608L)).duration(2400).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.assemblerRecipes);
        GTValues.RA.stdBuilder().itemInputs(CI.getTieredMachineCasing(1), CI.getElectricPump(2, 1), CI.getPlate(2, 4), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(0), 2), GTUtility.getIntegratedCircuit(16)).itemOutputs(ItemUtils.getSimpleStack(ModBlocks.blockPestKiller)).fluidInputs(FluidUtils.getHotWater(500)).duration(1200).eut(TierEU.RECIPE_LV / 2L).addTo(RecipeMaps.assemblerRecipes);
    }

    private static void addFuelBlocks() {
        int i;
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(ModItems.itemCactusCharcoal, 9, 0)).itemOutputs(ItemUtils.simpleMetaStack(ModBlocks.blockCactusCharcoal, 0, 1)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(ModItems.itemCactusCoke, 9, 0)).itemOutputs(ItemUtils.simpleMetaStack(ModBlocks.blockCactusCoke, 0, 1)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(ModItems.itemSugarCharcoal, 9, 0)).itemOutputs(ItemUtils.simpleMetaStack(ModBlocks.blockSugarCharcoal, 0, 1)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(ModItems.itemSugarCoke, 9, 0)).itemOutputs(ItemUtils.simpleMetaStack(ModBlocks.blockSugarCoke, 0, 1)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
        for (i = 1; i < 6; ++i) {
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.simpleMetaStack(ModBlocks.blockCactusCharcoal, i - 1, 9)).itemOutputs(ItemUtils.simpleMetaStack(ModBlocks.blockCactusCharcoal, i, 1)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
        }
        for (i = 1; i < 6; ++i) {
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.simpleMetaStack(ModBlocks.blockCactusCoke, i - 1, 9)).itemOutputs(ItemUtils.simpleMetaStack(ModBlocks.blockCactusCoke, i, 1)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
        }
        for (i = 1; i < 6; ++i) {
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.simpleMetaStack(ModBlocks.blockSugarCharcoal, i - 1, 9)).itemOutputs(ItemUtils.simpleMetaStack(ModBlocks.blockSugarCharcoal, i, 1)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
        }
        for (i = 1; i < 6; ++i) {
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.simpleMetaStack(ModBlocks.blockSugarCoke, i - 1, 9)).itemOutputs(ItemUtils.simpleMetaStack(ModBlocks.blockSugarCoke, i, 1)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
        }
    }

    private static boolean addCompressedObsidian() {
        ItemStack output;
        ItemStack input;
        int r;
        ItemStack aInvertedObsidian = ItemUtils.simpleMetaStack(ModBlocks.blockCompressedObsidian, 5, 1);
        if (RecipeUtils.addShapedRecipe(ItemUtils.getSimpleStack(Items.field_151137_ax), ItemUtils.getSimpleStack(Items.field_151114_aO), ItemUtils.getSimpleStack(Items.field_151137_ax), ItemUtils.getSimpleStack(Items.field_151114_aO), ItemUtils.simpleMetaStack(ModBlocks.blockCompressedObsidian, 1, 1), ItemUtils.getSimpleStack(Items.field_151114_aO), ItemUtils.getSimpleStack(Items.field_151137_ax), ItemUtils.getSimpleStack(Items.field_151114_aO), ItemUtils.getSimpleStack(Items.field_151137_ax), aInvertedObsidian)) {
            Logger.INFO("Added a recipe for Inverted Obsidian.");
        }
        ItemStack[] mItems = new ItemStack[6];
        mItems[0] = ItemUtils.getSimpleStack(Blocks.field_150343_Z);
        for (int r2 = 0; r2 < 5; ++r2) {
            mItems[r2 + 1] = ItemUtils.simpleMetaStack(ModBlocks.blockCompressedObsidian, r2, 1);
        }
        ItemStack[] mItems2 = new ItemStack[6];
        mItems2[0] = ItemUtils.getSimpleStack(Blocks.field_150426_aN);
        for (r = 0; r < 5; ++r) {
            mItems2[r + 1] = ItemUtils.simpleMetaStack(ModBlocks.blockCompressedObsidian, 6 + r, 1);
        }
        for (r = 0; r < 5; ++r) {
            input = mItems[r];
            output = mItems[r + 1];
            if (RecipeUtils.addShapedRecipe(input, input, input, input, input, input, input, input, input, output)) {
                Logger.INFO("Added a recipe for Compressed Obsidian [" + r + "]");
            }
            if (!RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{output}, ItemUtils.getSimpleStack(input, 9))) continue;
            Logger.INFO("Added a shapeless recipe for Compressed Obsidian [" + r + "]");
        }
        for (r = 0; r < 5; ++r) {
            input = mItems2[r];
            if (RecipeUtils.addShapedRecipe(input, input, input, input, r == 2 ? aInvertedObsidian : input, input, input, input, input, output = mItems2[r + 1])) {
                Logger.INFO("Added a recipe for Compressed Glowstone [" + r + "]");
            }
            if (!RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{output}, ItemUtils.getSimpleStack(input, 9))) continue;
            Logger.INFO("Added a shapeless recipe for Compressed Glowstone [" + r + "]");
        }
        return true;
    }

    private static void migratedRecipes() {
        Materials[] h;
        Material[] gtpp;
        RecipeUtils.generateMortarRecipe(ItemUtils.getSimpleStack(ModItems.itemPlateRawMeat), ItemUtils.getItemStackOfAmountFromOreDict("dustMeatRaw", 1));
        GregtechConduits.generateWireRecipes(MaterialsElements.getInstance().ZIRCONIUM);
        GregtechConduits.generateWireRecipes(MaterialsAlloy.HG1223);
        GregtechConduits.generateWireRecipes(MaterialsAlloy.LEAGRISIUM);
        GregtechConduits.generateWireRecipes(MaterialsAlloy.TRINIUM_TITANIUM);
        GregtechConduits.generateWireRecipes(MaterialsElements.STANDALONE.HYPOGEN);
        GregtechConduits.generateWireRecipes(MaterialsElements.STANDALONE.CHRONOMATIC_GLASS);
        for (Material mat : gtpp = new Material[]{MaterialsAlloy.STABALLOY, MaterialsAlloy.TANTALLOY_60, MaterialsAlloy.TANTALLOY_61, MaterialsAlloy.POTIN, MaterialsAlloy.MARAGING300, MaterialsAlloy.MARAGING350, MaterialsAlloy.INCONEL_690, MaterialsAlloy.INCONEL_792, MaterialsAlloy.HASTELLOY_X, MaterialsAlloy.TRINIUM_NAQUADAH_CARBON}) {
            GregtechConduits.generatePipeRecipes(mat.getLocalizedName(), mat.getMass(), mat.vVoltageMultiplier / 8);
        }
        for (Materials e : h = new Materials[]{Materials.Clay}) {
            if (e == Materials.DarkSteel && !Mods.EnderIO.isModLoaded()) continue;
            int tVoltageMultiplier = e.mBlastFurnaceTemp >= 2800 ? 60 : 15;
            GregtechConduits.generatePipeRecipes(e.mDefaultLocalName, e.getMass(), tVoltageMultiplier);
        }
        RecipeUtils.addShapedGregtechRecipe(CI.component_Plate[6], MaterialsAlloy.MARAGING250.getGear(1), CI.component_Plate[6], CI.getTieredCircuitOreDictName(4), GregtechItemList.Casing_AdvancedVacuum.get(1L, new Object[0]), CI.getTieredCircuitOreDictName(4), CI.component_Plate[5], ItemList.Hatch_Input_IV.get(1L, new Object[0]), CI.component_Plate[5], GregtechItemList.Hatch_Input_Cryotheum.get(1L, new Object[0]));
        RecipeUtils.addShapedGregtechRecipe(MaterialsAlloy.MARAGING250.getPlate(1), MaterialsAlloy.MARAGING300.getGear(1), MaterialsAlloy.MARAGING250.getPlate(1), CI.getTieredCircuitOreDictName(5), GregtechItemList.Casing_Adv_BlastFurnace.get(1L, new Object[0]), CI.getTieredCircuitOreDictName(5), MaterialsAlloy.MARAGING250.getPlate(1), ItemList.Hatch_Input_IV.get(1L, new Object[0]), MaterialsAlloy.MARAGING250.getPlate(1), GregtechItemList.Hatch_Input_Pyrotheum.get(1L, new Object[0]));
        RecipeUtils.addShapedGregtechRecipe(CI.component_Plate[8], MaterialsAlloy.PIKYONIUM.getGear(1), CI.component_Plate[9], CI.getTieredCircuitOreDictName(7), GregtechItemList.Casing_Naq_Reactor_A.get(1L, new Object[0]), CI.getTieredCircuitOreDictName(7), CI.component_Plate[9], ItemList.Hatch_Input_ZPM.get(1L, new Object[0]), CI.component_Plate[8], GregtechItemList.Hatch_Input_Naquadah.get(1L, new Object[0]));
        if (GTMod.gregtechproxy.mPollution) {
            GTModHandler.addCraftingRecipe(GregtechItemList.Hatch_Muffler_Adv_LV.get(1L, new Object[0]), CI.bitsd, new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_LV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_LV.get(1L, new Object[0])});
            GTModHandler.addCraftingRecipe(GregtechItemList.Hatch_Muffler_Adv_MV.get(1L, new Object[0]), CI.bitsd, new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_MV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_MV.get(1L, new Object[0])});
            GTModHandler.addCraftingRecipe(GregtechItemList.Hatch_Muffler_Adv_HV.get(1L, new Object[0]), CI.bitsd, new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_HV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_HV.get(1L, new Object[0])});
            GTModHandler.addCraftingRecipe(GregtechItemList.Hatch_Muffler_Adv_EV.get(1L, new Object[0]), CI.bitsd, new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_EV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_EV.get(1L, new Object[0])});
            GTModHandler.addCraftingRecipe(GregtechItemList.Hatch_Muffler_Adv_IV.get(1L, new Object[0]), CI.bitsd, new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_IV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_IV.get(1L, new Object[0])});
            GTModHandler.addCraftingRecipe(GregtechItemList.Hatch_Muffler_Adv_LuV.get(1L, new Object[0]), CI.bitsd, new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_LuV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_LuV.get(1L, new Object[0])});
            GTModHandler.addCraftingRecipe(GregtechItemList.Hatch_Muffler_Adv_ZPM.get(1L, new Object[0]), CI.bitsd, new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_ZPM.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_ZPM.get(1L, new Object[0])});
            GTModHandler.addCraftingRecipe(GregtechItemList.Hatch_Muffler_Adv_UV.get(1L, new Object[0]), CI.bitsd, new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_UV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_UV.get(1L, new Object[0])});
            GTModHandler.addCraftingRecipe(GregtechItemList.Hatch_Muffler_Adv_MAX.get(1L, new Object[0]), CI.bitsd, new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_MAX.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_MAX.get(1L, new Object[0])});
        }
    }

    static {
        RECIPE_LapisDust = "dustLazurite";
    }
}

