/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.minecraft.ItemPackage;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CoalTar
extends ItemPackage {
    public static Fluid Coal_Gas;
    public static Fluid Coal_Oil;
    public static Fluid Ethylene;
    public static Fluid Ethylbenzene;
    public static Fluid Anthracene;
    public static Fluid Toluene;
    public static Fluid Coal_Tar;
    public static Fluid Coal_Tar_Oil;
    public static Fluid Sulfuric_Coal_Tar_Oil;
    public static Fluid Naphthalene;

    public static void recipeCreateEthylene() {
        FluidStack bioEth1 = FluidUtils.getFluidStack("fluid.bioethanol", 1000);
        FluidStack bioEth2 = FluidUtils.getFluidStack("bioethanol", 1000);
        if (bioEth1 != null) {
            GTValues.RA.stdBuilder().itemInputs(CI.getNumberedBioCircuit(17), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("cellEthylene", 1)).fluidInputs(bioEth1).fluidOutputs(FluidUtils.getWater(1000)).eut(80).duration(2400).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        }
        if (bioEth2 != null) {
            GTValues.RA.stdBuilder().itemInputs(CI.getNumberedBioCircuit(18), ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("cellEthylene", 1)).fluidInputs(bioEth2).fluidOutputs(FluidUtils.getWater(1000)).eut(80).duration(2400).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        }
    }

    public static void recipeCreateBenzene() {
        GTValues.RA.stdBuilder().itemInputs(Materials.Toluene.getCells(1)).itemOutputs(Materials.Benzene.getCells(1)).fluidInputs(Materials.Hydrogen.getGas(2000L)).fluidOutputs(Materials.Methane.getGas(1000L)).duration(200).eut(90).noOptimize().addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
    }

    public static void recipeCreateEthylbenzene() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("cellEthylene", 2), GTUtility.getIntegratedCircuit(3)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 2)).fluidInputs(FluidUtils.getFluidStack("benzene", 2000)).fluidOutputs(FluidUtils.getFluidStack("fluid.ethylbenzene", 2000)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("cellBenzene", 2), GTUtility.getIntegratedCircuit(3)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", 2)).fluidInputs(FluidUtils.getFluidStack("ethylene", 2000)).fluidOutputs(FluidUtils.getFluidStack("fluid.ethylbenzene", 2000)).duration(300).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.chemicalReactorRecipes);
    }

    public static void recipeCoalToCoalTar() {
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(8), GTOreDictUnificator.get(OrePrefixes.gem, Materials.Charcoal, 32L)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustSmallDirt", 2)).fluidOutputs(FluidUtils.getFluidStack("fluid.coaltar", 800)).duration(360).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(8), GTOreDictUnificator.get(OrePrefixes.gem, Materials.Lignite, 16L)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustSmallDarkAsh", 2)).fluidOutputs(FluidUtils.getFluidStack("fluid.coaltar", 800)).duration(1080).eut(60).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(8), GTOreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 12L)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustSmallDarkAsh", 2)).fluidOutputs(FluidUtils.getFluidStack("fluid.coaltar", 2200)).duration(720).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.pyrolyseRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(8), ItemUtils.getItemStackOfAmountFromOreDict("fuelCoke", 8)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustSmallAsh", 3)).fluidOutputs(FluidUtils.getFluidStack("fluid.coaltar", 3400)).duration(360).eut(240).addTo(RecipeMaps.pyrolyseRecipes);
    }

    private static void recipeCoalTarToCoalTarOil() {
        FluidStack[] distOutputs = new FluidStack[]{FluidUtils.getFluidStack("fluid.coaltaroil", 600), FluidUtils.getFluidStack("liquid_naphtha", 150), FluidUtils.getFluidStack("fluid.ethylbenzene", 200), FluidUtils.getFluidStack("fluid.anthracene", 50), FluidUtils.getFluidStack("fluid.kerosene", 600)};
        for (int i = 0; i < distOutputs.length; ++i) {
            GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(i + 1)).fluidInputs(FluidUtils.getFluidStack("fluid.coaltar", 1000)).fluidOutputs(distOutputs[i]).duration(600).eut(64).addTo(RecipeMaps.distilleryRecipes);
        }
        GTValues.RA.stdBuilder().fluidInputs(FluidUtils.getFluidStack("fluid.coaltar", 1000)).fluidOutputs(distOutputs).duration(300).eut(256).addTo(RecipeMaps.distillationTowerRecipes);
    }

    private static void recipeCoalTarOilToSulfuricOilToNaphthalene() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalTarOil", 8), ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricAcid", 8)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricCoalTarOil", 16)).duration(320).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(6)).fluidInputs(FluidUtils.getFluidStack("fluid.sulfuriccoaltaroil", 1000)).fluidOutputs(FluidUtils.getFluidStack("fluid.naphthalene", 1000)).eut(TierEU.RECIPE_LV).duration(1200).addTo(RecipeMaps.distilleryRecipes);
    }

    private static void recipeNaphthaleneToPhthalicAcid() {
        GTValues.RA.stdBuilder().itemInputs(Materials.Lithium.getDust(5)).fluidInputs(FluidUtils.getFluidStack(Naphthalene, 2000)).fluidOutputs(Materials.PhthalicAcid.getFluid(2500L)).eut(30).duration(320).noOptimize().addTo(GTRecipeConstants.UniversalChemical);
    }

    private static void recipePhthalicAcidToPhthalicAnhydride() {
        GTValues.RA.stdBuilder().itemInputs(CI.getNumberedBioCircuit(15)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustPhthalicAnhydride", 15)).fluidInputs(Materials.PhthalicAcid.getFluid(1000L)).eut(TierEU.RECIPE_MV).duration(1200).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
    }

    @Override
    public String errorMessage() {
        return "Bad Coal Science!";
    }

    @Override
    public boolean generateRecipes() {
        CoalTar.recipeCreateEthylene();
        CoalTar.recipeCreateBenzene();
        CoalTar.recipeCreateEthylbenzene();
        CoalTar.recipeCoalToCoalTar();
        CoalTar.recipeCoalTarToCoalTarOil();
        CoalTar.recipeCoalTarOilToSulfuricOilToNaphthalene();
        CoalTar.recipeNaphthaleneToPhthalicAcid();
        CoalTar.recipePhthalicAcidToPhthalicAnhydride();
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("cellCoalGas", 1)).metadata(GTRecipeConstants.FUEL_VALUE, 96).metadata(GTRecipeConstants.FUEL_TYPE, GTRecipeConstants.FuelType.GasTurbine.ordinal()).duration(0).eut(0).addTo(GTRecipeConstants.Fuel);
        GTValues.RA.stdBuilder().fluidInputs(FluidContainerRegistry.getFluidForFilledItem((ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricCoalTarOil", 1))).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 64).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().fluidInputs(FluidContainerRegistry.getFluidForFilledItem((ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("cellCoalTarOil", 1))).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 32).addTo(GTPPRecipeMaps.semiFluidFuels);
        GTValues.RA.stdBuilder().fluidInputs(FluidContainerRegistry.getFluidForFilledItem((ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("cellCoalTar", 1))).duration(0).eut(0).metadata(GTRecipeConstants.FUEL_VALUE, 16).addTo(GTPPRecipeMaps.semiFluidFuels);
        return true;
    }

    @Override
    public void items() {
        ItemUtils.generateSpecialUseDusts("PhthalicAnhydride", "Phthalic Anhydride", "C6H4(CO)2O", Utils.rgbtoHexValue(175, 175, 175));
        ItemUtils.generateSpecialUseDusts("LithiumHydroperoxide", "Lithium Hydroperoxide", "HLiO2", Utils.rgbtoHexValue(125, 125, 125));
    }

    @Override
    public void blocks() {
    }

    @Override
    public void fluids() {
        Coal_Gas = FluidUtils.generateFluidNonMolten("CoalGas", "Coal Gas", 500, new short[]{48, 48, 48, 100}, null, null);
        Ethylene = !FluidUtils.doesFluidExist("ethylene") ? FluidUtils.generateFluidNonMolten("ethylene", "Ethylene", -103, new short[]{255, 255, 255, 100}, null, null) : FluidUtils.getWildcardFluidStack("ethylene", 1).getFluid();
        Ethylbenzene = FluidUtils.generateFluidNonMolten("Ethylbenzene", "Ethylbenzene", 136, new short[]{255, 255, 255, 100}, null, null);
        Anthracene = FluidUtils.generateFluidNonMolten("Anthracene", "Anthracene", 340, new short[]{255, 255, 255, 100}, null, null);
        Toluene = !FluidUtils.doesFluidExist("liquid_toluene") ? FluidUtils.generateFluidNonMolten("liquid_toluene", "Toluene", -95, new short[]{140, 70, 20, 100}, null, null) : FluidUtils.getWildcardFluidStack("liquid_toluene", 1).getFluid();
        Coal_Tar = FluidUtils.generateFluidNonMolten("CoalTar", "Coal Tar", 450, new short[]{32, 32, 32, 100}, null, null);
        Coal_Tar_Oil = FluidUtils.generateFluidNonMolten("CoalTarOil", "Coal Tar Oil", 240, new short[]{240, 240, 150, 100}, null, null);
        Sulfuric_Coal_Tar_Oil = FluidUtils.generateFluidNonMolten("SulfuricCoalTarOil", "Sulfuric Coal Tar Oil", 240, new short[]{250, 170, 12, 100}, null, null);
        Naphthalene = FluidUtils.generateFluidNonMolten("Naphthalene", "Naphthalene", 115, new short[]{210, 185, 135, 100}, null, null);
    }
}

