/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import gregtech.GTMod;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTUtil;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationUnitBase;
import gregtech.common.tileentities.machines.multi.purification.PurificationUnitStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.DimensionManager;

public class LinkedPurificationUnit {
    private boolean mIsActive = false;
    private final MTEPurificationUnitBase<?> mMetaTileEntity;

    public LinkedPurificationUnit(MTEPurificationUnitBase<?> unit) {
        this.mMetaTileEntity = unit;
    }

    public LinkedPurificationUnit(NBTTagCompound nbtData) {
        this.mIsActive = nbtData.func_74767_n("active");
        NBTTagCompound linkData = nbtData.func_74775_l("linkData");
        Object world = null;
        world = !GTMod.gregtechproxy.isClientSide() ? DimensionManager.getWorld((int)nbtData.func_74762_e("worldID")) : Minecraft.func_71410_x().field_71439_g.field_70170_p;
        int x = linkData.func_74762_e("x");
        int y = linkData.func_74762_e("y");
        int z = linkData.func_74762_e("z");
        TileEntity te = GTUtil.getTileEntity(world, x, y, z, true);
        if (te == null) {
            throw new NullPointerException("Unit disappeared during server sync. This is a bug.");
        }
        this.mMetaTileEntity = (MTEPurificationUnitBase)((IGregTechTileEntity)te).getMetaTileEntity();
    }

    public MTEPurificationUnitBase<?> metaTileEntity() {
        return this.mMetaTileEntity;
    }

    public boolean isActive() {
        return this.mIsActive;
    }

    public void setActive(boolean active) {
        this.mIsActive = active;
    }

    public String getStatusString() {
        if (this.isActive()) {
            return EnumChatFormatting.GREEN + "Active";
        }
        PurificationUnitStatus status = this.mMetaTileEntity.status();
        switch (status) {
            case ONLINE: {
                return EnumChatFormatting.GREEN + "Online";
            }
            case DISABLED: {
                return EnumChatFormatting.YELLOW + "Disabled";
            }
            case INCOMPLETE_STRUCTURE: {
                return EnumChatFormatting.RED + "Incomplete Structure";
            }
        }
        return null;
    }

    public NBTTagCompound writeLinkDataToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("active,", this.mIsActive);
        NBTTagCompound linkData = new NBTTagCompound();
        IGregTechTileEntity mte = this.mMetaTileEntity.getBaseMetaTileEntity();
        linkData.func_74768_a("x", mte.getXCoord());
        linkData.func_74768_a("y", (int)mte.getYCoord());
        linkData.func_74768_a("z", mte.getZCoord());
        tag.func_74782_a("linkData", (NBTBase)linkData);
        tag.func_74768_a("worldID", this.mMetaTileEntity.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
        return tag;
    }
}

