/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import appeng.api.implementations.tiles.ISoundP2PHandler;
import appeng.me.GridAccessException;
import appeng.me.cache.helpers.TunnelCollection;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.p2p.PartP2PSound;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.gtnhlib.api.MusicRecordMetadataProvider;
import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SliderWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTMusicSystem;
import gregtech.common.gui.modularui.UIHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Vector4i;
import org.joml.Vector4ic;

public class MTEBetterJukebox
extends MTEBasicMachine
implements IAddUIWidgets,
ISoundP2PHandler {
    public UUID jukeboxUuid = UNSET_UUID;
    public boolean loopMode = true;
    public boolean shuffleMode = false;
    public int playbackSlot = 0;
    public float playbackVolume = BalanceMath.VANILLA_JUKEBOX_RANGE;
    public float p2pVolume = BalanceMath.VANILLA_JUKEBOX_RANGE;
    public long discProgressMs = 0L;
    public boolean superFastDebugMode = false;
    private final Vector4i interdimPositionCache = new Vector4i();
    private GTMusicSystem.MusicSource musicSource = null;
    private boolean powered = false;
    private long discStartMs = 0L;
    public long discDurationMs = 1L;
    private ItemRecord currentlyPlaying = null;
    public static final UUID UNSET_UUID = UUID.nameUUIDFromBytes(new byte[]{0});
    public static final int INPUT_SLOTS = 21;
    private static final Random SHUFFLER = new Random();
    public static final String NBTKEY_UUID_LOW = "jukeboxUUIDLow";
    public static final String NBTKEY_UUID_HIGH = "jukeboxUUIDHigh";
    public static final String NBTKEY_LOOP_MODE = "loopMode";
    public static final String NBTKEY_SHUFFLE_MODE = "shuffleMode";
    public static final String NBTKEY_PLAYBACK_SLOT = "playbackSlot";
    public static final String NBTKEY_VOLUME_PLAY = "playbackVolume";
    public static final String NBTKEY_VOLUME_P2P = "p2pVolume";
    public static final String NBTKEY_DISC_PROGRESS_MS = "discProgressMs";
    private final EnumMap<ForgeDirection, PartP2PSound> attachedSoundP2P = new EnumMap(ForgeDirection.class);
    private final ObjectArrayList<PartP2PSound> combinedOutputsListCache = new ObjectArrayList((Object[])new PartP2PSound[0]);

    private static String[] buildDescription(int aTier) {
        String string;
        ArrayList<String> strings = new ArrayList<String>(4);
        strings.add("Plays music better than your average vanilla jukebox.");
        if (BalanceMath.headphoneLimit(aTier) != HeadphoneLimit.BLOCK_RANGE) {
            strings.add(EnumChatFormatting.BLUE + "The raw power of Hatsune Miku in your ears");
        }
        strings.add(String.format("Range: %s%.1f blocks", EnumChatFormatting.WHITE, Float.valueOf(BalanceMath.volumeToAttenuationDistance(BalanceMath.listeningVolume(aTier)))));
        switch (BalanceMath.headphoneLimit(aTier)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BLOCK_RANGE: {
                string = String.format("Headphone signal range: %s%d blocks", EnumChatFormatting.WHITE, BalanceMath.headphoneBlockRange(aTier));
                break;
            }
            case INSIDE_DIMENSION: {
                string = String.format("Headphones work anywhere in %sthe same dimension", EnumChatFormatting.WHITE);
                break;
            }
            case BETWEEN_DIMENSIONS: {
                string = String.format("Headphones work anywhere, in %sany dimension", EnumChatFormatting.WHITE);
            }
        }
        strings.add(string);
        strings.add(String.format("Cost: %s%d EU/t", EnumChatFormatting.WHITE, BalanceMath.eutUsage(aTier)));
        strings.add(GTValues.AuthorEigenRaven);
        return strings.toArray(new String[0]);
    }

    public MTEBetterJukebox(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, MTEBetterJukebox.buildDescription(aTier), 21, 1, new ITexture[0]);
        this.playbackVolume = BalanceMath.listeningVolume(aTier);
    }

    public MTEBetterJukebox(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 21, 1);
        this.playbackVolume = BalanceMath.listeningVolume(aTier);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEBetterJukebox(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == baseMetaTileEntity.getFrontFacing()) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
        }
        if (sideDirection != ForgeDirection.UP) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_JUKEBOX)};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_JUKEBOX).extFacing().build()};
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        Item item;
        super.onFirstTick(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isClientSide()) {
            return;
        }
        Vector4i interdimPosition = this.interdimPositionCache;
        interdimPosition.x = aBaseMetaTileEntity.getXCoord();
        interdimPosition.y = aBaseMetaTileEntity.getYCoord();
        interdimPosition.z = aBaseMetaTileEntity.getZCoord();
        interdimPosition.w = aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g;
        if (this.jukeboxUuid == UNSET_UUID) {
            this.jukeboxUuid = UUID.randomUUID();
            this.func_70296_d();
        }
        if (this.musicSource == null) {
            this.musicSource = GTMusicSystem.ServerSystem.registerOrGetMusicSource(this.jukeboxUuid);
            this.musicSource.originPosition.set((Vector4ic)interdimPosition);
            this.musicSource.headphoneLimit = BalanceMath.headphoneLimit(this.mTier);
            this.musicSource.headphoneBlockRange = BalanceMath.headphoneBlockRange(this.mTier);
            this.musicSource.startedPlayingAtMs = System.currentTimeMillis();
            this.updateEmitterList();
        }
        if (this.doesSlotContainValidRecord(this.playbackSlot) && (item = this.mInventory[this.getInputSlot() + this.playbackSlot].func_77973_b()) instanceof ItemRecord) {
            ResourceLocation playPath;
            ResourceLocation resource;
            ItemRecord record = (ItemRecord)item;
            if (record instanceof MusicRecordMetadataProvider) {
                MusicRecordMetadataProvider mrmp = (MusicRecordMetadataProvider)record;
                playPath = resource = mrmp.getMusicRecordResource(this.mInventory[this.getInputSlot() + this.playbackSlot]);
            } else {
                resource = record.getRecordResource(record.field_150929_a);
                playPath = new ResourceLocation(resource.func_110624_b(), "records." + resource.func_110623_a());
            }
            this.currentlyPlaying = record;
            this.discDurationMs = GTMusicSystem.getMusicRecordDurations().getOrDefault((Object)resource, 500000);
            this.discStartMs = System.currentTimeMillis() - this.discProgressMs;
            this.musicSource.setRecord(playPath, this.discProgressMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        try {
            Item item;
            boolean canStartPlaying;
            boolean hasValidRecord;
            if (aBaseMetaTileEntity.isClientSide() || !aBaseMetaTileEntity.isAllowedToWork() || this.musicSource == null) {
                if (this.currentlyPlaying != null) {
                    this.stopCurrentSong(System.currentTimeMillis());
                }
                return;
            }
            Vector4i interdimPosition = this.interdimPositionCache;
            interdimPosition.x = aBaseMetaTileEntity.getXCoord();
            interdimPosition.y = aBaseMetaTileEntity.getYCoord();
            interdimPosition.z = aBaseMetaTileEntity.getZCoord();
            interdimPosition.w = aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g;
            long now = System.currentTimeMillis();
            if (this.superFastDebugMode && this.discDurationMs > 4000L) {
                this.discDurationMs = 4000L;
            }
            boolean hasMinimumEU = aBaseMetaTileEntity.isUniversalEnergyStored(this.getMinimumStoredEU());
            if (this.currentlyPlaying != null && hasMinimumEU && aBaseMetaTileEntity.decreaseStoredEnergyUnits(BalanceMath.eutUsage(this.mTier), false)) {
                if (!this.powered) {
                    this.powered = true;
                    this.musicSource.modified = true;
                    this.musicSource.headphoneLimit = BalanceMath.headphoneLimit(this.mTier);
                    this.musicSource.headphoneBlockRange = BalanceMath.headphoneBlockRange(this.mTier);
                    this.updateEmitterList();
                }
            } else if ((!hasMinimumEU || this.currentlyPlaying != null) && this.powered) {
                this.powered = false;
                this.musicSource.modified = true;
                this.musicSource.headphoneLimit = HeadphoneLimit.BLOCK_RANGE;
                this.musicSource.headphoneBlockRange = BalanceMath.headphoneBlockRange(0);
                this.updateEmitterList();
            }
            if (this.currentlyPlaying != null) {
                boolean wasDiscSwapped;
                this.discProgressMs = now - this.discStartMs;
                hasValidRecord = this.doesSlotContainValidRecord(this.playbackSlot);
                boolean bl = wasDiscSwapped = hasValidRecord && this.mInventory[this.getInputSlot() + this.playbackSlot].func_77973_b() != this.currentlyPlaying;
                if (this.discProgressMs >= this.discDurationMs || !hasValidRecord || wasDiscSwapped) {
                    this.stopCurrentSong(now);
                    if (!this.loopMode) {
                        ItemStack oldOut = this.mInventory[this.getOutputSlot()];
                        this.mInventory[this.getOutputSlot()] = this.mInventory[this.getInputSlot() + this.playbackSlot];
                        this.mInventory[this.getInputSlot() + this.playbackSlot] = oldOut;
                        this.func_70296_d();
                    }
                    if (!hasValidRecord || !wasDiscSwapped) {
                        this.pickNextSlot();
                    }
                } else {
                    return;
                }
            }
            if (this.playbackSlot < 0 || this.playbackSlot >= 21 || aTimer % 10L == 0L && !this.doesSlotContainValidRecord(this.playbackSlot)) {
                this.pickNextSlot();
            }
            hasValidRecord = this.doesSlotContainValidRecord(this.playbackSlot);
            boolean bl = canStartPlaying = this.loopMode || this.isOutputEmpty();
            if (!hasValidRecord) {
                this.stopCurrentSong(now);
            } else if (canStartPlaying && (item = this.mInventory[this.getInputSlot() + this.playbackSlot].func_77973_b()) instanceof ItemRecord) {
                ResourceLocation playPath;
                ResourceLocation resource;
                ItemRecord record = (ItemRecord)item;
                if (record instanceof MusicRecordMetadataProvider) {
                    MusicRecordMetadataProvider mrmp = (MusicRecordMetadataProvider)record;
                    playPath = resource = mrmp.getMusicRecordResource(this.mInventory[this.getInputSlot() + this.playbackSlot]);
                } else {
                    resource = record.getRecordResource(record.field_150929_a);
                    playPath = new ResourceLocation(resource.func_110624_b(), "records." + resource.func_110623_a());
                }
                this.currentlyPlaying = record;
                this.musicSource.setRecord(playPath);
                this.discDurationMs = GTMusicSystem.getMusicRecordDurations().getOrDefault((Object)resource, 500000);
                this.discProgressMs = 0L;
                this.discStartMs = now;
            }
        }
        finally {
            super.onPostTick(aBaseMetaTileEntity, aTimer);
        }
    }

    private void stopCurrentSong(long nowMs) {
        if (this.currentlyPlaying == null) {
            return;
        }
        this.musicSource.setRecord(null);
        this.currentlyPlaying = null;
        this.discDurationMs = 1L;
        this.discProgressMs = 0L;
        this.discStartMs = nowMs;
        this.func_70296_d();
    }

    private void pickNextSlot() {
        this.playbackSlot = MathHelper.func_76125_a((int)this.playbackSlot, (int)0, (int)21);
        if (this.shuffleMode) {
            int[] validSlots = new int[21];
            int validSlotCount = 0;
            for (int i = 0; i < 21; ++i) {
                if (i == this.playbackSlot || !this.doesSlotContainValidRecord(i)) continue;
                validSlots[validSlotCount++] = i;
            }
            switch (validSlotCount) {
                case 0: {
                    break;
                }
                case 1: {
                    this.playbackSlot = validSlots[0];
                    break;
                }
                default: {
                    this.playbackSlot = validSlots[SHUFFLER.nextInt(validSlotCount)];
                    break;
                }
            }
        } else {
            int attempt = 0;
            int nextSlot = this.playbackSlot;
            while (!this.doesSlotContainValidRecord(nextSlot = (nextSlot + 1) % 21) && ++attempt <= 21) {
            }
            if (attempt <= 21) {
                this.playbackSlot = nextSlot;
            }
        }
    }

    public boolean doesSlotContainValidRecord(int slot) {
        return this.mInventory[this.getInputSlot() + slot] != null && this.mInventory[this.getInputSlot() + slot].func_77973_b() instanceof ItemRecord;
    }

    @Override
    public void onRemoval() {
        IGregTechTileEntity baseTE = this.getBaseMetaTileEntity();
        if (baseTE == null) {
            return;
        }
        if (!baseTE.isServerSide()) {
            return;
        }
        if (this.jukeboxUuid == UNSET_UUID) {
            return;
        }
        GTMusicSystem.ServerSystem.removeMusicSource(this.jukeboxUuid);
    }

    @Override
    public long getMinimumStoredEU() {
        return BalanceMath.eutUsage(this.mTier) * 20L;
    }

    @Override
    public long maxEUStore() {
        return 512L + BalanceMath.eutUsage(this.mTier) * 50L;
    }

    @Override
    public long maxAmperesIn() {
        return 1L;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Jukebox UUID: " + (this.jukeboxUuid == UNSET_UUID ? "unset" : this.jukeboxUuid), "Loop mode: " + this.loopMode, "Shuffle mode: " + this.shuffleMode, "Played the disc for [ms]: " + this.discProgressMs, "Current disc duration [ms]: " + this.discDurationMs, "Playback range [blocks]: " + BalanceMath.volumeToAttenuationDistance(this.playbackVolume), "P2P range [blocks]: " + BalanceMath.volumeToAttenuationDistance(this.playbackVolume), "Raw playback strength: " + this.playbackVolume, "Raw p2p strength: " + this.p2pVolume};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.jukeboxUuid != UNSET_UUID) {
            aNBT.func_74772_a(NBTKEY_UUID_LOW, this.jukeboxUuid.getLeastSignificantBits());
            aNBT.func_74772_a(NBTKEY_UUID_HIGH, this.jukeboxUuid.getMostSignificantBits());
            aNBT.func_74757_a(NBTKEY_LOOP_MODE, this.loopMode);
            aNBT.func_74757_a(NBTKEY_SHUFFLE_MODE, this.shuffleMode);
            aNBT.func_74768_a(NBTKEY_PLAYBACK_SLOT, this.playbackSlot);
            aNBT.func_74776_a(NBTKEY_VOLUME_PLAY, this.playbackVolume);
            aNBT.func_74776_a(NBTKEY_VOLUME_P2P, this.p2pVolume);
            aNBT.func_74772_a(NBTKEY_DISC_PROGRESS_MS, this.discProgressMs);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_150297_b(NBTKEY_UUID_LOW, 99) && aNBT.func_150297_b(NBTKEY_UUID_HIGH, 99)) {
            this.jukeboxUuid = new UUID(aNBT.func_74763_f(NBTKEY_UUID_HIGH), aNBT.func_74763_f(NBTKEY_UUID_LOW));
        }
        if (aNBT.func_150297_b(NBTKEY_LOOP_MODE, 99)) {
            this.loopMode = aNBT.func_74767_n(NBTKEY_LOOP_MODE);
        }
        if (aNBT.func_150297_b(NBTKEY_SHUFFLE_MODE, 99)) {
            this.shuffleMode = aNBT.func_74767_n(NBTKEY_SHUFFLE_MODE);
        }
        if (aNBT.func_150297_b(NBTKEY_PLAYBACK_SLOT, 99)) {
            this.playbackSlot = aNBT.func_74762_e(NBTKEY_PLAYBACK_SLOT);
        }
        if (aNBT.func_150297_b(NBTKEY_VOLUME_PLAY, 99)) {
            this.playbackVolume = aNBT.func_74760_g(NBTKEY_VOLUME_PLAY);
        }
        if (aNBT.func_150297_b(NBTKEY_VOLUME_P2P, 99)) {
            this.p2pVolume = aNBT.func_74760_g(NBTKEY_VOLUME_P2P);
        }
        if (aNBT.func_150297_b(NBTKEY_DISC_PROGRESS_MS, 99)) {
            this.discProgressMs = aNBT.func_74763_f(NBTKEY_DISC_PROGRESS_MS);
        }
        float maxVolume = BalanceMath.listeningVolume(this.mTier);
        this.playbackVolume = MathHelper.func_76131_a((float)this.playbackVolume, (float)0.0f, (float)maxVolume);
        this.p2pVolume = MathHelper.func_76131_a((float)this.p2pVolume, (float)0.0f, (float)maxVolume);
    }

    @Override
    protected BasicUIProperties getUIProperties() {
        return super.getUIProperties().toBuilder().itemInputPositionsGetter(count -> UIHelper.getGridPositions(count, 7, 6, 7, 3)).itemOutputPositionsGetter(count -> UIHelper.getGridPositions(count, 153, 24, 1)).specialItemPositionGetter(() -> new Pos2d(115, 62)).progressBarPos(Pos2d.cartesian((int)133, (int)24)).progressBarTexture(new FallbackableUITexture(GTUITextures.PROGRESSBAR_ARROW)).build();
    }

    @Override
    protected void addProgressBar(ModularWindow.Builder builder, BasicUIProperties uiProperties) {
        builder.widget(this.setNEITransferRect(new ProgressBar().setProgress(() -> Float.valueOf((float)this.discProgressMs / (float)Math.max(1L, this.discDurationMs))).setTexture(uiProperties.progressBarTexture.get(), uiProperties.progressBarImageSize).setDirection(uiProperties.progressBarDirection).setPos(uiProperties.progressBarPos).setSize(uiProperties.progressBarSize).setUpdateTooltipEveryTick(true).attachSyncer((FakeSyncWidget)new FakeSyncWidget.LongSyncer(() -> this.discProgressMs, val -> {
            this.discProgressMs = val;
        }), (IWidgetBuilder)builder).attachSyncer((FakeSyncWidget)new FakeSyncWidget.LongSyncer(() -> this.discDurationMs, val -> {
            this.discDurationMs = val;
        }), (IWidgetBuilder)builder).dynamicTooltip(() -> Collections.singletonList(String.format("%,.2f / %,.2f", Float.valueOf((float)this.discProgressMs / 1000.0f), Float.valueOf((float)this.discDurationMs / 1000.0f)))), uiProperties.neiTransferRectId));
        this.addProgressBarSpecialTextures(builder, uiProperties);
    }

    @Override
    protected SlotWidget createChargerSlot(int x, int y) {
        return super.createChargerSlot(97, 62);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        BasicUIProperties props = this.getUIProperties();
        List<Pos2d> inputSlots = props.itemInputPositionsGetter.apply(this.mInputSlotCount);
        builder.widget(new CycleButtonWidget().setToggle(() -> this.loopMode, val -> {
            this.loopMode = val;
        }).setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_CYCLIC).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.betterjukebox.loop.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(153, 6).setSize(18, 18));
        builder.widget(new CycleButtonWidget().setToggle(() -> this.shuffleMode, val -> {
            this.shuffleMode = val;
            this.playbackSlot = this.shuffleMode ? -1 : 0;
        }).setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_SHUFFLE).setVariableBackground(new UITexture[]{GTUITextures.BUTTON_STANDARD_TOGGLE}).setGTTooltip(() -> this.mTooltipCache.getData("GT5U.machines.betterjukebox.shuffle.tooltip", new Object[0])).setTooltipShowUpDelay(5).setPos(153, 42).setSize(18, 18));
        DrawableWidget slotHighlight = new DrawableWidget();
        builder.widget(slotHighlight.setDrawable((IDrawable)new UITexture(new ResourceLocation("minecraft", "textures/gui/widgets.png"), 0.0f, 0.0859375f, 0.09375f, 0.1796875f)).setSize(24, 24).attachSyncer((FakeSyncWidget)new FakeSyncWidget.IntegerSyncer(() -> this.playbackSlot, val -> {
            this.playbackSlot = val;
            slotHighlight.checkNeedsRebuild();
        }), (IWidgetBuilder)builder).setPosProvider((screenSize, window, parent) -> ((Pos2d)inputSlots.get(MathHelper.func_76125_a((int)this.playbackSlot, (int)0, (int)21))).add(-3, -3)));
        builder.widget(new SliderWidget().setBounds(0.0f, BalanceMath.volumeToAttenuationDistance(BalanceMath.listeningVolume(this.mTier))).setGetter(this::getPlaybackBlockRange).setSetter(this::setPlaybackBlockRange).dynamicTooltip(() -> this.mTooltipCache.getUncachedTooltipData((String)"GT5U.machines.betterjukebox.attenuationDistance.tooltip", (Object[])new Object[]{Integer.valueOf((int)((int)this.getPlaybackBlockRange()))}).text).setUpdateTooltipEveryTick(true).setPos(44, 63).setSize(52, 8));
        builder.widget(new SliderWidget().setBounds(0.0f, BalanceMath.volumeToAttenuationDistance(BalanceMath.listeningVolume(this.mTier))).setGetter(this::getP2PBlockRange).setSetter(this::setP2PBlockRange).dynamicTooltip(() -> this.mTooltipCache.getUncachedTooltipData((String)"GT5U.machines.betterjukebox.p2pAttenuationDistance.tooltip", (Object[])new Object[]{Integer.valueOf((int)((int)this.getP2PBlockRange()))}).text).setUpdateTooltipEveryTick(true).setPos(44, 71).setSize(52, 8));
    }

    private float getPlaybackBlockRange() {
        return BalanceMath.volumeToAttenuationDistance(this.playbackVolume);
    }

    private float getP2PBlockRange() {
        return BalanceMath.volumeToAttenuationDistance(this.p2pVolume);
    }

    private void setPlaybackBlockRange(float blockRange) {
        float volume = BalanceMath.attenuationDistanceToVolume(blockRange);
        if ((volume = MathHelper.func_76131_a((float)volume, (float)0.0f, (float)BalanceMath.listeningVolume(this.mTier))) != this.playbackVolume) {
            this.playbackVolume = volume;
            if (this.getBaseMetaTileEntity().isServerSide()) {
                this.updateEmitterList();
            }
        }
    }

    private void setP2PBlockRange(float blockRange) {
        float volume = BalanceMath.attenuationDistanceToVolume(blockRange);
        if ((volume = MathHelper.func_76131_a((float)volume, (float)0.0f, (float)BalanceMath.listeningVolume(this.mTier))) != this.p2pVolume) {
            this.p2pVolume = volume;
            if (this.getBaseMetaTileEntity().isServerSide()) {
                this.updateEmitterList();
            }
        }
    }

    private void updateEmitterList() {
        GTMusicSystem.MusicSource target = this.musicSource;
        if (target == null) {
            return;
        }
        ObjectArrayList<PartP2PSound> emitters = this.combinedOutputsListCache;
        emitters.clear();
        this.attachedSoundP2P.forEach((ignored, p2p) -> {
            if (p2p != null) {
                try {
                    p2p.getOutputs().forEach(arg_0 -> ((ObjectArrayList)emitters).add(arg_0));
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        });
        IGregTechTileEntity te = this.getBaseMetaTileEntity();
        if (te == null) {
            return;
        }
        Vector4i position = new Vector4i();
        target.resizeEmitterArray(1 + emitters.size());
        position.set(te.getXCoord(), (int)te.getYCoord(), te.getZCoord(), te.getWorld().field_73011_w.field_76574_g);
        float actualVolume = MathHelper.func_76131_a((float)this.playbackVolume, (float)0.0f, (float)BalanceMath.listeningVolume(this.powered ? this.mTier : (byte)0));
        target.setEmitter(0, position, actualVolume);
        float actualP2PVolume = MathHelper.func_76131_a((float)this.p2pVolume, (float)0.0f, (float)(this.powered ? BalanceMath.listeningVolume(this.mTier) : 0.0f));
        for (int i = 0; i < emitters.size(); ++i) {
            PartP2PSound p2p2 = (PartP2PSound)emitters.get(i);
            AENetworkProxy proxy = p2p2.getProxy();
            TileEntity emitterTe = p2p2.getTile();
            ForgeDirection dir = p2p2.getSide();
            position.set(emitterTe.field_145851_c + dir.offsetX, emitterTe.field_145848_d + dir.offsetY, emitterTe.field_145849_e + dir.offsetZ, emitterTe.func_145831_w().field_73011_w.field_76574_g);
            boolean active = proxy.isActive();
            target.setEmitter(1 + i, position, active ? actualP2PVolume : 0.0f);
        }
    }

    public boolean allowSoundProxying(PartP2PSound p2p) {
        return false;
    }

    public void onSoundP2PAttach(PartP2PSound p2p) {
        this.attachedSoundP2P.put(p2p.getSide(), p2p);
        this.updateEmitterList();
    }

    public void onSoundP2PDetach(PartP2PSound p2p) {
        this.attachedSoundP2P.put(p2p.getSide(), null);
        this.updateEmitterList();
    }

    public void onSoundP2POutputUpdate(PartP2PSound p2p, TunnelCollection<PartP2PSound> outputs) {
        this.updateEmitterList();
    }

    public static final class BalanceMath {
        public static int MAX_TIER = 5;
        public static float VANILLA_JUKEBOX_RANGE = 4.0f;
        private static final float[] LISTENING_VOLUME = new float[]{VANILLA_JUKEBOX_RANGE, VANILLA_JUKEBOX_RANGE + 1.0f, VANILLA_JUKEBOX_RANGE + 2.0f, VANILLA_JUKEBOX_RANGE + 4.0f, VANILLA_JUKEBOX_RANGE + 5.0f, VANILLA_JUKEBOX_RANGE + 6.0f};
        private static final int[] HEADPHONE_BLOCK_RANGE = new int[]{64, 128, 160, 320, 9001, 9002};

        public static float listeningVolume(int tier) {
            tier = MathHelper.func_76125_a((int)tier, (int)0, (int)MAX_TIER);
            return LISTENING_VOLUME[tier];
        }

        public static int headphoneBlockRange(int tier) {
            tier = MathHelper.func_76125_a((int)tier, (int)0, (int)MAX_TIER);
            return HEADPHONE_BLOCK_RANGE[tier];
        }

        public static HeadphoneLimit headphoneLimit(int tier) {
            if (tier <= 3) {
                return HeadphoneLimit.BLOCK_RANGE;
            }
            if (tier == 4) {
                return HeadphoneLimit.INSIDE_DIMENSION;
            }
            return HeadphoneLimit.BETWEEN_DIMENSIONS;
        }

        public static float volumeToAttenuationDistance(float range) {
            return 16.0f * range;
        }

        public static float attenuationDistanceToVolume(float blockRange) {
            return blockRange / 16.0f;
        }

        public static long eutUsage(int tier) {
            tier = MathHelper.func_76125_a((int)tier, (int)0, (int)MAX_TIER);
            return GTValues.V[tier] / 16L;
        }
    }

    public static enum HeadphoneLimit {
        BLOCK_RANGE,
        INSIDE_DIMENSION,
        BETWEEN_DIMENSIONS;

        public static final ImmutableList<HeadphoneLimit> ENTRIES;

        static {
            ENTRIES = ImmutableList.copyOf((Object[])HeadphoneLimit.values());
        }
    }
}

