/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gregtech.common.tileentities.storage.MTEDigitalTankBase;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverLiquidMeter
extends CoverBehaviorBase<LiquidMeterData> {
    public CoverLiquidMeter(ITexture coverTexture) {
        super(LiquidMeterData.class, coverTexture);
    }

    @Override
    public LiquidMeterData createDataObject(int aLegacyData) {
        return new LiquidMeterData(aLegacyData == 0, 0);
    }

    @Override
    public LiquidMeterData createDataObject() {
        return new LiquidMeterData();
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(ForgeDirection side, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    public static byte computeSignalBasedOnFluid(ICoverable tileEntity, boolean inverted, int threshold) {
        if (tileEntity instanceof IFluidHandler) {
            FluidTankInfo[] tanks = ((IFluidHandler)tileEntity).getTankInfo(ForgeDirection.UNKNOWN);
            long max = 0L;
            long used = 0L;
            if (tanks != null) {
                for (FluidTankInfo tank : tanks) {
                    if (tank == null) continue;
                    max = tileEntity instanceof BaseMetaTileEntity && ((BaseMetaTileEntity)tileEntity).getMetaTileEntity() instanceof MTEDigitalTankBase ? (max += (long)((MTEDigitalTankBase)((BaseMetaTileEntity)tileEntity).getMetaTileEntity()).getRealCapacity()) : (max += (long)tank.capacity);
                    FluidStack tLiquid = tank.fluid;
                    if (tLiquid == null) continue;
                    used += (long)tLiquid.amount;
                }
            }
            return GTUtility.convertRatioToRedstone(used, max, threshold, inverted);
        }
        return 0;
    }

    @Override
    protected LiquidMeterData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        byte signal = CoverLiquidMeter.computeSignalBasedOnFluid(aTileEntity, aCoverVariable.inverted, aCoverVariable.threshold);
        aTileEntity.setOutputRedstoneSignal(side, signal);
        return aCoverVariable;
    }

    @Override
    protected LiquidMeterData onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aCoverVariable.inverted) {
            aCoverVariable.inverted = false;
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("055", "Normal"));
        } else {
            aCoverVariable.inverted = true;
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("054", "Inverted"));
        }
        return aCoverVariable;
    }

    @Override
    protected boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, LiquidMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, LiquidMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsInImpl(ForgeDirection side, int aCoverID, LiquidMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, LiquidMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(ForgeDirection side, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(ForgeDirection side, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new LiquidMeterUIFactory(buildContext).createWindow();
    }

    public static class LiquidMeterData
    implements ISerializableObject {
        private boolean inverted;
        private int threshold;

        public LiquidMeterData() {
            this.inverted = false;
            this.threshold = 0;
        }

        public LiquidMeterData(boolean inverted, int threshold) {
            this.inverted = inverted;
            this.threshold = threshold;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new LiquidMeterData(this.inverted, this.threshold);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("invert", this.inverted);
            tag.func_74768_a("threshold", this.threshold);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeBoolean(this.inverted);
            aBuf.writeInt(this.threshold);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.inverted = tag.func_74767_n("invert");
            this.threshold = tag.func_74762_e("threshold");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.inverted = aBuf.readBoolean();
            this.threshold = aBuf.readInt();
            return this;
        }
    }

    private class LiquidMeterUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private int maxCapacity;

        public LiquidMeterUIFactory(CoverUIBuildContext buildContext) {
            super(buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            String INVERTED = GTUtility.trans("INVERTED", "Inverted");
            String NORMAL = GTUtility.trans("NORMAL", "Normal");
            this.setMaxCapacity();
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(((CoverDataControllerWidget)new CoverDataControllerWidget<LiquidMeterData>(this::getCoverData, this::setCoverData, CoverLiquidMeter.this).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofRedstone(), coverData -> ((LiquidMeterData)coverData).inverted, (coverData, state) -> {
                ((LiquidMeterData)coverData).inverted = state;
                return coverData;
            }, widget -> widget.addTooltip(0, NORMAL).addTooltip(1, INVERTED).setPos(0, 0))).addFollower((Widget)new CoverDataFollowerNumericWidget(), coverData -> ((LiquidMeterData)coverData).threshold, (coverData, state) -> {
                ((LiquidMeterData)coverData).threshold = state.intValue();
                return coverData;
            }, widget -> widget.setBounds(0.0, this.maxCapacity > 0 ? (double)this.maxCapacity : 2.147483647E9).setScrollValues(1000.0, 144.0, 100000.0).setFocusOnGuiOpen(true).setPos(0, 20).setSize(77, 12)).setPos(10, 25))).widget(new TextWidget().setStringSupplier(() -> this.getCoverData() != null ? (((LiquidMeterData)this.getCoverData()).inverted ? INVERTED : NORMAL) : "").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 29))).widget(new TextWidget(GTUtility.trans("222", "Fluid threshold")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(90, 47));
        }

        private void setMaxCapacity() {
            ICoverable tile = this.getUIBuildContext().getTile();
            if (!tile.isDead() && tile instanceof IFluidHandler) {
                FluidTankInfo[] tanks = ((IFluidHandler)tile).getTankInfo(ForgeDirection.UNKNOWN);
                this.maxCapacity = Arrays.stream(tanks).mapToInt(tank -> tank.capacity).sum();
            } else {
                this.maxCapacity = -1;
            }
        }
    }
}

