/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gregtech.common.gui.modularui.widget.ItemWatcherSlotWidget;
import gregtech.common.tileentities.machines.MTEHatchOutputBusME;
import gregtech.common.tileentities.storage.MTEDigitalChestBase;
import io.netty.buffer.ByteBuf;
import java.text.FieldPosition;
import java.text.NumberFormat;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverItemMeter
extends CoverBehaviorBase<ItemMeterData> {
    private static final int SLOT_MASK = 0x3FFFFFFF;
    private static final int CONVERTED_BIT = Integer.MIN_VALUE;
    private static final int INVERT_BIT = 0x40000000;

    public CoverItemMeter(ITexture coverTexture) {
        super(ItemMeterData.class, coverTexture);
    }

    @Override
    public ItemMeterData createDataObject(int aLegacyData) {
        if ((Integer.MIN_VALUE & aLegacyData) == 0) {
            if (aLegacyData == 0) {
                aLegacyData = Integer.MIN_VALUE;
            } else if (aLegacyData == 1) {
                aLegacyData = -1073741824;
            } else if (aLegacyData > 1) {
                aLegacyData = Integer.MIN_VALUE | Math.min(aLegacyData - 2, 0x3FFFFFFF);
            }
        }
        boolean invert = (aLegacyData & 0x40000000) == 0x40000000;
        int slot = (aLegacyData & 0x3FFFFFFF) - 1;
        return new ItemMeterData(invert, slot, 0);
    }

    @Override
    public ItemMeterData createDataObject() {
        return new ItemMeterData();
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(ForgeDirection side, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    public static byte computeSignalBasedOnItems(ICoverable tileEntity, boolean inverted, int threshold, int slot, int ordinalSide) {
        long max = 0L;
        long used = 0L;
        IMetaTileEntity mte = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
        if (mte instanceof MTEDigitalChestBase) {
            MTEDigitalChestBase dc = (MTEDigitalChestBase)mte;
            max = dc.getMaxItemCount();
            used = dc.getProgresstime();
        } else if (mte instanceof MTEHatchOutputBusME) {
            if (((MTEHatchOutputBusME)mte).canAcceptItem()) {
                max = 64L;
                used = 0L;
            }
        } else {
            int[] slots;
            int[] nArray;
            if (slot >= 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = slot;
            } else {
                nArray = tileEntity.func_94128_d(ordinalSide);
            }
            for (int i : slots = nArray) {
                if (i < 0 || i >= tileEntity.func_70302_i_()) continue;
                max += 64L;
                ItemStack stack = tileEntity.func_70301_a(i);
                if (stack == null) continue;
                used += ((long)stack.field_77994_a << 6) / (long)stack.func_77976_d();
            }
        }
        return GTUtility.convertRatioToRedstone(used, max, threshold, inverted);
    }

    @Override
    protected ItemMeterData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        byte signal = CoverItemMeter.computeSignalBasedOnItems(aTileEntity, aCoverVariable.inverted, aCoverVariable.threshold, aCoverVariable.slot, side.ordinal());
        aTileEntity.setOutputRedstoneSignal(side, signal);
        return aCoverVariable;
    }

    @Override
    protected ItemMeterData onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            if (aCoverVariable.inverted) {
                aCoverVariable.inverted = false;
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("055", "Normal"));
            } else {
                aCoverVariable.inverted = true;
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("054", "Inverted"));
            }
        } else {
            aCoverVariable.slot++;
            if (aCoverVariable.slot > aTileEntity.func_70302_i_()) {
                aCoverVariable.slot = -1;
            }
            if (aCoverVariable.slot == -1) {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("053", "Slot: ") + GTUtility.trans("ALL", "All"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("053", "Slot: ") + aCoverVariable.slot);
            }
        }
        return aCoverVariable;
    }

    @Override
    protected boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, ItemMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, ItemMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsInImpl(ForgeDirection side, int aCoverID, ItemMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, ItemMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(ForgeDirection side, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(ForgeDirection side, int aCoverID, ItemMeterData aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ItemMeterUIFactory(buildContext).createWindow();
    }

    public static class ItemMeterData
    implements ISerializableObject {
        private boolean inverted;
        private int slot;
        private int threshold;

        public ItemMeterData() {
            this.inverted = false;
            this.slot = -1;
            this.threshold = 0;
        }

        public ItemMeterData(boolean inverted, int slot, int threshold) {
            this.inverted = inverted;
            this.slot = slot;
            this.threshold = threshold;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new ItemMeterData(this.inverted, this.slot, this.threshold);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("invert", this.inverted);
            tag.func_74768_a("slot", this.slot);
            tag.func_74768_a("threshold", this.threshold);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeBoolean(this.inverted);
            aBuf.writeInt(this.slot);
            aBuf.writeInt(this.threshold);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.inverted = tag.func_74767_n("invert");
            this.slot = tag.func_74762_e("slot");
            this.threshold = tag.func_74762_e("threshold");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.inverted = aBuf.readBoolean();
            this.slot = aBuf.readInt();
            this.threshold = aBuf.readInt();
            return this;
        }
    }

    private class ItemMeterUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        protected static final NumberFormatMUI numberFormatAll = new NumberFormatMUI(){

            public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
                if (number < 0.0) {
                    return toAppendTo.append(GTUtility.trans("ALL", "All"));
                }
                return super.format(number, toAppendTo, pos);
            }
        };
        private int maxSlot;
        private int maxThreshold;

        public ItemMeterUIFactory(CoverUIBuildContext buildContext) {
            super(buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            String INVERTED = GTUtility.trans("INVERTED", "Inverted");
            String NORMAL = GTUtility.trans("NORMAL", "Normal");
            this.setMaxSlot();
            this.setMaxThreshold();
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(((CoverDataControllerWidget)((CoverDataControllerWidget)new CoverDataControllerWidget<ItemMeterData>(this::getCoverData, this::setCoverData, CoverItemMeter.this).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofRedstone(), coverData -> ((ItemMeterData)coverData).inverted, (coverData, state) -> {
                ((ItemMeterData)coverData).inverted = state;
                return coverData;
            }, widget -> widget.addTooltip(0, NORMAL).addTooltip(1, INVERTED).setPos(0, 0))).addFollower((Widget)new CoverDataFollowerNumericWidget(), coverData -> ((ItemMeterData)coverData).threshold, (coverData, state) -> {
                ((ItemMeterData)coverData).threshold = state.intValue();
                return coverData;
            }, widget -> widget.setBounds(0.0, this.maxThreshold).setScrollValues(1.0, 64.0, 1000.0).setFocusOnGuiOpen(true).setPos(0, 20).setSize(77, 12))).addFollower((Widget)new CoverDataFollowerNumericWidget(), coverData -> ((ItemMeterData)coverData).slot, (coverData, state) -> {
                ((ItemMeterData)coverData).slot = state.intValue();
                return coverData;
            }, widget -> widget.setBounds(-1.0, this.maxSlot).setDefaultValue(-1.0).setScrollValues(1.0, 100.0, 10.0).setNumberFormat((NumberFormat)numberFormatAll).setPos(0, 38).setSize(55, 12)).setPos(10, 25))).widget(new ItemWatcherSlotWidget().setGetter(this::getTargetItem).setPos(72, 61))).widget(new TextWidget().setStringSupplier(() -> this.getCoverData() != null ? (((ItemMeterData)this.getCoverData()).inverted ? INVERTED : NORMAL) : "").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 29))).widget(new TextWidget(GTUtility.trans("254", "Detect slot #")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(91, 65))).widget(new TextWidget(GTUtility.trans("221", "Item threshold")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(91, 47));
        }

        private void setMaxSlot() {
            IGregTechTileEntity gtTile;
            ICoverable tile = this.getUIBuildContext().getTile();
            this.maxSlot = !tile.isDead() && tile instanceof IGregTechTileEntity && !((gtTile = (IGregTechTileEntity)tile).getMetaTileEntity() instanceof MTEDigitalChestBase) ? Math.min(tile.func_70302_i_() - 1, 0x3FFFFFFE) : -1;
        }

        private void setMaxThreshold() {
            IGregTechTileEntity gtTile;
            ICoverable tile = this.getUIBuildContext().getTile();
            this.maxThreshold = !tile.isDead() && tile instanceof IGregTechTileEntity && (gtTile = (IGregTechTileEntity)tile).getMetaTileEntity() instanceof MTEDigitalChestBase ? gtTile.getMaxItemCount() : (this.maxSlot > 0 ? this.maxSlot * 64 : Integer.MAX_VALUE);
        }

        private ItemStack getTargetItem() {
            ItemMeterData coverVariable = (ItemMeterData)this.getCoverData();
            if (coverVariable == null || coverVariable.slot < 0) {
                return null;
            }
            ICoverable tile = this.getUIBuildContext().getTile();
            if (tile instanceof TileEntity && !tile.isDead() && tile.func_70302_i_() >= coverVariable.slot) {
                return tile.func_70301_a(coverVariable.slot);
            }
            return null;
        }
    }
}

