/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicBatteryBuffer;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerCycleButtonWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverEUMeter
extends CoverBehaviorBase<EUMeterData> {
    public CoverEUMeter(ITexture coverTexture) {
        super(EUMeterData.class, coverTexture);
    }

    @Override
    public EUMeterData createDataObject(int aLegacyData) {
        return new EUMeterData(aLegacyData, 0L);
    }

    @Override
    public EUMeterData createDataObject() {
        return new EUMeterData();
    }

    @Override
    protected EUMeterData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        long stored = aCoverVariable.type.getTileEntityStoredEnergy(aTileEntity);
        long capacity = aCoverVariable.type.getTileEntityEnergyCapacity(aTileEntity);
        byte redstoneSignal = stored == 0L ? (byte)0 : (stored >= capacity ? (byte)15 : (byte)((byte)(1L + 14L * stored / capacity)));
        if (aCoverVariable.inverted) {
            redstoneSignal = (byte)(15 - redstoneSignal);
        }
        if (aCoverVariable.threshold > 0L) {
            if (aCoverVariable.inverted && stored >= aCoverVariable.threshold) {
                redstoneSignal = 0;
            } else if (!aCoverVariable.inverted && stored < aCoverVariable.threshold) {
                redstoneSignal = 0;
            }
        }
        aTileEntity.setOutputRedstoneSignal(side, redstoneSignal);
        return aCoverVariable;
    }

    @Override
    protected EUMeterData onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int num = (aCoverVariable.getNum() + (aPlayer.func_70093_af() ? -1 : 1) + EnergyType.values().length * 2) % (EnergyType.values().length * 2);
        switch (num) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("031", "Normal Universal Storage"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("032", "Inverted Universal Storage"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("033", "Normal Electricity Storage"));
                break;
            }
            case 3: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("034", "Inverted Electricity Storage"));
                break;
            }
            case 4: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("035", "Normal Steam Storage"));
                break;
            }
            case 5: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("036", "Inverted Steam Storage"));
                break;
            }
            case 6: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("037", "Normal Average Electric Input"));
                break;
            }
            case 7: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("038", "Inverted Average Electric Input"));
                break;
            }
            case 8: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("039", "Normal Average Electric Output"));
                break;
            }
            case 9: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("040", "Inverted Average Electric Output"));
                break;
            }
            case 10: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("041", "Normal Electricity Storage(Including Batteries)"));
                break;
            }
            case 11: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("042", "Inverted Electricity Storage(Including Batteries)"));
            }
        }
        aCoverVariable.setNum(num);
        return aCoverVariable;
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(ForgeDirection side, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    protected boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, EUMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, EUMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsInImpl(ForgeDirection side, int aCoverID, EUMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, EUMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(ForgeDirection side, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(ForgeDirection side, int aCoverID, EUMeterData aCoverVariable, ICoverable aTileEntity) {
        return 20;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new EUMeterUIFactory(buildContext).createWindow();
    }

    public static class EUMeterData
    implements ISerializableObject {
        private EnergyType type;
        private boolean inverted;
        private long threshold;

        public EUMeterData() {
            this.type = EnergyType.UNIVERSAL_STORAGE;
            this.inverted = false;
            this.threshold = 0L;
        }

        public EUMeterData(EnergyType type, boolean inverted, long threshold) {
            this.type = type;
            this.inverted = inverted;
            this.threshold = threshold;
        }

        public EUMeterData(int num, long threshold) {
            this();
            this.setNum(num);
            this.threshold = threshold;
        }

        public int getNum() {
            return this.type.ordinal() * 2 + (this.inverted ? 1 : 0);
        }

        public void setNum(int num) {
            this.type = EnergyType.getEnergyType(num / 2);
            this.inverted = num % 2 == 1;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new EUMeterData(this.type, this.inverted, this.threshold);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("typeOrdinal", this.type.ordinal());
            tag.func_74757_a("inverted", this.inverted);
            tag.func_74772_a("threshold", this.threshold);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeInt(this.type.ordinal());
            aBuf.writeBoolean(this.inverted);
            aBuf.writeLong(this.threshold);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            int typeOrdinal = tag.func_74762_e("typeOrdinal");
            this.type = EnergyType.getEnergyType(typeOrdinal);
            this.inverted = tag.func_74767_n("inverted");
            this.threshold = tag.func_74763_f("threshold");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, @Nullable EntityPlayerMP aPlayer) {
            int typeOrdinal = aBuf.readInt();
            this.type = EnergyType.getEnergyType(typeOrdinal);
            this.inverted = aBuf.readBoolean();
            this.threshold = aBuf.readLong();
            return this;
        }
    }

    private static enum EnergyType {
        UNIVERSAL_STORAGE(GTUtility.trans("301", "Universal"), GTUtility.trans("256", "Universal Storage"), IBasicEnergyContainer::getUniversalEnergyStored, IBasicEnergyContainer::getUniversalEnergyCapacity),
        ELECTRICITY_STORAGE(GTUtility.trans("302", "Int. EU"), GTUtility.trans("257", "Electricity Storage"), IBasicEnergyContainer::getStoredEU, IBasicEnergyContainer::getEUCapacity),
        STEAM_STORAGE(GTUtility.trans("303", "Steam"), GTUtility.trans("258", "Steam Storage"), IBasicEnergyContainer::getStoredSteam, IBasicEnergyContainer::getSteamCapacity),
        AVERAGE_ELECTRIC_INPUT(GTUtility.trans("304", "Avg. Input"), GTUtility.trans("259", "Average Electric Input"), IBasicEnergyContainer::getAverageElectricInput, te -> te.getInputVoltage() * te.getInputAmperage()),
        AVERAGE_ELECTRIC_OUTPUT(GTUtility.trans("305", "Avg. Output"), GTUtility.trans("260", "Average Electric Output"), IBasicEnergyContainer::getAverageElectricOutput, te -> te.getOutputVoltage() * te.getOutputAmperage()),
        ELECTRICITY_STORAGE_INCLUDING_BATTERIES(GTUtility.trans("306", "EU stored"), GTUtility.trans("261", "Electricity Storage(Including Batteries)"), te -> {
            IMetaTileEntity mte;
            if (te instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof MTEBasicBatteryBuffer) {
                MTEBasicBatteryBuffer buffer = (MTEBasicBatteryBuffer)mte;
                return buffer.getStoredEnergy()[0];
            }
            return te.getStoredEU();
        }, te -> {
            IMetaTileEntity mte;
            if (te instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) instanceof MTEBasicBatteryBuffer) {
                MTEBasicBatteryBuffer buffer = (MTEBasicBatteryBuffer)mte;
                return buffer.getStoredEnergy()[1];
            }
            return te.getEUCapacity();
        });

        private final String title;
        private final String tooltip;
        private final Function<ICoverable, Long> getTileEntityStoredEnergyFunc;
        private final Function<ICoverable, Long> getTileEntityEnergyCapacityFunc;

        private EnergyType(String title, String tooltip, Function<ICoverable, Long> getTileEntityStoredEnergyFunc, Function<ICoverable, Long> getTileEntityEnergyCapacityFunc) {
            this.title = title;
            this.tooltip = tooltip;
            this.getTileEntityStoredEnergyFunc = getTileEntityStoredEnergyFunc;
            this.getTileEntityEnergyCapacityFunc = getTileEntityEnergyCapacityFunc;
        }

        public String getTitle() {
            return this.title;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public long getTileEntityStoredEnergy(ICoverable aTileEntity) {
            return this.getTileEntityStoredEnergyFunc.apply(aTileEntity);
        }

        public long getTileEntityEnergyCapacity(ICoverable aTileEntity) {
            return this.getTileEntityEnergyCapacityFunc.apply(aTileEntity);
        }

        public EnergyType getNext() {
            return EnergyType.values()[(this.ordinal() + 1) % EnergyType.values().length];
        }

        public static EnergyType getEnergyType(int ordinal) {
            if (ordinal < 0 || EnergyType.values().length <= ordinal) {
                ordinal = 0;
            }
            return EnergyType.values()[ordinal];
        }
    }

    private class EUMeterUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public EUMeterUIFactory(CoverUIBuildContext buildContext) {
            super(buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            String INVERTED = GTUtility.trans("INVERTED", "Inverted");
            String NORMAL = GTUtility.trans("NORMAL", "Normal");
            CoverDataFollowerNumericWidget numericWidget = new CoverDataFollowerNumericWidget();
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(((CoverDataControllerWidget)((CoverDataControllerWidget)new CoverDataControllerWidget<EUMeterData>(this::getCoverData, this::setCoverData, CoverEUMeter.this).addFollower((Widget)new CoverDataFollowerCycleButtonWidget(), coverData -> ((EUMeterData)coverData).type.ordinal(), (coverData, state) -> {
                ((EUMeterData)coverData).type = EnergyType.getEnergyType(state);
                return coverData;
            }, widget -> widget.setLength(EnergyType.values().length).addTooltip(state -> EnergyType.getEnergyType(state).getTooltip()).setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_CYCLIC).setPos(0, 0))).addFollower((Widget)CoverDataFollowerToggleButtonWidget.ofRedstone(), coverData -> ((EUMeterData)coverData).inverted, (coverData, state) -> {
                ((EUMeterData)coverData).inverted = state;
                return coverData;
            }, widget -> widget.addTooltip(0, NORMAL).addTooltip(1, INVERTED).setPos(0, 18))).addFollower((Widget)numericWidget, coverData -> ((EUMeterData)coverData).threshold, (coverData, state) -> {
                ((EUMeterData)coverData).threshold = state.longValue();
                return coverData;
            }, widget -> widget.setScrollValues(1000.0, 100.0, 100000.0).setFocusOnGuiOpen(true).setPos(0, 38).setSize(144, 12)).setPos(10, 25))).widget(new TextWidget().setStringSupplier(() -> this.getCoverData() != null ? ((EUMeterData)this.getCoverData()).type.getTitle() : "").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 29))).widget(new TextWidget().setStringSupplier(() -> this.getCoverData() != null ? (((EUMeterData)this.getCoverData()).inverted ? INVERTED : NORMAL) : "").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(28, 47))).widget(new TextWidget(GTUtility.trans("222.1", "Energy threshold")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(10, 83))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.getCoverData() != null ? ((EUMeterData)this.getCoverData()).type.getTileEntityEnergyCapacity(this.getUIBuildContext().getTile()) : Long.MAX_VALUE, value -> numericWidget.setMaxValue(value.longValue())));
        }
    }
}

