/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.metadata.CompressionTierKey;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gregtech.common.tileentities.machines.IDualInputInventory;
import gregtech.common.tileentities.machines.MTEHatchCraftingInputME;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchSolidifier;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEIndustrialMultiMachine
extends GTPPMultiBlockBase<MTEIndustrialMultiMachine>
implements ISurvivalConstructable {
    private static final int MACHINEMODE_METAL = 0;
    private static final int MACHINEMODE_FLUID = 1;
    private static final int MACHINEMODE_MISC = 2;
    private static final int MODE_COMPRESSOR = 0;
    private static final int MODE_LATHE = 1;
    private static final int MODE_MAGNETIC = 2;
    private static final int MODE_FERMENTER = 3;
    private static final int MODE_FLUIDEXTRACT = 4;
    private static final int MODE_EXTRACTOR = 5;
    private static final int MODE_LASER = 6;
    private static final int MODE_AUTOCLAVE = 7;
    private static final int MODE_FLUIDSOLIDIFY = 8;
    private static final int[][] MODE_MAP = new int[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8}};
    public static final String[] aToolTipNames = new String[9];
    private int mCasing;
    private static IStructureDefinition<MTEIndustrialMultiMachine> STRUCTURE_DEFINITION = null;

    public MTEIndustrialMultiMachine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialMultiMachine(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialMultiMachine(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Nine in One";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        String[] aBuiltStrings = new String[]{aToolTipNames[0] + ", " + aToolTipNames[1] + ", " + aToolTipNames[2], aToolTipNames[3] + ", " + aToolTipNames[4] + ", " + aToolTipNames[5], aToolTipNames[6] + ", " + aToolTipNames[7] + ", " + aToolTipNames[8]};
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo(EnumChatFormatting.RED + "DEPRECATED! This machine will be removed in the next major update.").addInfo(EnumChatFormatting.RED + "A variety of multiblocks have been added to replace these machines!").addInfo("250% faster than using single block machines of the same voltage").addInfo("Only uses 80% of the EU/t normally required").addInfo("Processes two items per voltage tier").addInfo("Machine Type: Metal - " + EnumChatFormatting.YELLOW + aBuiltStrings[0] + EnumChatFormatting.RESET).addInfo("Machine Type: Fluid - " + EnumChatFormatting.YELLOW + aBuiltStrings[1] + EnumChatFormatting.RESET).addInfo("Machine Type: Misc - " + EnumChatFormatting.YELLOW + aBuiltStrings[2] + EnumChatFormatting.RESET).addInfo("Read Multi-Machine Manual for extra information").addInfo(EnumChatFormatting.AQUA + "You can use Solidifier Hatch to solidify multiple liquids." + EnumChatFormatting.RESET).addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoMin("Multi-Use Casings", 6, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialMultiMachine> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTEIndustrialMultiMachine.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler, HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(this.getTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)2)))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 6 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialMultiMachineActive;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialMultiMachine;
    }

    @Override
    protected int getCasingTextureId() {
        return this.getTextureIndex();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * GTUtility.getTier(this.getMaxInputVoltage());
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        switch (this.machineMode) {
            case 0: {
                return PollutionConfig.pollutionPerSecondMultiIndustrialMultiMachine_ModeMetal;
            }
            case 1: {
                return PollutionConfig.pollutionPerSecondMultiIndustrialMultiMachine_ModeFluid;
            }
        }
        return PollutionConfig.pollutionPerSecondMultiIndustrialMultiMachine_ModeMisc;
    }

    public int getTextureIndex() {
        return TAE.getIndexFromPage(2, 2);
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private ItemStack getCircuit(ItemStack[] t) {
        for (ItemStack j : t) {
            if (j.func_77973_b() != GTUtility.getIntegratedCircuit(0).func_77973_b() || j.func_77960_j() < 20 || j.func_77960_j() > 22) continue;
            return j;
        }
        return null;
    }

    private int getCircuitID(ItemStack circuit) {
        int H = circuit.func_77960_j();
        int T = H == 20 ? 0 : (H == 21 ? 1 : (H == 22 ? 2 : -1));
        return MODE_MAP[this.machineMode][T];
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return null;
    }

    @Override
    @Nonnull
    public Collection<RecipeMap<?>> getAvailableRecipeMaps() {
        return Arrays.asList(RecipeMaps.compressorRecipes, RecipeMaps.latheRecipes, RecipeMaps.polarizerRecipes, RecipeMaps.fermentingRecipes, RecipeMaps.fluidExtractionRecipes, RecipeMaps.extractorRecipes, RecipeMaps.laserEngraverRecipes, RecipeMaps.autoclaveRecipes, RecipeMaps.fluidSolidifierRecipes);
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -10;
    }

    private static RecipeMap<?> getRecipeMap(int aMode) {
        if (aMode == 0) {
            return RecipeMaps.compressorRecipes;
        }
        if (aMode == 1) {
            return RecipeMaps.latheRecipes;
        }
        if (aMode == 2) {
            return RecipeMaps.polarizerRecipes;
        }
        if (aMode == 3) {
            return RecipeMaps.fermentingRecipes;
        }
        if (aMode == 4) {
            return RecipeMaps.fluidExtractionRecipes;
        }
        if (aMode == 5) {
            return RecipeMaps.extractorRecipes;
        }
        if (aMode == 6) {
            return RecipeMaps.laserEngraverRecipes;
        }
        if (aMode == 7) {
            return RecipeMaps.autoclaveRecipes;
        }
        if (aMode == 8) {
            return RecipeMaps.fluidSolidifierRecipes;
        }
        return null;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)((ProcessingLogic)new ProcessingLogic(){
            private ItemStack lastCircuit = null;
            private int lastMode = -1;

            @Override
            @Nonnull
            protected Stream<GTRecipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                RecipeMap foundMap;
                ItemStack circuit = MTEIndustrialMultiMachine.this.getCircuit(this.inputItems);
                if (circuit == null) {
                    return Stream.empty();
                }
                if (!GTUtility.areStacksEqual(circuit, this.lastCircuit)) {
                    this.lastRecipe = null;
                    this.lastCircuit = circuit;
                }
                if (MTEIndustrialMultiMachine.this.machineMode != this.lastMode) {
                    this.lastRecipe = null;
                    this.lastMode = MTEIndustrialMultiMachine.this.machineMode;
                }
                if ((foundMap = MTEIndustrialMultiMachine.getRecipeMap(MTEIndustrialMultiMachine.this.getCircuitID(circuit))) == null) {
                    return Stream.empty();
                }
                return super.findRecipeMatches(foundMap);
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (recipe.getMetadataOrDefault(CompressionTierKey.INSTANCE, 0) > 0) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                return super.validateRecipe(recipe);
            }
        }.setSpeedBonus(0.2857142984867096)).setEuModifier(0.8f)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public String getMachineModeName() {
        return StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_INDUSTRIAL_MULTI_MACHINE.mode." + this.machineMode));
    }

    @Override
    public String[] getInfoData() {
        String mode;
        String[] data = super.getInfoData();
        ArrayList<String> mInfo = new ArrayList<String>(Arrays.asList(data));
        switch (this.machineMode) {
            case 0: {
                mode = StatCollector.func_74838_a((String)"GTPP.multiblock.multimachine.metal");
                break;
            }
            case 1: {
                mode = StatCollector.func_74838_a((String)"GTPP.multiblock.multimachine.fluid");
                break;
            }
            default: {
                mode = StatCollector.func_74838_a((String)"GTPP.multiblock.multimachine.misc");
            }
        }
        mInfo.add(mode);
        return mInfo.toArray(new String[0]);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mInternalMode")) {
            this.machineMode = aNBT.func_74762_e("mInternalMode");
        }
        super.loadNBTData(aNBT);
    }

    @Override
    public boolean isInputSeparationEnabled() {
        return true;
    }

    @Override
    protected CheckRecipeResult doCheckRecipe() {
        if (this.machineMode != 2 || !this.isInputSeparationEnabled()) {
            return super.doCheckRecipe();
        }
        CheckRecipeResult result = CheckRecipeResultRegistry.NO_RECIPE;
        if (this.supportsCraftingMEBuffer()) {
            for (IDualInputHatch dualInputHatch : this.mDualInputHatches) {
                Iterator<? extends IDualInputInventory> it = dualInputHatch.inventories();
                while (it.hasNext()) {
                    IDualInputInventory slot = it.next();
                    this.processingLogic.setInputItems(slot.getItemInputs());
                    this.processingLogic.setInputFluids(slot.getFluidInputs());
                    CheckRecipeResult foundResult = this.processingLogic.process();
                    if (foundResult.wasSuccessful()) {
                        return foundResult;
                    }
                    if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
                    result = foundResult;
                }
            }
        }
        for (MTEHatchInput solidifierHatch : this.mInputHatches) {
            if (!(solidifierHatch instanceof MTEHatchSolidifier)) continue;
            ItemStack mold = ((MTEHatchSolidifier)solidifierHatch).getMold();
            FluidStack fluid = solidifierHatch.getFluid();
            if (mold == null || fluid == null) continue;
            ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
            inputItems.add(mold);
            inputItems.add(GTUtility.getIntegratedCircuit(22));
            this.processingLogic.setInputItems(inputItems.toArray(new ItemStack[0]));
            this.processingLogic.setInputFluids(fluid);
            CheckRecipeResult foundResult = this.processingLogic.process();
            if (foundResult.wasSuccessful()) {
                return foundResult;
            }
            if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
            result = foundResult;
        }
        this.processingLogic.clear();
        this.processingLogic.setInputFluids(this.getStoredFluids());
        for (MTEHatchInputBus bus : this.mInputBusses) {
            if (bus instanceof MTEHatchCraftingInputME) continue;
            ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
            for (int i = bus.func_70302_i_() - 1; i >= 0; --i) {
                ItemStack stored = bus.func_70301_a(i);
                if (stored == null) continue;
                inputItems.add(stored);
            }
            if (this.canUseControllerSlotForRecipe() && this.getControllerSlot() != null) {
                inputItems.add(this.getControllerSlot());
            }
            this.processingLogic.setInputItems(inputItems.toArray(new ItemStack[0]));
            CheckRecipeResult foundResult = this.processingLogic.process();
            if (foundResult.wasSuccessful()) {
                return foundResult;
            }
            if (foundResult == CheckRecipeResultRegistry.NO_RECIPE) continue;
            result = foundResult;
        }
        return result;
    }

    @Override
    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (MTEHatchInput tHatch : GTUtility.validMTEList(this.mInputHatches)) {
            if (tHatch instanceof MTEHatchSolidifier) continue;
            this.setHatchRecipeMap(tHatch);
            if (tHatch instanceof MTEHatchMultiInput) {
                for (FluidStack tFluid : ((MTEHatchMultiInput)tHatch).getStoredFluid()) {
                    if (tFluid == null) continue;
                    rList.add(tFluid);
                }
                continue;
            }
            if (tHatch instanceof MTEHatchInputME) {
                if (!tHatch.isValid()) continue;
                for (FluidStack fluidStack : ((MTEHatchInputME)tHatch).getStoredFluids()) {
                    if (fluidStack == null) continue;
                    rList.add(fluidStack);
                }
                continue;
            }
            if (tHatch.getFillableStack() == null) continue;
            rList.add(tHatch.getFillableStack());
        }
        return rList;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("mode", this.machineMode);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("mode")) {
            currentTip.add(StatCollector.func_74838_a((String)"GT5U.machines.oreprocessor1") + " " + EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)("GT5U.GTPP_MULTI_INDUSTRIAL_MULTI_MACHINE.mode." + tag.func_74762_e("mode"))) + EnumChatFormatting.RESET);
        }
    }

    @Override
    public boolean supportsMachineModeSwitch() {
        return true;
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.setMachineMode(this.nextMachineMode());
        PlayerUtils.messagePlayer(aPlayer, String.format(StatCollector.func_74838_a((String)"GT5U.MULTI_MACHINE_CHANGE"), this.getMachineModeName()));
    }

    @Override
    public int nextMachineMode() {
        this.mLastRecipe = null;
        if (this.machineMode == 0) {
            return 1;
        }
        if (this.machineMode == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public void setMachineModeIcons() {
        this.machineModeIcons.clear();
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_METAL);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_LPF_FLUID);
        this.machineModeIcons.add(GTUITextures.OVERLAY_BUTTON_MACHINEMODE_DEFAULT);
    }

    static {
        for (int id = 0; id < 9; ++id) {
            RecipeMap<?> recipeMap = MTEIndustrialMultiMachine.getRecipeMap(id);
            if (recipeMap == null) continue;
            String aNEI = GTLanguageManager.getTranslation(MTEIndustrialMultiMachine.getRecipeMap((int)id).unlocalizedName);
            MTEIndustrialMultiMachine.aToolTipNames[id] = aNEI != null ? aNEI : "BAD NEI NAME (Report to Github)";
        }
    }
}

