/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.network.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.network.handler.AbstractServerMessageHandler;
import gtPlusPlus.core.network.packet.AbstractPacket;
import gtPlusPlus.core.tileentities.general.TileEntityVolumetricFlaskSetter;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketVolumetricFlaskGui
extends AbstractServerMessageHandler<PacketVolumetricFlaskGui>
implements AbstractPacket {
    private int x;
    private int y;
    private int z;
    private int flaskValue;

    public PacketVolumetricFlaskGui() {
    }

    public PacketVolumetricFlaskGui(TileEntityVolumetricFlaskSetter tile, int aCustomValue) {
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        this.flaskValue = aCustomValue;
        Logger.INFO("Created Packet with values (" + this.x + ", " + this.y + ", " + this.z + " | " + this.flaskValue + ")");
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.flaskValue);
        Logger.INFO("Writing to byte buffer.");
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.flaskValue = buf.readInt();
        Logger.INFO("Reading from byte buffer.");
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getCustomValue() {
        return this.flaskValue;
    }

    public void setCustomValue(int aVal) {
        this.flaskValue = aVal;
    }

    protected TileEntityVolumetricFlaskSetter getTileEntity(PacketVolumetricFlaskGui message, MessageContext ctx) {
        Logger.INFO("Trying to get tile.");
        World worldObj = this.getWorld(ctx);
        if (worldObj == null) {
            Logger.INFO("Bad world object.");
            return null;
        }
        TileEntity te = worldObj.func_147438_o(message.getX(), message.getY(), message.getZ());
        if (te == null) {
            Logger.INFO("Bad Tile.");
            return null;
        }
        if (te instanceof TileEntityVolumetricFlaskSetter) {
            Logger.INFO("Found Tile.");
            return (TileEntityVolumetricFlaskSetter)te;
        }
        Logger.INFO("Error.");
        return null;
    }

    protected World getWorld(MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            return ctx.getServerHandler().field_147369_b.field_70170_p;
        }
        return GTplusplus.proxy.getClientWorld();
    }

    @Override
    public IMessage handleServerMessage(EntityPlayer player, PacketVolumetricFlaskGui message, MessageContext ctx) {
        TileEntityVolumetricFlaskSetter te = this.getTileEntity(message, ctx);
        if (te != null) {
            Logger.INFO("Setting value on tile. " + message.getCustomValue());
            te.setCustomValue(message.getCustomValue());
        }
        return null;
    }

    @Override
    public String getPacketName() {
        return "Packet_VoluemtricFlaskSetter_ToServer";
    }
}

