/*
 * Decompiled with CFR 0.152.
 */
package bartworks.util;

import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.util.GTUtility;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class ResultWrongSievert
implements CheckRecipeResult {
    private NeededSievertType type;
    private int required;

    public ResultWrongSievert(int required, NeededSievertType type) {
        this.required = required;
        this.type = type;
    }

    @Override
    @NotNull
    public String getID() {
        return "wrong_sievert";
    }

    @Override
    public boolean wasSuccessful() {
        return false;
    }

    @Override
    @NotNull
    public String getDisplayString() {
        String string;
        switch (this.type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EXACTLY: {
                string = StatCollector.func_74837_a((String)"GT5U.gui.text.wrong_sievert_exactly", (Object[])new Object[]{GTUtility.formatNumbers(this.required)});
                break;
            }
            case MINIMUM: {
                string = StatCollector.func_74837_a((String)"GT5U.gui.text.wrong_sievert_min", (Object[])new Object[]{GTUtility.formatNumbers(this.required)});
            }
        }
        return string;
    }

    @Override
    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound tag) {
        tag.func_74768_a("required", this.required);
        tag.func_74768_a("type", this.type.ordinal());
        return tag;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tag) {
        this.required = tag.func_74762_e("required");
    }

    @Override
    @NotNull
    public CheckRecipeResult newInstance() {
        return new ResultWrongSievert(0, NeededSievertType.EXACTLY);
    }

    @Override
    public void encode(@NotNull PacketBuffer buffer) {
        buffer.func_150787_b(this.required);
        buffer.func_150787_b(this.type.ordinal());
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.required = buffer.func_150792_a();
        this.type = NeededSievertType.values()[buffer.func_150792_a()];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultWrongSievert that = (ResultWrongSievert)o;
        return this.required == that.required;
    }

    public static CheckRecipeResult insufficientSievert(int required) {
        return new ResultWrongSievert(required, NeededSievertType.MINIMUM);
    }

    public static CheckRecipeResult wrongSievert(int required) {
        return new ResultWrongSievert(required, NeededSievertType.EXACTLY);
    }

    public static enum NeededSievertType {
        EXACTLY,
        MINIMUM;

    }
}

