/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.mechanics.dataTransport.QuantumDataPacket;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataInput;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataOutput;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class MTENetworkSwitch
extends TTMultiblockBase
implements IConstructable {
    private static final String[] description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.hint.1")};
    private static final IStructureDefinition<MTENetworkSwitch> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"BBB", "BAB", "BBB"}, {"B~B", "AAA", "BAB"}, {"BBB", "BAB", "BBB"}})).addElement('A', GTStructureUtility.buildHatchAdder(MTENetworkSwitch.class).atLeast(HatchElement.Energy.or(TTMultiblockBase.HatchElement.EnergyMulti), HatchElement.Maintenance, TTMultiblockBase.HatchElement.InputData, TTMultiblockBase.HatchElement.OutputData).casingIndex(1027).dot(1).buildAndChain(StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)3))).addElement('B', GTStructureUtility.buildHatchAdder(MTENetworkSwitch.class).atLeast(HatchElement.Energy.or(TTMultiblockBase.HatchElement.EnergyMulti), HatchElement.Maintenance, TTMultiblockBase.HatchElement.OutputData).casingIndex(1025).dot(2).buildAndChain(StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)1))).build();
    private static final INameFunction<MTENetworkSwitch> ROUTE_NAME = (base, p) -> (p.parameterId() == 0 ? StatCollector.func_74838_a((String)"tt.keyword.Destination") + " " : StatCollector.func_74838_a((String)"tt.keyword.Weight") + " ") + p.hatchId();
    private static final IStatusFunction<MTENetworkSwitch> WEI_STATUS = (base, p) -> {
        double v = p.get();
        if (Double.isNaN(v)) {
            return LedStatus.STATUS_WRONG;
        }
        if (v < 0.0) {
            return LedStatus.STATUS_TOO_LOW;
        }
        if (v == 0.0) {
            return LedStatus.STATUS_LOW;
        }
        if (Double.isInfinite(v)) {
            return LedStatus.STATUS_HIGH;
        }
        return LedStatus.STATUS_OK;
    };
    private static final IStatusFunction<MTENetworkSwitch> DST_STATUS = (base, p) -> {
        if (base.weight[p.hatchId()].getStatus((boolean)false).isOk) {
            double v = p.get();
            if (Double.isNaN(v)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((v = (double)((int)v)) <= 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            return LedStatus.STATUS_OK;
        }
        return LedStatus.STATUS_NEUTRAL;
    };
    protected Parameters.Group.ParameterIn[] dst;
    protected Parameters.Group.ParameterIn[] weight;

    public MTENetworkSwitch(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTENetworkSwitch(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENetworkSwitch(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        return this.structureCheck_EM("main", 1, 1, 0);
    }

    @Override
    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        int thingsActive = 0;
        for (MTEHatchDataInput di : this.eInputData) {
            if (di.q == null) continue;
            thingsActive = (short)(thingsActive + 1);
        }
        if (thingsActive > 0) {
            thingsActive = (short)(thingsActive + this.eOutputData.size());
            this.mEUt = -((int)GTValues.V[7]);
            this.eAmpereFlow = 1 + (thingsActive >> 2);
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            return SimpleCheckRecipeResult.ofSuccess("routing");
        }
        return SimpleCheckRecipeResult.ofFailure("no_routing");
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (!this.eOutputData.isEmpty()) {
            double weight;
            double total = 0.0;
            for (int i = 0; i < 10; ++i) {
                weight = this.weight[i].get();
                if (!(weight > 0.0) || !(this.dst[i].get() >= 0.0)) continue;
                total += weight;
            }
            Vec3Impl pos = new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
            QuantumDataPacket pack = new QuantumDataPacket(0L).unifyTraceWith(pos);
            if (pack == null) {
                return;
            }
            for (MTEHatchDataInput hatch : this.eInputData) {
                if (hatch.q == null || ((QuantumDataPacket)hatch.q).contains(pos) || (pack = pack.unifyPacketWith((QuantumDataPacket)hatch.q)) != null) continue;
                return;
            }
            long remaining = (Long)pack.getContent();
            for (int i = 0; i < 10; ++i) {
                int outIndex;
                double dest = this.dst[i].get();
                weight = this.weight[i].get();
                if (!(weight > 0.0) || !(dest >= 0.0) || (outIndex = (int)dest - 1) < 0 || outIndex >= this.eOutputData.size()) continue;
                MTEHatchDataOutput out = (MTEHatchDataOutput)this.eOutputData.get(outIndex);
                if (Double.isInfinite(total)) {
                    if (!Double.isInfinite(weight)) continue;
                    out.q = new QuantumDataPacket(remaining).unifyTraceWith(pack);
                    break;
                }
                long part = (long)Math.floor((double)((Long)pack.getContent()).longValue() * weight / total);
                if (part <= 0L) continue;
                if ((remaining -= part) > 0L) {
                    out.q = new QuantumDataPacket(part).unifyTraceWith(pack);
                    continue;
                }
                if (part + remaining <= 0L) break;
                out.q = new QuantumDataPacket(part + remaining).unifyTraceWith(pack);
                break;
            }
        }
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.name")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.desc.0")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.switch.desc.1")).addTecTechHatchInfo().beginStructureBlock(3, 3, 3, false).addController(StatCollector.func_74838_a((String)"tt.keyword.Structure.FrontCenter")).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.DataInput"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyAdvComputerCasing"), 1).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.DataOutput"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasing"), 2).addEnergyHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasing"), 2).addMaintenanceHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasing"), 2).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][1], new TTRenderedExtendedFacingTexture(aActive ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][1]};
    }

    @Override
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.TECTECH_MACHINES_FX_HIGH_FREQ;
    }

    @Override
    protected void parametersInstantiation_EM() {
        this.dst = new Parameters.Group.ParameterIn[10];
        this.weight = new Parameters.Group.ParameterIn[10];
        for (int i = 0; i < 10; ++i) {
            Parameters.Group hatch = this.parametrization.getGroup(i);
            this.dst[i] = hatch.makeInParameter(0, i, ROUTE_NAME, DST_STATUS);
            this.weight[i] = hatch.makeInParameter(1, 0.0, ROUTE_NAME, WEI_STATUS);
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM("main", 1, 1, 0, stackSize, hintsOnly);
    }

    public IStructureDefinition<MTENetworkSwitch> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }
}

