/*
 * Decompiled with CFR 0.152.
 */
package tectech.mechanics.spark;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import gregtech.api.enums.Mods;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import tectech.mechanics.spark.ThaumSpark;
import thaumcraft.client.fx.bolt.FXLightningBolt;

public class RendererMessage
implements IMessage {
    Set<ThaumSpark> sparkList;

    public void fromBytes(ByteBuf buffer) {
        this.sparkList = new HashSet<ThaumSpark>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.sparkList.add(new ThaumSpark(buffer));
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.sparkList.size());
        for (ThaumSpark spark : this.sparkList) {
            spark.writeToBuf(buffer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void thaumLightning(ThaumSpark spark) {
        if (Mods.Thaumcraft.isModLoaded()) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world.field_73011_w.field_76574_g == spark.wID) {
                FXLightningBolt bolt = new FXLightningBolt((World)world, (double)((float)spark.x + 0.5f), (double)((float)spark.y + 0.5f), (double)((float)spark.z + 0.5f), (double)((float)(spark.x + spark.xR) + 0.5f), (double)((float)(spark.y + spark.yR) + 0.5f), (double)((float)(spark.z + spark.zR) + 0.5f), world.field_73012_v.nextLong(), 10, 0.5f, 8);
                bolt.defaultFractal();
                bolt.setType(2);
                bolt.setWidth(0.125f);
                bolt.finalizeBolt();
            }
        }
    }

    public static class ClientHandler
    extends AbstractClientMessageHandler<RendererData> {
        public IMessage handleClientMessage(EntityPlayer pPlayer, RendererData pMessage, MessageContext pCtx) {
            int i;
            Random localRand = Minecraft.func_71410_x().field_71441_e.field_73012_v;
            int[] zapsToUse = new int[4];
            for (i = 0; i < 3; ++i) {
                zapsToUse[i] = localRand.nextInt(pMessage.sparkList.size());
            }
            i = 0;
            for (ThaumSpark spark : pMessage.sparkList) {
                for (int j : zapsToUse) {
                    if (i != j) continue;
                    RendererMessage.thaumLightning(spark);
                }
                ++i;
            }
            return null;
        }
    }

    public static class RendererData
    extends RendererMessage {
        public RendererData() {
        }

        public RendererData(Set<ThaumSpark> eSparkList) {
            this.sparkList = eSparkList;
        }
    }
}

