/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.eig;

import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kubatech.api.eig.EIGBucket;
import kubatech.api.eig.IEIGBucketFactory;
import kubatech.kubatech;
import kubatech.tileentity.gregtech.multiblock.MTEExtremeIndustrialGreenhouse;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class EIGMode {
    private final HashMap<String, IEIGBucketFactory> factories = new HashMap();
    private final LinkedList<IEIGBucketFactory> orderedFactories = new LinkedList();

    public abstract int getUIIndex();

    public abstract String getName();

    public abstract int getMinVoltageTier();

    public abstract int getMinGlassTier();

    public abstract int getStartingSlotCount();

    public abstract int getSlotPerTierMultiplier();

    public abstract int getSlotCount(int var1);

    public abstract int getSeedCapacityPerSlot();

    public abstract int getWeedEXMultiplier();

    public abstract int getMaxFertilizerUsagePerSeed();

    public abstract double getFertilizerBoost();

    public abstract MultiblockTooltipBuilder addTooltipInfo(MultiblockTooltipBuilder var1);

    public void addLowPriorityFactory(IEIGBucketFactory factory) {
        String factoryId = factory.getNBTIdentifier();
        this.dealWithDuplicateFactoryId(factoryId);
        this.factories.put(factoryId, factory);
        this.orderedFactories.addLast(factory);
    }

    public void addHighPriorityFactory(IEIGBucketFactory factory) {
        String factoryId = factory.getNBTIdentifier();
        this.dealWithDuplicateFactoryId(factoryId);
        this.factories.put(factoryId, factory);
        this.orderedFactories.addFirst(factory);
    }

    private void dealWithDuplicateFactoryId(String factoryId) {
        if (this.factories.containsKey(factoryId)) {
            kubatech.error("Duplicate EIG bucket index detected!!!: " + factoryId);
            this.orderedFactories.remove(this.factories.get(factoryId));
        }
    }

    public EIGBucket tryCreateNewBucket(MTEExtremeIndustrialGreenhouse greenhouse, ItemStack input, int maxConsume, boolean simulate) {
        if (input == null) {
            return null;
        }
        if ((maxConsume = Math.min(input.field_77994_a, maxConsume)) <= 0) {
            return null;
        }
        for (IEIGBucketFactory factory : this.orderedFactories) {
            EIGBucket bucket = factory.tryCreateBucket(greenhouse, input);
            if (bucket == null || !bucket.isValid()) continue;
            if (!simulate) {
                --input.field_77994_a;
            }
            bucket.tryAddSeed(greenhouse, input, --maxConsume, simulate);
            return bucket;
        }
        return null;
    }

    public void restoreBuckets(NBTTagList bucketNBTList, List<EIGBucket> loadTo) {
        for (int i = 0; i < bucketNBTList.func_74745_c(); ++i) {
            NBTTagCompound bucketNBT = bucketNBTList.func_150305_b(i);
            if (bucketNBT.func_82582_d()) {
                kubatech.error("Empty nbt bucket found in EIG nbt.");
                continue;
            }
            if (!bucketNBT.func_150297_b("type", 8)) {
                kubatech.error("Failed to identify bucket type in EIG nbt.");
                continue;
            }
            String bucketType = bucketNBT.func_74779_i("type");
            IEIGBucketFactory factory = this.factories.getOrDefault(bucketType, null);
            if (factory == null) {
                kubatech.error("failed to find EIG bucket factory for type: " + bucketType);
                continue;
            }
            loadTo.add(factory.restore(bucketNBT));
        }
    }
}

