/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IPipeRenderedTileEntity;
import gregtech.api.interfaces.tileentity.ITexturedTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.common.blocks.BlockMachines;
import gregtech.common.render.GTRendererBlock;
import gtPlusPlus.xmod.gregtech.common.helpers.GTMethodHelper;
import java.util.EnumMap;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class MachineBlockRenderer
extends GTRendererBlock {
    public static MachineBlockRenderer INSTANCE;
    public final int mRenderID = RenderingRegistry.getNextAvailableRenderId();

    public MachineBlockRenderer() {
        INSTANCE = this;
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this);
    }

    private static ITexture[] getTexture(IMetaTileEntity tile, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean arg5) {
        IGregTechTileEntity gtTile = tile.getBaseMetaTileEntity();
        return tile.getTexture(gtTile, side, facing, (byte)colorIndex, active, arg5);
    }

    private static ITexture[] getTexture(IMetaTileEntity tile, ForgeDirection side, int facingMask, int colorIndex, boolean active, boolean arg5) {
        MetaPipeEntity gtTile = (MetaPipeEntity)((Object)tile.getBaseMetaTileEntity());
        return gtTile.getTexture((IGregTechTileEntity)((Object)tile), side, facingMask, colorIndex, active, arg5);
    }

    private static void renderNormalInventoryMetaTileEntity(Block aBlock, int aMeta, RenderBlocks aRenderer) {
        IMetaTileEntity tMetaTileEntity;
        if (aMeta > 0 && aMeta < GregTechAPI.METATILEENTITIES.length && (tMetaTileEntity = GregTechAPI.METATILEENTITIES[aMeta]) != null) {
            aBlock.func_149683_g();
            aRenderer.func_147775_a(aBlock);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            IGregTechTileEntity iGregTechTileEntity = tMetaTileEntity.getBaseMetaTileEntity();
            if (iGregTechTileEntity instanceof IPipeRenderedTileEntity) {
                IPipeRenderedTileEntity pipeRenderedTile = (IPipeRenderedTileEntity)((Object)iGregTechTileEntity);
                float tThickness = pipeRenderedTile.getThickNess();
                float sp = (1.0f - tThickness) / 2.0f;
                aBlock.func_149676_a(0.0f, sp, sp, 1.0f, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
                MachineBlockRenderer.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.DOWN, 9, -1, false, false), true);
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
                MachineBlockRenderer.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.UP, 9, -1, false, false), true);
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
                MachineBlockRenderer.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.NORTH, 9, -1, false, false), true);
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
                MachineBlockRenderer.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.SOUTH, 9, -1, false, false), true);
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
                MachineBlockRenderer.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.WEST, 9, -1, true, false), true);
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
                MachineBlockRenderer.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.EAST, 9, -1, true, false), true);
                Tessellator.field_78398_a.func_78381_a();
            } else {
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
                MachineBlockRenderer.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.DOWN, ForgeDirection.WEST, -1, true, false), true);
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
                MachineBlockRenderer.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.UP, ForgeDirection.WEST, -1, true, false), true);
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
                MachineBlockRenderer.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.NORTH, ForgeDirection.WEST, -1, true, false), true);
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
                MachineBlockRenderer.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.SOUTH, ForgeDirection.WEST, -1, true, false), true);
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
                MachineBlockRenderer.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.WEST, ForgeDirection.WEST, -1, true, false), true);
                Tessellator.field_78398_a.func_78381_a();
                Tessellator.field_78398_a.func_78382_b();
                Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
                MachineBlockRenderer.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, MachineBlockRenderer.getTexture(tMetaTileEntity, ForgeDirection.EAST, ForgeDirection.WEST, -1, true, false), true);
                Tessellator.field_78398_a.func_78381_a();
            }
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    @Override
    public boolean renderStandardBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return tTileEntity instanceof ITexturedTileEntity && this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, new ITexture[][]{GTMethodHelper.getTexture(tTileEntity, aBlock, ForgeDirection.DOWN), GTMethodHelper.getTexture(tTileEntity, aBlock, ForgeDirection.UP), GTMethodHelper.getTexture(tTileEntity, aBlock, ForgeDirection.NORTH), GTMethodHelper.getTexture(tTileEntity, aBlock, ForgeDirection.SOUTH), GTMethodHelper.getTexture(tTileEntity, aBlock, ForgeDirection.WEST), GTMethodHelper.getTexture(tTileEntity, aBlock, ForgeDirection.EAST)});
    }

    @Override
    public boolean renderStandardBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer, ITexture[][] aTextures) {
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.DOWN.ordinal()], true);
        MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.UP.ordinal()], true);
        MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.NORTH.ordinal()], true);
        MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.SOUTH.ordinal()], true);
        MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.WEST.ordinal()], true);
        MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.EAST.ordinal()], true);
        return true;
    }

    @Override
    public boolean renderPipeBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, IPipeRenderedTileEntity aTileEntity, RenderBlocks aRenderer) {
        byte aConnections = aTileEntity.getConnections();
        if ((aConnections & 0xC0) != 0) {
            return this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
        }
        float tThickness = aTileEntity.getThickNess();
        if (tThickness >= 0.99f) {
            return this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
        }
        float sp = (1.0f - tThickness) / 2.0f;
        int connexionSidesBits = 0;
        for (int ordinalSide = 0; ordinalSide < 6; ++ordinalSide) {
            if ((aConnections & 1 << ordinalSide) == 0) continue;
            connexionSidesBits |= 1 << (ordinalSide + 2) % 6;
        }
        EnumSet<ForgeDirection> coveredSides = EnumSet.noneOf(ForgeDirection.class);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (aTileEntity.getCoverIDAtSide(side) == 0) continue;
            coveredSides.add(side);
        }
        if (coveredSides.containsAll(EnumSet.of(ForgeDirection.DOWN, new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST}))) {
            return this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
        }
        EnumMap<ForgeDirection, ITexture[]> texture = new EnumMap<ForgeDirection, ITexture[]>(ForgeDirection.class);
        EnumMap<ForgeDirection, ITexture[]> textureUncovered = new EnumMap<ForgeDirection, ITexture[]>(ForgeDirection.class);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            texture.put(side, GTMethodHelper.getTexture((TileEntity)aTileEntity, aBlock, side));
            textureUncovered.put(side, aTileEntity.getTextureUncovered(side));
        }
        switch (connexionSidesBits) {
            case 0: {
                aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.DOWN), false);
                MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.UP), false);
                MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.NORTH), false);
                MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.SOUTH), false);
                MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.WEST), false);
                MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.EAST), false);
                break;
            }
            case 3: {
                aBlock.func_149676_a(0.0f, sp, sp, 1.0f, sp + tThickness, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.DOWN), false);
                MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.UP), false);
                MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.NORTH), false);
                MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.SOUTH), false);
                if (!coveredSides.contains(ForgeDirection.WEST)) {
                    MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.WEST), false);
                }
                if (coveredSides.contains(ForgeDirection.EAST)) break;
                MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.EAST), false);
                break;
            }
            case 12: {
                aBlock.func_149676_a(sp, 0.0f, sp, sp + tThickness, 1.0f, sp + tThickness);
                aRenderer.func_147775_a(aBlock);
                MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.NORTH), false);
                MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.SOUTH), false);
                MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.WEST), false);
                MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.EAST), false);
                if (!coveredSides.contains(ForgeDirection.DOWN)) {
                    MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.DOWN), false);
                }
                if (coveredSides.contains(ForgeDirection.UP)) break;
                MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.UP), false);
                break;
            }
            case 48: {
                aBlock.func_149676_a(sp, sp, 0.0f, sp + tThickness, sp + tThickness, 1.0f);
                aRenderer.func_147775_a(aBlock);
                MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.DOWN), false);
                MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.UP), false);
                MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.WEST), false);
                MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.EAST), false);
                if (!coveredSides.contains(ForgeDirection.NORTH)) {
                    MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.NORTH), false);
                }
                if (coveredSides.contains(ForgeDirection.SOUTH)) break;
                MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.SOUTH), false);
                break;
            }
            default: {
                if ((connexionSidesBits & 1) == 0) {
                    aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.WEST), false);
                } else {
                    aBlock.func_149676_a(0.0f, sp, sp, sp, sp + tThickness, sp + tThickness);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.DOWN), false);
                    MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.UP), false);
                    MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.NORTH), false);
                    MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.SOUTH), false);
                    if (!coveredSides.contains(ForgeDirection.WEST)) {
                        MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.WEST), false);
                    }
                }
                if ((connexionSidesBits & 2) == 0) {
                    aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.EAST), false);
                } else {
                    aBlock.func_149676_a(sp + tThickness, sp, sp, 1.0f, sp + tThickness, sp + tThickness);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.DOWN), false);
                    MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.UP), false);
                    MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.NORTH), false);
                    MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.SOUTH), false);
                    if (!coveredSides.contains(ForgeDirection.EAST)) {
                        MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.EAST), false);
                    }
                }
                if ((connexionSidesBits & 4) == 0) {
                    aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.DOWN), false);
                } else {
                    aBlock.func_149676_a(sp, 0.0f, sp, sp + tThickness, sp, sp + tThickness);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.NORTH), false);
                    MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.SOUTH), false);
                    MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.WEST), false);
                    MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.EAST), false);
                    if (!coveredSides.contains(ForgeDirection.DOWN)) {
                        MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.DOWN), false);
                    }
                }
                if ((connexionSidesBits & 8) == 0) {
                    aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.UP), false);
                } else {
                    aBlock.func_149676_a(sp, sp + tThickness, sp, sp + tThickness, 1.0f, sp + tThickness);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.NORTH), false);
                    MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.SOUTH), false);
                    MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.WEST), false);
                    MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.EAST), false);
                    if (!coveredSides.contains(ForgeDirection.UP)) {
                        MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.UP), false);
                    }
                }
                if ((connexionSidesBits & 0x10) == 0) {
                    aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.NORTH), false);
                } else {
                    aBlock.func_149676_a(sp, sp, 0.0f, sp + tThickness, sp + tThickness, sp);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.DOWN), false);
                    MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.UP), false);
                    MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.WEST), false);
                    MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.EAST), false);
                    if (!coveredSides.contains(ForgeDirection.NORTH)) {
                        MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.NORTH), false);
                    }
                }
                if ((connexionSidesBits & 0x20) == 0) {
                    aBlock.func_149676_a(sp, sp, sp, sp + tThickness, sp + tThickness, sp + tThickness);
                    aRenderer.func_147775_a(aBlock);
                    MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.SOUTH), false);
                    break;
                }
                aBlock.func_149676_a(sp, sp, sp + tThickness, sp + tThickness, sp + tThickness, 1.0f);
                aRenderer.func_147775_a(aBlock);
                MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.DOWN), false);
                MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.UP), false);
                MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.WEST), false);
                MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.EAST), false);
                if (coveredSides.contains(ForgeDirection.SOUTH)) break;
                MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])textureUncovered.get(ForgeDirection.SOUTH), false);
            }
        }
        if (coveredSides.contains(ForgeDirection.DOWN)) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.DOWN), false);
            MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.DOWN), false);
            if (!coveredSides.contains(ForgeDirection.NORTH)) {
                MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.DOWN), false);
            }
            if (!coveredSides.contains(ForgeDirection.SOUTH)) {
                MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.DOWN), false);
            }
            if (!coveredSides.contains(ForgeDirection.WEST)) {
                MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.DOWN), false);
            }
            if (!coveredSides.contains(ForgeDirection.EAST)) {
                MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.DOWN), false);
            }
        }
        if (coveredSides.contains(ForgeDirection.UP)) {
            aBlock.func_149676_a(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.UP), false);
            MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.UP), false);
            if (!coveredSides.contains(ForgeDirection.NORTH)) {
                MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.UP), false);
            }
            if (!coveredSides.contains(ForgeDirection.SOUTH)) {
                MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.UP), false);
            }
            if (!coveredSides.contains(ForgeDirection.WEST)) {
                MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.UP), false);
            }
            if (!coveredSides.contains(ForgeDirection.EAST)) {
                MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.UP), false);
            }
        }
        if (coveredSides.contains(ForgeDirection.NORTH)) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
            aRenderer.func_147775_a(aBlock);
            if (!coveredSides.contains(ForgeDirection.DOWN)) {
                MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.NORTH), false);
            }
            if (!coveredSides.contains(ForgeDirection.UP)) {
                MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.NORTH), false);
            }
            MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.NORTH), false);
            MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.NORTH), false);
            if (!coveredSides.contains(ForgeDirection.WEST)) {
                MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.NORTH), false);
            }
            if (!coveredSides.contains(ForgeDirection.EAST)) {
                MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.NORTH), false);
            }
        }
        if (coveredSides.contains(ForgeDirection.SOUTH)) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!coveredSides.contains(ForgeDirection.DOWN)) {
                MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.SOUTH), false);
            }
            if (!coveredSides.contains(ForgeDirection.UP)) {
                MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.SOUTH), false);
            }
            MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.SOUTH), false);
            MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.SOUTH), false);
            if (!coveredSides.contains(ForgeDirection.WEST)) {
                MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.SOUTH), false);
            }
            if (!coveredSides.contains(ForgeDirection.EAST)) {
                MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.SOUTH), false);
            }
        }
        if (coveredSides.contains(ForgeDirection.WEST)) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!coveredSides.contains(ForgeDirection.DOWN)) {
                MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.WEST), false);
            }
            if (!coveredSides.contains(ForgeDirection.UP)) {
                MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.WEST), false);
            }
            if (!coveredSides.contains(ForgeDirection.NORTH)) {
                MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.WEST), false);
            }
            if (!coveredSides.contains(ForgeDirection.SOUTH)) {
                MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.WEST), false);
            }
            MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.WEST), false);
            MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.WEST), false);
        }
        if (coveredSides.contains(ForgeDirection.EAST)) {
            aBlock.func_149676_a(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!coveredSides.contains(ForgeDirection.DOWN)) {
                MachineBlockRenderer.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.EAST), false);
            }
            if (!coveredSides.contains(ForgeDirection.UP)) {
                MachineBlockRenderer.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.EAST), false);
            }
            if (!coveredSides.contains(ForgeDirection.NORTH)) {
                MachineBlockRenderer.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.EAST), false);
            }
            if (!coveredSides.contains(ForgeDirection.SOUTH)) {
                MachineBlockRenderer.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.EAST), false);
            }
            MachineBlockRenderer.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.EAST), false);
            MachineBlockRenderer.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, (ITexture[])texture.get(ForgeDirection.EAST), false);
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        return true;
    }

    public static void renderNegativeYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY - 1, aZ, 0)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY - 1 : aY, aZ));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderYNeg(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderPositiveYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY + 1, aZ, 1)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY + 1 : aY, aZ));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderYPos(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderNegativeZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY, aZ - 1, 2)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ - 1 : aZ));
        }
        boolean bl = aRenderer.field_147842_e = !aFullBlock;
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderZNeg(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderPositiveZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY, aZ + 1, 3)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ + 1 : aZ));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderZPos(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderNegativeXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX - 1, aY, aZ, 4)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aFullBlock ? aX - 1 : aX, aY, aZ));
        }
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderXNeg(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    public static void renderPositiveXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX + 1, aY, aZ, 5)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aFullBlock ? aX + 1 : aX, aY, aZ));
        }
        boolean bl = aRenderer.field_147842_e = !aFullBlock;
        if (aIcon != null) {
            for (ITexture iTexture : aIcon) {
                if (iTexture == null) continue;
                iTexture.renderXPos(aRenderer, aBlock, aX, aY, aZ);
            }
        }
        aRenderer.field_147842_e = false;
    }

    @Override
    public void renderInventoryBlock(Block aBlock, int aMeta, int aModelID, RenderBlocks aRenderer) {
        if (aBlock instanceof BlockMachines && (aMeta += 30400) > 0 && aMeta < GregTechAPI.METATILEENTITIES.length && GregTechAPI.METATILEENTITIES[aMeta] != null && !GregTechAPI.METATILEENTITIES[aMeta].renderInInventory(aBlock, aMeta, aRenderer)) {
            MachineBlockRenderer.renderNormalInventoryMetaTileEntity(aBlock, aMeta, aRenderer);
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity != null && (aTileEntity instanceof IGregTechTileEntity && ((IGregTechTileEntity)aTileEntity).getMetaTileEntity() != null && ((IGregTechTileEntity)aTileEntity).getMetaTileEntity().renderInWorld(aWorld, aX, aY, aZ, aBlock, aRenderer) || (aTileEntity instanceof IPipeRenderedTileEntity ? this.renderPipeBlock(aWorld, aX, aY, aZ, aBlock, (IPipeRenderedTileEntity)aTileEntity, aRenderer) : this.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer)));
    }

    @Override
    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    @Override
    public int getRenderId() {
        return this.mRenderID;
    }
}

