/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multiblock.logic;

import gregtech.api.enums.Mods;
import gregtech.api.logic.FluidInventoryLogic;
import gregtech.api.logic.ItemInventoryLogic;
import gregtech.api.logic.MuTEProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CokeOvenProcessingLogic
extends MuTEProcessingLogic<CokeOvenProcessingLogic> {
    private static final int NORMAL_RECIPE_TIME = 1800;
    private static final int WOOD_ORE_ID = OreDictionary.getOreID((String)"logWood");
    private static final int COAL_ORE_ID = OreDictionary.getOreID((String)"coal");
    private static final int COAL_BLOCK_ORE_ID = OreDictionary.getOreID((String)"blockCoal");
    private static final int SUGARCANE_ORE_ID = OreDictionary.getOreID((String)"sugarcane");
    private static final int CACTUS_ORE_ID = OreDictionary.getOreID((String)"blockCactus");
    private static final int CACTUS_CHARCOAL_ORE_ID = OreDictionary.getOreID((String)"itemCharcoalCactus");
    private static final int SUGAR_CHARCOAL_ORE_ID = OreDictionary.getOreID((String)"itemCharcoalSugar");
    private int timeMultiplier = 1;

    @Override
    @Nonnull
    protected Object findRecipe(@Nullable RecipeMap<?> map, @Nonnull ItemInventoryLogic itemInput, @Nonnull FluidInventoryLogic fluidInput) {
        for (ItemStack item : itemInput.getStoredItems()) {
            ItemStack output = this.findRecipe(item);
            if (output == null) continue;
            ItemStack input = item.func_77946_l();
            input.field_77994_a = 1;
            return null;
        }
        return null;
    }

    @Nullable
    private ItemStack findRecipe(@Nonnull ItemStack input) {
        for (int oreId : OreDictionary.getOreIDs((ItemStack)input)) {
            if (oreId == COAL_ORE_ID) {
                return GTOreDictUnificator.get("fuelCoke", null, 1L);
            }
            if (oreId == COAL_BLOCK_ORE_ID) {
                this.timeMultiplier = 9;
                return GTModHandler.getModItem(Mods.Railcraft.ID, "cube", 1L, 0);
            }
            if (oreId == WOOD_ORE_ID) {
                return new ItemStack(Items.field_151044_h, 1, 1);
            }
            if (oreId == SUGARCANE_ORE_ID) {
                return GTOreDictUnificator.get("itemCharcoalSugar", null, 1L);
            }
            if (oreId == SUGAR_CHARCOAL_ORE_ID) {
                return GTOreDictUnificator.get("itemCokeSugar", null, 1L);
            }
            if (oreId == CACTUS_ORE_ID) {
                return GTOreDictUnificator.get("itemCharcoalCactus", null, 1L);
            }
            if (oreId != CACTUS_CHARCOAL_ORE_ID) continue;
            return GTOreDictUnificator.get("itemCokeCactus", null, 1L);
        }
        return null;
    }
}

