/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import com.gtnewhorizons.modularui.api.math.Pos2d;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.RecipeDisplayInfo;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TranscendentPlasmaMixerFrontend
extends RecipeMapFrontend {
    public TranscendentPlasmaMixerFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder);
    }

    @Override
    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return UIHelper.getGridPositions(itemInputCount, 60, 8, 1);
    }

    @Override
    public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        return UIHelper.getGridPositions(fluidInputCount, 6, 26, 4, 5);
    }

    @Override
    public List<Pos2d> getFluidOutputPositions(int fluidOutputCount) {
        return UIHelper.getGridPositions(fluidOutputCount, 114, 44, 1);
    }

    @Override
    protected void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        long multiplier = recipeInfo.recipe.getMetadataOrDefault(GTRecipeConstants.EU_MULTIPLIER, 10).intValue();
        recipeInfo.drawText(GTUtility.trans("152", "Total: ") + GTUtility.formatNumbers(multiplier * (long)recipeInfo.recipe.mDuration * (long)recipeInfo.recipe.mEUt) + " EU");
        long averageUsage = multiplier * (long)recipeInfo.recipe.mEUt;
        recipeInfo.drawText("Average: " + GTUtility.formatNumbers(averageUsage) + " EU/t" + GTUtility.getTierNameWithParentheses(averageUsage));
    }
}

