/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import cpw.mods.fml.common.network.NetworkRegistry;
import gregtech.api.enums.InventoryType;
import gregtech.api.enums.VoidingMode;
import gregtech.api.interfaces.IDescribable;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.logic.AbstractProcessingLogic;
import gregtech.api.logic.ControllerFluidLogic;
import gregtech.api.logic.ControllerItemLogic;
import gregtech.api.logic.FluidInventoryLogic;
import gregtech.api.logic.ItemInventoryLogic;
import gregtech.api.logic.MuTEProcessingLogic;
import gregtech.api.logic.PowerLogic;
import gregtech.api.multitileentity.WeakTargetRef;
import gregtech.api.multitileentity.enums.MultiTileCasingPurpose;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.interfaces.IMultiBlockPart;
import gregtech.api.multitileentity.machine.MultiTileBasicMachine;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.multitileentity.multiblock.casing.FunctionalCasing;
import gregtech.api.multitileentity.multiblock.casing.UpgradeCasing;
import gregtech.api.net.GTPacketMultiTileEntity;
import gregtech.api.objects.GTItemStack;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GTWaila;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.misc.WirelessNetworkManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

public abstract class Controller<C extends Controller<C, P>, P extends MuTEProcessingLogic<P>>
extends MultiTileBasicMachine<P>
implements IAlignment,
IMultiBlockController,
IDescribable,
ISurvivalConstructable {
    public static final String ALL_INVENTORIES_NAME = "all";
    protected static final int AUTO_OUTPUT_FREQUENCY_TICK = 20;
    private static final Map<Integer, MultiblockTooltipBuilder> tooltip = new ConcurrentHashMap<Integer, MultiblockTooltipBuilder>();
    private final List<WeakTargetRef<UpgradeCasing>> upgradeCasings = new ArrayList<WeakTargetRef<UpgradeCasing>>();
    private final List<WeakTargetRef<FunctionalCasing>> functionalCasings = new ArrayList<WeakTargetRef<FunctionalCasing>>();
    protected BuildState buildState = new BuildState();
    private boolean structureOkay = false;
    private boolean structureChanged = false;
    private ExtendedFacing extendedFacing = ExtendedFacing.DEFAULT;
    private IAlignmentLimits limits = this.getInitialAlignmentLimits();
    protected boolean separateInputs = this.getDefaultInputSeparationMode();
    protected VoidingMode voidingMode = this.getDefaultVoidingMode();
    protected boolean batchMode = this.getDefaultBatchMode();
    protected boolean recipeLock = this.getDefaultRecipeLockingMode();
    protected boolean shouldSort = false;
    protected boolean isSimpleMachine = true;
    protected boolean isCleanroom = false;
    protected ControllerItemLogic controllerItemInput = new ControllerItemLogic();
    protected ControllerItemLogic controllerItemOutput = new ControllerItemLogic();
    protected ControllerFluidLogic controllerFluidInput = new ControllerFluidLogic();
    protected ControllerFluidLogic controllerFluidOutput = new ControllerFluidLogic();
    protected List<List<WeakTargetRef<IMultiBlockPart>>> registeredCoveredParts = Arrays.asList(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
    protected List<List<WeakTargetRef<IMultiBlockPart>>> registeredTickableParts = new ArrayList<List<WeakTargetRef<IMultiBlockPart>>>();

    public Controller() {
        for (int i = 0; i < MultiTileCasingPurpose.values().length; ++i) {
            this.registeredTickableParts.add(new ArrayList());
        }
    }

    public abstract short getCasingRegistryID();

    public abstract int getCasingMeta();

    protected abstract MultiblockTooltipBuilder createTooltip();

    public abstract Vec3Impl getStartingStructureOffset();

    public abstract IStructureDefinition<C> getStructureDefinition();

    public boolean checkMachine() {
        this.calculateTier();
        this.updatePowerLogic();
        return this.tier > 0;
    }

    protected void calculateTier() {
        if (this.functionalCasings.isEmpty()) {
            return;
        }
        double sum = 0.0;
        for (WeakTargetRef<FunctionalCasing> casingRef : this.functionalCasings) {
            FunctionalCasing casing = casingRef.get();
            if (casing == null) continue;
            sum += (double)((float)casing.getPartTier() * casing.getPartModifier());
        }
        this.tier = (int)Math.min(Math.floor(sum / (double)this.functionalCasings.size()), 14.0);
    }

    @Override
    public void writeMultiTileNBT(NBTTagCompound nbt) {
        super.writeMultiTileNBT(nbt);
        nbt.func_74757_a("gt.structure.ok", this.structureOkay);
        nbt.func_74774_a("gt.eRotation", (byte)this.extendedFacing.getRotation().getIndex());
        nbt.func_74774_a("gt.eFlip", (byte)this.extendedFacing.getFlip().getIndex());
        nbt.func_74778_a("gt.voiding.mode", this.voidingMode.name);
        nbt.func_74757_a("gt.separate.inputs", this.separateInputs);
        nbt.func_74757_a("gt.recipe.lock", this.recipeLock);
        nbt.func_74757_a("gt.batch.mode", this.batchMode);
    }

    @Override
    protected void saveItemLogic(NBTTagCompound nbt) {
        NBTTagCompound itemInputNBT = this.controllerItemInput.saveToNBT();
        nbt.func_74782_a("gt.invlist.in", (NBTBase)itemInputNBT);
        NBTTagCompound itemOutputNBT = this.controllerItemOutput.saveToNBT();
        nbt.func_74782_a("gt.invlist.out", (NBTBase)itemOutputNBT);
    }

    @Override
    protected void saveFluidLogic(NBTTagCompound nbt) {
        NBTTagCompound fluidInputNBT = this.controllerFluidInput.saveToNBT();
        nbt.func_74782_a("gt.tank.in.", (NBTBase)fluidInputNBT);
        NBTTagCompound fluidOutputNBT = this.controllerFluidOutput.saveToNBT();
        nbt.func_74782_a("gt.tank.out.", (NBTBase)fluidOutputNBT);
    }

    @Override
    public void readMultiTileNBT(NBTTagCompound nbt) {
        super.readMultiTileNBT(nbt);
        this.structureOkay = nbt.func_74767_n("gt.structure.ok");
        this.extendedFacing = ExtendedFacing.of((ForgeDirection)this.getFrontFacing(), (Rotation)Rotation.byIndex((int)nbt.func_74771_c("gt.eRotation")), (Flip)Flip.byIndex((int)nbt.func_74771_c("gt.eFlip")));
        this.voidingMode = VoidingMode.fromName(nbt.func_74779_i("gt.voiding.mode"));
        this.separateInputs = nbt.func_74767_n("gt.separate.inputs");
        this.recipeLock = nbt.func_74767_n("gt.recipe.lock");
        this.batchMode = nbt.func_74767_n("gt.batch.mode");
    }

    @Override
    protected void loadItemLogic(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("gt.invlist.in") && !nbt.func_74764_b("gt.invlist.out")) {
            this.controllerItemInput.addInventory(new ItemInventoryLogic(16));
            this.controllerItemOutput.addInventory(new ItemInventoryLogic(16));
            return;
        }
        this.controllerItemInput.loadFromNBT(nbt.func_74775_l("gt.invlist.in"));
        this.controllerItemOutput.loadFromNBT(nbt.func_74775_l("gt.invlist.out"));
    }

    @Override
    protected void loadFluidLogic(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("gt.tank.in.") && !nbt.func_74764_b("gt.tank.out.")) {
            this.controllerFluidInput.addInventory(new FluidInventoryLogic(16, 32000L));
            this.controllerFluidOutput.addInventory(new FluidInventoryLogic(16, 32000L));
            return;
        }
        this.controllerFluidInput.loadFromNBT(nbt.func_74775_l("gt.tank.in."));
        this.controllerFluidOutput.loadFromNBT(nbt.func_74775_l("gt.tank.out."));
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.addAll(Arrays.asList(this.getDescription()));
    }

    @Override
    public String[] getDescription() {
        if (Keyboard.isKeyDown((int)42)) {
            return this.getTooltip().getStructureInformation();
        }
        return this.getTooltip().getInformation();
    }

    @Override
    protected void addDebugInfo(EntityPlayer aPlayer, int aLogLevel, ArrayList<String> tList) {
        super.addDebugInfo(aPlayer, aLogLevel, tList);
        tList.add("Structure ok: " + this.checkStructure(false));
    }

    protected int getToolTipID() {
        return this.getMultiTileEntityRegistryID() << 16 + this.getMultiTileEntityID();
    }

    protected MultiblockTooltipBuilder getTooltip() {
        MultiblockTooltipBuilder builder = tooltip.get(this.getToolTipID());
        if (builder == null) {
            builder = this.createTooltip();
            tooltip.put(this.getToolTipID(), builder);
        }
        return builder;
    }

    @Override
    public boolean checkStructure(boolean aForceReset) {
        if (!this.isServerSide()) {
            return this.structureOkay;
        }
        if (this.structureChanged || aForceReset) {
            this.clearSpecialLists();
            this.structureOkay = this.checkMachine();
        }
        this.structureChanged = false;
        return this.structureOkay;
    }

    @Override
    public void onStructureChange() {
        this.structureChanged = true;
    }

    public final boolean checkPiece(String piece, Vec3Impl offset) {
        return this.checkPiece(piece, offset.get0(), offset.get1(), offset.get2());
    }

    protected final boolean checkPiece(String piece, int horizontalOffset, int verticalOffset, int depthOffset) {
        return this.getCastedStructureDefinition().check((Object)this, piece, this.getWorld(), this.getExtendedFacing(), this.getXCoord(), (int)this.getYCoord(), this.getZCoord(), horizontalOffset, verticalOffset, depthOffset, !this.structureOkay);
    }

    public final boolean buildPiece(String piece, ItemStack trigger, boolean hintsOnly, Vec3Impl offset) {
        return this.buildPiece(piece, trigger, hintsOnly, offset.get0(), offset.get1(), offset.get2());
    }

    protected final boolean buildPiece(String piece, ItemStack trigger, boolean hintOnly, int horizontalOffset, int verticalOffset, int depthOffset) {
        return this.getCastedStructureDefinition().buildOrHints((Object)this, trigger, piece, this.getWorld(), this.getExtendedFacing(), this.getXCoord(), (int)this.getYCoord(), this.getZCoord(), horizontalOffset, verticalOffset, depthOffset, hintOnly);
    }

    protected final int survivalBuildPiece(String piece, ItemStack trigger, Vec3Impl offset, int elementBudget, ISurvivalBuildEnvironment env, boolean check) {
        return this.survivalBuildPiece(piece, trigger, offset.get0(), offset.get1(), offset.get2(), elementBudget, env, check);
    }

    protected final Integer survivalBuildPiece(String piece, ItemStack trigger, int horizontalOffset, int verticalOffset, int depthOffset, int elementBudget, ISurvivalBuildEnvironment env, boolean check) {
        return this.getCastedStructureDefinition().survivalBuild((Object)this, trigger, piece, this.getWorld(), this.getExtendedFacing(), this.getXCoord(), (int)this.getYCoord(), this.getZCoord(), horizontalOffset, verticalOffset, depthOffset, elementBudget, env, check);
    }

    private IStructureDefinition<Controller<C, P>> getCastedStructureDefinition() {
        return this.getStructureDefinition();
    }

    public ExtendedFacing getExtendedFacing() {
        return this.extendedFacing;
    }

    public void setExtendedFacing(ExtendedFacing newExtendedFacing) {
        if (this.extendedFacing == newExtendedFacing) {
            return;
        }
        this.onStructureChange();
        if (this.structureOkay) {
            this.stopMachine(false);
        }
        this.extendedFacing = newExtendedFacing;
        this.structureOkay = false;
        if (this.isServerSide()) {
            StructureLibAPI.sendAlignment((IAlignmentProvider)this, (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(this.getWorld().field_73011_w.field_76574_g, (double)this.getXCoord(), (double)this.getYCoord(), (double)this.getZCoord(), 512.0));
        } else {
            this.issueTextureUpdate();
        }
    }

    @Override
    public boolean onWrenchRightClick(EntityPlayer aPlayer, ItemStack tCurrentItem, ForgeDirection wrenchSide, float aX, float aY, float aZ, ItemStack aTool) {
        if (wrenchSide != this.getFrontFacing()) {
            return super.onWrenchRightClick(aPlayer, tCurrentItem, wrenchSide, aX, aY, aZ);
        }
        if (aPlayer.func_70093_af()) {
            this.toolSetFlip(this.getFlip().isHorizontallyFlipped() ? Flip.NONE : Flip.HORIZONTAL);
        } else {
            this.toolSetRotation(null);
        }
        return true;
    }

    @Override
    public void registerCoveredPartOnSide(ForgeDirection side, IMultiBlockPart part) {
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        List<WeakTargetRef<IMultiBlockPart>> registeredCovers = this.registeredCoveredParts.get(side.ordinal());
        registeredCovers.add(new WeakTargetRef<IMultiBlockPart>(part, true));
    }

    @Override
    public void unregisterCoveredPartOnSide(ForgeDirection side, IMultiBlockPart aPart) {
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        List<WeakTargetRef<IMultiBlockPart>> coveredParts = this.registeredCoveredParts.get(side.ordinal());
        ListIterator<WeakTargetRef<IMultiBlockPart>> it = coveredParts.listIterator();
        while (it.hasNext()) {
            IMultiBlockPart part = (IMultiBlockPart)((WeakTargetRef)it.next()).get();
            if (part != null && part != aPart) continue;
            it.remove();
        }
    }

    @Override
    public void registerCaseWithPurpose(MultiTileCasingPurpose purpose, IMultiBlockPart part) {
        List<WeakTargetRef<IMultiBlockPart>> tickableParts = this.registeredTickableParts.get(purpose.ordinal());
        ListIterator<WeakTargetRef<IMultiBlockPart>> it = tickableParts.listIterator();
        while (it.hasNext()) {
            IMultiBlockPart next = (IMultiBlockPart)((WeakTargetRef)it.next()).get();
            if (next == null) {
                it.remove();
                continue;
            }
            if (next != part) continue;
            return;
        }
        tickableParts.add(new WeakTargetRef<IMultiBlockPart>(part, true));
    }

    @Override
    public void unregisterCaseWithPurpose(MultiTileCasingPurpose purpose, IMultiBlockPart part) {
        List<WeakTargetRef<IMultiBlockPart>> tickableParts = this.registeredTickableParts.get(purpose.ordinal());
        ListIterator<WeakTargetRef<IMultiBlockPart>> it = tickableParts.listIterator();
        while (it.hasNext()) {
            IMultiBlockPart next = (IMultiBlockPart)((WeakTargetRef)it.next()).get();
            if (next != null && next != part) continue;
            it.remove();
        }
    }

    @Override
    public void onFirstTick(boolean isServerSide) {
        super.onFirstTick(isServerSide);
        if (isServerSide) {
            this.checkStructure(true);
        } else {
            StructureLibAPI.queryAlignment((IAlignmentProvider)this);
        }
    }

    private boolean tickCovers() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            List<WeakTargetRef<IMultiBlockPart>> coveredParts = this.registeredCoveredParts.get(side.ordinal());
            ListIterator<WeakTargetRef<IMultiBlockPart>> it = coveredParts.listIterator();
            while (it.hasNext()) {
                IMultiBlockPart part = (IMultiBlockPart)((WeakTargetRef)it.next()).get();
                if (part == null) {
                    it.remove();
                    continue;
                }
                if (part.tickCoverAtSide(side, this.mTickTimer)) continue;
                it.remove();
            }
        }
        return true;
    }

    @Override
    public void onTick(long tick, boolean isServerSide) {
        this.tickCovers();
    }

    @Override
    public void onPostTick(long tick, boolean isServerSide) {
        if (!isServerSide) {
            this.doActivitySound(this.getActivitySoundLoop());
            return;
        }
        if (tick % 600L == 5L && !this.checkStructure(false)) {
            this.checkStructure(true);
        }
        if (this.checkStructure(false)) {
            this.runMachine(tick);
            this.pushItemOutputs(tick);
            this.pushFluidOutputs(tick);
        } else {
            this.stopMachine(false);
        }
    }

    protected void pushItemOutputs(long tick) {
        if (tick % 20L != 0L) {
            return;
        }
        List<WeakTargetRef<IMultiBlockPart>> registeredItemOutputs = this.registeredTickableParts.get(MultiTileCasingPurpose.ItemOutput.ordinal());
        ListIterator<WeakTargetRef<IMultiBlockPart>> itemOutputIterator = registeredItemOutputs.listIterator();
        while (itemOutputIterator.hasNext()) {
            IMultiBlockPart part = (IMultiBlockPart)((WeakTargetRef)itemOutputIterator.next()).get();
            if (part == null) {
                itemOutputIterator.remove();
                continue;
            }
            if (!part.shouldTick(this.mTickTimer)) {
                itemOutputIterator.remove();
                continue;
            }
            IInventory facingInventory = part.getIInventoryAtSide(part.getFrontFacing());
            if (facingInventory == null) continue;
            GTUtility.moveMultipleItemStacks(part, facingInventory, part.getFrontFacing(), part.getBackFacing(), null, false, (byte)64, (byte)1, (byte)64, (byte)1, part.func_70302_i_());
            for (int i = 0; i < part.func_70302_i_(); ++i) {
                ItemStack stack = part.func_70301_a(i);
                if (stack == null || stack.field_77994_a > 0) continue;
                part.func_70299_a(i, null);
            }
        }
    }

    protected void pushFluidOutputs(long tick) {
        if (tick % 20L != 0L) {
            return;
        }
        List<WeakTargetRef<IMultiBlockPart>> registeredFluidOutputs = this.registeredTickableParts.get(MultiTileCasingPurpose.FluidOutput.ordinal());
        ListIterator<WeakTargetRef<IMultiBlockPart>> fluidOutputIterator = registeredFluidOutputs.listIterator();
        while (fluidOutputIterator.hasNext()) {
            IMultiBlockPart part = (IMultiBlockPart)((WeakTargetRef)fluidOutputIterator.next()).get();
            if (part == null) {
                fluidOutputIterator.remove();
                continue;
            }
            if (part.shouldTick(this.mTickTimer)) continue;
            fluidOutputIterator.remove();
        }
    }

    @Override
    public void setCleanroom(boolean cleanroom) {
        this.isCleanroom = cleanroom;
    }

    protected void clearSpecialLists() {
        this.upgradeCasings.clear();
        this.functionalCasings.clear();
    }

    @Override
    public final boolean isFacingValid(ForgeDirection facing) {
        return this.canSetToDirectionAny(facing);
    }

    @Override
    public void onFacingChange() {
        this.toolSetDirection(this.getFrontFacing());
        this.onStructureChange();
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GTItemStack aCoverID) {
        return side != this.facing;
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return this.getTooltip().getStructureHint();
    }

    public IAlignmentLimits getAlignmentLimits() {
        return this.limits;
    }

    protected void setAlignmentLimits(IAlignmentLimits mLimits) {
        this.limits = mLimits;
    }

    public boolean isSeparateInputs() {
        return this.separateInputs;
    }

    public void setSeparateInputs(boolean aSeparateInputs) {
        this.separateInputs = aSeparateInputs;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !f.isVerticallyFliped();
    }

    public void registerSpecialCasings(MultiBlockPart part) {
        if (part instanceof UpgradeCasing) {
            UpgradeCasing upgradeCasing = (UpgradeCasing)part;
            this.upgradeCasings.add(new WeakTargetRef<UpgradeCasing>(upgradeCasing, true));
        }
        if (part instanceof FunctionalCasing) {
            FunctionalCasing functionalCasing = (FunctionalCasing)part;
            this.functionalCasings.add(new WeakTargetRef<FunctionalCasing>(functionalCasing, true));
        }
    }

    @Override
    @Nullable
    public FluidInventoryLogic getFluidLogic(@Nonnull ForgeDirection side, @Nonnull InventoryType type) {
        FluidInventoryLogic fluidInventoryLogic;
        if (side == this.facing) {
            return null;
        }
        switch (type) {
            case Input: {
                fluidInventoryLogic = this.controllerFluidInput.getAllInventoryLogics();
                break;
            }
            case Output: {
                fluidInventoryLogic = this.controllerFluidOutput.getAllInventoryLogics();
                break;
            }
            default: {
                fluidInventoryLogic = null;
            }
        }
        return fluidInventoryLogic;
    }

    @Override
    @Nonnull
    @NotNull
    public FluidInventoryLogic getFluidLogic(@Nonnull InventoryType type, @Nullable UUID id) {
        FluidInventoryLogic fluidInventoryLogic;
        switch (type) {
            case Input: {
                fluidInventoryLogic = this.controllerFluidInput.getInventoryLogic(id);
                break;
            }
            case Output: {
                fluidInventoryLogic = this.controllerFluidOutput.getInventoryLogic(id);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
            }
        }
        return fluidInventoryLogic;
    }

    @Override
    @Nonnull
    public UUID registerFluidInventory(int tanks, long capacity, int tier, @Nonnull InventoryType type, boolean isUpgradeInventory) {
        UUID uUID;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Input: {
                uUID = this.controllerFluidInput.addInventory(new FluidInventoryLogic(tanks, capacity, tier, isUpgradeInventory));
                break;
            }
            case Output: {
                uUID = this.controllerFluidOutput.addInventory(new FluidInventoryLogic(tanks, capacity, tier, isUpgradeInventory));
                break;
            }
            case Both: {
                UUID id = this.controllerFluidInput.addInventory(new FluidInventoryLogic(tanks, capacity, tier, isUpgradeInventory));
                this.controllerFluidOutput.addInventory(id, new FluidInventoryLogic(tanks, capacity, tier, isUpgradeInventory));
                uUID = id;
                break;
            }
        }
        return uUID;
    }

    @Override
    @Nonnull
    public FluidInventoryLogic unregisterFluidInventory(@Nonnull UUID id, @Nonnull InventoryType type) {
        FluidInventoryLogic fluidInventoryLogic;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Input: {
                fluidInventoryLogic = this.controllerFluidInput.removeInventory(id);
                break;
            }
            case Output: {
                fluidInventoryLogic = this.controllerFluidOutput.removeInventory(id);
                break;
            }
            case Both: {
                FluidInventoryLogic input = this.controllerFluidInput.removeInventory(id);
                FluidInventoryLogic output = this.controllerFluidOutput.removeInventory(id);
                fluidInventoryLogic = new FluidInventoryLogic(Stream.of(input, output).map(FluidInventoryLogic::getInventory).collect(Collectors.toList()));
                break;
            }
        }
        return fluidInventoryLogic;
    }

    @Override
    public void changeFluidInventoryDisplayName(@Nullable UUID id, @Nullable String displayName, @Nonnull InventoryType type) {
        switch (type) {
            case Input: {
                this.controllerFluidInput.setInventoryDisplayName(id, displayName);
                break;
            }
            case Output: {
                this.controllerFluidOutput.setInventoryDisplayName(id, displayName);
                break;
            }
            case Both: {
                this.controllerFluidInput.setInventoryDisplayName(id, displayName);
                this.controllerFluidOutput.setInventoryDisplayName(id, displayName);
            }
        }
    }

    @Override
    @Nullable
    public ItemInventoryLogic getItemLogic(@Nonnull ForgeDirection side, @Nonnull InventoryType type) {
        ItemInventoryLogic itemInventoryLogic;
        if (side == this.facing) {
            return null;
        }
        switch (type) {
            case Input: {
                itemInventoryLogic = this.controllerItemInput.getAllInventoryLogics();
                break;
            }
            case Output: {
                itemInventoryLogic = this.controllerItemOutput.getAllInventoryLogics();
                break;
            }
            default: {
                itemInventoryLogic = null;
            }
        }
        return itemInventoryLogic;
    }

    @Override
    @Nonnull
    public ItemInventoryLogic getItemLogic(@Nonnull InventoryType type, @Nullable UUID id) {
        ItemInventoryLogic itemInventoryLogic;
        switch (type) {
            case Input: {
                itemInventoryLogic = this.controllerItemInput.getInventoryLogic(id);
                break;
            }
            case Output: {
                itemInventoryLogic = this.controllerItemOutput.getInventoryLogic(id);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
            }
        }
        return itemInventoryLogic;
    }

    @Override
    @Nonnull
    public UUID registerItemInventory(int slots, int tier, @Nonnull InventoryType type, boolean isUpgradeInventory) {
        UUID uUID;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Input: {
                uUID = this.controllerItemInput.addInventory(new ItemInventoryLogic(slots, tier, isUpgradeInventory));
                break;
            }
            case Output: {
                uUID = this.controllerItemOutput.addInventory(new ItemInventoryLogic(slots, tier, isUpgradeInventory));
                break;
            }
            case Both: {
                UUID id = this.controllerItemInput.addInventory(new ItemInventoryLogic(slots, tier, isUpgradeInventory));
                this.controllerItemOutput.addInventory(id, new ItemInventoryLogic(slots, tier, isUpgradeInventory));
                uUID = id;
                break;
            }
        }
        return uUID;
    }

    @Override
    public ItemInventoryLogic unregisterItemInventory(@Nonnull UUID id, @Nonnull InventoryType type) {
        ItemInventoryLogic itemInventoryLogic;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Input: {
                itemInventoryLogic = this.controllerItemInput.removeInventory(id);
                break;
            }
            case Output: {
                itemInventoryLogic = this.controllerItemOutput.removeInventory(id);
                break;
            }
            case Both: {
                ItemInventoryLogic input = this.controllerItemInput.removeInventory(id);
                ItemInventoryLogic output = this.controllerItemOutput.removeInventory(id);
                itemInventoryLogic = new ItemInventoryLogic(Arrays.asList(input, output).stream().map(inv -> inv.getInventory()).collect(Collectors.toList()));
                break;
            }
        }
        return itemInventoryLogic;
    }

    @Override
    public void changeItemInventoryDisplayName(@Nullable UUID id, @Nullable String displayName, @Nonnull InventoryType type) {
        switch (type) {
            case Input: {
                this.controllerItemInput.setInventoryDisplayName(id, displayName);
                break;
            }
            case Output: {
                this.controllerItemOutput.setInventoryDisplayName(id, displayName);
                break;
            }
            case Both: {
                this.controllerItemInput.setInventoryDisplayName(id, displayName);
                this.controllerItemOutput.setInventoryDisplayName(id, displayName);
            }
        }
    }

    @Override
    @Nonnull
    public PowerLogic getPowerLogic() {
        return this.getPowerLogic(ForgeDirection.UNKNOWN);
    }

    @Override
    protected void updateSlots() {
        this.controllerItemInput.getAllInventoryLogics().update(this.shouldSort);
        this.controllerItemOutput.getAllInventoryLogics().update(this.shouldSort);
        this.controllerFluidInput.getAllInventoryLogics().update();
        this.controllerFluidOutput.getAllInventoryLogics().update();
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public boolean hasGui(ForgeDirection side) {
        return true;
    }

    @Override
    protected void addTitleTextStyle(ModularWindow.Builder builder, String title) {
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public VoidingMode getVoidingMode() {
        return this.voidingMode;
    }

    @Override
    public void setVoidingMode(VoidingMode mode) {
        this.voidingMode = mode;
    }

    @Override
    public boolean canDumpItemToME() {
        return false;
    }

    @Override
    public boolean canDumpFluidToME() {
        return false;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean isInputSeparated() {
        return this.separateInputs;
    }

    @Override
    public void setInputSeparation(Boolean enabled) {
        this.separateInputs = enabled;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean isBatchModeEnabled() {
        return this.batchMode;
    }

    @Override
    public void setBatchMode(Boolean mode) {
        this.batchMode = mode;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return false;
    }

    @Override
    public boolean isRecipeLockingEnabled() {
        return this.recipeLock;
    }

    @Override
    public void setRecipeLocking(Boolean enabled) {
        this.recipeLock = enabled;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        Object processing = this.getProcessingLogic();
        tag.func_74768_a("progress", ((MuTEProcessingLogic)processing).getProgress());
        tag.func_74768_a("maxProgress", ((AbstractProcessingLogic)processing).getDuration());
        tag.func_74757_a("structureOkay", this.structureOkay);
        tag.func_74757_a("isActive", this.isActive());
        if (this.isActive()) {
            tag.func_74772_a("energyUsage", ((AbstractProcessingLogic)this.getProcessingLogic()).getCalculatedEut());
            tag.func_74772_a("energyTier", (long)this.tier);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        boolean isActive;
        super.getWailaBody(itemStack, currentTip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        if (!tag.func_74767_n("structureOkay")) {
            currentTip.add(SpecialChars.RED + "** INCOMPLETE STRUCTURE **" + SpecialChars.RESET);
        } else {
            currentTip.add(SpecialChars.GREEN + "Running Fine" + SpecialChars.RESET);
        }
        if (this.isSimpleMachine) {
            isActive = tag.func_74767_n("isActive");
            currentTip.add(GTWaila.getMachineProgressString(isActive, tag.func_74762_e("maxProgress"), tag.func_74762_e("progress")));
        }
        if (isActive = tag.func_74767_n("isActive")) {
            long energyTier = tag.func_74763_f("energyTier");
            long actualEnergyUsage = tag.func_74763_f("energyUsage");
            if (actualEnergyUsage > 0L) {
                currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.use_with_amperage", (Object[])new Object[]{GTUtility.formatNumbers(actualEnergyUsage), GTUtility.getAmperageForTier(actualEnergyUsage, (byte)energyTier), GTUtility.getColoredTierNameFromTier((byte)energyTier)}));
            } else if (actualEnergyUsage < 0L) {
                currentTip.add(StatCollector.func_74837_a((String)"GT5U.waila.energy.produce_with_amperage", (Object[])new Object[]{GTUtility.formatNumbers(-actualEnergyUsage), GTUtility.getAmperageForTier(-actualEnergyUsage, (byte)energyTier), GTUtility.getColoredTierNameFromTier((byte)energyTier)}));
            }
        }
    }

    @Override
    public GTPacketMultiTileEntity getClientDataPacket() {
        return super.getClientDataPacket();
    }

    @Override
    public void enableWorking() {
        super.enableWorking();
        if (!this.structureOkay) {
            this.checkStructure(true);
        }
    }

    @Override
    public List<ItemStack> getItemOutputSlots(ItemStack[] toOutput) {
        return new ArrayList<ItemStack>(0);
    }

    @Override
    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        return new ArrayList(0);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<UUID, FluidInventoryLogic>> getAllFluidInventoryLogics(@Nonnull InventoryType type) {
        Set set;
        switch (type) {
            case Input: {
                set = this.controllerFluidInput.getAllInventoryLogicsAsEntrySet();
                break;
            }
            case Output: {
                set = this.controllerFluidOutput.getAllInventoryLogicsAsEntrySet();
                break;
            }
            default: {
                set = super.getAllFluidInventoryLogics(type);
            }
        }
        return set;
    }

    @Override
    @Nonnull
    public Set<Map.Entry<UUID, ItemInventoryLogic>> getAllItemInventoryLogics(@Nonnull InventoryType type) {
        Set set;
        switch (type) {
            case Input: {
                set = this.controllerItemInput.getAllInventoryLogicsAsEntrySet();
                break;
            }
            case Output: {
                set = this.controllerItemOutput.getAllInventoryLogicsAsEntrySet();
                break;
            }
            default: {
                set = super.getAllItemInventoryLogics(type);
            }
        }
        return set;
    }

    @Override
    public void setWirelessSupport(boolean canUse) {
        if (canUse) {
            WirelessNetworkManager.strongCheckOrAddUser(this.getOwnerUuid());
        }
        this.power.setCanUseWireless(canUse, this.getOwnerUuid());
    }

    @Override
    public void setLaserSupport(boolean canUse) {
        this.power.setCanUseLaser(canUse);
    }

    @Override
    public void setMaxAmperage(long amperage) {
        this.power.setMaxAmperage(amperage);
    }

    public static class BuildState {
        boolean building = false;
        Vec3Impl currentOffset;

        public void startBuilding(Vec3Impl structureOffset) {
            if (this.building) {
                throw new IllegalStateException("Already building!");
            }
            this.building = true;
            this.setCurrentOffset(structureOffset);
        }

        public Vec3Impl setCurrentOffset(Vec3Impl structureOffset) {
            this.verifyBuilding();
            this.currentOffset = structureOffset;
            return this.currentOffset;
        }

        private void verifyBuilding() {
            if (!this.building) {
                throw new IllegalStateException("Not building!");
            }
        }

        public boolean failBuilding() {
            this.building = false;
            this.currentOffset = null;
            return false;
        }

        public Vec3Impl stopBuilding() {
            Vec3Impl toReturn = this.getCurrentOffset();
            this.building = false;
            this.currentOffset = null;
            return toReturn;
        }

        public Vec3Impl getCurrentOffset() {
            this.verifyBuilding();
            return this.currentOffset;
        }

        public Vec3Impl addOffset(Vec3Impl offset) {
            this.verifyBuilding();
            return this.setCurrentOffset(this.currentOffset.add(offset));
        }
    }
}

