/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import appeng.tile.powersink.IC2;
import cofh.api.energy.IEnergyReceiver;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.graphs.Node;
import gregtech.api.graphs.NodeList;
import gregtech.api.graphs.PowerNode;
import gregtech.api.graphs.PowerNodes;
import gregtech.api.graphs.consumers.ConsumerNode;
import gregtech.api.graphs.paths.NodePath;
import gregtech.api.graphs.paths.PowerNodePath;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityCable;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.GTCoverNone;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTGCCompat;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.GTClient;
import gregtech.common.covers.CoverInfo;
import gregtech.common.covers.CoverSolarPanel;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.reactor.IReactorChamber;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTECable
extends MetaPipeEntity
implements IMetaTileEntityCable {
    public final float mThickNess;
    public final Materials mMaterial;
    public final long mCableLossPerMeter;
    public final long mAmperage;
    public final long mVoltage;
    public final boolean mInsulated;
    public final boolean mCanShock;
    public int mTransferredAmperage = 0;

    public MTECable(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aID, aName, aNameRegional, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
    }

    public MTECable(String aName, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aName, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mAmperage = aAmperage;
        this.mVoltage = aVoltage;
        this.mInsulated = aInsulated;
        this.mCanShock = aCanShock;
        this.mCableLossPerMeter = aCableLossPerMeter;
    }

    @Override
    public byte getTileEntityBaseType() {
        return (byte)(this.mInsulated ? 9 : 8);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTECable(this.mName, this.mThickNess, this.mMaterial, this.mCableLossPerMeter, this.mAmperage, this.mVoltage, this.mInsulated, this.mCanShock);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, int facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (!this.mInsulated) {
            return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], Dyes.getModulation(colorIndex, this.mMaterial.mRGBa))};
        }
        if (active) {
            float tThickNess = this.getThickNess();
            if (tThickNess < 0.124f) {
                return new ITexture[]{TextureFactory.of(Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.374f) {
                return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_TINY, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.499f) {
                return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_SMALL, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.624f) {
                return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_MEDIUM, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.749f) {
                return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_MEDIUM_PLUS, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            if (tThickNess < 0.874f) {
                return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_LARGE, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
            }
            return new ITexture[]{TextureFactory.of(this.mMaterial.mIconSet.mTextures[69], this.mMaterial.mRGBa), TextureFactory.of(Textures.BlockIcons.INSULATION_HUGE, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
        }
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.INSULATION_FULL, Dyes.getModulation(colorIndex, Dyes.CABLE_INSULATION.mRGBa))};
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if (!this.mCanShock) {
            return;
        }
        BaseMetaPipeEntity baseEntity = (BaseMetaPipeEntity)this.getBaseMetaTileEntity();
        if (!(aEntity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase livingEntity = (EntityLivingBase)aEntity;
        NodePath nodePath = baseEntity.getNodePath();
        if (!(nodePath instanceof PowerNodePath)) {
            return;
        }
        PowerNodePath powerPath = (PowerNodePath)nodePath;
        if (this.isCoverOnSide(baseEntity, livingEntity)) {
            return;
        }
        if ((baseEntity.mConnections & 0x80) == 1) {
            return;
        }
        long amperage = powerPath.getAmperage();
        long voltage = powerPath.getVoltage();
        if (amperage == 0L) {
            return;
        }
        GTUtility.applyElectricityDamage(livingEntity, voltage, amperage);
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public final boolean renderInside(ForgeDirection side) {
        return false;
    }

    @Override
    public int getProgresstime() {
        return this.mTransferredAmperage * 64;
    }

    @Override
    public int maxProgresstime() {
        return (int)this.mAmperage * 64;
    }

    @Override
    public long injectEnergyUnits(ForgeDirection side, long voltage, long amperage) {
        if (!this.isConnectedAtSide(side) && side != ForgeDirection.UNKNOWN) {
            return 0L;
        }
        if (!this.getBaseMetaTileEntity().getCoverInfoAtSide(side).letsEnergyIn()) {
            return 0L;
        }
        return this.transferElectricity(side, voltage, amperage, (HashSet<TileEntity>)null);
    }

    @Override
    @Deprecated
    public long transferElectricity(ForgeDirection side, long aVoltage, long aAmperage, ArrayList<TileEntity> aAlreadyPassedTileEntityList) {
        return this.transferElectricity(side, aVoltage, aAmperage, new HashSet<TileEntity>(aAlreadyPassedTileEntityList));
    }

    @Override
    public long transferElectricity(ForgeDirection side, long voltage, long amperage, HashSet<TileEntity> alreadyPassedSet) {
        if (!this.getBaseMetaTileEntity().isServerSide() || !this.isConnectedAtSide(side) && side != ForgeDirection.UNKNOWN) {
            return 0L;
        }
        BaseMetaPipeEntity tBase = (BaseMetaPipeEntity)this.getBaseMetaTileEntity();
        Node node = tBase.getNode();
        if (!(node instanceof PowerNode)) {
            return 0L;
        }
        PowerNode tNode = (PowerNode)node;
        int tPlace = 0;
        Node[] tToPower = new Node[tNode.mConsumers.size()];
        if (tNode.mHadVoltage) {
            for (ConsumerNode consumer : tNode.mConsumers) {
                if (!consumer.needsEnergy()) continue;
                tToPower[tPlace++] = consumer;
            }
        } else {
            tNode.mHadVoltage = true;
            for (ConsumerNode consumer : tNode.mConsumers) {
                tToPower[tPlace++] = consumer;
            }
        }
        return PowerNodes.powerNode(tNode, null, new NodeList(tToPower), (int)voltage, (int)amperage);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aTick % 20L == 0L && aBaseMetaTileEntity.isServerSide() && (!GTMod.gregtechproxy.gt6Cable || this.mCheckConnections)) {
            this.checkConnections();
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GTMod.gregtechproxy.gt6Cable && GTModHandler.damageOrDechargeItem(aPlayer.field_71071_by.func_70448_g(), 1, 500, (EntityLivingBase)aPlayer)) {
            if (this.isConnectedAtSide(wrenchingSide)) {
                this.disconnect(wrenchingSide);
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("215", "Disconnected"));
            } else if (!GTMod.gregtechproxy.costlyCableConnection && this.connect(wrenchingSide) > 0) {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("214", "Connected"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GTMod.gregtechproxy.gt6Cable && GTModHandler.damageOrDechargeItem(aPlayer.field_71071_by.func_70448_g(), 1, 500, (EntityLivingBase)aPlayer)) {
            if (this.isConnectedAtSide(wrenchingSide)) {
                this.disconnect(wrenchingSide);
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("215", "Disconnected"));
            } else if ((!GTMod.gregtechproxy.costlyCableConnection || GTModHandler.consumeSolderingMaterial(aPlayer)) && this.connect(wrenchingSide) > 0) {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("214", "Connected"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean letsIn(CoverBehavior coverBehavior, ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsEnergyIn(side, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public boolean letsOut(CoverBehavior coverBehavior, ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsEnergyOut(side, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public boolean letsIn(CoverBehaviorBase<?> coverBehavior, ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsEnergyIn(side, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public boolean letsOut(CoverBehaviorBase<?> coverBehavior, ForgeDirection side, int aCoverID, ISerializableObject aCoverVariable, ICoverable aTileEntity) {
        return coverBehavior.letsEnergyOut(side, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public boolean letsIn(CoverInfo coverInfo) {
        return coverInfo.letsEnergyIn();
    }

    @Override
    public boolean letsOut(CoverInfo coverInfo) {
        return coverInfo.letsEnergyOut();
    }

    @Override
    public boolean canConnect(ForgeDirection side, TileEntity tileEntity) {
        TileEntity ic2Energy;
        IC2 ic2sink;
        IEnergyConnected energyConnected;
        PowerLogicHost powerLogic;
        IGregTechTileEntity baseMetaTile = this.getBaseMetaTileEntity();
        CoverBehaviorBase<?> coverBehavior = baseMetaTile.getCoverBehaviorAtSideNew(side);
        ForgeDirection oppositeSide = side.getOpposite();
        if (tileEntity instanceof PowerLogicHost && (powerLogic = (PowerLogicHost)tileEntity).getPowerLogic(oppositeSide) != null || tileEntity instanceof IEnergyConnected && ((energyConnected = (IEnergyConnected)tileEntity).inputEnergyFrom(oppositeSide, false) || energyConnected.outputsEnergyTo(oppositeSide, false))) {
            return true;
        }
        if (coverBehavior instanceof CoverSolarPanel) {
            return true;
        }
        if (Mods.GalacticraftCore.isModLoaded() && GTGCCompat.canConnect(tileEntity, oppositeSide)) {
            return true;
        }
        if (tileEntity instanceof IC2 && (ic2sink = (IC2)tileEntity).acceptsEnergyFrom((TileEntity)baseMetaTile, oppositeSide)) {
            return true;
        }
        if (tileEntity instanceof IReactorChamber) {
            ic2Energy = (TileEntity)((IReactorChamber)tileEntity).getReactor();
        } else {
            TileEntity tileEntity2 = ic2Energy = tileEntity == null || tileEntity instanceof IEnergyTile || EnergyNet.instance == null ? tileEntity : EnergyNet.instance.getTileEntity(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        }
        if (ic2Energy instanceof IEnergySink && ((IEnergySink)ic2Energy).acceptsEnergyFrom((TileEntity)baseMetaTile, oppositeSide)) {
            return true;
        }
        if (GTMod.gregtechproxy.ic2EnergySourceCompat && ic2Energy instanceof IEnergySource && ((IEnergySource)ic2Energy).emitsEnergyTo((TileEntity)baseMetaTile, oppositeSide)) {
            return true;
        }
        if (GregTechAPI.mOutputRF && tileEntity instanceof IEnergyReceiver && ((IEnergyReceiver)tileEntity).canConnectEnergy(oppositeSide)) {
            return true;
        }
        return GregTechAPI.mInputRF && tileEntity instanceof IEnergyEmitter && ((IEnergyEmitter)tileEntity).emitsEnergyTo((TileEntity)baseMetaTile, oppositeSide);
    }

    @Override
    public boolean getGT6StyleConnection() {
        return GTMod.gregtechproxy.gt6Cable;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{StatCollector.func_74838_a((String)"GT5U.item.cable.max_voltage") + ": %%%" + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mVoltage) + " (" + GTUtility.getColoredTierNameFromVoltage(this.mVoltage) + EnumChatFormatting.GREEN + ")" + EnumChatFormatting.GRAY, StatCollector.func_74838_a((String)"GT5U.item.cable.max_amperage") + ": %%%" + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mAmperage) + EnumChatFormatting.GRAY, StatCollector.func_74838_a((String)"GT5U.item.cable.loss") + ": %%%" + EnumChatFormatting.RED + GTUtility.formatNumbers(this.mCableLossPerMeter) + EnumChatFormatting.GRAY + "%%% " + StatCollector.func_74838_a((String)"GT5U.item.cable.eu_volt")};
    }

    @Override
    public float getThickNess() {
        if (GTMod.instance.isClientSide() && (GTClient.hideValue & 1) != 0) {
            return 0.0625f;
        }
        return this.mThickNess;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (GTMod.gregtechproxy.gt6Cable) {
            aNBT.func_74774_a("mConnections", this.mConnections);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (GTMod.gregtechproxy.gt6Cable) {
            this.mConnections = aNBT.func_74771_c("mConnections");
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        BaseMetaPipeEntity base = (BaseMetaPipeEntity)this.getBaseMetaTileEntity();
        PowerNodePath path = (PowerNodePath)base.getNodePath();
        if (path == null) {
            return new String[]{EnumChatFormatting.RED + "Failed to get Power Node info" + EnumChatFormatting.RESET};
        }
        long currAmp = path.getAmperage();
        long currVoltage = path.getVoltage();
        double avgAmp = path.getAvgAmperage();
        double avgVoltage = path.getAvgVoltage();
        long maxVoltageOut = (this.mVoltage - this.mCableLossPerMeter) * this.mAmperage;
        return new String[]{"Amperage: " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(currAmp) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mAmperage) + EnumChatFormatting.RESET + " A", "Voltage Out: " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(currVoltage) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxVoltageOut) + EnumChatFormatting.RESET + " EU/t", "Avg Amperage (20t): " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(avgAmp) + EnumChatFormatting.RESET + " A", "Avg Output (20t): " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(avgVoltage) + EnumChatFormatting.RESET + " EU/t"};
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        if (GTMod.instance.isClientSide() && (GTClient.hideValue & 2) != 0) {
            return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
        }
        return this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    private AxisAlignedBB getActualCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        byte tConn;
        float tSpace;
        float spaceDown = tSpace = (1.0f - this.mThickNess) / 2.0f;
        float spaceUp = 1.0f - tSpace;
        float spaceNorth = tSpace;
        float spaceSouth = 1.0f - tSpace;
        float spaceWest = tSpace;
        float spaceEast = 1.0f - tSpace;
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.DOWN) != 0) {
            spaceWest = 0.0f;
            spaceNorth = 0.0f;
            spaceDown = 0.0f;
            spaceEast = 1.0f;
            spaceSouth = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.UP) != 0) {
            spaceWest = 0.0f;
            spaceNorth = 0.0f;
            spaceEast = 1.0f;
            spaceSouth = 1.0f;
            spaceUp = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.NORTH) != 0) {
            spaceWest = 0.0f;
            spaceNorth = 0.0f;
            spaceDown = 0.0f;
            spaceEast = 1.0f;
            spaceUp = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.SOUTH) != 0) {
            spaceWest = 0.0f;
            spaceDown = 0.0f;
            spaceEast = 1.0f;
            spaceSouth = 1.0f;
            spaceUp = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.WEST) != 0) {
            spaceWest = 0.0f;
            spaceNorth = 0.0f;
            spaceDown = 0.0f;
            spaceSouth = 1.0f;
            spaceUp = 1.0f;
        }
        if (this.getBaseMetaTileEntity().getCoverIDAtSide(ForgeDirection.EAST) != 0) {
            spaceNorth = 0.0f;
            spaceDown = 0.0f;
            spaceEast = 1.0f;
            spaceSouth = 1.0f;
            spaceUp = 1.0f;
        }
        if (((tConn = ((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections) & ForgeDirection.DOWN.flag) != 0) {
            spaceDown = 0.0f;
        }
        if ((tConn & ForgeDirection.UP.flag) != 0) {
            spaceUp = 1.0f;
        }
        if ((tConn & ForgeDirection.NORTH.flag) != 0) {
            spaceNorth = 0.0f;
        }
        if ((tConn & ForgeDirection.SOUTH.flag) != 0) {
            spaceSouth = 1.0f;
        }
        if ((tConn & ForgeDirection.WEST.flag) != 0) {
            spaceWest = 0.0f;
        }
        if ((tConn & ForgeDirection.EAST.flag) != 0) {
            spaceEast = 1.0f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)aX + spaceWest), (double)((float)aY + spaceDown), (double)((float)aZ + spaceNorth), (double)((float)aX + spaceEast), (double)((float)aY + spaceUp), (double)((float)aZ + spaceSouth));
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB aabb;
        super.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
        if (GTMod.instance.isClientSide() && (GTClient.hideValue & 2) != 0 && inputAABB.func_72326_a(aabb = this.getActualCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ))) {
            outputAABB.add(aabb);
        }
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        if (!GTMod.gregtechproxy.ic2EnergySourceCompat) {
            return false;
        }
        if (this.mConnections != 0) {
            IGregTechTileEntity baseMeta = this.getBaseMetaTileEntity();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tEmitter;
                if (!this.isConnectedAtSide(side)) continue;
                TileEntity tTileEntity = baseMeta.getTileEntityAtSide(side);
                TileEntity tileEntity = tEmitter = tTileEntity == null || tTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? tTileEntity : EnergyNet.instance.getTileEntity(tTileEntity.func_145831_w(), tTileEntity.field_145851_c, tTileEntity.field_145848_d, tTileEntity.field_145849_e);
                if (!(tEmitter instanceof IEnergyEmitter)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void reloadLocks() {
        BaseMetaPipeEntity pipe = (BaseMetaPipeEntity)this.getBaseMetaTileEntity();
        if (pipe.getNode() != null) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                CoverInfo coverInfo;
                if (!this.isConnectedAtSide(side) || (coverInfo = pipe.getCoverInfoAtSide(side)).getCoverBehavior() instanceof GTCoverNone) continue;
                if (!this.letsIn(coverInfo) || !this.letsOut(coverInfo)) {
                    pipe.addToLock(pipe, side);
                    continue;
                }
                pipe.removeFromLock(pipe, side);
            }
        } else {
            boolean dontAllow = false;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                CoverInfo coverInfo;
                if (!this.isConnectedAtSide(side) || (coverInfo = pipe.getCoverInfoAtSide(side)).getCoverBehavior() instanceof GTCoverNone || this.letsIn(coverInfo) && this.letsOut(coverInfo)) continue;
                dontAllow = true;
            }
            if (dontAllow) {
                pipe.addToLock(pipe, ForgeDirection.DOWN);
            } else {
                pipe.removeFromLock(pipe, ForgeDirection.DOWN);
            }
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.item.cable.max_voltage") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mVoltage) + " (" + GTUtility.getColoredTierNameFromVoltage(this.mVoltage) + EnumChatFormatting.GREEN + ")");
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.item.cable.max_amperage") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mAmperage));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.item.cable.loss") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.mCableLossPerMeter) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.item.cable.eu_volt"));
    }
}

