/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.eig;

import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kubatech.api.utils.ItemUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class EIGDropTable {
    private static final String NBT_DROP_TABLE_ITEM_KEY = "item";
    private static final String NBT_DROP_TABLE_COUNT_KEY = "count";
    private final ItemStackMap<Double> dropTable = new ItemStackMap(true);

    public EIGDropTable() {
    }

    public EIGDropTable(NBTTagCompound nbt, String key) {
        this(nbt.func_150295_c(key, 10));
    }

    public EIGDropTable(NBTTagList nbt) {
        this();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound drop = nbt.func_150305_b(i);
            this.dropTable.merge(ItemUtils.readItemStackFromNBT(drop.func_74775_l(NBT_DROP_TABLE_ITEM_KEY)), (Object)drop.func_74769_h(NBT_DROP_TABLE_COUNT_KEY), Double::sum);
        }
    }

    public NBTTagList save() {
        NBTTagList nbt = new NBTTagList();
        for (Map.Entry entry : this.dropTable.entrySet()) {
            NBTTagCompound entryNBT = new NBTTagCompound();
            entryNBT.func_74782_a(NBT_DROP_TABLE_ITEM_KEY, (NBTBase)ItemUtils.writeItemStackToNBT((ItemStack)entry.getKey()));
            entryNBT.func_74780_a(NBT_DROP_TABLE_COUNT_KEY, ((Double)entry.getValue()).doubleValue());
            nbt.func_74742_a((NBTBase)entryNBT);
        }
        return nbt;
    }

    public void addDrop(ItemStack itemStack, double amount) {
        ItemStack key = itemStack.func_77946_l();
        key.field_77994_a = 1;
        this.dropTable.merge(key, (Object)amount, Double::sum);
    }

    public void addTo(EIGDropTable target, double variance, Random rand) {
        this.addTo(target, 1.0, variance, rand);
    }

    public void addTo(EIGDropTable target, double multiplier, double variance, Random rand) {
        this.addTo(target, variance * (rand.nextDouble() - 0.5) * multiplier);
    }

    public void addTo(EIGDropTable target) {
        this.addTo(target, 1.0);
    }

    public void addTo(EIGDropTable target, double multiplier) {
        for (Map.Entry entry : this.dropTable.entrySet()) {
            target.dropTable.merge((ItemStack)entry.getKey(), (Object)((Double)entry.getValue() * multiplier), Double::sum);
        }
    }

    public boolean isEmpty() {
        return this.dropTable.isEmpty();
    }

    public Set<Map.Entry<ItemStack, Double>> entrySet() {
        return this.dropTable.entrySet();
    }

    public double getItemAmount(ItemStack item) {
        if (this.dropTable.containsKey((Object)item)) {
            return (Double)this.dropTable.get((Object)item);
        }
        return 0.0;
    }

    public void setItemAmount(ItemStack item, double value) {
        this.dropTable.put(item, (Object)value);
    }

    public void removeItem(ItemStack item) {
        this.dropTable.remove((Object)item);
    }

    public EIGDropTable intersect(EIGDropTable with) {
        EIGDropTable ret = new EIGDropTable();
        for (ItemStack key : with.dropTable.keySet()) {
            if (!this.dropTable.containsKey((Object)key)) continue;
            ret.addDrop(key, (Double)this.dropTable.get((Object)key));
        }
        return ret;
    }

    public ItemStack[] getDrops() {
        return (ItemStack[])this.dropTable.entrySet().parallelStream().map(EIGDropTable::computeDrops).toArray(ItemStack[]::new);
    }

    private static ItemStack computeDrops(Map.Entry<ItemStack, Double> entry) {
        ItemStack copied = entry.getKey().func_77946_l();
        copied.field_77994_a = (int)Math.floor(entry.getValue());
        if (entry.getValue() >= 1.0) {
            entry.setValue(entry.getValue() % 1.0);
        }
        return copied;
    }
}

