/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.CoverLiquidMeter;
import gregtech.common.covers.redstone.CoverAdvancedRedstoneTransmitterBase;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverWirelessFluidDetector
extends CoverAdvancedRedstoneTransmitterBase<FluidTransmitterData> {
    public CoverWirelessFluidDetector(ITexture coverTexture) {
        super(FluidTransmitterData.class, coverTexture);
    }

    @Override
    public FluidTransmitterData createDataObject() {
        return new FluidTransmitterData();
    }

    @Override
    public FluidTransmitterData createDataObject(int aLegacyData) {
        return this.createDataObject();
    }

    @Override
    public FluidTransmitterData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, FluidTransmitterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        byte signal = CoverLiquidMeter.computeSignalBasedOnFluid(aTileEntity, aCoverVariable.invert, aCoverVariable.threshold);
        long hash = CoverWirelessFluidDetector.hashCoverCoords(aTileEntity, side);
        CoverWirelessFluidDetector.setSignalAt(aCoverVariable.getUuid(), aCoverVariable.getFrequency(), hash, signal);
        aTileEntity.setOutputRedstoneSignal(side, signal);
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, FluidTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(ForgeDirection side, int aCoverID, FluidTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new WirelessFluidDetectorUIFactory(buildContext).createWindow();
    }

    public static class FluidTransmitterData
    extends CoverAdvancedRedstoneTransmitterBase.TransmitterData {
        private int threshold;

        public FluidTransmitterData(int frequency, UUID uuid, boolean invert, int threshold) {
            super(frequency, uuid, invert);
            this.threshold = threshold;
        }

        public FluidTransmitterData() {
            this.threshold = 0;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FluidTransmitterData(this.frequency, this.uuid, this.invert, this.threshold);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = (NBTTagCompound)super.saveDataToNBT();
            tag.func_74768_a("threshold", this.threshold);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            super.writeToByteBuf(aBuf);
            aBuf.writeInt(this.threshold);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            super.loadDataFromNBT(aNBT);
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.threshold = tag.func_74762_e("threshold");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            super.readFromPacket(aBuf, aPlayer);
            this.threshold = aBuf.readInt();
            return this;
        }
    }

    private class WirelessFluidDetectorUIFactory
    extends CoverAdvancedRedstoneTransmitterBase.AdvancedRedstoneTransmitterBaseUIFactory {
        private int maxCapacity;

        public WirelessFluidDetectorUIFactory(CoverUIBuildContext buildContext) {
            super(CoverWirelessFluidDetector.this, buildContext);
        }

        @Override
        protected int getFrequencyRow() {
            return 0;
        }

        @Override
        protected int getButtonRow() {
            return 1;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            this.setMaxCapacity();
            super.addUIWidgets(builder);
            builder.widget(new TextWidget(GTUtility.trans("222", "Fluid threshold")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(100, 65));
        }

        protected void addUIForDataController(CoverDataControllerWidget<FluidTransmitterData> controller) {
            super.addUIForDataController(controller);
            controller.addFollower((Widget)new CoverDataFollowerNumericWidget(), coverData -> ((FluidTransmitterData)coverData).threshold, (coverData, state) -> {
                ((FluidTransmitterData)coverData).threshold = state.intValue();
                return coverData;
            }, widget -> widget.setBounds(0.0, this.maxCapacity > 0 ? (double)this.maxCapacity : 2.147483647E9).setScrollValues(1000.0, 144.0, 100000.0).setFocusOnGuiOpen(true).setPos(1, 38).setSize(86, 12));
        }

        private void setMaxCapacity() {
            ICoverable tile = this.getUIBuildContext().getTile();
            if (!tile.isDead() && tile instanceof IFluidHandler) {
                FluidTankInfo[] tanks = ((IFluidHandler)tile).getTankInfo(ForgeDirection.UNKNOWN);
                this.maxCapacity = Arrays.stream(tanks).mapToInt(tank -> tank.capacity).sum();
            } else {
                this.maxCapacity = -1;
            }
        }
    }
}

