/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import baubles.api.BaublesApi;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.gtnewhorizon.gtnhlib.api.MusicRecordMetadataProvider;
import com.jcraft.jorbis.VorbisFile;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.net.GTPacketMusicSystemData;
import gregtech.client.ElectricJukeboxSound;
import gregtech.common.items.ItemWirelessHeadphones;
import gregtech.common.tileentities.machines.basic.MTEBetterJukebox;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector4i;

public final class GTMusicSystem {
    private static final Object2IntOpenHashMap<ResourceLocation> musicRecordDurations = new Object2IntOpenHashMap();
    private static volatile boolean musicRecordsInitialized;

    private GTMusicSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object2IntOpenHashMap<ResourceLocation> getMusicRecordDurations() {
        if (musicRecordsInitialized) {
            return musicRecordDurations;
        }
        Object2IntOpenHashMap<ResourceLocation> object2IntOpenHashMap = musicRecordDurations;
        synchronized (object2IntOpenHashMap) {
            if (musicRecordsInitialized) {
                return musicRecordDurations;
            }
            Gson gson = new Gson();
            try {
                ArrayList<URL> candidates = Collections.list(GTMusicSystem.class.getClassLoader().getResources("soundmeta/durations.json"));
                Path configPath = Loader.instance().getConfigDir().toPath().resolve("soundmeta").resolve("durations.json");
                if (Files.exists(configPath, new LinkOption[0])) {
                    candidates.add(configPath.toUri().toURL());
                }
                for (URL url : candidates) {
                    try {
                        String objectJson = IOUtils.toString((URL)url);
                        SoundDurationsJson object = (SoundDurationsJson)gson.fromJson(objectJson, SoundDurationsJson.class);
                        if (object == null || object.soundDurationsMs == null || object.soundDurationsMs.isEmpty()) continue;
                        for (Map.Entry<String, Integer> entry : object.soundDurationsMs.entrySet()) {
                            musicRecordDurations.put((Object)new ResourceLocation(entry.getKey()), entry.getValue().intValue());
                        }
                    }
                    catch (Exception e) {
                        GTMod.GT_FML_LOGGER.error("Could not parse sound durations from {}", new Object[]{url, e});
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            musicRecordsInitialized = true;
            return musicRecordDurations;
        }
    }

    public static class SoundDurationsJson {
        public Map<String, Integer> soundDurationsMs = new TreeMap<String, Integer>();
    }

    public static final class ClientSystem {
        public static final Object2ObjectOpenHashMap<UUID, MusicSource> musicSources = new Object2ObjectOpenHashMap();
        private static final Object2ObjectOpenHashMap<UUID, ClientSourceData> activelyPlayingMusic = new Object2ObjectOpenHashMap(16);
        private static final ObjectOpenHashSet<UUID> wornHeadphones = new ObjectOpenHashSet();
        private static int currentDimension = Integer.MIN_VALUE;
        private static boolean soundsPaused = false;
        private static long pauseTimeMs = 0L;
        private static int tickCounter = 0;

        public static void loadUpdatedSources(ByteBuf bytes) {
            int sourceCount = ByteBufUtils.readVarInt((ByteBuf)bytes, (int)5);
            musicSources.clear();
            for (int i = 0; i < sourceCount; ++i) {
                MusicSource source = MusicSource.decode(bytes);
                musicSources.put((Object)source.sourceID, (Object)source);
            }
        }

        private static ElectricJukeboxSound makeRecord(MusicSource source, int emitter) {
            int x = source.emitterParameters[emitter * 5 + 0];
            int y = source.emitterParameters[emitter * 5 + 1];
            int z = source.emitterParameters[emitter * 5 + 2];
            float volume = (float)source.emitterParameters[emitter * 5 + 4] / 100.0f;
            return new ElectricJukeboxSound(source.currentRecord, volume, source.playingForMs, x, y, z);
        }

        public static void dumpAllRecordDurations() {
            try {
                Minecraft mc = Minecraft.func_71410_x();
                SoundRegistry sm = mc.func_147118_V().field_147697_e;
                SoundDurationsJson json = new SoundDurationsJson();
                Map allRecords = ItemRecord.field_150928_b;
                File tempFile = File.createTempFile("mcdecode", ".ogg");
                ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
                for (ItemRecord record : allRecords.values()) {
                    resources.clear();
                    if (record instanceof MusicRecordMetadataProvider) {
                        MusicRecordMetadataProvider mrmp = (MusicRecordMetadataProvider)record;
                        StreamSupport.stream(mrmp.getMusicRecordVariants().spliterator(), false).map(arg_0 -> ((MusicRecordMetadataProvider)mrmp).getMusicRecordResource(arg_0)).filter(Objects::nonNull).forEach(resources::add);
                    } else {
                        ResourceLocation res = record.getRecordResource(record.field_150929_a);
                        resources.add(new ResourceLocation(res.func_110624_b(), "records." + res.func_110623_a()));
                    }
                    for (ResourceLocation res : resources) {
                        try {
                            SoundEventAccessorComposite registryEntry = (SoundEventAccessorComposite)sm.func_82594_a((Object)res);
                            if (registryEntry == null) {
                                registryEntry = (SoundEventAccessorComposite)sm.func_82594_a((Object)res);
                            }
                            ResourceLocation realPath = registryEntry.func_148720_g().func_148652_a();
                            InputStream is = mc.func_110442_L().func_110536_a(realPath).func_110527_b();
                            try {
                                FileOutputStream os = FileUtils.openOutputStream((File)tempFile);
                                try {
                                    IOUtils.copy((InputStream)is, (OutputStream)os);
                                    ((OutputStream)os).close();
                                    VorbisFile vf = new VorbisFile(tempFile.getAbsolutePath());
                                    float totalSeconds = vf.time_total(-1);
                                    json.soundDurationsMs.put(res.toString(), (int)Math.ceil(totalSeconds * 1000.0f));
                                }
                                finally {
                                    if (os == null) continue;
                                    ((OutputStream)os).close();
                                }
                            }
                            finally {
                                if (is == null) continue;
                                is.close();
                            }
                        }
                        catch (Exception e) {
                            GTMod.GT_FML_LOGGER.warn("Skipping {}: {}", new Object[]{record.field_150929_a, res, e});
                        }
                    }
                }
                GTMod.GT_FML_LOGGER.info("Sound durations json: \n{}", new Object[]{new GsonBuilder().setPrettyPrinting().create().toJson((Object)json)});
                tempFile.delete();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static void reset() {
            musicSources.clear();
            ClientSystem.tick();
        }

        public static void tick() {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71438_f == null || mc.field_71441_e == null || mc.field_71439_g == null || mc.field_71441_e.field_73011_w == null) {
                return;
            }
            long now = System.currentTimeMillis();
            currentDimension = mc.field_71441_e.field_73011_w.field_76574_g;
            if (++tickCounter % 20 == 0) {
                wornHeadphones.clear();
                IInventory baubles = BaublesApi.getBaubles((EntityPlayer)mc.field_71439_g);
                if (baubles != null) {
                    int baublesSize = baubles.func_70302_i_();
                    for (int i = 0; i < baublesSize; ++i) {
                        Item item;
                        ItemStack item2 = baubles.func_70301_a(i);
                        if (item2 == null || !((item = item2.func_77973_b()) instanceof ItemWirelessHeadphones)) continue;
                        ItemWirelessHeadphones headphones = (ItemWirelessHeadphones)item;
                        UUID id = ItemWirelessHeadphones.getBoundJukeboxUUID(item2);
                        if (id == null) continue;
                        wornHeadphones.add((Object)id);
                    }
                }
            }
            activelyPlayingMusic.forEach((uuid, data) -> data.resetMark());
            musicSources.forEach((uuid, musicSource) -> {
                ClientSourceData data = (ClientSourceData)activelyPlayingMusic.computeIfAbsent(uuid, ignored -> new ClientSourceData());
                data.mark();
                if (data.currentSound != null && !mc.func_147118_V().func_147692_c((ISound)data.currentSound) && now - data.clientReferenceStartTime < (long)GTMusicSystem.getMusicRecordDurations().getOrDefault((Object)data.currentSoundResource, Integer.MAX_VALUE)) {
                    data.currentSound = null;
                    data.currentSoundResource = null;
                }
                boolean onHeadphones = wornHeadphones.contains(uuid);
                if (!data.equalSound((MusicSource)musicSource)) {
                    data.resetSound(mc, (MusicSource)musicSource, onHeadphones);
                } else {
                    data.updateSound(mc, (MusicSource)musicSource, onHeadphones);
                }
            });
            ObjectIterator entries = activelyPlayingMusic.object2ObjectEntrySet().fastIterator();
            while (entries.hasNext()) {
                ClientSourceData entry = (ClientSourceData)((Object2ObjectMap.Entry)entries.next()).getValue();
                if (entry.markFlag) continue;
                entry.clearSound(mc);
                entries.remove();
            }
        }

        @ApiStatus.Internal
        public static void onSoundBatchStop() {
            long now = System.currentTimeMillis();
            activelyPlayingMusic.forEach((uuid, data) -> {
                data.currentSound = null;
                data.currentSoundResource = null;
                MusicSource source = (MusicSource)musicSources.get(uuid);
                if (source == null) {
                    return;
                }
                source.playingForMs = now - data.clientReferenceStartTime;
            });
        }

        @ApiStatus.Internal
        public static void onSoundBatchPause() {
            if (soundsPaused) {
                return;
            }
            soundsPaused = true;
            pauseTimeMs = System.currentTimeMillis();
        }

        @ApiStatus.Internal
        public static void onSoundBatchResume() {
            if (!soundsPaused) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71438_f == null || mc.field_71441_e == null || mc.field_71439_g == null || mc.field_71441_e.field_73011_w == null) {
                return;
            }
            soundsPaused = false;
            if (!mc.func_71356_B() || mc.func_71401_C().func_71344_c()) {
                return;
            }
            long now = System.currentTimeMillis();
            long pauseDurationMs = now - pauseTimeMs;
            ServerSystem.onPauseMs(pauseDurationMs);
            musicSources.forEach((uuid, source) -> source.startedPlayingAtMs += pauseDurationMs);
            activelyPlayingMusic.forEach((uuid, data) -> {
                data.originalStartTime += pauseDurationMs;
                data.clientReferenceStartTime += pauseDurationMs;
            });
        }

        private static final class ClientSourceData {
            public ElectricJukeboxSound currentSound = null;
            public ResourceLocation currentSoundResource = null;
            public long originalStartTime = 0L;
            public long clientReferenceStartTime = 0L;
            public boolean markFlag = false;

            private ClientSourceData() {
            }

            public void resetMark() {
                this.markFlag = false;
            }

            public void mark() {
                this.markFlag = true;
            }

            public void clearSound(Minecraft mc) {
                this.currentSoundResource = null;
                if (this.currentSound != null) {
                    mc.func_147118_V().func_147683_b((ISound)this.currentSound);
                    this.currentSound = null;
                    this.originalStartTime = 0L;
                }
            }

            public boolean equalSound(MusicSource source) {
                if (source == null || source.currentRecord == null) {
                    return this.currentSoundResource == null;
                }
                return source.currentRecord.equals((Object)this.currentSoundResource) && this.originalStartTime == source.startedPlayingAtMs;
            }

            public void resetSound(Minecraft mc, MusicSource source, boolean onHeadphones) {
                int closestEmitter;
                this.clearSound(mc);
                if (source == null || source.emitterParameters.length == 0) {
                    return;
                }
                int n = closestEmitter = onHeadphones ? 0 : source.closestEmitter((int)Math.floor(mc.field_71439_g.field_70165_t), (int)Math.floor(mc.field_71439_g.field_70163_u), (int)Math.floor(mc.field_71439_g.field_70161_v), currentDimension);
                if (closestEmitter < 0) {
                    return;
                }
                this.currentSoundResource = source.currentRecord;
                this.originalStartTime = source.startedPlayingAtMs;
                this.clientReferenceStartTime = System.currentTimeMillis() - source.playingForMs;
                if (this.currentSoundResource != null) {
                    this.currentSound = ClientSystem.makeRecord(source, closestEmitter);
                    if (onHeadphones) {
                        this.currentSound.volume = 1.0E20f;
                    }
                    mc.func_147118_V().func_147682_a((ISound)this.currentSound);
                }
            }

            public void updateSound(Minecraft mc, MusicSource source, boolean onHeadphones) {
                int closestEmitter;
                if (source == null || this.currentSound == null || source.emitterParameters.length == 0) {
                    return;
                }
                int n = closestEmitter = onHeadphones ? 0 : source.closestEmitter((int)Math.floor(mc.field_71439_g.field_70165_t), (int)Math.floor(mc.field_71439_g.field_70163_u), (int)Math.floor(mc.field_71439_g.field_70161_v), currentDimension);
                if (closestEmitter < 0) {
                    this.currentSound.volume = 0.0f;
                    return;
                }
                int offset = closestEmitter * 5;
                this.currentSound.xPosition = source.emitterParameters[offset + 0];
                this.currentSound.yPosition = source.emitterParameters[offset + 1];
                this.currentSound.zPosition = source.emitterParameters[offset + 2];
                this.currentSound.volume = onHeadphones ? 1.0E20f : (float)source.emitterParameters[offset + 4] / 100.0f;
            }
        }
    }

    public static final class ServerSystem {
        static final Object2ObjectOpenHashMap<UUID, MusicSource> musicSources = new Object2ObjectOpenHashMap(32);
        static boolean musicSourcesDirty = false;
        private static boolean tickAnyDirty;

        public static synchronized MusicSource registerOrGetMusicSource(UUID uuid) {
            return (MusicSource)musicSources.computeIfAbsent((Object)uuid, id -> {
                musicSourcesDirty = true;
                return new MusicSource((UUID)id);
            });
        }

        public static synchronized void removeMusicSource(UUID uuid) {
            musicSources.remove((Object)uuid);
            musicSourcesDirty = true;
        }

        public static synchronized void reset() {
            musicSources.clear();
            musicSourcesDirty = true;
        }

        public static synchronized ByteBuf serialize() {
            ByteBuf out = Unpooled.buffer();
            ByteBufUtils.writeVarInt((ByteBuf)out, (int)musicSources.size(), (int)5);
            musicSources.forEach((uuid, source) -> source.encode(out));
            return out;
        }

        public static synchronized void tick() {
            long now = System.currentTimeMillis();
            tickAnyDirty = false;
            musicSources.forEach((uuid, source) -> {
                source.playingForMs = now - source.startedPlayingAtMs;
                tickAnyDirty |= source.modified;
                source.modified = false;
            });
            if (tickAnyDirty || musicSourcesDirty) {
                musicSourcesDirty = false;
                GTValues.NW.sendToAll(new GTPacketMusicSystemData(ServerSystem.serialize()));
            }
        }

        static synchronized void onPauseMs(long pauseDurationMs) {
            musicSources.forEach((uuid, source) -> source.startedPlayingAtMs += pauseDurationMs);
        }
    }

    public static final class MusicSource {
        public boolean modified;
        public final UUID sourceID;
        public ResourceLocation currentRecord;
        public MTEBetterJukebox.HeadphoneLimit headphoneLimit;
        public long startedPlayingAtMs;
        public long playingForMs;
        public final Vector4i originPosition = new Vector4i();
        public int headphoneBlockRange;
        public int[] emitterParameters;
        public static final int EMITTER_X = 0;
        public static final int EMITTER_Y = 1;
        public static final int EMITTER_Z = 2;
        public static final int EMITTER_DIMENSION = 3;
        public static final int EMITTER_VOLUME_X_100 = 4;
        public static final int EMITTER_STRIDE = 5;

        public MusicSource(UUID sourceID) {
            this.sourceID = sourceID;
        }

        public void resizeEmitterArray(int count) {
            int len = count * 5;
            if (this.emitterParameters == null || this.emitterParameters.length != len) {
                this.emitterParameters = this.emitterParameters == null ? new int[len] : Arrays.copyOf(this.emitterParameters, len);
                this.modified = true;
            }
        }

        public void setEmitter(int index, Vector4i position, float volume) {
            int intVolume;
            int arrIndex = index * 5;
            if (arrIndex < 0 || arrIndex >= this.emitterParameters.length) {
                throw new IndexOutOfBoundsException("Trying to access emitter with index " + index + " in an array of " + this.emitterParameters.length / 5);
            }
            if (this.emitterParameters[arrIndex + 0] != position.x) {
                this.modified = true;
                this.emitterParameters[arrIndex + 0] = position.x;
            }
            if (this.emitterParameters[arrIndex + 1] != position.y) {
                this.modified = true;
                this.emitterParameters[arrIndex + 1] = position.y;
            }
            if (this.emitterParameters[arrIndex + 2] != position.z) {
                this.modified = true;
                this.emitterParameters[arrIndex + 2] = position.z;
            }
            if (this.emitterParameters[arrIndex + 3] != position.w) {
                this.modified = true;
                this.emitterParameters[arrIndex + 3] = position.w;
            }
            if (this.emitterParameters[arrIndex + 4] != (intVolume = (int)(volume * 100.0f))) {
                this.modified = true;
                this.emitterParameters[arrIndex + 4] = intVolume;
            }
        }

        private static int sq(int x) {
            return x * x;
        }

        public int closestEmitter(int x, int y, int z, int dim) {
            int closest = -1;
            int closestDistanceSq = Integer.MAX_VALUE;
            int emittersCount = this.emitterParameters.length / 5;
            for (int i = 0; i < emittersCount; ++i) {
                int offset = i * 5;
                int eDim = this.emitterParameters[offset + 3];
                if (eDim != dim) continue;
                int eX = this.emitterParameters[offset + 0];
                int eY = this.emitterParameters[offset + 1];
                int eZ = this.emitterParameters[offset + 2];
                int distanceSq = MusicSource.sq(x - eX) + MusicSource.sq(y - eY) + MusicSource.sq(z - eZ);
                if (distanceSq >= closestDistanceSq) continue;
                closestDistanceSq = distanceSq;
                closest = i;
            }
            return closest;
        }

        public boolean inHeadphoneRange(int x, int y, int z, int dim) {
            boolean bl;
            switch (this.headphoneLimit) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case BETWEEN_DIMENSIONS: {
                    bl = true;
                    break;
                }
                case INSIDE_DIMENSION: {
                    if (dim == this.originPosition.w) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case BLOCK_RANGE: {
                    bl = dim == this.originPosition.w && this.originPosition.distanceSquared(x, y, z, dim) <= MusicSource.sq(this.headphoneBlockRange);
                }
            }
            return bl;
        }

        public void encode(ByteBuf target) {
            target.writeLong(this.sourceID.getMostSignificantBits());
            target.writeLong(this.sourceID.getLeastSignificantBits());
            if (this.currentRecord != null) {
                int duration = GTMusicSystem.getMusicRecordDurations().getOrDefault((Object)this.currentRecord, Integer.MAX_VALUE);
                if (this.playingForMs >= (long)duration) {
                    target.writeBoolean(false);
                } else {
                    target.writeBoolean(true);
                    ByteBufUtils.writeUTF8String((ByteBuf)target, (String)this.currentRecord.func_110624_b());
                    ByteBufUtils.writeUTF8String((ByteBuf)target, (String)this.currentRecord.func_110623_a());
                }
            } else {
                target.writeBoolean(false);
            }
            target.writeByte((int)((byte)this.headphoneLimit.ordinal()));
            ByteBufUtils.writeVarInt((ByteBuf)target, (int)this.headphoneBlockRange, (int)5);
            target.writeLong(this.startedPlayingAtMs);
            target.writeLong(this.playingForMs);
            ByteBufUtils.writeVarInt((ByteBuf)target, (int)this.originPosition.x, (int)5);
            ByteBufUtils.writeVarInt((ByteBuf)target, (int)this.originPosition.y, (int)5);
            ByteBufUtils.writeVarInt((ByteBuf)target, (int)this.originPosition.z, (int)5);
            ByteBufUtils.writeVarInt((ByteBuf)target, (int)this.originPosition.w, (int)5);
            ByteBufUtils.writeVarInt((ByteBuf)target, (int)this.emitterParameters.length, (int)5);
            for (int emitterParameter : this.emitterParameters) {
                ByteBufUtils.writeVarInt((ByteBuf)target, (int)emitterParameter, (int)5);
            }
        }

        public static MusicSource decode(ByteBuf bytes) {
            long uuidMsb = bytes.readLong();
            long uuidLsb = bytes.readLong();
            MusicSource source = new MusicSource(new UUID(uuidMsb, uuidLsb));
            boolean hasRecord = bytes.readBoolean();
            if (hasRecord) {
                String domain = ByteBufUtils.readUTF8String((ByteBuf)bytes);
                String path = ByteBufUtils.readUTF8String((ByteBuf)bytes);
                source.currentRecord = new ResourceLocation(domain, path);
            }
            source.headphoneLimit = (MTEBetterJukebox.HeadphoneLimit)((Object)MTEBetterJukebox.HeadphoneLimit.ENTRIES.get((int)bytes.readByte()));
            source.headphoneBlockRange = ByteBufUtils.readVarInt((ByteBuf)bytes, (int)5);
            source.startedPlayingAtMs = bytes.readLong();
            source.playingForMs = bytes.readLong();
            int originX = ByteBufUtils.readVarInt((ByteBuf)bytes, (int)5);
            int originY = ByteBufUtils.readVarInt((ByteBuf)bytes, (int)5);
            int originZ = ByteBufUtils.readVarInt((ByteBuf)bytes, (int)5);
            int originW = ByteBufUtils.readVarInt((ByteBuf)bytes, (int)5);
            source.originPosition.set(originX, originY, originZ, originW);
            int emittersLength = ByteBufUtils.readVarInt((ByteBuf)bytes, (int)5);
            source.emitterParameters = new int[emittersLength];
            for (int i = 0; i < emittersLength; ++i) {
                source.emitterParameters[i] = ByteBufUtils.readVarInt((ByteBuf)bytes, (int)5);
            }
            return source;
        }

        public void setRecord(ResourceLocation record) {
            this.setRecord(record, 0L);
        }

        public void setRecord(ResourceLocation record, long seekOffset) {
            this.modified = true;
            this.currentRecord = record;
            this.playingForMs = seekOffset;
            this.startedPlayingAtMs = System.currentTimeMillis() - seekOffset;
        }
    }
}

