/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.common.WirelessComputationPacket;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.dataTransport.QuantumDataPacket;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataOutput;

public class MTEHatchWirelessComputationOutput
extends MTEHatchDataOutput {
    private int clearDelay = 0;
    private static String[] tooltips;

    public MTEHatchWirelessComputationOutput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public MTEHatchWirelessComputationOutput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchWirelessComputationOutput(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean canConnectData(ForgeDirection side) {
        return false;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("clearDelay")) {
            this.clearDelay = aNBT.func_74762_e("clearDelay");
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("clearDelay", this.clearDelay);
    }

    @Override
    public void providePacket(QuantumDataPacket packet) {
        super.providePacket(packet);
        this.clearDelay = 21;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.q != null) {
            WirelessComputationPacket.uploadData(aBaseMetaTileEntity.getOwnerUuid(), (Long)((QuantumDataPacket)this.q).getContent(), aTick);
            if (this.clearDelay-- == 0) {
                this.q = null;
            }
        }
    }

    @Override
    public String[] getDescription() {
        if (tooltips == null) {
            tooltips = new String[]{"Wireless Computation Output for Multiblocks"};
        }
        return tooltips;
    }
}

