/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.PowerLogic;
import gregtech.api.logic.interfaces.PowerLogicHost;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.util.GTUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.mechanics.pipe.IConnectsToEnergyTunnel;
import tectech.thing.metaTileEntity.Textures;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyTunnel;
import tectech.thing.metaTileEntity.pipe.MTEPipeEnergy;
import tectech.thing.metaTileEntity.pipe.MTEPipeEnergyMirror;
import tectech.util.CommonValues;
import tectech.util.TTUtility;

public class MTEHatchDynamoTunnel
extends MTEHatchDynamoMulti
implements IConnectsToEnergyTunnel {
    public MTEHatchDynamoTunnel(int ID, String unlocalisedName, String localisedName, int tier, int amps) {
        super(ID, unlocalisedName, localisedName, tier, 0, new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dynamotunnel.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.screwdrivertooltip"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dynamotunnel.desc.1") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers((long)amps * GTValues.V[tier]) + EnumChatFormatting.RESET + " EU/t"}, amps);
        TTUtility.setTier(tier, this);
    }

    public MTEHatchDynamoTunnel(String aName, int aTier, int aAmp, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aAmp, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.OVERLAYS_ENERGY_OUT_LASER_TT[this.mTier]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.OVERLAYS_ENERGY_OUT_LASER_TT[this.mTier]};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * 24L * (long)this.Amperes;
    }

    @Override
    public boolean isEnetOutput() {
        return false;
    }

    @Override
    public boolean isEnetInput() {
        return false;
    }

    @Override
    public MTEHatch.ConnectionType getConnectionType() {
        return MTEHatch.ConnectionType.LASER;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchDynamoTunnel(this.mName, (int)this.mTier, this.Amperes, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        byte Tick;
        if (aBaseMetaTileEntity.isServerSide() && 16 == (Tick = (byte)(aTick % 20L))) {
            if (aBaseMetaTileEntity.getStoredEU() > 0L) {
                this.setEUVar(aBaseMetaTileEntity.getStoredEU() - (long)this.Amperes);
                if (aBaseMetaTileEntity.getStoredEU() < 0L) {
                    this.setEUVar(0L);
                }
            }
            if (aBaseMetaTileEntity.getStoredEU() > this.getMinimumStoredEU()) {
                this.moveAround(aBaseMetaTileEntity);
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.Amperes != this.maxAmperes) {
            aNBT.func_74768_a("amperes", this.Amperes);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        int savedAmperes = aNBT.func_74762_e("amperes");
        if (savedAmperes != 0) {
            this.Amperes = savedAmperes;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void moveAround(IGregTechTileEntity aBaseMetaTileEntity) {
        byte color = this.getBaseMetaTileEntity().getColorization();
        if (color < 0) {
            return;
        }
        ForgeDirection front = aBaseMetaTileEntity.getFrontFacing();
        ForgeDirection opposite = front.getOpposite();
        for (int dist = 1; dist < 1000; dist = (int)((short)(dist + 1))) {
            IGregTechTileEntity tGTTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSideAndDistance(front, dist);
            if (tGTTileEntity == null || tGTTileEntity.getColorization() != color) return;
            IMetaTileEntity aMetaTileEntity = tGTTileEntity.getMetaTileEntity();
            if (aMetaTileEntity != null) {
                if (aMetaTileEntity instanceof MTEPipeEnergyMirror) {
                    MTEPipeEnergyMirror tMirror = (MTEPipeEnergyMirror)aMetaTileEntity;
                    tGTTileEntity = tMirror.bendAround(opposite);
                    if (tGTTileEntity == null) return;
                    aMetaTileEntity = tGTTileEntity.getMetaTileEntity();
                    opposite = tMirror.getChainedFrontFacing();
                }
                if (aMetaTileEntity instanceof MTEHatchEnergyTunnel && opposite == tGTTileEntity.getFrontFacing()) {
                    if (this.maxEUOutput() > ((MTEHatchEnergyTunnel)aMetaTileEntity).maxEUInput()) {
                        aMetaTileEntity.doExplosion(this.maxEUOutput());
                        this.setEUVar(aBaseMetaTileEntity.getStoredEU() - this.maxEUOutput());
                        return;
                    }
                    if (this.maxEUOutput() != ((MTEHatchEnergyTunnel)aMetaTileEntity).maxEUInput()) return;
                    long diff = Math.min((long)this.Amperes * 20L * this.maxEUOutput(), Math.min(((MTEHatchEnergyTunnel)aMetaTileEntity).maxEUStore() - aMetaTileEntity.getBaseMetaTileEntity().getStoredEU(), aBaseMetaTileEntity.getStoredEU()));
                    this.setEUVar(aBaseMetaTileEntity.getStoredEU() - diff);
                    ((MTEHatchEnergyTunnel)aMetaTileEntity).setEUVar(aMetaTileEntity.getBaseMetaTileEntity().getStoredEU() + diff);
                    return;
                }
                if (!(aMetaTileEntity instanceof MTEPipeEnergy)) return;
                if (((MTEPipeEnergy)aMetaTileEntity).connectionCount < 2) {
                    return;
                }
            } else {
                if (!(tGTTileEntity instanceof PowerLogicHost)) return;
                PowerLogic logic = ((PowerLogicHost)((Object)tGTTileEntity)).getPowerLogic(opposite);
                if (logic == null || !logic.canUseLaser() || opposite != tGTTileEntity.getFrontFacing()) {
                    return;
                }
                long ampsUsed = logic.injectEnergy(this.maxEUOutput(), this.Amperes);
                this.setEUVar(aBaseMetaTileEntity.getStoredEU() - ampsUsed * this.maxEUOutput());
                return;
            }
            ((MTEPipeEnergy)aMetaTileEntity).markUsed();
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        GTUIInfos.openGTTileEntityUI(this.getBaseMetaTileEntity(), aPlayer);
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        int x = this.getGUIWidth() / 2 - 37;
        int y = this.getGUIHeight() / 5 - 7;
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GT5U.machines.laser_hatch.amperage", (Object[])new Object[0]).setPos(x, y).setSize(74, 14))).widget(new NumericWidget().setSetter(val -> {
            this.Amperes = (int)val;
        }).setGetter(() -> this.Amperes).setBounds(1.0, (double)this.maxAmperes).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(x, y + 16).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return this.isOutputFacing(side);
    }
}

