/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity.recipe.beamline;

import com.gtnewhorizons.modularui.api.math.Pos2d;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTUtility;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.nei.GTNEIDefaultHandler;
import gregtech.nei.RecipeDisplayInfo;
import gtnhlanth.util.Util;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class TargetChamberFrontend
extends RecipeMapFrontend {
    public TargetChamberFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder);
    }

    @Override
    public void drawDescription(RecipeDisplayInfo recipeInfo) {
        this.drawEnergyInfo(recipeInfo);
        this.drawSpecialInfo(recipeInfo);
        this.drawMetadataInfo(recipeInfo);
        this.drawRecipeOwnerInfo(recipeInfo);
    }

    @Override
    protected void drawNEIOverlayForInput(GTNEIDefaultHandler.FixedPositionedStack stack) {
        if (stack.isNotConsumed()) {
            this.drawNEIOverlayText("PC", stack);
        }
    }

    @Override
    protected List<String> handleNEIItemInputTooltip(List<String> currentTip, GTNEIDefaultHandler.FixedPositionedStack pStack) {
        if (pStack.isNotConsumed()) {
            currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"gtnhlanth.tt.pc"));
        }
        return currentTip;
    }

    @Override
    public void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        if (recipeInfo.calculator.getConsumption() <= 0L) {
            return;
        }
        recipeInfo.drawText(GTUtility.trans("153", "Usage: ") + this.getEUtDisplay(recipeInfo.calculator));
        recipeInfo.drawText(GTUtility.trans("154", "Voltage: ") + this.getVoltageString(recipeInfo.calculator));
        recipeInfo.drawText(GTUtility.trans("155", "Amperage: ") + this.getAmperageString(recipeInfo.calculator));
    }

    @Override
    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return UIHelper.getGridPositions(itemOutputCount, 128, 24, 1, 3);
    }

    @Override
    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return Util.getGridPositions(itemInputCount, 8, 20, 3, 1, 20);
    }

    private String getEUtDisplay(OverclockCalculator calculator) {
        return this.getEUtWithoutTier(calculator);
    }

    private String getEUtWithoutTier(OverclockCalculator calculator) {
        return GTUtility.formatNumbers(calculator.getConsumption()) + " EU/t";
    }

    private String getVoltageString(OverclockCalculator calculator) {
        long voltage = this.computeVoltageForEURate(calculator.getConsumption());
        return GTUtility.formatNumbers(voltage) + " EU/t" + GTUtility.getTierNameWithParentheses(voltage);
    }

    private long computeVoltageForEURate(long euPerTick) {
        return euPerTick;
    }

    private String getAmperageString(OverclockCalculator calculator) {
        return GTUtility.formatNumbers(1L);
    }
}

