/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity;

import bartworks.common.loaders.ItemRegistry;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gtnhlanth.common.beamline.BeamInformation;
import gtnhlanth.common.beamline.BeamLinePacket;
import gtnhlanth.common.beamline.Particle;
import gtnhlanth.common.hatch.MTEBusInputFocus;
import gtnhlanth.common.hatch.MTEHatchInputBeamline;
import gtnhlanth.common.register.LanthItemList;
import gtnhlanth.common.tileentity.recipe.beamline.BeamlineRecipeAdder2;
import gtnhlanth.common.tileentity.recipe.beamline.RecipeTC;
import gtnhlanth.util.DescTextLocalization;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTETargetChamber
extends MTEEnhancedMultiBlockBase<MTETargetChamber>
implements ISurvivalConstructable {
    private static final IStructureDefinition<MTETargetChamber> STRUCTURE_DEFINITION;
    private final ArrayList<MTEHatchInputBeamline> mInputBeamline = new ArrayList();
    private final ArrayList<MTEBusInputFocus> mInputFocus = new ArrayList();
    private static final int CASING_INDEX_FRONT;
    private static final int CASING_INDEX_CENTRE;
    private float inputEnergy;
    private float inputRate;
    private int inputParticle;
    private float inputFocus;

    private boolean addGlass(Block block, int meta) {
        return block == ItemRegistry.bw_glasses[0];
    }

    private boolean addBeamLineInputHatch(IGregTechTileEntity te, int casingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte == null) {
            return false;
        }
        if (mte instanceof MTEHatchInputBeamline) {
            return this.mInputBeamline.add((MTEHatchInputBeamline)mte);
        }
        return false;
    }

    private boolean addFocusInputHatch(IGregTechTileEntity te, int casingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte == null) {
            return false;
        }
        if (mte instanceof MTEBusInputFocus) {
            return this.mInputFocus.add((MTEBusInputFocus)mte);
        }
        return false;
    }

    public MTETargetChamber(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public MTETargetChamber(String name) {
        super(name);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity te) {
        return new MTETargetChamber(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47]};
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Collision Chamber").addInfo("Hitting things with other things").addInfo(DescTextLocalization.BEAMLINE_SCANNER_INFO).beginStructureBlock(5, 5, 6, true).addController("Front bottom").addCasingInfoExactly("Grate Machine Casing", 29, false).addCasingInfoExactly("Shielded Accelerator Casing", 28, false).addCasingInfoExactly("Borosilicate Glass", 16, true).addCasingInfoExactly(LanthItemList.SHIELDED_ACCELERATOR_GLASS.func_149732_F(), 34, false).addCasingInfoExactly(LanthItemList.TARGET_RECEPTACLE_CASING.func_149732_F(), 4, false).addCasingInfoExactly(LanthItemList.FOCUS_MANIPULATION_CASING.func_149732_F(), 4, false).addCasingInfoExactly(LanthItemList.FOCUS_HOLDER.func_149732_F(), 1, false).addCasingInfoExactly(LanthItemList.TARGET_HOLDER.func_149732_F(), 1, false).addOtherStructurePart("Focus Input Bus", DescTextLocalization.addDotText(1)).addMaintenanceHatch(DescTextLocalization.addDotText(2)).addEnergyHatch(DescTextLocalization.addDotText(2)).addInputBus(DescTextLocalization.addDotText(3)).addOutputBus(DescTextLocalization.addDotText(4)).addOtherStructurePart("Beamline Input Hatch", DescTextLocalization.addDotText(5)).toolTipFinisher(new String[0]);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("base", stackSize, hintsOnly, 2, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece("base", stackSize, 2, 4, 0, elementBudget, env, false, true);
    }

    @Override
    public IStructureDefinition<MTETargetChamber> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return BeamlineRecipeAdder2.instance.TargetChamberRecipes;
    }

    @Override
    public boolean checkRecipe(ItemStack itemStack) {
        ItemStack[] itemOutputArray;
        this.inputEnergy = 0.0f;
        this.inputRate = 0.0f;
        this.inputParticle = 0;
        this.inputFocus = 0.0f;
        ArrayList<ItemStack> tItems = this.getStoredInputs();
        ItemStack tFocusItem = this.getFocusItemStack();
        ItemStack tFocusItemZeroDamage = null;
        if (tFocusItem != null) {
            tFocusItemZeroDamage = tFocusItem.func_77946_l();
            tFocusItemZeroDamage.func_77964_b(0);
        }
        ArrayList<ItemStack> tItemsWithFocusItem = new ArrayList<ItemStack>();
        tItemsWithFocusItem.add(tFocusItemZeroDamage);
        tItemsWithFocusItem.addAll(tItems);
        long tVoltage = this.getMaxInputVoltage();
        ItemStack[] tItemsArray = tItems.toArray(new ItemStack[0]);
        ItemStack[] tItemsWithFocusItemArray = tItemsWithFocusItem.toArray(new ItemStack[0]);
        RecipeTC tRecipe = (RecipeTC)BeamlineRecipeAdder2.instance.TargetChamberRecipes.findRecipeQuery().items(tItemsWithFocusItemArray).voltage(tVoltage).filter(recipe -> {
            RecipeTC recipeTc = (RecipeTC)recipe;
            int particle = recipeTc.particleId;
            BeamInformation inputInfo = this.getInputInformation();
            return particle == inputInfo.getParticleId() && !(inputInfo.getEnergy() < recipeTc.minEnergy) && !(inputInfo.getEnergy() > recipeTc.maxEnergy);
        }).find();
        if (tRecipe == null) {
            return false;
        }
        BeamInformation inputInfo = this.getInputInformation();
        if (inputInfo == null) {
            return false;
        }
        this.inputEnergy = inputInfo.getEnergy();
        this.inputRate = inputInfo.getRate();
        this.inputParticle = inputInfo.getParticleId();
        this.inputFocus = inputInfo.getFocus();
        if (this.inputEnergy < tRecipe.minEnergy || this.inputEnergy > tRecipe.maxEnergy) {
            return false;
        }
        if (this.inputFocus < tRecipe.minFocus) {
            return false;
        }
        if (this.inputParticle != tRecipe.particleId) {
            return false;
        }
        if (tRecipe.focusItem != null && tRecipe.focusItem.func_77973_b() != tFocusItem.func_77973_b()) {
            return false;
        }
        int focusDurabilityDepletion = 1;
        float progressTime = (float)tRecipe.amount / this.inputRate * 5.0f * 20.0f;
        int batchAmount = 1;
        if (progressTime < 1.0f) {
            int maskLimit;
            batchAmount = (int)Math.round(1.0 / (double)progressTime);
            if (tRecipe.focusItem != null && batchAmount > (maskLimit = tFocusItem.func_77958_k() - tFocusItem.func_77960_j() + 1)) {
                batchAmount = maskLimit;
            }
            progressTime = 1.0f;
        }
        this.mMaxProgresstime = (int)progressTime;
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        double maxParallel = tRecipe.maxParallelCalculatedByInputs(batchAmount, new FluidStack[0], tItemsWithFocusItemArray);
        if (maxParallel < 1.0) {
            return false;
        }
        if ((double)batchAmount > maxParallel) {
            batchAmount = (int)maxParallel;
        }
        tRecipe.consumeInput(batchAmount, new FluidStack[0], tItemsWithFocusItemArray);
        focusDurabilityDepletion = batchAmount;
        for (ItemStack stack : itemOutputArray = GTUtility.copyItemArray(tRecipe.mOutputs)) {
            stack.field_77994_a *= batchAmount;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mEUt = (int)(-tVoltage);
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mOutputItems = itemOutputArray;
        if (tRecipe.focusItem != null) {
            this.mInputFocus.get(0).depleteFocusDurability(focusDurabilityDepletion);
        }
        this.updateSlots();
        return true;
    }

    private BeamInformation getInputInformation() {
        Iterator<MTEHatchInputBeamline> iterator = this.mInputBeamline.iterator();
        if (iterator.hasNext()) {
            MTEHatchInputBeamline in = iterator.next();
            if (in.q == null) {
                return new BeamInformation(0.0f, 0, 0, 0.0f);
            }
            return (BeamInformation)((BeamLinePacket)in.q).getContent();
        }
        return null;
    }

    private ItemStack getFocusItemStack() {
        Iterator<MTEBusInputFocus> iterator = this.mInputFocus.iterator();
        if (iterator.hasNext()) {
            MTEBusInputFocus hatch = iterator.next();
            if (hatch.getContentUsageSlots().isEmpty()) {
                return null;
            }
            return hatch.getContentUsageSlots().get(0);
        }
        return null;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity arg0, ItemStack arg1) {
        this.mInputBeamline.clear();
        this.mInputFocus.clear();
        if (!this.checkPiece("base", 2, 4, 0)) {
            return false;
        }
        return this.mInputBeamline.size() == 1 && this.mMaintenanceHatches.size() == 1 && this.mInputBusses.size() == 1 && this.mOutputBusses.size() == 1 && this.mInputFocus.size() == 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack arg0) {
        return false;
    }

    @Override
    public int getDamageToComponent(ItemStack arg0) {
        return 0;
    }

    @Override
    public int getMaxEfficiency(ItemStack arg0) {
        return 10000;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack arg0) {
        return true;
    }

    @Override
    public String[] getStructureDescription(ItemStack arg0) {
        return DescTextLocalization.addText("TargetChamber.hint", 13);
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchEnergy tHatch : this.mEnergyHatches) {
            if (!tHatch.isValid()) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        BeamInformation information = this.getInputInformation();
        if (information == null) {
            information = new BeamInformation(0.0f, 0, 0, 0.0f);
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.getActualEnergyUsage()) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"beamline.in_pre") + ": " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.particle") + ": " + EnumChatFormatting.GOLD + Particle.getParticleFromId(information.getParticleId()).getLocalisedName() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.energy") + ": " + EnumChatFormatting.DARK_RED + information.getEnergy() * 1000.0f + EnumChatFormatting.RESET + " eV", StatCollector.func_74838_a((String)"beamline.focus") + ": " + EnumChatFormatting.BLUE + information.getFocus() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.amount") + ": " + EnumChatFormatting.LIGHT_PURPLE + information.getRate()};
    }

    static {
        CASING_INDEX_FRONT = GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings3, 10);
        CASING_INDEX_CENTRE = GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings5, 14);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("base", (String[][])new String[][]{{"ggggg", "gjjjg", "gjbjg", "gjjjg", "ff~ff"}, {"cslsc", "s-r-s", "srhrs", "s-r-s", "ccccc"}, {"csssc", "s---s", "s---s", "s---s", "ccccc"}, {"csssc", "s---s", "s---s", "s---s", "ccccc"}, {"cstsc", "s-u-s", "suius", "s-u-s", "ccccc"}, {"ggggg", "gjjjg", "gjojg", "gjjjg", "ggggg"}}).addElement('g', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10)).addElement('f', GTStructureUtility.buildHatchAdder(MTETargetChamber.class).atLeast(HatchElement.Maintenance, HatchElement.Energy).casingIndex(CASING_INDEX_FRONT).dot(2).buildAndChain(StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10))).addElement('j', StructureUtility.ofBlockAdder(MTETargetChamber::addGlass, (Block)ItemRegistry.bw_glasses[0], (int)1)).addElement('b', GTStructureUtility.buildHatchAdder(MTETargetChamber.class).hatchClass(MTEHatchInputBeamline.class).casingIndex(CASING_INDEX_CENTRE).dot(5).adder(MTETargetChamber::addBeamLineInputHatch).build()).addElement('c', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_CASING, (int)0)).addElement('l', GTStructureUtility.buildHatchAdder(MTETargetChamber.class).hatchClass(MTEBusInputFocus.class).casingIndex(CASING_INDEX_CENTRE).dot(1).adder(MTETargetChamber::addFocusInputHatch).build()).addElement('t', GTStructureUtility.buildHatchAdder(MTETargetChamber.class).atLeast(HatchElement.InputBus).casingIndex(CASING_INDEX_CENTRE).dot(3).build()).addElement('s', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_GLASS, (int)0)).addElement('r', StructureUtility.ofBlock((Block)LanthItemList.FOCUS_MANIPULATION_CASING, (int)0)).addElement('h', StructureUtility.ofBlock((Block)LanthItemList.FOCUS_HOLDER, (int)0)).addElement('u', StructureUtility.ofBlock((Block)LanthItemList.TARGET_RECEPTACLE_CASING, (int)0)).addElement('i', StructureUtility.ofBlock((Block)LanthItemList.TARGET_HOLDER, (int)0)).addElement('o', GTStructureUtility.buildHatchAdder(MTETargetChamber.class).atLeast(HatchElement.OutputBus).casingIndex(CASING_INDEX_CENTRE).dot(4).build()).build();
    }
}

