/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import forestry.api.arboriculture.IToolGrafter;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Mods;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.VoidProtectionHelper;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import gregtech.common.pollution.PollutionConfig;
import gregtech.common.tileentities.machines.MTEHatchInputBusME;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechTools;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class MTETreeFarm
extends GTPPMultiBlockBase<MTETreeFarm>
implements ISurvivalConstructable {
    public static int CASING_TEXTURE_ID;
    private static final int TICKS_PER_OPERATION = 100;
    private static final int TOOL_DAMAGE_PER_OPERATION = 1;
    private static final int TOOL_CHARGE_PER_OPERATION = 32;
    private int mCasing;
    public static String mCasingName;
    private static IStructureDefinition<MTETreeFarm> STRUCTURE_DEFINITION;
    private static final EnumMap<Mode, Integer> modeMultiplier;
    public static final HashMap<String, EnumMap<Mode, ItemStack>> treeProductsMap;
    private static final ItemStack[][] altToolsForNEI;

    public MTETreeFarm(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(1, 15);
    }

    public MTETreeFarm(String aName) {
        super(aName);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(1, 15);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETreeFarm(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Tree Farm";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Farms and harvests trees using EU").addInfo("Place a sapling in the controller slot").addInfo("Place a tool in an input bus").addInfo("Different tools are required for different outputs").addInfo("Advanced tools multiply output amount").addInfo("  Logs: Saw (1x), Buzzsaw (2x), Chainsaw (4x)").addInfo("  Saplings: Branch Cutter (1x), Grafter (4x)").addInfo("  Leaves: Shears (1x), Wire Cutter (2x), Automatic Snips (4x)").addInfo("  Fruit: Knife (1x)").addInfo("Multiple tools can be used at the same time").addSeparator().addInfo("Work time is fixed at 5 seconds").addInfo("Energy input tier multiplies output further").addInfo("Output multiplier is equal to: 2*tier^2 - 2*tier + 5").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfoMin(mCasingName, 8, false).addInputBus("Any casing", 1).addStructureInfo(EnumChatFormatting.YELLOW + "Stocking Input Busses and Crafting Input Busses/Buffers are not allowed!").addOutputBus("Any casing", 1).addEnergyHatch("Any casing", 1).addMaintenanceHatch("Any casing", 1).addMufflerHatch("Any casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCATreeFarmActive;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCATreeFarm;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_TEXTURE_ID;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 8 && this.checkHatch();
    }

    @Override
    public boolean addInputBusToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInputBusME) {
            return false;
        }
        return super.addInputBusToMachineList(aTileEntity, aBaseCasingIndex);
    }

    @Override
    public boolean supportsCraftingMEBuffer() {
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public boolean supportsBatchMode() {
        return false;
    }

    @Override
    public boolean isBatchModeEnabled() {
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiTreeFarm;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IStructureDefinition<MTETreeFarm> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTETreeFarm.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy.or(GTPPMultiBlockBase.GTPPHatchElement.TTEnergy), HatchElement.Muffler).casingIndex(CASING_TEXTURE_ID).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)15)))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        if (this.isValidSapling(aStack)) {
            return true;
        }
        return aStack.func_77973_b() instanceof MetaGeneratedTool01;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.treeGrowthSimulatorFakeRecipes;
    }

    private static int getTierMultiplier(int tier) {
        return 2 * (tier * tier) - 2 * tier + 5;
    }

    @Override
    public ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            public CheckRecipeResult process() {
                Mode[] MODE_VALUES;
                ItemStack sapling;
                if (this.inputItems == null) {
                    this.inputItems = new ItemStack[0];
                }
                if (this.inputFluids == null) {
                    this.inputFluids = new FluidStack[0];
                }
                if ((sapling = MTETreeFarm.this.findSapling()) == null) {
                    return SimpleCheckRecipeResult.ofFailure("no_sapling");
                }
                EnumMap outputPerMode = MTETreeFarm.getOutputsForSapling(sapling);
                if (outputPerMode == null) {
                    Logger.INFO("No output found for sapling: " + sapling.func_82833_r());
                    return SimpleCheckRecipeResult.ofFailure("no_output_for_sapling");
                }
                int tier = Math.max(1, GTUtility.getTier(this.availableVoltage * this.availableAmperage));
                int tierMultiplier = MTETreeFarm.getTierMultiplier(tier);
                ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
                for (Mode mode : MODE_VALUES = Mode.values()) {
                    int toolMultiplier;
                    ItemStack output = (ItemStack)outputPerMode.get((Object)mode);
                    if (output == null || (toolMultiplier = MTETreeFarm.this.useToolForMode(mode, false)) < 0) continue;
                    ItemStack out = output.func_77946_l();
                    out.field_77994_a *= tierMultiplier * (Integer)modeMultiplier.get((Object)mode) * toolMultiplier;
                    outputs.add(out);
                }
                if (outputs.isEmpty()) {
                    return SimpleCheckRecipeResult.ofFailure("no_tools");
                }
                this.outputItems = outputs.toArray(new ItemStack[0]);
                VoidProtectionHelper voidProtection = new VoidProtectionHelper().setMachine(this.machine).setItemOutputs(this.outputItems).build();
                if (voidProtection.isItemFull()) {
                    return CheckRecipeResultRegistry.ITEM_OUTPUT_FULL;
                }
                this.duration = 100;
                this.calculatedEut = GTValues.VP[tier];
                for (Mode mode : MODE_VALUES) {
                    if (outputPerMode.get((Object)mode) == null) continue;
                    MTETreeFarm.this.useToolForMode(mode, true);
                }
                return SimpleCheckRecipeResult.ofSuccess("growing_trees");
            }
        };
    }

    private int useToolForMode(Mode mode, boolean shouldDamage) {
        ArrayList<ItemStack> inputs = this.getStoredInputs();
        int inputsSize = inputs.size();
        for (int i = inputsSize - 1; i >= 0; --i) {
            boolean canDamage;
            ItemStack stack = inputs.get(i);
            int toolMultiplier = MTETreeFarm.getToolMultiplier(stack, mode);
            if (toolMultiplier < 0) continue;
            boolean bl = canDamage = shouldDamage ? GTModHandler.damageOrDechargeItem(stack, 1, 32, null) : GTModHandler.damageOrDechargeItem(stack, 0, 0, null);
            if (shouldDamage && (!canDamage || GTModHandler.isElectricItem(stack) && !GTModHandler.canUseElectricItem(stack, 32))) {
                this.depleteInput(stack);
                this.addOutput(stack);
            }
            if (!canDamage) continue;
            return toolMultiplier;
        }
        return -1;
    }

    public static int getToolMultiplier(ItemStack toolStack, Mode mode) {
        Item tool = toolStack.func_77973_b();
        int damage = toolStack.func_77960_j();
        switch (mode) {
            case LOG: {
                if (!(tool instanceof MetaGeneratedTool01)) break;
                if (damage == IDMetaTool01.SAW.ID || damage == IDMetaTool01.POCKET_SAW.ID || damage == IDMetaTool01.POCKET_MULTITOOL.ID) {
                    return 1;
                }
                if (damage == IDMetaTool01.BUZZSAW_LV.ID || damage == IDMetaTool01.BUZZSAW_MV.ID || damage == IDMetaTool01.BUZZSAW_HV.ID) {
                    return 2;
                }
                if (damage != IDMetaTool01.CHAINSAW_LV.ID && damage != IDMetaTool01.CHAINSAW_MV.ID && damage != IDMetaTool01.CHAINSAW_HV.ID) break;
                return 4;
            }
            case SAPLING: {
                if (tool instanceof MetaGeneratedTool01 && (damage == IDMetaTool01.BRANCHCUTTER.ID || damage == IDMetaTool01.POCKET_BRANCHCUTTER.ID || damage == IDMetaTool01.POCKET_MULTITOOL.ID)) {
                    return 1;
                }
                if (!Mods.Forestry.isModLoaded() || !(tool instanceof IToolGrafter) || !tool.func_77645_m()) break;
                return 4;
            }
            case LEAVES: {
                if (tool instanceof ItemShears && tool.func_77645_m()) {
                    return 1;
                }
                if (tool instanceof MetaGeneratedTool01) {
                    if (damage == IDMetaTool01.POCKET_MULTITOOL.ID) {
                        return 1;
                    }
                    if (damage == IDMetaTool01.WIRECUTTER.ID || damage == IDMetaTool01.POCKET_WIRECUTTER.ID) {
                        return 2;
                    }
                }
                if (!(tool instanceof MetaGeneratedGregtechTools) || toolStack.func_77960_j() != 7934) break;
                return 4;
            }
            case FRUIT: {
                if (!(tool instanceof MetaGeneratedTool01) || damage != IDMetaTool01.KNIFE.ID && damage != IDMetaTool01.POCKET_KNIFE.ID && damage != IDMetaTool01.POCKET_MULTITOOL.ID) break;
                return 1;
            }
        }
        return -1;
    }

    private ItemStack findSapling() {
        ItemStack controllerSlot = this.getControllerSlot();
        if (this.isValidSapling(controllerSlot)) {
            return controllerSlot;
        }
        if (controllerSlot != null && !this.legacyToolSwap()) {
            this.addOutput(controllerSlot);
            this.mInventory[1] = null;
        }
        for (ItemStack stack : this.getStoredInputs()) {
            if (!this.isValidSapling(stack)) continue;
            this.mInventory[1] = stack.func_77979_a(1);
            return this.mInventory[1];
        }
        return null;
    }

    private boolean legacyToolSwap() {
        ItemStack controllerSlot = this.getControllerSlot();
        if (controllerSlot == null || !(controllerSlot.func_77973_b() instanceof MetaGeneratedTool01)) {
            return false;
        }
        for (MTEHatchInputBus inputBus : GTUtility.validMTEList(this.mInputBusses)) {
            ItemStack[] inventory = inputBus.getRealInventory();
            for (int slot = 0; slot < inventory.length; ++slot) {
                if (!this.isValidSapling(inventory[slot])) continue;
                this.mInventory[1] = inventory[slot];
                inventory[slot] = controllerSlot;
                inputBus.updateSlots();
                return true;
            }
        }
        return false;
    }

    private boolean isValidSapling(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        String registryName = Item.field_150901_e.func_148750_c((Object)stack.func_77973_b());
        return treeProductsMap.containsKey(registryName + ":" + stack.func_77960_j()) || "Forestry:sapling".equals(registryName);
    }

    private static EnumMap<Mode, ItemStack> getOutputsForSapling(ItemStack sapling) {
        String registryName = Item.field_150901_e.func_148750_c((Object)sapling.func_77973_b());
        if (Mods.Forestry.isModLoaded() && "Forestry:sapling".equals(registryName)) {
            return MTETreeFarm.getOutputsForForestrySapling(sapling);
        }
        return treeProductsMap.get(registryName + ":" + sapling.func_77960_j());
    }

    private static EnumMap<Mode, ItemStack> getOutputsForForestrySapling(ItemStack sapling) {
        ItemStack fruit;
        ItemStack leaves;
        ItemStack saplingOut;
        ITree tree = TreeManager.treeRoot.getMember(sapling);
        if (tree == null) {
            return null;
        }
        String speciesUUID = tree.getIdent();
        EnumMap<Mode, ItemStack> defaultMap = treeProductsMap.get("Forestry:sapling:" + speciesUUID);
        if (defaultMap == null) {
            return null;
        }
        EnumMap<Mode, ItemStack> adjustedMap = new EnumMap<Mode, ItemStack>(Mode.class);
        ItemStack log = defaultMap.get((Object)Mode.LOG);
        if (log != null) {
            double height = Math.max(3.0f * (tree.getGenome().getHeight() - 1.0f), 0.0f) + 1.0f;
            double girth = tree.getGenome().getGirth();
            log = log.func_77946_l();
            log.field_77994_a = (int)((double)log.field_77994_a * height * girth);
            adjustedMap.put(Mode.LOG, log);
        }
        if ((saplingOut = defaultMap.get((Object)Mode.SAPLING)) != null) {
            double fertility = tree.getGenome().getFertility() * 10.0f;
            int stackSize = Math.max(1, (int)((double)saplingOut.field_77994_a * fertility));
            saplingOut = sapling.func_77946_l();
            saplingOut.field_77994_a = stackSize;
            adjustedMap.put(Mode.SAPLING, saplingOut);
        }
        if ((leaves = defaultMap.get((Object)Mode.LEAVES)) != null) {
            adjustedMap.put(Mode.LEAVES, leaves.func_77946_l());
        }
        if ((fruit = defaultMap.get((Object)Mode.FRUIT)) != null) {
            double yield = tree.getGenome().getYield() * 10.0f;
            fruit = fruit.func_77946_l();
            fruit.field_77994_a = (int)((double)fruit.field_77994_a * yield);
            adjustedMap.put(Mode.FRUIT, fruit);
        }
        return adjustedMap;
    }

    public static void registerTreeProducts(ItemStack sapling, ItemStack log, ItemStack leaves, ItemStack fruit) {
        MTETreeFarm.registerTreeProducts(sapling, log, sapling, leaves, fruit);
    }

    public static void registerTreeProducts(ItemStack saplingIn, ItemStack log, ItemStack saplingOut, ItemStack leaves, ItemStack fruit) {
        String key = Item.field_150901_e.func_148750_c((Object)saplingIn.func_77973_b()) + ":" + saplingIn.func_77960_j();
        EnumMap<Mode, ItemStack> map = new EnumMap<Mode, ItemStack>(Mode.class);
        if (log != null) {
            map.put(Mode.LOG, log);
        }
        if (saplingOut != null) {
            map.put(Mode.SAPLING, saplingOut);
        }
        if (leaves != null) {
            map.put(Mode.LEAVES, leaves);
        }
        if (fruit != null) {
            map.put(Mode.FRUIT, fruit);
        }
        treeProductsMap.put(key, map);
        if (!MTETreeFarm.addFakeRecipeToNEI(saplingIn, log, saplingOut, leaves, fruit)) {
            Logger.INFO("Registering NEI fake recipe for " + key + " failed!");
        }
    }

    public static void registerForestryTree(String speciesUID, ItemStack sapling, ItemStack log, ItemStack leaves, ItemStack fruit) {
        String key = "Forestry:sapling:" + speciesUID;
        EnumMap<Mode, Object> map = new EnumMap<Mode, ItemStack>(Mode.class);
        map.put(Mode.LOG, log);
        map.put(Mode.SAPLING, sapling);
        map.put(Mode.LEAVES, leaves);
        map.put(Mode.FRUIT, fruit);
        treeProductsMap.put(key, map);
        map = MTETreeFarm.getOutputsForForestrySapling(sapling);
        if (map == null) {
            Logger.INFO("Could not create Forestry tree output map for " + speciesUID);
            return;
        }
        MTETreeFarm.addFakeRecipeToNEI(sapling, (ItemStack)map.get((Object)Mode.LOG), (ItemStack)map.get((Object)Mode.SAPLING), (ItemStack)map.get((Object)Mode.LEAVES), (ItemStack)map.get((Object)Mode.FRUIT));
    }

    public static boolean addFakeRecipeToNEI(ItemStack saplingIn, ItemStack log, ItemStack saplingOut, ItemStack leaves, ItemStack fruit) {
        int recipeCount = GTPPRecipeMaps.treeGrowthSimulatorFakeRecipes.getAllRecipes().size();
        ItemStack specialStack = saplingIn.func_77946_l();
        specialStack.field_77994_a = 0;
        Mode[] MODE_VALUES = Mode.values();
        ItemStack[][] inputStacks = new ItemStack[MODE_VALUES.length][];
        ItemStack[] outputStacks = new ItemStack[MODE_VALUES.length];
        for (Mode mode : MODE_VALUES) {
            ItemStack output;
            switch (mode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case LOG: {
                    ItemStack itemStack = log;
                    break;
                }
                case SAPLING: {
                    ItemStack itemStack = saplingOut;
                    break;
                }
                case LEAVES: {
                    ItemStack itemStack = leaves;
                    break;
                }
                case FRUIT: {
                    ItemStack itemStack = output = fruit;
                }
            }
            if (output == null) continue;
            int ordinal = mode.ordinal();
            inputStacks[ordinal] = altToolsForNEI[ordinal];
            outputStacks[ordinal] = output.func_77946_l();
            outputStacks[ordinal].field_77994_a *= modeMultiplier.get((Object)mode).intValue();
        }
        Logger.INFO("Adding Tree Growth Simulation NEI recipe for " + specialStack.func_82833_r() + " -> " + ItemUtils.getArrayStackNames(outputStacks));
        GTPPRecipeMaps.treeGrowthSimulatorFakeRecipes.addFakeRecipe(false, new GTRecipe.GTRecipe_WithAlt(false, null, outputStacks, specialStack, null, null, null, 100, 0, recipeCount, inputStacks));
        return GTPPRecipeMaps.treeGrowthSimulatorFakeRecipes.getAllRecipes().size() > recipeCount;
    }

    static {
        mCasingName = "Sterile Farm Casing";
        STRUCTURE_DEFINITION = null;
        modeMultiplier = new EnumMap(Mode.class);
        modeMultiplier.put(Mode.LOG, 5);
        modeMultiplier.put(Mode.SAPLING, 5);
        modeMultiplier.put(Mode.LEAVES, 2);
        modeMultiplier.put(Mode.FRUIT, 1);
        treeProductsMap = new HashMap();
        MetaGeneratedTool01 toolInstance = MetaGeneratedTool01.INSTANCE;
        altToolsForNEI = new ItemStack[][]{{toolInstance.getToolWithStats(IDMetaTool01.SAW.ID, 1, null, null, null), toolInstance.getToolWithStats(IDMetaTool01.POCKET_SAW.ID, 1, null, null, null), toolInstance.getToolWithStats(IDMetaTool01.BUZZSAW_LV.ID, 1, null, null, null), toolInstance.getToolWithStats(IDMetaTool01.CHAINSAW_LV.ID, 1, null, null, null), toolInstance.getToolWithStats(IDMetaTool01.BUZZSAW_MV.ID, 1, null, null, null), toolInstance.getToolWithStats(IDMetaTool01.CHAINSAW_MV.ID, 1, null, null, null), toolInstance.getToolWithStats(IDMetaTool01.BUZZSAW_HV.ID, 1, null, null, null), toolInstance.getToolWithStats(IDMetaTool01.CHAINSAW_HV.ID, 1, null, null, null)}, {toolInstance.getToolWithStats(IDMetaTool01.BRANCHCUTTER.ID, 1, null, null, null), toolInstance.getToolWithStats(IDMetaTool01.POCKET_BRANCHCUTTER.ID, 1, null, null, null), GTModHandler.getModItem(Mods.Forestry.ID, "grafter", 1L, 0)}, {new ItemStack((Item)Items.field_151097_aZ), toolInstance.getToolWithStats(IDMetaTool01.WIRECUTTER.ID, 1, null, null, null), toolInstance.getToolWithStats(IDMetaTool01.POCKET_WIRECUTTER.ID, 1, null, null, null), MetaGeneratedGregtechTools.getInstance().getToolWithStats(7934, 1, null, null, null)}, {toolInstance.getToolWithStats(IDMetaTool01.KNIFE.ID, 1, null, null, null), toolInstance.getToolWithStats(IDMetaTool01.POCKET_KNIFE.ID, 1, null, null, null)}};
    }

    public static enum Mode {
        LOG,
        SAPLING,
        LEAVES,
        FRUIT;

    }
}

