/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.everglades;

import bwcrossmod.galacticgreg.MTEVoidMinerBase;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.config.ASMConfiguration;
import gtPlusPlus.core.config.Configuration;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.MaterialsOres;
import gtPlusPlus.everglades.biome.BiomeEverglades;
import gtPlusPlus.everglades.block.DarkWorldContentLoader;
import gtPlusPlus.everglades.dimension.DimensionEverglades;
import gtPlusPlus.everglades.gen.gt.WorldGen_GT_Base;
import gtPlusPlus.everglades.gen.gt.WorldGen_GT_Ore_Layer;
import gtPlusPlus.everglades.gen.gt.WorldGen_Ores;
import net.minecraft.block.Block;
import net.minecraftforge.common.DimensionManager;

@Mod(modid="ToxicEverglades", name="GT++ Toxic Everglades", version="5.09.50.103", dependencies="required-after:Forge; after:dreamcraft; after:IC2; required-after:gregtech; required-after:miscutils;")
public class GTPPEverglades {
    @Mod.Instance(value="ToxicEverglades")
    public static GTPPEverglades instance;
    protected static volatile BiomeEverglades Everglades_Biome;
    protected static volatile DimensionEverglades Everglades_Dimension;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Logger.INFO("Loading " + Mods.GTPlusPlusEverglades.ID + " V" + "5.09.50.103");
        this.setVars(event);
        GTPPEverglades.setEvergladesBiome(new BiomeEverglades());
        Everglades_Dimension = new DimensionEverglades();
        GTPPEverglades.getEvergladesBiome().instance = instance;
        GTPPEverglades.Everglades_Dimension.instance = instance;
        GTPPEverglades.getEvergladesBiome().preInit(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent e) {
        Logger.INFO("Begin resource allocation for " + Mods.GTPlusPlusEverglades.ID + " V" + "5.09.50.103");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGen_GT_Base(), (int)Short.MAX_VALUE);
        GTPPEverglades.getEvergladesBiome().load();
        Everglades_Dimension.load();
        this.addToVoidMinerDrops();
    }

    public static synchronized void GenerateOreMaterials() {
        MaterialGenerator.generateOreMaterial(MaterialsOres.CROCROITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.GEIKIELITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.NICHROMITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.TITANITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.ZIMBABWEITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.ZIRCONILITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.GADOLINITE_CE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.GADOLINITE_Y);
        MaterialGenerator.generateOreMaterial(MaterialsOres.LEPERSONNITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.SAMARSKITE_Y);
        MaterialGenerator.generateOreMaterial(MaterialsOres.SAMARSKITE_YB);
        MaterialGenerator.generateOreMaterial(MaterialsOres.XENOTIME);
        MaterialGenerator.generateOreMaterial(MaterialsOres.YTTRIAITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.YTTRIALITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.YTTROCERITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.ZIRCON);
        MaterialGenerator.generateOreMaterial(MaterialsOres.POLYCRASE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.ZIRCOPHYLLITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.ZIRKELITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.LANTHANITE_LA);
        MaterialGenerator.generateOreMaterial(MaterialsOres.LANTHANITE_CE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.LANTHANITE_ND);
        MaterialGenerator.generateOreMaterial(MaterialsOres.AGARDITE_Y);
        MaterialGenerator.generateOreMaterial(MaterialsOres.AGARDITE_CD);
        MaterialGenerator.generateOreMaterial(MaterialsOres.AGARDITE_LA);
        MaterialGenerator.generateOreMaterial(MaterialsOres.AGARDITE_ND);
        MaterialGenerator.generateOreMaterial(MaterialsOres.HIBONITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.CERITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.FLUORCAPHITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.FLORENCITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.CRYOLITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.LAUTARITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.LAFOSSAITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.DEMICHELEITE_BR);
        MaterialGenerator.generateOreMaterial(MaterialsOres.COMANCHEITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.PERROUDITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.HONEAITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.ALBURNITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.MIESSIITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.KASHINITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.IRARSITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.GREENOCKITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.RADIOBARITE);
        MaterialGenerator.generateOreMaterial(MaterialsOres.DEEP_EARTH_REACTOR_FUEL_DEPOSIT);
    }

    protected synchronized void setVars(FMLPreInitializationEvent event) {
        if (DimensionManager.isDimensionRegistered((int)DimensionEverglades.DIMID)) {
            DimensionEverglades.DIMID = DimensionManager.getNextFreeDimId();
        }
        WorldGen_Ores.generateValidOreVeins();
        WorldGen_GT_Base.oreveinPercentage = 64;
        WorldGen_GT_Base.oreveinAttempts = 16;
        WorldGen_GT_Base.oreveinMaxPlacementAttempts = 4;
        if (ASMConfiguration.debug.debugMode || GTPPCore.DEVENV) {
            WorldGen_GT_Base.debugWorldGen = true;
        }
        DarkWorldContentLoader.run();
    }

    public void addToVoidMinerDrops() {
        for (WorldGen_GT_Ore_Layer t : WorldGen_Ores.validOreveins.values()) {
            this.addVMDrop(t.mPrimaryMeta, 0, t.mWeight);
            this.addVMDrop(t.mSecondaryMeta, 0, t.mWeight);
            this.addVMDrop(t.mBetweenMeta, 0, (float)t.mWeight / 8.0f);
            this.addVMDrop(t.mSporadicMeta, 0, (float)t.mWeight / 8.0f);
        }
    }

    public void addVMDrop(Block block, int meta, float weight) {
        MTEVoidMinerBase.addBlockToDimensionList(Configuration.worldgen.EVERGLADES_ID, block, meta, weight);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        GTPPEverglades.getEvergladesBiome().serverLoad(event);
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent e) {
        Logger.INFO("Finished loading Everglades plugin for GT++.");
    }

    public static synchronized BiomeEverglades getEvergladesBiome() {
        return Everglades_Biome;
    }

    public static synchronized void setEvergladesBiome(BiomeEverglades darkWorld_Biome) {
        Everglades_Biome = darkWorld_Biome;
    }
}

