/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.circuit;

import com.gtnewhorizons.modularui.api.UIInfos;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.INetworkUpdatableItem;
import gregtech.api.net.GTPacketUpdateItem;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.gui.modularui.uifactory.SelectItemUIFactory;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.commons.lang3.tuple.Pair;

public class GTPPIntegratedCircuitItem
extends Item
implements INetworkUpdatableItem {
    private final List<ItemStack> ALL_VARIANTS = new ArrayList<ItemStack>();
    private final String iconLocation;
    protected final IIcon[] iconDamage = new IIcon[25];

    public GTPPIntegratedCircuitItem(String unlocalizedName, String iconLocation) {
        this.func_77627_a(true);
        this.setNoRepair();
        this.func_77625_d(64);
        this.func_77656_e(0);
        this.func_77655_b(unlocalizedName);
        this.iconLocation = iconLocation;
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
        this.ALL_VARIANTS.add(new ItemStack((Item)this, 0, 0));
        for (int i = 1; i <= 24; ++i) {
            ItemStack aStack = new ItemStack((Item)this, 0, i);
            this.ALL_VARIANTS.add(aStack);
        }
    }

    public boolean func_77645_m() {
        return false;
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer p_77624_2_, List aList, boolean p_77624_4_) {
        try {
            aList.add("Configuration == " + aStack.func_77960_j());
            aList.add(GTLanguageManager.addStringLocalization(this.func_77658_a() + ".tooltip.0", "Right click to reconfigure"));
            aList.add(GTLanguageManager.addStringLocalization(this.func_77658_a() + ".tooltip.1", "Needs a screwdriver or circuit programming tool"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        super.func_77624_a(aStack, p_77624_2_, aList, p_77624_4_);
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.common;
    }

    public void func_150895_a(Item aItem, CreativeTabs p_150895_2_, List aList) {
        aList.add(ItemUtils.simpleMetaStack(aItem, 0, 1));
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public void func_94581_a(IIconRegister u) {
        for (int i = 0; i < this.iconDamage.length; ++i) {
            this.iconDamage[i] = u.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.iconLocation + "/" + i);
        }
    }

    public IIcon func_77617_a(int meta) {
        return this.iconDamage[MathUtils.balance(meta, 0, 24)];
    }

    @Override
    public boolean receive(ItemStack stack, EntityPlayerMP player, NBTTagCompound tag) {
        int meta;
        int n = meta = tag.func_150297_b("meta", 1) ? (int)tag.func_74771_c("meta") : -1;
        if (meta < 0 || meta > 24) {
            return true;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            Pair<Integer, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> toolIndex = GTPPIntegratedCircuitItem.findConfiguratorInInv((EntityPlayer)player);
            if (toolIndex == null) {
                return true;
            }
            ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
            mainInventory[((Integer)toolIndex.getKey()).intValue()] = (ItemStack)((BiFunction)toolIndex.getValue()).apply(mainInventory[(Integer)toolIndex.getKey()], player);
        }
        stack.func_77964_b(meta);
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ItemStack configuratorStack;
        if (player instanceof FakePlayer || !world.field_72995_K) {
            return stack;
        }
        if (player.field_71075_bZ.field_75098_d) {
            configuratorStack = null;
        } else {
            Pair<Integer, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> configurator = GTPPIntegratedCircuitItem.findConfiguratorInInv(player);
            if (configurator == null) {
                int count;
                try {
                    count = Integer.parseInt(StatCollector.func_74838_a((String)"GT5U.item.programmed_circuit.no_screwdriver.count"));
                }
                catch (NumberFormatException e) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Error in translation GT5U.item.programmed_circuit.no_screwdriver.count: " + e.getMessage()));
                    count = 1;
                }
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.item.programmed_circuit.no_screwdriver." + XSTR.XSTR_INSTANCE.nextInt(count), new Object[0]));
                return stack;
            }
            configuratorStack = player.field_71071_by.field_70462_a[(Integer)configurator.getKey()];
        }
        this.openSelectorGui(configuratorStack, stack.func_77960_j(), player);
        return stack;
    }

    private void openSelectorGui(ItemStack configurator, int meta, EntityPlayer player) {
        UIInfos.openClientUI((EntityPlayer)player, buildContext -> new SelectItemUIFactory(StatCollector.func_74838_a((String)"GT5U.item.programmed_circuit.select.header"), configurator, GTPPIntegratedCircuitItem::onConfigured, this.ALL_VARIANTS, meta, true).createWindow((UIBuildContext)buildContext));
    }

    private static void onConfigured(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("meta", (byte)stack.func_77960_j());
        GTValues.NW.sendToServer(new GTPacketUpdateItem(tag));
    }

    private static Pair<Integer, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> findConfiguratorInInv(EntityPlayer player) {
        ItemStack[] mainInventory = player.field_71071_by.field_70462_a;
        int mainInventoryLength = mainInventory.length;
        for (int j = 0; j < mainInventoryLength; ++j) {
            ItemStack toolStack = mainInventory[j];
            if (!GTUtility.isStackValid(toolStack)) continue;
            for (Map.Entry<Predicate<ItemStack>, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> p : GregTechAPI.sCircuitProgrammerList.entrySet()) {
                if (!p.getKey().test(toolStack)) continue;
                return Pair.of((Object)j, p.getValue());
            }
        }
        return null;
    }
}

