/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.base.CoreItem;
import gtPlusPlus.core.util.Utils;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BaseItemTickable
extends CoreItem {
    public final String[] descriptionString;
    public final int itemColour;
    public final int maxTicks;
    public final boolean twoRenderPasses;
    public final boolean ticksInContainers;
    public IIcon[] mIcon = new IIcon[2];

    public BaseItemTickable(boolean twoPass, String unlocalName, int colour, int maxTicks) {
        this(false, twoPass, unlocalName, colour, maxTicks, new String[0]);
    }

    public BaseItemTickable(boolean containerTick, boolean twoPass, String unlocalName, int colour, int maxTicks) {
        this(containerTick, twoPass, unlocalName, colour, maxTicks, new String[0]);
    }

    public BaseItemTickable(boolean containerTick, boolean twoPass, String unlocalName, int colour, int maxTicks, String[] Description) {
        super(unlocalName, AddToCreativeTab.tabMisc, 1, 999999999, Description, EnumRarity.epic, EnumChatFormatting.DARK_RED, true, null);
        this.itemColour = colour;
        this.descriptionString = Description;
        this.maxTicks = maxTicks;
        this.twoRenderPasses = twoPass;
        this.ticksInContainers = containerTick;
        this.field_77777_bU = 1;
    }

    @Override
    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
        if (world == null || iStack == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        boolean active = this.isTicking(world, iStack);
        if (active) {
            this.tickItemTag(world, iStack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return this.twoRenderPasses;
    }

    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass == 1 && this.twoRenderPasses) {
            return Utils.rgbtoHexValue(255, 255, 255);
        }
        return this.itemColour;
    }

    public IIcon func_77618_c(int damage, int pass) {
        if (this.twoRenderPasses) {
            if (pass == 0) {
                return this.mIcon[0];
            }
            return this.mIcon[1];
        }
        return this.mIcon[0];
    }

    public void func_94581_a(IIconRegister i) {
        if (this.twoRenderPasses) {
            this.mIcon[0] = i.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.func_77658_a());
            this.mIcon[1] = i.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.func_77658_a() + "_OVERLAY");
        } else {
            this.mIcon[0] = i.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.func_77658_a());
        }
    }

    protected int getMaxTicks(ItemStack aStack) {
        return this.maxTicks;
    }

    protected boolean createNBT(World world, ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74772_a("Tick", 0L);
        tagNBT.func_74772_a("maxTick", (long)this.getMaxTicks(rStack));
        tagNBT.func_74757_a("isActive", true);
        if (world != null) {
            // empty if block
        }
        tagMain.func_74782_a("TickableItem", (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        Logger.INFO("Created Tickable NBT data.");
        return true;
    }

    public final long getTicks(World world, ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("TickableItem")) != null) {
                return aNBT.func_74763_f("Tick");
            }
        } else {
            this.createNBT(world, aStack);
        }
        return 0L;
    }

    public final boolean setTicks(World world, ItemStack aStack, long aDamage) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("TickableItem")) != null) {
                aNBT.func_74772_a("Tick", aDamage);
                return true;
            }
        } else {
            this.createNBT(world, aStack);
        }
        return false;
    }

    public final boolean isTicking(World world, ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("TickableItem")) != null) {
                return aNBT.func_74767_n("isActive");
            }
        } else {
            return this.createNBT(world, aStack);
        }
        return true;
    }

    public final boolean setTicking(World world, ItemStack aStack, boolean active) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("TickableItem")) != null) {
                aNBT.func_74757_a("isActive", active);
                return true;
            }
        } else {
            this.createNBT(world, aStack);
        }
        return false;
    }

    public final boolean getTicksInContainer(World world, ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("TickableItem")) != null) {
                return aNBT.func_74767_n("ticksInContainer");
            }
        } else {
            this.createNBT(world, aStack);
        }
        return false;
    }

    public final boolean setTicksInContainer(World world, ItemStack aStack, boolean active) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("TickableItem")) != null) {
                aNBT.func_74757_a("ticksInContainer", active);
                return true;
            }
        } else {
            this.createNBT(world, aStack);
        }
        return false;
    }

    public final long getDifferenceInWorldTimeToCreationTime(World world, ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("TickableItem")) != null) {
                return world.func_82737_E() - aNBT.func_74763_f("CreationDate");
            }
        } else {
            this.createNBT(world, aStack);
        }
        return 0L;
    }

    public final boolean setItemStackCreationTime(ItemStack aStack, World world) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("TickableItem")) != null) {
                aNBT.func_74772_a("CreationDate", world.func_82737_E());
                return true;
            }
        } else {
            this.createNBT(world, aStack);
        }
        return false;
    }

    public final boolean tickItemTag(World world, ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && aNBT.func_74764_b("TickableItem")) {
            aNBT = aNBT.func_74775_l("TickableItem");
            if ((long)this.getMaxTicks(aStack) - this.getTicks(world, aStack) <= 0L) {
                this.setTicking(world, aStack, false);
                return false;
            }
            if (this.isTicking(world, aStack)) {
                if (aNBT != null) {
                    aNBT.func_74772_a("Tick", this.getTicks(world, aStack) + 1L);
                    return true;
                }
                return false;
            }
            return false;
        }
        return this.createNBT(world, aStack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 0.0;
        }
        double currentDamage = this.getTicks(null, stack);
        return currentDamage / (double)this.getMaxTicks(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        World world = player.func_130014_f_();
        if (this.descriptionString.length > 0) {
            list.add(EnumChatFormatting.GRAY + this.descriptionString[0]);
        }
        long maxTicks = this.getMaxTicks(stack);
        long ticks = 0L;
        if (stack.func_77942_o()) {
            ticks = this.getTicks(world, stack);
        }
        EnumChatFormatting durability = EnumChatFormatting.GRAY;
        if ((double)(maxTicks - ticks) > (double)maxTicks * 0.8) {
            durability = EnumChatFormatting.GRAY;
        } else if ((double)(maxTicks - ticks) > (double)maxTicks * 0.6) {
            durability = EnumChatFormatting.GREEN;
        } else if ((double)(maxTicks - ticks) > (double)maxTicks * 0.4) {
            durability = EnumChatFormatting.YELLOW;
        } else if ((double)(maxTicks - ticks) > (double)maxTicks * 0.2) {
            durability = EnumChatFormatting.GOLD;
        } else if (maxTicks - ticks > 0L) {
            durability = EnumChatFormatting.RED;
        }
        list.add(durability + "" + (maxTicks - ticks) / 20L + EnumChatFormatting.GRAY + " seconds until decay");
        if (this.descriptionString.length > 1) {
            for (int h = 1; h < this.descriptionString.length; ++h) {
                list.add(EnumChatFormatting.GRAY + this.descriptionString[h]);
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }
}

