/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.GTProxy;
import gregtech.common.items.IDMetaTool01;
import gregtech.common.items.MetaGeneratedTool01;
import net.minecraft.item.ItemStack;

public class ProcessingToolHead
implements IOreRecipeRegistrator {
    public ProcessingToolHead() {
        OrePrefixes.toolHeadAxe.add(this);
        OrePrefixes.toolHeadBuzzSaw.add(this);
        OrePrefixes.toolHeadChainsaw.add(this);
        OrePrefixes.toolHeadDrill.add(this);
        OrePrefixes.toolHeadFile.add(this);
        OrePrefixes.toolHeadHoe.add(this);
        OrePrefixes.toolHeadPickaxe.add(this);
        OrePrefixes.toolHeadPlow.add(this);
        OrePrefixes.toolHeadSaw.add(this);
        OrePrefixes.toolHeadSense.add(this);
        OrePrefixes.toolHeadShovel.add(this);
        OrePrefixes.toolHeadSword.add(this);
        OrePrefixes.toolHeadUniversalSpade.add(this);
        OrePrefixes.toolHeadWrench.add(this);
        OrePrefixes.toolHeadHammer.add(this);
        OrePrefixes.turbineBlade.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        boolean aSpecialRecipeReq1 = aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_SMASHING);
        boolean aSpecialRecipeReq2 = aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aMaterial.contains(SubTag.NO_WORKING);
        boolean aNoWorking = aMaterial.contains(SubTag.NO_WORKING);
        boolean aProducesSoftMallet = aMaterial.contains(SubTag.BOUNCY) || aMaterial.contains(SubTag.WOOD) || aMaterial.contains(SubTag.SOFT);
        switch (aPrefix) {
            case toolHeadAxe: {
                GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.AXE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadAxe, aMaterial, 1L), GTUtility.getIntegratedCircuit(2)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.AXE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.assemblerRecipes);
                }
                if (aSpecialRecipeReq1) {
                    GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadAxe, aMaterial, 1L), GTProxy.tBits, new Object[]{"PIh", "P  ", "f  ", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial), Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
                }
                if (aNoWorking) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadAxe, aMaterial, 1L), GTProxy.tBits, new Object[]{"GG ", "G  ", "f  ", Character.valueOf('G'), OrePrefixes.gem.get(aMaterial)});
                break;
            }
            case toolHeadBuzzSaw: {
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BUZZSAW_LV.ID, 1, aMaterial, Materials.Steel, new long[]{100000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PBM", "dXG", "SGP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BUZZSAW_LV.ID, 1, aMaterial, Materials.Steel, new long[]{75000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PBM", "dXG", "SGP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BUZZSAW_LV.ID, 1, aMaterial, Materials.Steel, new long[]{50000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PBM", "dXG", "SGP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BUZZSAW_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{400000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PBM", "dXG", "SGP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BUZZSAW_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{300000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PBM", "dXG", "SGP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BUZZSAW_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{200000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PBM", "dXG", "SGP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BUZZSAW_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1600000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PBM", "dXG", "SGP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BUZZSAW_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1200000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PBM", "dXG", "SGP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.BUZZSAW_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{800000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PBM", "dXG", "SGP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0])});
                if (!aSpecialRecipeReq2) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadBuzzSaw, aMaterial, 1L), GTProxy.tBits, new Object[]{"wXh", "X X", "fXx", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
                break;
            }
            case toolHeadChainsaw: {
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CHAINSAW_LV.ID, 1, aMaterial, Materials.Steel, new long[]{100000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CHAINSAW_LV.ID, 1, aMaterial, Materials.Steel, new long[]{75000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CHAINSAW_LV.ID, 1, aMaterial, Materials.Steel, new long[]{50000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CHAINSAW_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{400000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CHAINSAW_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{300000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CHAINSAW_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{200000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CHAINSAW_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1600000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CHAINSAW_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1200000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.CHAINSAW_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{800000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0])});
                if (!aSpecialRecipeReq2) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadChainsaw, aMaterial, 1L), GTProxy.tBits, new Object[]{"SRS", "XhX", "SRS", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial), Character.valueOf('S'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('R'), OrePrefixes.ring.get(Materials.Steel)});
                break;
            }
            case toolHeadDrill: {
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_LV.ID, 1, aMaterial, Materials.Steel, new long[]{100000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_LV.ID, 1, aMaterial, Materials.Steel, new long[]{75000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_LV.ID, 1, aMaterial, Materials.Steel, new long[]{50000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{400000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{300000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{200000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1600000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1200000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.DRILL_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{800000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.JACKHAMMER.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1600000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "PRP", "MPB", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Piston_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('R'), OrePrefixes.spring.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.JACKHAMMER.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1200000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "PRP", "MPB", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Piston_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('R'), OrePrefixes.spring.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.JACKHAMMER.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{800000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "PRP", "MPB", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Piston_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('R'), OrePrefixes.spring.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0])});
                if (!aSpecialRecipeReq2) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadDrill, aMaterial, 1L), GTProxy.tBits, new Object[]{"XSX", "XSX", "ShS", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial), Character.valueOf('S'), OrePrefixes.plate.get(Materials.Steel)});
                if (aMaterial.mStandardMoltenFluid != null) {
                    GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_ToolHeadDrill.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.toolHeadDrill, aMaterial, 1L)).fluidInputs(aMaterial.getMolten(576L)).duration(100).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.fluidSolidifierRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial, 4L), ItemList.Shape_Extruder_ToolHeadDrill.get(0L, new Object[0])).itemOutputs(GTOreDictUnificator.get(OrePrefixes.toolHeadDrill, aMaterial, 1L)).duration(100).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.extruderRecipes);
                break;
            }
            case toolHeadFile: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.FILE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                    if (!aMaterial.contains(SubTag.NO_SMASHING) && !aMaterial.contains(SubTag.BOUNCY) && (long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                        GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.FILE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), GTModHandler.RecipeBits.MIRRORED | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"P", "P", "S", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial), Character.valueOf('S'), OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                    }
                }
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadFile, aMaterial, 1L), GTUtility.getIntegratedCircuit(15)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.FILE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case toolHeadHoe: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.HOE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                }
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadHoe, aMaterial, 1L), GTUtility.getIntegratedCircuit(16)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.HOE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.assemblerRecipes);
                }
                if (aSpecialRecipeReq1) {
                    GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadHoe, aMaterial, 1L), GTProxy.tBits, new Object[]{"PIh", "f  ", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial), Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
                }
                if (aNoWorking) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadHoe, aMaterial, 1L), GTProxy.tBits, new Object[]{"GG ", "f  ", "   ", Character.valueOf('G'), OrePrefixes.gem.get(aMaterial)});
                break;
            }
            case toolHeadPickaxe: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.PICKAXE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                    if (aSpecialRecipeReq1) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadPickaxe, aMaterial, 1L), GTProxy.tBits, new Object[]{"PII", "f h", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial), Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
                    }
                    if (!aNoWorking) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadPickaxe, aMaterial, 1L), GTProxy.tBits, new Object[]{"GGG", "f  ", Character.valueOf('G'), OrePrefixes.gem.get(aMaterial)});
                    }
                }
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadPickaxe, aMaterial, 1L), GTUtility.getIntegratedCircuit(5)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.PICKAXE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case toolHeadPlow: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.PLOW.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                    if (aSpecialRecipeReq1) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadPlow, aMaterial, 1L), GTProxy.tBits, new Object[]{"PP", "PP", "hf", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial)});
                    }
                    if (!aNoWorking) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadPlow, aMaterial, 1L), GTProxy.tBits, new Object[]{"GG", "GG", " f", Character.valueOf('G'), OrePrefixes.gem.get(aMaterial)});
                    }
                }
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadPlow, aMaterial, 1L), GTUtility.getIntegratedCircuit(6)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.PLOW.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case toolHeadSaw: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SAW.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                    if (aSpecialRecipeReq1) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadSaw, aMaterial, 1L), GTProxy.tBits, new Object[]{"PP ", "fh ", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial), Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
                    }
                    if (!aNoWorking) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadSaw, aMaterial, 1L), GTProxy.tBits, new Object[]{"GGf", Character.valueOf('G'), OrePrefixes.gem.get(aMaterial)});
                    }
                }
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadSaw, aMaterial, 1L), GTUtility.getIntegratedCircuit(7)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SAW.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case toolHeadSense: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SENSE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                    if (aSpecialRecipeReq1) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadSense, aMaterial, 1L), GTProxy.tBits, new Object[]{"PPI", "hf ", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial), Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
                    }
                    if (!aNoWorking) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadSense, aMaterial, 1L), GTProxy.tBits, new Object[]{"GGG", " f ", "   ", Character.valueOf('G'), OrePrefixes.gem.get(aMaterial)});
                    }
                }
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadSense, aMaterial, 1L), GTUtility.getIntegratedCircuit(8)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SENSE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case toolHeadShovel: {
                GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SHOVEL.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadShovel, aMaterial, 1L), GTUtility.getIntegratedCircuit(9)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SHOVEL.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.assemblerRecipes);
                }
                if (aSpecialRecipeReq1) {
                    GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadShovel, aMaterial, 1L), GTProxy.tBits, new Object[]{"fPh", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial), Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
                }
                if (aNoWorking) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadShovel, aMaterial, 1L), GTProxy.tBits, new Object[]{"fG", Character.valueOf('G'), OrePrefixes.gem.get(aMaterial)});
                break;
            }
            case toolHeadSword: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SWORD.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                    if (aSpecialRecipeReq1) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadSword, aMaterial, 1L), GTProxy.tBits, new Object[]{" P ", "fPh", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial), Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
                    }
                    if (!aNoWorking) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadSword, aMaterial, 1L), GTProxy.tBits, new Object[]{" G", "fG", Character.valueOf('G'), OrePrefixes.gem.get(aMaterial)});
                    }
                }
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadSword, aMaterial, 1L), GTUtility.getIntegratedCircuit(10)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SWORD.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case toolHeadUniversalSpade: {
                GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.UNIVERSALSPADE.ID, 1, aMaterial, aMaterial, null), new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial), OrePrefixes.screw.get(aMaterial), ToolDictNames.craftingToolScrewdriver});
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) != null && GTOreDictUnificator.get(OrePrefixes.screw, aMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.screw, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadUniversalSpade, aMaterial, 1L), GTUtility.getIntegratedCircuit(11)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.UNIVERSALSPADE.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.assemblerRecipes);
                }
                if (!aSpecialRecipeReq2) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadUniversalSpade, aMaterial, 1L), GTProxy.tBits, new Object[]{"fX", Character.valueOf('X'), OrePrefixes.toolHeadShovel.get(aMaterial)});
                break;
            }
            case toolHeadWrench: {
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_LV.ID, 1, aMaterial, Materials.Steel, new long[]{100000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_LV.ID, 1, aMaterial, Materials.Steel, new long[]{75000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_LV.ID, 1, aMaterial, Materials.Steel, new long[]{50000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{400000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{300000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{200000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1600000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1200000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.WRENCH_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{800000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"SXd", "GMG", "PBP", Character.valueOf('X'), aOreDictName, Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_LV.ID, 1, aMaterial, Materials.Steel, new long[]{100000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_LV.ID, 1, aMaterial, Materials.Steel, new long[]{75000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_LV.ID, 1, aMaterial, Materials.Steel, new long[]{50000L, 32L, 1L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Motor_LV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Steel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Steel), Character.valueOf('B'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{400000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{300000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_MV.ID, 1, aMaterial, Materials.Aluminium, new long[]{200000L, 128L, 2L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Motor_MV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.Aluminium), Character.valueOf('P'), OrePrefixes.plate.get(Materials.Aluminium), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.Aluminium), Character.valueOf('B'), ItemList.Battery_RE_MV_Sodium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1600000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Lithium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{1200000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Cadmium.get(1L, new Object[0])});
                GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(IDMetaTool01.SCREWDRIVER_HV.ID, 1, aMaterial, Materials.StainlessSteel, new long[]{800000L, 512L, 3L, -1L}), GTModHandler.RecipeBits.DISMANTLEABLE | GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"PdX", "MGS", "GBP", Character.valueOf('X'), OrePrefixes.stickLong.get(aMaterial), Character.valueOf('M'), ItemList.Electric_Motor_HV.get(1L, new Object[0]), Character.valueOf('S'), OrePrefixes.screw.get(Materials.StainlessSteel), Character.valueOf('P'), OrePrefixes.plate.get(Materials.StainlessSteel), Character.valueOf('G'), OrePrefixes.gearGtSmall.get(Materials.StainlessSteel), Character.valueOf('B'), ItemList.Battery_RE_HV_Sodium.get(1L, new Object[0])});
                if (!aSpecialRecipeReq2) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadWrench, aMaterial, 1L), GTProxy.tBits, new Object[]{"hXW", "XRX", "WXd", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial), Character.valueOf('S'), OrePrefixes.plate.get(Materials.Steel), Character.valueOf('R'), OrePrefixes.ring.get(Materials.Steel), Character.valueOf('W'), OrePrefixes.screw.get(Materials.Steel)});
                break;
            }
            case toolHeadHammer: 
            case toolHeadMallet: {
                if (GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L) != null) {
                    GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial.mHandleMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.toolHeadHammer, aMaterial, 1L), GTUtility.getIntegratedCircuit(14)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(aProducesSoftMallet ? IDMetaTool01.SOFTMALLET.ID : IDMetaTool01.HARDHAMMER.ID, 1, aMaterial, aMaterial.mHandleMaterial, null)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, (int)TierEU.RECIPE_MV)).addTo(RecipeMaps.assemblerRecipes);
                }
                if (aMaterial != Materials.Stone && aMaterial != Materials.Flint) {
                    GTModHandler.addShapelessCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(aProducesSoftMallet ? IDMetaTool01.SOFTMALLET.ID : IDMetaTool01.HARDHAMMER.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{aOreDictName, OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                    GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(aProducesSoftMallet ? IDMetaTool01.SOFTMALLET.ID : IDMetaTool01.HARDHAMMER.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"XX ", "XXS", "XX ", Character.valueOf('X'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(Materials.Wood) : OrePrefixes.ingot.get(aMaterial), Character.valueOf('S'), OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                    GTModHandler.addCraftingRecipe(MetaGeneratedTool01.INSTANCE.getToolWithStats(aProducesSoftMallet ? IDMetaTool01.SOFTMALLET.ID : IDMetaTool01.HARDHAMMER.ID, 1, aMaterial, aMaterial.mHandleMaterial, null), GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.BUFFERED, new Object[]{"XX ", "XXS", "XX ", Character.valueOf('X'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(Materials.Wood) : OrePrefixes.gem.get(aMaterial), Character.valueOf('S'), OrePrefixes.stick.get(aMaterial.mHandleMaterial)});
                }
                if (aPrefix != OrePrefixes.toolHeadHammer || !aSpecialRecipeReq1) break;
                GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.toolHeadHammer, aMaterial, 1L), GTProxy.tBits, new Object[]{"II ", "IIh", "II ", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial), Character.valueOf('I'), OrePrefixes.ingot.get(aMaterial)});
                break;
            }
            case turbineBlade: {
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial, 4L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Magnalium, 1L)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(170, 1, aMaterial, aMaterial, null)).duration(160).eut(GTUtility.calculateRecipeEU(aMaterial, 100)).addTo(RecipeMaps.assemblerRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial, 8L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Titanium, 1L)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(172, 1, aMaterial, aMaterial, null)).duration(320).eut(GTUtility.calculateRecipeEU(aMaterial, 400)).addTo(RecipeMaps.assemblerRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial, 12L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.TungstenSteel, 1L)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(174, 1, aMaterial, aMaterial, null)).duration(640).eut(GTUtility.calculateRecipeEU(aMaterial, 1600)).addTo(RecipeMaps.assemblerRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial, 16L), GTOreDictUnificator.get(OrePrefixes.stickLong, Materials.Americium, 1L)).itemOutputs(MetaGeneratedTool01.INSTANCE.getToolWithStats(176, 1, aMaterial, aMaterial, null)).duration(1280).eut(GTUtility.calculateRecipeEU(aMaterial, 6400)).addTo(RecipeMaps.assemblerRecipes);
                if (!aSpecialRecipeReq2) break;
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial, 1L), GTProxy.tBits, new Object[]{"fPd", "SPS", " P ", Character.valueOf('P'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(aMaterial) : OrePrefixes.plateDouble.get(aMaterial), Character.valueOf('R'), OrePrefixes.ring.get(aMaterial), Character.valueOf('S'), OrePrefixes.screw.get(aMaterial)});
                }
                if (GTOreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L) == null || GTOreDictUnificator.get(OrePrefixes.screw, aMaterial, 1L) == null) break;
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 3L), GTOreDictUnificator.get(OrePrefixes.screw, aMaterial, 2L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.turbineBlade, aMaterial, 1L)).duration(200).eut(GTUtility.calculateRecipeEU(aMaterial, 60)).addTo(RecipeMaps.formingPressRecipes);
                break;
            }
        }
    }
}

