/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.ItemHandlerHelper;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.GTMod;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.widgets.PhantomItemButton;
import gregtech.api.interfaces.IDataCopyable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IItemLockable;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.api.util.extensions.ArrayExt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Nullable;

public class MTEHatchOutputBus
extends MTEHatch
implements IAddUIWidgets,
IItemLockable,
IDataCopyable {
    private static final String DATA_STICK_DATA_TYPE = "outputBusFilter";
    private static final String LOCKED_ITEM_NBT_KEY = "lockedItem";
    protected ItemStack lockedItem = null;

    public MTEHatchOutputBus(int aID, String aName, String aNameRegional, int aTier) {
        this(aID, aName, aNameRegional, aTier, MTEHatchOutputBus.getSlots(aTier));
    }

    public MTEHatchOutputBus(int id, String name, String nameRegional, int tier, int slots) {
        super(id, name, nameRegional, tier, slots, ArrayExt.of("Item Output for Multiblocks", "Capacity: " + MTEHatchOutputBus.getSlots(tier) + " stack" + (MTEHatchOutputBus.getSlots(tier) >= 2 ? "s" : ""), "Left click with data stick to save filter config", "Right click with data stick to load filter config"), new ITexture[0]);
    }

    public MTEHatchOutputBus(int aID, String aName, String aNameRegional, int aTier, String[] aDescription) {
        super(aID, aName, aNameRegional, aTier, MTEHatchOutputBus.getSlots(aTier), aDescription, new ITexture[0]);
    }

    public MTEHatchOutputBus(int aID, String aName, String aNameRegional, int aTier, String[] aDescription, int inventorySize) {
        super(aID, aName, aNameRegional, aTier, inventorySize, aDescription, new ITexture[0]);
    }

    public MTEHatchOutputBus(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, MTEHatchOutputBus.getSlots(aTier), aDescription, aTextures);
    }

    public MTEHatchOutputBus(String name, int tier, int slots, String[] description, ITexture[][][] textures) {
        super(name, tier, slots, description, textures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.ITEM_OUT_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        }
        return iTextureArray;
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.ITEM_OUT_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        }
        return iTextureArray;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchOutputBus(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!this.acceptsItemLock() || !(aPlayer instanceof EntityPlayerMP)) {
            GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
            return true;
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
            return true;
        }
        if (!this.pasteCopiedData(aPlayer, dataStick.field_77990_d)) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.machines.output_bus.invalid", new Object[0]));
            return false;
        }
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.machines.output_bus.loaded", new Object[0]));
        return true;
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!this.acceptsItemLock() || !(aPlayer instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack dataStick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual(dataStick, false, true)) {
            return;
        }
        dataStick.field_77990_d = this.getCopiedData(aPlayer);
        dataStick.func_151001_c("Output Bus Configuration");
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("GT5U.machines.output_bus.saved", new Object[0]));
    }

    @Override
    public NBTTagCompound getCopiedData(EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("type", DATA_STICK_DATA_TYPE);
        if (this.lockedItem != null) {
            nbt.func_74782_a(LOCKED_ITEM_NBT_KEY, (NBTBase)this.lockedItem.func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public boolean pasteCopiedData(EntityPlayer player, NBTTagCompound nbt) {
        if (nbt == null || !DATA_STICK_DATA_TYPE.equals(nbt.func_74779_i("type"))) {
            return false;
        }
        this.lockedItem = nbt.func_74764_b(LOCKED_ITEM_NBT_KEY) ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l(LOCKED_ITEM_NBT_KEY)) : null;
        return true;
    }

    @Override
    public String getCopiedDataIdentifier(EntityPlayer player) {
        return DATA_STICK_DATA_TYPE;
    }

    public boolean storeAll(ItemStack aStack) {
        this.func_70296_d();
        if (this.lockedItem != null && !this.lockedItem.func_77969_a(aStack)) {
            return false;
        }
        int mInventoryLength = this.mInventory.length;
        for (int i = 0; i < mInventoryLength && aStack.field_77994_a > 0; ++i) {
            int tRealStackLimit;
            ItemStack tSlot = this.mInventory[i];
            if (GTUtility.isStackInvalid(tSlot)) {
                tRealStackLimit = Math.min(this.func_70297_j_(), aStack.func_77976_d());
                if (aStack.field_77994_a <= tRealStackLimit) {
                    this.mInventory[i] = aStack;
                    return true;
                }
                this.mInventory[i] = aStack.func_77979_a(tRealStackLimit);
                continue;
            }
            tRealStackLimit = Math.min(this.func_70297_j_(), tSlot.func_77976_d());
            if (tSlot.field_77994_a >= tRealStackLimit || !tSlot.func_77969_a(aStack) || !ItemStack.func_77970_a((ItemStack)tSlot, (ItemStack)aStack)) continue;
            if (aStack.field_77994_a + tSlot.field_77994_a <= tRealStackLimit) {
                this.mInventory[i].field_77994_a += aStack.field_77994_a;
                return true;
            }
            aStack.field_77994_a -= tRealStackLimit - tSlot.field_77994_a;
            this.mInventory[i].field_77994_a = tRealStackLimit;
        }
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        IInventory tTileEntity;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && (aTick & 7L) == 0L && (tTileEntity = aBaseMetaTileEntity.getIInventoryAtSide(aBaseMetaTileEntity.getFrontFacing())) != null) {
            GTUtility.moveMultipleItemStacks(aBaseMetaTileEntity, tTileEntity, aBaseMetaTileEntity.getFrontFacing(), aBaseMetaTileEntity.getBackFacing(), null, false, (byte)64, (byte)1, (byte)64, (byte)1, this.mInventory.length);
            for (int i = 0; i < this.mInventory.length; ++i) {
                if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
                this.mInventory[i] = null;
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.lockedItem != null) {
            aNBT.func_74782_a(LOCKED_ITEM_NBT_KEY, (NBTBase)this.lockedItem.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b(LOCKED_ITEM_NBT_KEY)) {
            this.lockedItem = ItemStack.func_77949_a((NBTTagCompound)aNBT.func_74775_l(LOCKED_ITEM_NBT_KEY));
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        switch (this.mTier) {
            case 0: {
                this.getBaseMetaTileEntity().add1by1Slot(builder, new IDrawable[0]);
                break;
            }
            case 1: {
                this.getBaseMetaTileEntity().add2by2Slots(builder, new IDrawable[0]);
                break;
            }
            case 2: {
                this.getBaseMetaTileEntity().add3by3Slots(builder, new IDrawable[0]);
                break;
            }
            default: {
                this.getBaseMetaTileEntity().add4by4Slots(builder, new IDrawable[0]);
            }
        }
        if (this.acceptsItemLock()) {
            builder.widget(new PhantomItemButton(this).setPos(this.getGUIWidth() - 25, 40).setBackground(PhantomItemButton.FILTER_BACKGROUND));
        }
    }

    @Override
    public void setLockedItem(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            this.clearLock();
        } else {
            this.lockedItem = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1);
        }
    }

    @Override
    @Nullable
    public ItemStack getLockedItem() {
        return this.lockedItem;
    }

    @Override
    public void clearLock() {
        this.lockedItem = null;
    }

    @Override
    public boolean isLocked() {
        return this.lockedItem != null;
    }

    @Override
    public boolean acceptsItemLock() {
        return true;
    }
}

