/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.util.GTStructureUtility;
import java.util.List;
import net.minecraft.item.ItemStack;

public abstract class MTECubicMultiBlockBase<T extends MTECubicMultiBlockBase<T>>
extends MTEEnhancedMultiBlockBase<T>
implements ISurvivalConstructable {
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    protected static final ClassValue<IStructureDefinition<MTECubicMultiBlockBase<?>>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<MTECubicMultiBlockBase<?>>>(){

        @Override
        protected IStructureDefinition<MTECubicMultiBlockBase<?>> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(MTECubicMultiBlockBase.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"hhh", "hhh", "hhh"}, {"h~h", "h-h", "hhh"}, {"hhh", "hhh", "hhh"}})).addElement('h', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeastList(t.getAllowedHatches()).casingIndex(t.getHatchTextureIndex()).dot(1).build()), StructureUtility.onElementPass(MTECubicMultiBlockBase::onCorrectCasingAdded, (IStructureElement)StructureUtility.lazy(MTECubicMultiBlockBase::getCasingElement))})).build();
        }
    };
    private int mCasingAmount = 0;

    protected MTECubicMultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected MTECubicMultiBlockBase(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<T> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    public void construct(ItemStack aStack, boolean aHintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, aStack, aHintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 0) && this.mCasingAmount >= this.getRequiredCasingCount() && this.checkHatches(aBaseMetaTileEntity, aStack);
    }

    protected boolean checkHatches(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.mMaintenanceHatches.size() == 1;
    }

    protected abstract IStructureElement<MTECubicMultiBlockBase<?>> getCasingElement();

    protected List<IHatchElement<? super MTECubicMultiBlockBase<?>>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputHatch, (Object)HatchElement.OutputHatch, (Object)HatchElement.InputBus, (Object)HatchElement.OutputBus, (Object)HatchElement.Muffler, (Object)HatchElement.Maintenance, (Object)HatchElement.Energy);
    }

    protected abstract int getHatchTextureIndex();

    protected abstract int getRequiredCasingCount();

    protected void onCorrectCasingAdded() {
        ++this.mCasingAmount;
    }
}

