/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.modularui;

import com.gtnewhorizons.modularui.api.UIInfos;
import com.gtnewhorizons.modularui.api.screen.ITileWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.builder.UIBuilder;
import com.gtnewhorizons.modularui.common.builder.UIInfo;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularGui;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.net.GTPacketSendCoverData;
import gregtech.api.util.CoverBehaviorBase;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class GTUIInfos {
    public static final Function<ContainerConstructor, UIInfo<?, ?>> GTTileEntityUIFactory = containerConstructor -> UIBuilder.of().container((player, world, x, y, z) -> {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITileWithModularUI) {
            ITileWithModularUI mui = (ITileWithModularUI)te;
            return GTUIInfos.createTileEntityContainer(player, arg_0 -> ((ITileWithModularUI)mui).createWindow(arg_0), () -> ((TileEntity)te).func_70296_d(), containerConstructor);
        }
        return null;
    }).gui((player, world, x, y, z) -> {
        if (!world.field_72995_K) {
            return null;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITileWithModularUI) {
            ITileWithModularUI mui = (ITileWithModularUI)te;
            return GTUIInfos.createTileEntityGuiContainer(player, arg_0 -> ((ITileWithModularUI)mui).createWindow(arg_0), containerConstructor);
        }
        return null;
    }).build();
    private static final UIInfo<?, ?> GTTileEntityDefaultUI = GTTileEntityUIFactory.apply(ModularUIContainer::new);
    private static final Map<ForgeDirection, UIInfo<?, ?>> coverUI = new HashMap();

    public static void init() {
    }

    public static void openGTTileEntityUI(IHasWorldObjectAndCoords aTileEntity, EntityPlayer aPlayer) {
        if (aTileEntity.isClientSide() || aPlayer instanceof FakePlayer) {
            return;
        }
        GTTileEntityDefaultUI.open(aPlayer, aTileEntity.getWorld(), aTileEntity.getXCoord(), (int)aTileEntity.getYCoord(), aTileEntity.getZCoord());
    }

    public static void openCoverUI(ICoverable tileEntity, EntityPlayer player, ForgeDirection side) {
        if (tileEntity.isClientSide()) {
            return;
        }
        GTValues.NW.sendToPlayer(new GTPacketSendCoverData(side, tileEntity.getCoverIDAtSide(side), tileEntity.getComplexCoverDataAtSide(side), tileEntity), (EntityPlayerMP)player);
        coverUI.get(side).open(player, tileEntity.getWorld(), tileEntity.getXCoord(), (int)tileEntity.getYCoord(), tileEntity.getZCoord());
    }

    public static void openPlayerHeldItemUI(EntityPlayer player) {
        if (NetworkUtils.isClient()) {
            return;
        }
        UIInfos.PLAYER_HELD_ITEM_UI.open(player);
    }

    private static ModularUIContainer createTileEntityContainer(EntityPlayer player, Function<UIBuildContext, ModularWindow> windowCreator, Runnable onWidgetUpdate, ContainerConstructor containerCreator) {
        UIBuildContext buildContext = new UIBuildContext(player);
        ModularWindow window = windowCreator.apply(buildContext);
        if (window == null) {
            return null;
        }
        return containerCreator.of(new ModularUIContext(buildContext, onWidgetUpdate), window);
    }

    @SideOnly(value=Side.CLIENT)
    private static ModularGui createTileEntityGuiContainer(EntityPlayer player, Function<UIBuildContext, ModularWindow> windowCreator, ContainerConstructor containerConstructor) {
        ModularUIContainer container = GTUIInfos.createTileEntityContainer(player, windowCreator, null, containerConstructor);
        if (container == null) {
            return null;
        }
        return new ModularGui(container);
    }

    private static ModularUIContainer createCoverContainer(EntityPlayer player, Function<CoverUIBuildContext, ModularWindow> windowCreator, Runnable onWidgetUpdate, int coverID, ForgeDirection side, ICoverable tile) {
        CoverUIBuildContext buildContext = new CoverUIBuildContext(player, coverID, side, tile, false);
        ModularWindow window = windowCreator.apply(buildContext);
        if (window == null) {
            return null;
        }
        return new ModularUIContainer(new ModularUIContext((UIBuildContext)buildContext, onWidgetUpdate), window);
    }

    @SideOnly(value=Side.CLIENT)
    private static ModularGui createCoverGuiContainer(EntityPlayer player, Function<CoverUIBuildContext, ModularWindow> windowCreator, int coverID, ForgeDirection side, ICoverable tile) {
        ModularUIContainer container = GTUIInfos.createCoverContainer(player, windowCreator, null, coverID, side, tile);
        if (container == null) {
            return null;
        }
        return new ModularGui(container);
    }

    static {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            coverUI.put(side, UIBuilder.of().container((player, world, x, y, z) -> {
                TileEntity te = world.func_147438_o(x, y, z);
                if (!(te instanceof ICoverable)) {
                    return null;
                }
                ICoverable gtTileEntity = (ICoverable)te;
                CoverBehaviorBase<?> cover = gtTileEntity.getCoverBehaviorAtSideNew(side);
                return GTUIInfos.createCoverContainer(player, cover::createWindow, () -> ((TileEntity)te).func_70296_d(), gtTileEntity.getCoverIDAtSide(side), side, gtTileEntity);
            }).gui((player, world, x, y, z) -> {
                if (!world.field_72995_K) {
                    return null;
                }
                TileEntity te = world.func_147438_o(x, y, z);
                if (!(te instanceof ICoverable)) {
                    return null;
                }
                ICoverable gtTileEntity = (ICoverable)te;
                CoverBehaviorBase<?> cover = gtTileEntity.getCoverBehaviorAtSideNew(side);
                return GTUIInfos.createCoverGuiContainer(player, cover::createWindow, gtTileEntity.getCoverIDAtSide(side), side, gtTileEntity);
            }).build());
        }
    }

    @FunctionalInterface
    public static interface ContainerConstructor {
        public ModularUIContainer of(ModularUIContext var1, ModularWindow var2);
    }
}

