/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.objects.MaterialStack;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class ProcessingCell
implements IOreRecipeRegistrator {
    public ProcessingCell() {
        OrePrefixes.cell.add(this);
        OrePrefixes.cellPlasma.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        switch (aPrefix) {
            case cell: {
                ItemStack[] outputsArray;
                if (aMaterial == Materials.Empty) {
                    GT_ModHandler.removeRecipeByOutputDelayed(aStack);
                    if (!aModName.equalsIgnoreCase("AtomicScience")) break;
                    GT_ModHandler.addExtractionRecipe(ItemList.Cell_Empty.get(1L, new Object[0]), aStack);
                    break;
                }
                if (aMaterial.mFuelPower > 0) {
                    GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                    recipeBuilder.itemInputs(GT_Utility.copyAmount(1, aStack));
                    if (GT_Utility.getFluidForFilledItem(aStack, true) == null && GT_Utility.getContainerItem(aStack, true) != null) {
                        recipeBuilder.itemOutputs(GT_Utility.getContainerItem(aStack, true));
                    }
                    recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GT_RecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GT_RecipeConstants.Fuel);
                }
                if (aMaterial.mMaterialList.size() <= 0 || (aMaterial.mExtraData & 3) == 0) break;
                int tAllAmount = 0;
                for (MaterialStack tMat2 : aMaterial.mMaterialList) {
                    tAllAmount = (int)((long)tAllAmount + tMat2.mAmount);
                }
                long tItemAmount = 0L;
                long tCapsuleCount = (long)GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(aStack) * (long)(-tAllAmount);
                long tDensityMultiplier = aMaterial.getDensity() > 3628800L ? aMaterial.getDensity() / 3628800L : 1L;
                ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
                for (MaterialStack tMat : aMaterial.mMaterialList) {
                    ItemStack tStack;
                    if (tMat.mAmount <= 0L) continue;
                    if (tMat.mMaterial == Materials.Air) {
                        tStack = ItemList.Cell_Air.get(tMat.mAmount * tDensityMultiplier / 2L, new Object[0]);
                    } else {
                        tStack = GT_OreDictUnificator.get(OrePrefixes.dust, tMat.mMaterial, tMat.mAmount);
                        if (tStack == null) {
                            tStack = GT_OreDictUnificator.get(OrePrefixes.cell, tMat.mMaterial, tMat.mAmount);
                        }
                    }
                    if (tItemAmount + tMat.mAmount * 3628800L > (long)aStack.func_77976_d() * aMaterial.getDensity()) continue;
                    tItemAmount += tMat.mAmount * 3628800L;
                    if (tStack == null) continue;
                    tStack.field_77994_a = (int)((long)tStack.field_77994_a * tDensityMultiplier);
                    while (tStack.field_77994_a > 64 && (tCapsuleCount + (long)GT_ModHandler.getCapsuleCellContainerCount(tStack) * 64L < 0L ? tList.size() < 5 : tList.size() < 6) && tCapsuleCount + (long)GT_ModHandler.getCapsuleCellContainerCount(tStack) * 64L <= 64L) {
                        tCapsuleCount += (long)GT_ModHandler.getCapsuleCellContainerCount(tStack) * 64L;
                        tList.add(GT_Utility.copyAmount(64, tStack));
                        tStack.field_77994_a -= 64;
                    }
                    int tThisCapsuleCount = GT_ModHandler.getCapsuleCellContainerCountMultipliedWithStackSize(tStack);
                    if (tStack.field_77994_a <= 0 || tCapsuleCount + (long)tThisCapsuleCount > 64L || !(tCapsuleCount + (long)tThisCapsuleCount < 0L ? tList.size() < 5 : tList.size() < 6)) continue;
                    tCapsuleCount += (long)tThisCapsuleCount;
                    tList.add(tStack);
                }
                tItemAmount = GT_Utility.ceilDiv(tItemAmount * tDensityMultiplier, aMaterial.getDensity());
                if (tList.size() <= 0) break;
                if ((aMaterial.mExtraData & 1) != 0) {
                    if (GT_Utility.getFluidForFilledItem(aStack, true) == null) {
                        GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                        if (tCapsuleCount > 0L) {
                            recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack), ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]));
                        } else {
                            recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack));
                        }
                        if (tCapsuleCount < 0L) {
                            tList.add(ItemList.Cell_Empty.get(-tCapsuleCount, new Object[0]));
                        }
                        outputsArray = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                        recipeBuilder.itemOutputs(outputsArray).duration(Math.max(1L, Math.abs(aMaterial.getProtons() * 2L * tItemAmount))).eut(Math.min(4, tList.size()) * 30).addTo(RecipeMaps.electrolyzerRecipes);
                    } else {
                        long tCellBalance = tCapsuleCount + tItemAmount - 1L;
                        GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                        if (tCellBalance > 0L) {
                            recipeBuilder.itemInputs(aStack, ItemList.Cell_Empty.get(tCellBalance, new Object[0]));
                        } else {
                            recipeBuilder.itemInputs(aStack);
                        }
                        if (tCellBalance < 0L) {
                            tList.add(ItemList.Cell_Empty.get(-tCellBalance, new Object[0]));
                        }
                        ItemStack[] outputsArray2 = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                        recipeBuilder.itemOutputs(outputsArray2).duration(Math.max(1L, Math.abs(aMaterial.getProtons() * 8L * tItemAmount))).eut(Math.min(4, tList.size()) * 30).addTo(RecipeMaps.electrolyzerRecipes);
                    }
                }
                if ((aMaterial.mExtraData & 2) == 0) break;
                GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                if (tCapsuleCount > 0L) {
                    recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack), ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]));
                } else {
                    recipeBuilder.itemInputs(GT_Utility.copyAmount(tItemAmount, aStack));
                }
                if (tCapsuleCount < 0L) {
                    tList.add(ItemList.Cell_Empty.get(-tCapsuleCount, new Object[0]));
                }
                outputsArray = tList.toArray(new ItemStack[Math.min(tList.size(), 6)]);
                recipeBuilder.itemOutputs(outputsArray).duration(Math.max(1L, Math.abs(aMaterial.getMass() * 2L * tItemAmount))).eut(5).addTo(RecipeMaps.centrifugeRecipes);
                break;
            }
            case cellPlasma: {
                if (aMaterial == Materials.Empty) {
                    GT_ModHandler.removeRecipeByOutputDelayed(aStack);
                    break;
                }
                GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                recipeBuilder.itemInputs(GT_Utility.copyAmount(1, aStack));
                if (GT_Utility.getFluidForFilledItem(aStack, true) == null && GT_Utility.getContainerItem(aStack, true) != null) {
                    recipeBuilder.itemOutputs(GT_Utility.getContainerItem(aStack, true));
                }
                switch (aMaterial.mName) {
                    case "Aluminium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 159744).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Americium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 501760).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Antimony": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 309760).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Argon": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 188416).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Arsenic": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 230400).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Barium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 342302).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Beryllium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 110592).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Bismuth": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 425984).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Boron": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 112640).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Cadmium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 293601).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Caesium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 332513).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Calcium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 188416).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Cerium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 346931).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Chlorine": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 172032).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Chrome": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 202342).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Cobalt": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 217497).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Copper": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 219340).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Deuterium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 40960).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Erbium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 376217).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Europium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 355635).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Fluorine": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 147456).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Force": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 150000).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Gadolinium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 366551).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Gallium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 229376).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Gold": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 401408).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Helium_3": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 61440).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Helium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 81920).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Holmium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 376176).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Hydrogen": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 20480).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Indium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 296509).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Iridium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 397148).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Iron": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 206438).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Lanthanum": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 344801).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Lead": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 423936).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Lithium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 100352).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Lutetium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 381296).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Magnesium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 152371).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Manganese": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 202752).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Mercury": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 409600).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Molybdenum": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 272384).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Neodymium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 347996).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Nickel": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 213811).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Niobium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 269516).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Nitrogen": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 129024).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Osmium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 393659).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Oxygen": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 131072).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Palladium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 282214).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Phosphor": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 165888).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Platinum": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 399360).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Plutonium241": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 497664).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Plutonium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 503808).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Potassium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 183705).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Praseodymium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 346931).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Promethium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 347996).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Radon": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 450560).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Rubidium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 243712).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Samarium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 353280).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Scandium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 193536).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Silicon": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 160563).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Silver": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 282685).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Sodium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 148684).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Strontium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 249446).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Sulfur": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 170393).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Tantalum": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 384000).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Terbium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 368885).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Thorium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 471040).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Thulium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 378470).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Tin": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 150000).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Titanium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 196608).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Tritium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 61440).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Tungsten": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 384778).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Uranium235": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 481280).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Uranium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 487424).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Vanadium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 198451).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Ytterbium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 379695).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Yttrium": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 255180).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "Zinc": {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, 226304).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    default: {
                        recipeBuilder.metadata(GT_RecipeConstants.FUEL_VALUE, (int)Math.max(1024L, 1024L * aMaterial.getMass())).metadata(GT_RecipeConstants.FUEL_TYPE, 4).addTo(GT_RecipeConstants.Fuel);
                    }
                }
                if (GT_OreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.cell, aMaterial, 1L)).duration((int)Math.max(aMaterial.getMass() * 2L, 1L) * 1).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.vacuumFreezerRecipes);
                break;
            }
        }
    }
}

