/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.items.GT_Generic_Block;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.blocks.GT_Item_Storage;
import gregtech.common.blocks.GT_Material_Reinforced;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GT_Block_Reinforced
extends GT_Generic_Block {
    public GT_Block_Reinforced(String aName) {
        super(GT_Item_Storage.class, aName, new GT_Material_Reinforced());
        for (int i = 0; i < 16; ++i) {
            Textures.BlockIcons.casingTexturePages[1][i + 80] = TextureFactory.of(this, i);
        }
        this.func_149672_a(field_149769_e);
        this.func_149647_a(GregTech_API.TAB_GREGTECH);
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".0.name", "Bronzeplate Reinforced Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".1.name", "Iridium Reinforced Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".2.name", "Plascrete Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".3.name", "Tungstensteel Reinforced Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".4.name", "Brittle Charcoal");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".5.name", "Powderbarrel");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".6.name", "Solid Super Fuel");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".7.name", "Magic Solid Super Fuel");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".8.name", "Steel Reinforced Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".9.name", "Titanium Reinforced Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".10.name", "Naquadah Reinforced Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".11.name", "Neutronium Reinforced Block");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".12.name", "Raw Deep Dark Portal Block");
        ItemList.Block_BronzePlate.set(new ItemStack(this.func_149711_c(60.0f).func_149752_b(150.0f), 1, 0));
        ItemList.Block_IridiumTungstensteel.set(new ItemStack(this.func_149711_c(400.0f).func_149752_b(600.0f), 1, 1));
        ItemList.Block_Plascrete.set(new ItemStack(this.func_149711_c(5.0f).func_149752_b(6.0f), 1, 2));
        ItemList.Block_TungstenSteelReinforced.set(new ItemStack(this.func_149711_c(250.0f).func_149752_b(400.0f), 1, 3));
        ItemList.Block_BrittleCharcoal.set(new ItemStack(this.func_149711_c(0.5f).func_149752_b(8.0f), 1, 4));
        ItemList.Block_Powderbarrel.set(new ItemStack(this.func_149711_c(2.5f).func_149752_b(2.0f), 1, 5));
        ItemList.Block_SSFUEL.set(new ItemStack(this.func_149711_c(2.5f).func_149752_b(2.0f), 1, 6));
        ItemList.Block_MSSFUEL.set(new ItemStack(this.func_149711_c(2.5f).func_149752_b(2.0f), 1, 7));
        ItemList.Block_SteelPlate.set(new ItemStack(this.func_149711_c(150.0f).func_149752_b(200.0f), 1, 8));
        ItemList.Block_TitaniumPlate.set(new ItemStack(this.func_149711_c(200.0f).func_149752_b(300.0f), 1, 9));
        ItemList.Block_NaquadahPlate.set(new ItemStack(this.func_149711_c(500.0f).func_149752_b(1000.0f), 1, 10));
        ItemList.Block_NeutroniumPlate.set(new ItemStack(this.func_149711_c(750.0f).func_149752_b(2500.0f), 1, 11));
        ItemList.Block_BedrockiumCompressed.set(new ItemStack(this.func_149711_c(1500.0f).func_149752_b(5000.0f), 1, 12));
        GT_ModHandler.addShapelessCraftingRecipe(new ItemStack(Items.field_151044_h, 1, 1), new Object[]{ItemList.Block_BrittleCharcoal.get(1L, new Object[0])});
        GT_ModHandler.addCraftingRecipe(ItemList.Block_Powderbarrel.get(1L, new Object[0]), GT_ModHandler.RecipeBits.REVERSIBLE, new Object[]{"WSW", "GGG", "WGW", Character.valueOf('W'), OrePrefixes.plate.get(Materials.Wood), Character.valueOf('G'), new ItemStack(Items.field_151016_H, 1), Character.valueOf('S'), new ItemStack(Items.field_151007_F, 1)});
    }

    public String getHarvestTool(int aMeta) {
        if (aMeta == 5 || aMeta == 4 || aMeta == 6 || aMeta == 7) {
            return "axe";
        }
        if (aMeta == 2) {
            return "wrench";
        }
        return "pickaxe";
    }

    public int getHarvestLevel(int aMeta) {
        if (aMeta == 4 || aMeta == 5 || aMeta == 6 || aMeta == 7) {
            return 1;
        }
        if (aMeta == 2) {
            return 2;
        }
        if (aMeta == 9 || aMeta == 3 || aMeta == 1) {
            return 5;
        }
        if (aMeta == 10 || aMeta == 11) {
            return 7;
        }
        return 4;
    }

    public IIcon func_149691_a(int ordinalSide, int aMeta) {
        if (aMeta >= 0 && aMeta < 16) {
            switch (aMeta) {
                case 0: {
                    return Textures.BlockIcons.BLOCK_BRONZEPREIN.getIcon();
                }
                case 1: {
                    return Textures.BlockIcons.BLOCK_IRREIN.getIcon();
                }
                case 2: {
                    return Textures.BlockIcons.BLOCK_PLASCRETE.getIcon();
                }
                case 3: {
                    return Textures.BlockIcons.BLOCK_TSREIN.getIcon();
                }
                case 4: 
                case 6: 
                case 7: {
                    return Blocks.field_150402_ci.func_149691_a(0, 0);
                }
                case 5: {
                    return Textures.BlockIcons.COVER_WOOD_PLATE.getIcon();
                }
                case 8: {
                    return Textures.BlockIcons.BLOCK_STEELPREIN.getIcon();
                }
                case 9: {
                    return Textures.BlockIcons.BLOCK_TITANIUMPREIN.getIcon();
                }
                case 10: {
                    return Textures.BlockIcons.BLOCK_NAQUADAHPREIN.getIcon();
                }
                case 11: {
                    return Textures.BlockIcons.BLOCK_NEUTRONIUMPREIN.getIcon();
                }
                case 12: {
                    return Textures.BlockIcons.BLOCK_DEEP_DARK_RAW.getIcon();
                }
            }
        }
        return Textures.BlockIcons.MACHINE_CASING_SOLID_STEEL.getIcon();
    }

    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        if (aWorld == null) {
            return 0.0f;
        }
        if (aWorld.func_147437_c(aX, aY, aZ)) {
            return 0.0f;
        }
        int tMeta = aWorld.func_72805_g(aX, aY, aZ);
        if (tMeta == 0) {
            return 60.0f;
        }
        if (tMeta == 1) {
            return 400.0f;
        }
        if (tMeta == 2) {
            return 5.0f;
        }
        if (tMeta == 3) {
            return 250.0f;
        }
        if (tMeta == 4 || tMeta == 5 || tMeta == 6 || tMeta == 7) {
            return 0.5f;
        }
        if (tMeta == 8) {
            return 150.0f;
        }
        if (tMeta == 9) {
            return 200.0f;
        }
        if (tMeta == 10) {
            return 500.0f;
        }
        if (tMeta == 11) {
            return 750.0f;
        }
        return Blocks.field_150339_S.func_149712_f(aWorld, aX, aY, aZ);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        if (world == null) {
            return 0.0f;
        }
        int tMeta = world.func_72805_g(x, y, z);
        if (tMeta == 0) {
            return 150.0f;
        }
        if (tMeta == 1) {
            return 600.0f;
        }
        if (tMeta == 2) {
            return 6.0f;
        }
        if (tMeta == 3) {
            return 400.0f;
        }
        if (tMeta == 4 || tMeta == 6 || tMeta == 7) {
            return 8.0f;
        }
        if (tMeta == 5) {
            return 1.0f;
        }
        if (tMeta == 8) {
            return 200.0f;
        }
        if (tMeta == 9) {
            return 300.0f;
        }
        if (tMeta == 10) {
            return 1000.0f;
        }
        if (tMeta == 11) {
            return 2500.0f;
        }
        return super.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public String func_149739_a() {
        return this.mUnlocalizedName;
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)(this.mUnlocalizedName + ".name"));
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return true;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_72805_g(aX, aY, aZ);
    }

    public void func_149690_a(World aWorld, int aX, int aY, int aZ, int aMetadata, float chance, int aFortune) {
        if (aMetadata == 4) {
            this.func_149642_a(aWorld, aX, aY, aZ, new ItemStack(Items.field_151044_h, XSTR.XSTR_INSTANCE.nextInt(2) + 1, 1));
        } else {
            super.func_149690_a(aWorld, aX, aY, aZ, aMetadata, chance, aFortune);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!world.field_72995_K && world.func_72805_g(x, y, z) == 5) {
            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), (EntityLivingBase)player);
            world.func_72838_d((Entity)entitytntprimed);
            ((WorldSpawnedEventBuilder.SoundAtEntityEventBuilder)new WorldSpawnedEventBuilder.SoundAtEntityEventBuilder().setPitch(1.0f).setVolume(1.0f).setIdentifier((Enum)SoundResource.GAME_TNT_PRIMED)).setEntity((Entity)entitytntprimed).setWorld(world).run();
            world.func_147468_f(x, y, z);
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (world.func_72864_z(x, y, z) && world.func_72805_g(x, y, z) == 5) {
            this.removedByPlayer(world, null, x, y, z);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (world.func_72864_z(x, y, z) && world.func_72805_g(x, y, z) == 5) {
            this.removedByPlayer(world, null, x, y, z);
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (!world.field_72995_K && world.func_72805_g(x, y, z) == 5) {
            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), explosion.func_94613_c());
            entitytntprimed.field_70516_a = world.field_73012_v.nextInt(entitytntprimed.field_70516_a / 4) + entitytntprimed.field_70516_a / 8;
            world.func_72838_d((Entity)entitytntprimed);
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int ordinalSide, float xOffset, float yOffset, float zOffset) {
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Items.field_151033_d && world.func_72805_g(x, y, z) == 5) {
            this.removedByPlayer(world, player, x, y, z);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, ordinalSide, xOffset, yOffset, zOffset);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister aIconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item aItem, CreativeTabs aCreativeTab, List<ItemStack> aList) {
        for (int i = 0; i < 16; ++i) {
            ItemStack aStack = new ItemStack(aItem, 1, i);
            if (aStack.func_82833_r().contains(".name")) continue;
            aList.add(aStack);
        }
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return !(entity instanceof EntityWither);
    }
}

