/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.shutdown;

import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import gregtech.api.util.shutdown.ShutDownReason;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class SimpleShutDownReason
implements ShutDownReason {
    private String key;
    private boolean wasCritical;

    public SimpleShutDownReason(String key, boolean isCritical) {
        this.key = key;
        this.wasCritical = isCritical;
    }

    @Override
    @NotNull
    public String getID() {
        return "simple_result";
    }

    @Override
    @NotNull
    public String getDisplayString() {
        return Objects.requireNonNull(StatCollector.func_74838_a((String)("GT5U.gui.text." + this.key)));
    }

    @Override
    @NotNull
    public ShutDownReason newInstance() {
        return new SimpleShutDownReason("", false);
    }

    @Override
    public void encode(@NotNull PacketBuffer buffer) {
        buffer.writeBoolean(this.wasCritical);
        NetworkUtils.writeStringSafe((PacketBuffer)buffer, (String)this.key);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.wasCritical = buffer.readBoolean();
        this.key = NetworkUtils.readStringSafe((PacketBuffer)buffer);
    }

    @Override
    public boolean wasCritical() {
        return this.wasCritical;
    }

    @Nonnull
    public static ShutDownReason ofCritical(String key) {
        return new SimpleShutDownReason(key, true);
    }

    @Nonnull
    public static ShutDownReason ofNormal(String key) {
        return new SimpleShutDownReason(key, false);
    }
}

