/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.core.IClimateProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.genetics.alleles.Allele;
import forestry.core.utils.StringUtil;
import gregtech.GT_Mod;
import gregtech.api.enums.Mods;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.common.bees.GT_AlleleHelper;
import gregtech.common.items.ItemComb;
import gregtech.common.items.ItemDrop;
import gregtech.common.items.ItemPollen;
import gregtech.common.items.ItemPropolis;
import gregtech.loaders.misc.GT_BeeDefinition;
import gregtech.loaders.misc.bees.GT_AlleleEffect;
import gregtech.loaders.misc.bees.GT_EffectMachineBoost;
import gregtech.loaders.misc.bees.GT_EffectTreeTwister;
import gregtech.loaders.misc.bees.GT_Flowers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class GT_Bees {
    public static IAlleleInteger noFertility;
    public static IAlleleInteger superFertility;
    public static IAlleleInteger noFlowering;
    public static IAlleleInteger superFlowering;
    public static IAlleleArea noTerritory;
    public static IAlleleArea superTerritory;
    public static IAlleleFloat noWork;
    public static IAlleleFloat speedBlinding;
    public static IAlleleFloat superSpeed;
    public static IAlleleInteger blinkLife;
    public static IAlleleInteger superLife;
    public static IAlleleBeeEffect treetwisterEffect;
    public static IAlleleBeeEffect machineBoostEffect;
    public static ItemPropolis propolis;
    public static ItemPollen pollen;
    public static ItemDrop drop;
    public static ItemComb combs;

    public GT_Bees() {
        if (!Mods.Forestry.isModLoaded() || !GT_Mod.gregtechproxy.mGTBees) {
            return;
        }
        GT_Flowers.doInit();
        GT_AlleleHelper.initialisation();
        GT_Bees.setupGTAlleles();
        propolis = new ItemPropolis();
        propolis.initPropolisRecipes();
        pollen = new ItemPollen();
        drop = new ItemDrop();
        drop.initDropsRecipes();
        combs = new ItemComb();
        combs.initCombsRecipes();
        combs.registerOreDict();
        GT_BeeDefinition.initBees();
    }

    private static void setupGTAlleles() {
        noFertility = new AlleleInteger("fertilitySterile", 0, false, EnumBeeChromosome.FERTILITY);
        superFertility = new AlleleInteger("fertilityMultiply", 8, false, EnumBeeChromosome.FERTILITY);
        noFlowering = new AlleleInteger("floweringNonpollinating", 0, false, EnumBeeChromosome.FLOWERING);
        superFlowering = new AlleleInteger("floweringNaturalistic", 240, false, EnumBeeChromosome.FLOWERING);
        noTerritory = new AlleleArea("areaLethargic", 1, 1, false);
        superTerritory = new AlleleArea("areaExploratory", 32, 16, false);
        noWork = new AlleleFloat("speedUnproductive", 0.0f, false);
        superSpeed = new AlleleFloat("speedAccelerated", 4.0f, false);
        speedBlinding = AlleleManager.alleleRegistry.getAllele("magicbees.speedBlinding") == null ? new AlleleFloat("speedBlinding", 2.0f, false) : (IAlleleFloat)AlleleManager.alleleRegistry.getAllele("magicbees.speedBlinding");
        blinkLife = new AlleleInteger("lifeBlink", 2, false, EnumBeeChromosome.LIFESPAN);
        superLife = new AlleleInteger("lifeEon", 600, false, EnumBeeChromosome.LIFESPAN);
        machineBoostEffect = new GT_EffectMachineBoost();
        if (Mods.GalaxySpace.isModLoaded() && Mods.TwilightForest.isModLoaded()) {
            GT_Mod.GT_FML_LOGGER.info("treetwisterEffect: GalaxySpace and TwilightForest loaded, using default impl");
            treetwisterEffect = new GT_EffectTreeTwister();
        } else {
            GT_Mod.GT_FML_LOGGER.info("treetwisterEffect: GalaxySpace or TwilightForest was not loaded, using fallback impl");
            treetwisterEffect = GT_AlleleEffect.FORESTRY_BASE_EFFECT;
        }
    }

    private static class AlleleInteger
    extends Allele
    implements IAlleleInteger {
        private final int value;

        public AlleleInteger(String id, int val, boolean isDominant, EnumBeeChromosome c) {
            super("gregtech." + id, "gregtech." + id, isDominant);
            this.value = val;
            AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{c});
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class AlleleArea
    extends Allele
    implements IAlleleArea {
        private final int[] value;

        public AlleleArea(String id, int rangeXZ, int rangeY, boolean isDominant) {
            super("gregtech." + id, "gregtech." + id, isDominant);
            this.value = new int[]{rangeXZ, rangeY, rangeXZ};
            AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{EnumBeeChromosome.TERRITORY});
        }

        public int[] getValue() {
            return this.value;
        }
    }

    private static class AlleleFloat
    extends Allele
    implements IAlleleFloat {
        private final float value;

        public AlleleFloat(String id, float val, boolean isDominant) {
            super("gregtech." + id, "gregtech." + id, isDominant);
            this.value = val;
            AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{EnumBeeChromosome.SPEED});
        }

        public float getValue() {
            return this.value;
        }
    }

    public static class ActiveGTMachineMutationCondition
    implements IMutationCondition {
        public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
            BaseMetaTileEntity machine;
            TileEntity tileEntity = world.func_147438_o(x, y - 1, z);
            if (tileEntity instanceof BaseMetaTileEntity && (machine = (BaseMetaTileEntity)tileEntity).isActive()) {
                return 1.0f;
            }
            return 0.0f;
        }

        public String getDescription() {
            return "Needs a running GT Machine below to breed";
        }
    }

    public static class BiomeIDMutationCondition
    implements IMutationCondition {
        final int biomeID;
        final String biomeName;

        public BiomeIDMutationCondition(int id, String name) {
            this.biomeID = id;
            this.biomeName = name;
        }

        public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
            if (climate.getBiome().field_76756_M == this.biomeID) {
                return 1.0f;
            }
            return 0.0f;
        }

        public String getDescription() {
            if (BiomeGenBase.func_150568_d((int)this.biomeID) != null) {
                return StringUtil.localizeAndFormat((String)"mutation.condition.biomeid", (Object[])new Object[0]) + " " + this.biomeName;
            }
            return "";
        }
    }

    public static class DimensionMutationCondition
    implements IMutationCondition {
        final int dimID;
        final String dimName;

        public DimensionMutationCondition(int id, String name) {
            this.dimID = id;
            this.dimName = name;
        }

        public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
            if (world.field_73011_w.field_76574_g == this.dimID) {
                return 1.0f;
            }
            return 0.0f;
        }

        public String getDescription() {
            return StringUtil.localizeAndFormat((String)"mutation.condition.dim", (Object[])new Object[0]) + " " + this.dimName;
        }
    }
}

