/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import appeng.api.parts.IPartHost;
import appeng.api.util.IOrientable;
import appeng.tile.misc.TileInterface;
import gregtech.api.enums.SoundResource;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_None;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class Behaviour_Wrench
extends Behaviour_None {
    private final int mCosts;
    private final String mTooltip = GT_LanguageManager.addStringLocalization("gt.behaviour.wrench", "Rotates Blocks on Rightclick");

    public Behaviour_Wrench(int aCosts) {
        this.mCosts = aCosts;
    }

    @Override
    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == null) {
            return false;
        }
        int aMeta = aWorld.func_72805_g(aX, aY, aZ);
        short targetSideOrdinal = (short)GT_Utility.determineWrenchingSide(side, hitX, hitY, hitZ).ordinal();
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        WrenchHandler handler = new WrenchHandler(aBlock, aMeta, targetSideOrdinal, aTileEntity, aPlayer, aWorld, aX, aY, aZ, aStack, (GT_MetaGenerated_Tool)aItem, this.mCosts);
        try {
            return handler.handle() && !aWorld.field_72995_K;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isVanillaRotatable(Block block) {
        return Behaviour_Wrench.isVanillaCantFaceAxisY(block) || Behaviour_Wrench.isVanillaAllSideRotatable(block) || block == Blocks.field_150438_bZ;
    }

    public static boolean isVanillaCantFaceAxisY(Block block) {
        return GT_Utility.arrayContains(block, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150460_al, Blocks.field_150470_am, Blocks.field_150486_ae, Blocks.field_150447_bR, Blocks.field_150477_bB);
    }

    public static boolean isVanillaAllSideRotatable(Block block) {
        return GT_Utility.arrayContains(block, Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150367_z, Blocks.field_150409_cd);
    }

    @Override
    public List<String> getAdditionalToolTips(GT_MetaBase_Item aItem, List<String> aList, ItemStack aStack) {
        aList.add(this.mTooltip);
        return aList;
    }

    private static class WrenchHandler {
        private final Block block;
        private final short targetSideOrdinal;
        private final TileEntity tileEntity;
        private final EntityPlayer player;
        private final World world;
        private final int x;
        private final int y;
        private final int z;
        private final int meta;
        private final ItemStack stack;
        private final GT_MetaGenerated_Tool item;
        private final int costs;

        boolean handle() {
            ForgeDirection direction = ForgeDirection.getOrientation((int)this.targetSideOrdinal);
            TileEntity tileEntity = this.tileEntity;
            if (tileEntity instanceof IOrientable) {
                IOrientable orientable = (IOrientable)tileEntity;
                if (!orientable.canBeRotated()) {
                    return false;
                }
                ForgeDirection front = orientable.getForward();
                ForgeDirection up = orientable.getUp();
                if (front == ForgeDirection.UNKNOWN) {
                    front = direction == ForgeDirection.UP || direction == ForgeDirection.DOWN ? ForgeDirection.NORTH : ForgeDirection.UP;
                }
                ForgeDirection back = front.getOpposite();
                ForgeDirection down = up.getOpposite();
                if (this.tileEntity instanceof TileInterface) {
                    if (this.player.func_70093_af()) {
                        return false;
                    }
                    if (direction == down) {
                        return this.doWrenchOperation(this.costs, () -> {
                            orientable.setOrientation(ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN);
                            return true;
                        });
                    }
                    direction = direction.getOpposite();
                    up = up.getOpposite();
                } else if (direction == up || direction == front) {
                    ForgeDirection tempFront = front;
                    ForgeDirection tempUp = up;
                    if (!this.player.func_70093_af() && direction == up) {
                        return this.doWrenchOperation(this.costs, () -> {
                            orientable.setOrientation(tempFront.getRotation(tempUp), tempUp);
                            return true;
                        });
                    }
                    if (this.player.func_70093_af() && direction == front) {
                        return this.doWrenchOperation(this.costs, () -> {
                            orientable.setOrientation(tempFront, tempUp.getRotation(tempFront).getRotation(tempFront));
                            return true;
                        });
                    }
                }
                if (this.player.func_70093_af()) {
                    if (direction == up || direction == down) {
                        orientable.setOrientation(direction, down.getRotation(front.getRotation(direction)));
                    } else {
                        orientable.setOrientation(direction, up);
                    }
                } else if (direction == front || direction == back) {
                    orientable.setOrientation(back.getRotation(up.getRotation(direction)), direction);
                } else {
                    orientable.setOrientation(front, direction);
                }
                return this.damageWrench(this.costs);
            }
            if (this.world.field_72995_K) {
                return false;
            }
            tileEntity = this.tileEntity;
            if (tileEntity instanceof IWrenchable) {
                IWrenchable wrenchable = (IWrenchable)tileEntity;
                if (wrenchable.wrenchCanSetFacing(this.player, (int)this.targetSideOrdinal)) {
                    return this.doWrenchOperation(this.costs, () -> {
                        wrenchable.setFacing(this.targetSideOrdinal);
                        return true;
                    });
                }
                return false;
            }
            if (this.block == Blocks.field_150416_aS || this.block == Blocks.field_150413_aR || this.block == Blocks.field_150455_bV || this.block == Blocks.field_150441_bU) {
                return this.setBlockMeta(this.costs, this.meta / 4 * 4 + (this.meta % 4 + 1) % 4);
            }
            if (this.block == Blocks.field_150438_bZ && this.targetSideOrdinal != 1) {
                return this.setBlockMeta(this.costs, this.targetSideOrdinal);
            }
            if (Behaviour_Wrench.isVanillaAllSideRotatable(this.block) && this.meta < 6) {
                return this.setBlockMeta(this.costs, this.targetSideOrdinal);
            }
            if (Behaviour_Wrench.isVanillaCantFaceAxisY(this.block)) {
                if (this.targetSideOrdinal > 1) {
                    return this.setBlockMeta(this.costs, this.targetSideOrdinal);
                }
                return false;
            }
            if (this.tileEntity instanceof IPartHost) {
                return false;
            }
            int logWoodId = OreDictionary.getOreID((String)"logWood");
            if (Arrays.stream(OreDictionary.getOreIDs((ItemStack)new ItemStack(this.block))).anyMatch(id -> id == logWoodId)) {
                return this.setBlockMeta(this.costs, (this.meta + 4) % 12);
            }
            if (Arrays.asList(this.block.getValidRotations(this.world, this.x, this.y, this.z)).contains(direction)) {
                return this.rotateBlock(this.costs, direction);
            }
            return false;
        }

        public WrenchHandler(Block block, int meta, short targetSideOrdinal, TileEntity tileEntity, EntityPlayer player, World world, int x, int y, int z, ItemStack stack, GT_MetaGenerated_Tool item, int costs) {
            this.block = block;
            this.meta = meta;
            this.targetSideOrdinal = targetSideOrdinal;
            this.tileEntity = tileEntity;
            this.player = player;
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.stack = stack;
            this.item = item;
            this.costs = costs;
        }

        boolean doWrenchOperation(int damage, BooleanSupplier operation) {
            if ((this.player.field_71075_bZ.field_75098_d || this.item.canWrench(this.player, this.x, this.y, this.z)) && operation.getAsBoolean()) {
                this.item.doDamage(this.stack, damage);
                GT_Utility.sendSoundToPlayers(this.world, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.x, this.y, this.z);
                return true;
            }
            return false;
        }

        boolean setBlockMeta(int damage, int newMeta) {
            return this.doWrenchOperation(damage, () -> this.setBlockMetadataWithNotify(newMeta));
        }

        boolean rotateBlock(int damage, ForgeDirection direction) {
            return this.doWrenchOperation(damage, () -> this.block.rotateBlock(this.world, this.x, this.y, this.z, direction));
        }

        boolean damageWrench(int damage) {
            return this.doWrenchOperation(damage, () -> true);
        }

        private boolean setBlockMetadataWithNotify(int newMeta) {
            return this.world.func_72921_c(this.x, this.y, this.z, newMeta, 3);
        }
    }
}

