/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui.widget;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.gui.modularui.IDataFollowerWidget;
import gregtech.api.util.ISerializableObject;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class CoverDataFollower_SlotWidget<T extends ISerializableObject>
extends SlotWidget
implements IDataFollowerWidget<T, ItemStack> {
    private Function<T, ItemStack> dataToStateGetter;
    private Consumer<ItemStack> dataSetter;

    public CoverDataFollower_SlotWidget(BaseSlot slot) {
        super(slot);
    }

    public CoverDataFollower_SlotWidget(IItemHandlerModifiable handler, int index, boolean phantom) {
        this(new BaseSlot(handler, index, phantom));
    }

    public CoverDataFollower_SlotWidget(IItemHandlerModifiable handler, int index) {
        this(handler, index, false);
    }

    public CoverDataFollower_SlotWidget<T> setDataToStateGetter(Function<T, ItemStack> dataToStateGetter) {
        this.dataToStateGetter = dataToStateGetter;
        return this;
    }

    public CoverDataFollower_SlotWidget<T> setStateSetter(Consumer<ItemStack> setter) {
        this.dataSetter = setter;
        return this;
    }

    @Override
    public void updateState(T data) {
        this.getMcSlot().func_75215_d(this.dataToStateGetter.apply(data));
    }

    public void detectAndSendChanges(boolean init) {
    }

    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        if (this.interactionDisabled) {
            return Interactable.ClickResult.REJECT;
        }
        if (this.isPhantom()) {
            Widget.ClickData clickData = Widget.ClickData.create((int)buttonId, (boolean)doubleClick);
            this.syncToServer(2, arg_0 -> ((Widget.ClickData)clickData).writeToPacket(arg_0));
            this.phantomClick(clickData);
            this.dataSetter.accept(this.getMcSlot().func_75211_c());
            return Interactable.ClickResult.ACCEPT;
        }
        return Interactable.ClickResult.REJECT;
    }

    public boolean onMouseScroll(int direction) {
        if (this.interactionDisabled) {
            return false;
        }
        if (this.isPhantom()) {
            if (Interactable.hasShiftDown()) {
                direction *= 8;
            }
            int finalDirection = direction;
            this.syncToServer(3, buffer -> buffer.func_150787_b(finalDirection));
            this.phantomScroll(finalDirection);
            this.dataSetter.accept(this.getMcSlot().func_75211_c());
            return true;
        }
        return false;
    }

    public boolean handleDragAndDrop(ItemStack draggedStack, int button) {
        if (this.interactionDisabled) {
            return false;
        }
        if (!this.isPhantom()) {
            return false;
        }
        Widget.ClickData clickData = Widget.ClickData.create((int)button, (boolean)false);
        this.syncToServer(5, buffer -> {
            clickData.writeToPacket(buffer);
            NetworkUtils.writeItemStack((PacketBuffer)buffer, (ItemStack)draggedStack);
        });
        this.phantomClick(clickData, draggedStack);
        this.dataSetter.accept(this.getMcSlot().func_75211_c());
        draggedStack.field_77994_a = 0;
        return true;
    }
}

