/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import gregtech.api.enums.SteamVariant;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SteamOverclockDescriber
extends OverclockDescriber {
    private final SteamVariant steamVariant;
    private final int euPerTickMultiplier;
    private final int durationMultiplier;

    public SteamOverclockDescriber(SteamVariant steamVariant, int euPerTickMultiplier, int durationMultiplier) {
        super((byte)1);
        this.steamVariant = steamVariant;
        this.euPerTickMultiplier = euPerTickMultiplier;
        this.durationMultiplier = durationMultiplier;
    }

    @Override
    public String getTierString() {
        return StatCollector.func_74838_a((String)("GT5U.steam_variant." + this.steamVariant.toString()));
    }

    @Override
    public GT_OverclockCalculator createCalculator(GT_OverclockCalculator template, GT_Recipe recipe) {
        return GT_OverclockCalculator.ofNoOverclock(recipe).setEUtDiscount(this.euPerTickMultiplier).setSpeedBoost(this.durationMultiplier);
    }

    @Override
    public void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        if (recipeInfo.calculator.getConsumption() <= 0L) {
            return;
        }
        recipeInfo.drawText(GT_Utility.trans("152", "Total: ") + this.getTotalPowerString(recipeInfo.calculator));
        recipeInfo.drawText(GT_Utility.trans("153", "Usage: ") + this.getSteamUsageString(recipeInfo.calculator));
    }

    private String getTotalPowerString(GT_OverclockCalculator calculator) {
        return GT_Utility.formatNumbers(SteamOverclockDescriber.convertEUToSteam(calculator.getConsumption() * (long)calculator.getDuration())) + " Steam";
    }

    private String getSteamUsageString(GT_OverclockCalculator calculator) {
        return GT_Utility.formatNumbers(20L * SteamOverclockDescriber.convertEUToSteam(calculator.getConsumption())) + " L/s Steam";
    }

    private static long convertEUToSteam(long eu) {
        return 2L * eu;
    }
}

