/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Pollution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_Muffler
extends GT_MetaTileEntity_Hatch {
    private static final String localizedDescFormat = GT_LanguageManager.addStringLocalization("gt.blockmachines.hatch.muffler.desc.format", "Outputs the Pollution (Might cause ... things)%nDO NOT OBSTRUCT THE OUTPUT!%nReduces Pollution to %d%%%nRecovers %d%% of CO2/CO/SO2");
    private final int pollutionReduction = this.calculatePollutionReduction(100);
    private final int pollutionRecover = 100 - this.pollutionReduction;
    private final String[] description = String.format(localizedDescFormat, this.pollutionReduction, this.pollutionRecover).split("\\R");

    public GT_MetaTileEntity_Hatch_Muffler(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, "", new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_Muffler(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch_Muffler(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        this(aName, aTier, new String[]{aDescription}, aTextures);
    }

    public GT_MetaTileEntity_Hatch_Muffler(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        this(aName, aTier, 0, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch_Muffler(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return this.description;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_MUFFLER)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_MUFFLER)};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Muffler(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && this.getBaseMetaTileEntity().isActive()) {
            this.pollutionParticles(this.getBaseMetaTileEntity().getWorld(), ParticleFX.LARGE_SMOKE.toString());
        }
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void pollutionParticles(World aWorld, String name) {
        float zSpd;
        float xSpd;
        boolean chk3;
        boolean chk2;
        float ran3;
        float ran2;
        boolean chk1;
        float ran1 = XSTR.XSTR_INSTANCE.nextFloat();
        boolean bl = chk1 = ran1 * 100.0f < (float)this.calculatePollutionReduction(100);
        if (GT_Pollution.getPollution(this.getBaseMetaTileEntity()) >= GT_Mod.gregtechproxy.mPollutionSmogLimit) {
            ran2 = XSTR.XSTR_INSTANCE.nextFloat();
            ran3 = XSTR.XSTR_INSTANCE.nextFloat();
            chk2 = ran2 * 100.0f < (float)this.calculatePollutionReduction(100);
            boolean bl2 = chk3 = ran3 * 100.0f < (float)this.calculatePollutionReduction(100);
            if (!(chk1 || chk2 || chk3)) {
                return;
            }
        } else {
            if (!chk1) {
                return;
            }
            ran3 = 0.0f;
            ran2 = 0.0f;
            chk3 = false;
            chk2 = false;
        }
        IGregTechTileEntity aMuffler = this.getBaseMetaTileEntity();
        ForgeDirection aDir = aMuffler.getFrontFacing();
        float xPos = (float)aDir.offsetX * 0.76f + (float)aMuffler.getXCoord() + 0.25f;
        float yPos = (float)aDir.offsetY * 0.76f + (float)aMuffler.getYCoord() + 0.25f;
        float zPos = (float)aDir.offsetZ * 0.76f + (float)aMuffler.getZCoord() + 0.25f;
        float ySpd = (float)aDir.offsetY * 0.1f + 0.2f + 0.1f * XSTR.XSTR_INSTANCE.nextFloat();
        if (aDir.offsetY == -1) {
            float temp = XSTR.XSTR_INSTANCE.nextFloat() * 2.0f * (float)Math.PI;
            xSpd = (float)Math.sin(temp) * 0.1f;
            zSpd = (float)Math.cos(temp) * 0.1f;
        } else {
            xSpd = (float)aDir.offsetX * (0.1f + 0.2f * XSTR.XSTR_INSTANCE.nextFloat());
            zSpd = (float)aDir.offsetZ * (0.1f + 0.2f * XSTR.XSTR_INSTANCE.nextFloat());
        }
        WorldSpawnedEventBuilder.ParticleEventBuilder events = new WorldSpawnedEventBuilder.ParticleEventBuilder().setIdentifier(name).setWorld(aWorld).setMotion(xSpd, ySpd, zSpd);
        if (chk1) {
            events.setPosition(xPos + ran1 * 0.5f, yPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f, zPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f).run();
        }
        if (chk2) {
            events.setPosition(xPos + ran2 * 0.5f, yPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f, zPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f).run();
        }
        if (chk3) {
            events.setPosition(xPos + ran3 * 0.5f, yPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f, zPos + XSTR.XSTR_INSTANCE.nextFloat() * 0.5f).run();
        }
    }

    public int calculatePollutionReduction(int aPollution) {
        if (this.mTier < 2) {
            return aPollution;
        }
        return (int)((float)aPollution * ((100.0f - 12.5f * ((float)this.mTier - 1.0f)) / 100.0f));
    }

    public boolean polluteEnvironment(MetaTileEntity mte) {
        if (this.getBaseMetaTileEntity().getAirAtSide(this.getBaseMetaTileEntity().getFrontFacing())) {
            GT_Pollution.addPollution(this.getBaseMetaTileEntity(), this.calculatePollutionReduction(10000));
            return true;
        }
        return false;
    }
}

