/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Buffer;
import gregtech.api.util.GT_TooltipDataCache;
import net.minecraft.nbt.NBTTagCompound;

public abstract class GT_MetaTileEntity_FilterBase
extends GT_MetaTileEntity_Buffer {
    private static final String INVERT_FILTER_TOOLTIP = "GT5U.machines.invert_filter.tooltip";
    protected static final int FILTER_SLOT_INDEX = 9;
    protected static final int NUM_INVENTORY_SLOTS = 9;
    private static final String EMIT_REDSTONE_GRADUALLY_TOOLTIP = "GT5U.machines.emit_redstone_gradually.tooltip";
    protected boolean invertFilter = false;

    public GT_MetaTileEntity_FilterBase(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription);
    }

    public GT_MetaTileEntity_FilterBase(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String[] aDescription) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription);
    }

    public GT_MetaTileEntity_FilterBase(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_FilterBase(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < 9;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("bInvertFilter", this.invertFilter);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.invertFilter = aNBT.func_74767_n("bInvertFilter");
    }

    @Override
    protected int getRedstoneOutput() {
        if (!this.bRedstoneIfFull) {
            return 0;
        }
        int redstoneOutput = this.getEmptySlots();
        if (!this.bInvert) {
            redstoneOutput = 9 - redstoneOutput;
        }
        return redstoneOutput;
    }

    private int getEmptySlots() {
        int emptySlots = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.mInventory[i] != null) continue;
            ++emptySlots;
        }
        return emptySlots;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        this.addSortStacksButton(builder);
        this.addEmitRedstoneGraduallyButton(builder);
        this.addInvertRedstoneButton(builder);
        this.addInvertFilterButton(builder);
    }

    private void addEmitRedstoneGraduallyButton(ModularWindow.Builder builder) {
        builder.widget(this.createToggleButton(() -> this.bRedstoneIfFull, val -> {
            this.bRedstoneIfFull = val;
        }, GT_UITextures.OVERLAY_BUTTON_EMIT_REDSTONE, this::getEmitRedstoneGraduallyButtonTooltip).setUpdateTooltipEveryTick(true));
    }

    private GT_TooltipDataCache.TooltipData getEmitRedstoneGraduallyButtonTooltip() {
        return this.mTooltipCache.getUncachedTooltipData(EMIT_REDSTONE_GRADUALLY_TOOLTIP, this.getEmptySlots(), this.getRedstoneOutput());
    }

    private void addInvertFilterButton(ModularWindow.Builder builder) {
        builder.widget(this.createToggleButton(() -> this.invertFilter, val -> {
            this.invertFilter = val;
        }, GT_UITextures.OVERLAY_BUTTON_INVERT_FILTER, () -> this.mTooltipCache.getData(INVERT_FILTER_TOOLTIP, new Object[0])));
    }
}

